/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.misc.ExtensionInfo;
import sun.misc.ExtensionInstallationException;
import sun.misc.ExtensionInstallationProvider;
import sun.misc.JarFilter;
import sun.misc.Launcher;
import sun.security.action.GetPropertyAction;

public class ExtensionDependency {
    private static Vector<ExtensionInstallationProvider> providers;
    static final boolean DEBUG = false;

    public static synchronized void addExtensionInstallationProvider(ExtensionInstallationProvider extensionInstallationProvider) {
        if (providers == null) {
            providers = new Vector();
        }
        providers.add(extensionInstallationProvider);
    }

    public static synchronized void removeExtensionInstallationProvider(ExtensionInstallationProvider extensionInstallationProvider) {
        providers.remove(extensionInstallationProvider);
    }

    public static boolean checkExtensionsDependencies(JarFile jarFile) {
        if (providers == null) {
            return true;
        }
        try {
            ExtensionDependency extensionDependency = new ExtensionDependency();
            return extensionDependency.checkExtensions(jarFile);
        }
        catch (ExtensionInstallationException extensionInstallationException) {
            ExtensionDependency.debug(extensionInstallationException.getMessage());
            return false;
        }
    }

    protected boolean checkExtensions(JarFile jarFile) throws ExtensionInstallationException {
        Manifest manifest;
        try {
            manifest = jarFile.getManifest();
        }
        catch (IOException iOException) {
            return false;
        }
        if (manifest == null) {
            return true;
        }
        boolean bl = true;
        Attributes attributes = manifest.getMainAttributes();
        if (attributes != null) {
            String string = attributes.getValue(Attributes.Name.EXTENSION_LIST);
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    ExtensionDependency.debug("The file " + jarFile.getName() + " appears to depend on " + string2);
                    String string3 = string2 + "-" + Attributes.Name.EXTENSION_NAME.toString();
                    if (attributes.getValue(string3) == null) {
                        ExtensionDependency.debug("The jar file " + jarFile.getName() + " appers to depend on " + string2 + " but does not define the " + string3 + " attribute in its manifest ");
                        continue;
                    }
                    if (this.checkExtension(string2, attributes)) continue;
                    ExtensionDependency.debug("Failed installing " + string2);
                    bl = false;
                }
            } else {
                ExtensionDependency.debug("No dependencies for " + jarFile.getName());
            }
        }
        return bl;
    }

    protected synchronized boolean checkExtension(String string, Attributes attributes) throws ExtensionInstallationException {
        ExtensionDependency.debug("Checking extension " + string);
        if (this.checkExtensionAgainstInstalled(string, attributes)) {
            return true;
        }
        ExtensionDependency.debug("Extension not currently installed ");
        ExtensionInfo extensionInfo = new ExtensionInfo(string, attributes);
        return this.installExtension(extensionInfo, null);
    }

    boolean checkExtensionAgainstInstalled(String string, Attributes attributes) throws ExtensionInstallationException {
        File[] fileArray;
        File file = this.checkExtensionExists(string);
        if (file != null) {
            try {
                if (this.checkExtensionAgainst(string, attributes, file)) {
                    return true;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.debugException(fileNotFoundException);
            }
            catch (IOException iOException) {
                this.debugException(iOException);
            }
            return false;
        }
        try {
            fileArray = this.getInstalledExtensions();
        }
        catch (IOException iOException) {
            this.debugException(iOException);
            return false;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                if (!this.checkExtensionAgainst(string, attributes, fileArray[i])) continue;
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.debugException(fileNotFoundException);
                continue;
            }
            catch (IOException iOException) {
                this.debugException(iOException);
            }
        }
        return false;
    }

    protected boolean checkExtensionAgainst(String string, Attributes attributes, File file) throws IOException, FileNotFoundException, ExtensionInstallationException {
        Attributes attributes2;
        Manifest manifest;
        ExtensionDependency.debug("Checking extension " + string + " against " + file.getName());
        try {
            manifest = (Manifest)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof FileNotFoundException) {
                throw (FileNotFoundException)privilegedActionException.getException();
            }
            throw (IOException)privilegedActionException.getException();
        }
        ExtensionInfo extensionInfo = new ExtensionInfo(string, attributes);
        ExtensionDependency.debug("Requested Extension : " + extensionInfo);
        int n = 4;
        ExtensionInfo extensionInfo2 = null;
        if (manifest != null && (attributes2 = manifest.getMainAttributes()) != null) {
            extensionInfo2 = new ExtensionInfo(null, attributes2);
            ExtensionDependency.debug("Extension Installed " + extensionInfo2);
            n = extensionInfo2.isCompatibleWith(extensionInfo);
            switch (n) {
                case 0: {
                    ExtensionDependency.debug("Extensions are compatible");
                    return true;
                }
                case 4: {
                    ExtensionDependency.debug("Extensions are incompatible");
                    return false;
                }
            }
            ExtensionDependency.debug("Extensions require an upgrade or vendor switch");
            return this.installExtension(extensionInfo, extensionInfo2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean installExtension(ExtensionInfo extensionInfo, ExtensionInfo extensionInfo2) throws ExtensionInstallationException {
        Vector vector;
        Vector vector2;
        Object object = providers;
        synchronized (object) {
            vector = vector2 = (Vector)providers.clone();
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            vector2 = (ExtensionInstallationProvider)object.nextElement();
            if (vector2 == null || !vector2.installExtension(extensionInfo, extensionInfo2)) continue;
            ExtensionDependency.debug(extensionInfo.name + " installation successful");
            Launcher.ExtClassLoader extClassLoader = (Launcher.ExtClassLoader)Launcher.getLauncher().getClassLoader().getParent();
            this.addNewExtensionsToClassLoader(extClassLoader);
            return true;
        }
        ExtensionDependency.debug(extensionInfo.name + " installation failed");
        return false;
    }

    private File checkExtensionExists(String string) {
        String string2 = string;
        String[] stringArray = new String[]{".jar", ".zip"};
        return (File)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
    }

    private static File[] getExtDirs() {
        File[] fileArray;
        String string = AccessController.doPrivileged(new GetPropertyAction("java.ext.dirs"));
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            int n = stringTokenizer.countTokens();
            ExtensionDependency.debug("getExtDirs count " + n);
            fileArray = new File[n];
            for (int i = 0; i < n; ++i) {
                fileArray[i] = new File(stringTokenizer.nextToken());
                ExtensionDependency.debug("getExtDirs dirs[" + i + "] " + fileArray[i]);
            }
        } else {
            fileArray = new File[]{};
            ExtensionDependency.debug("getExtDirs dirs " + fileArray);
        }
        ExtensionDependency.debug("getExtDirs dirs.length " + fileArray.length);
        return fileArray;
    }

    private static File[] getExtFiles(File[] fileArray) throws IOException {
        Vector<File> vector = new Vector<File>();
        for (int i = 0; i < fileArray.length; ++i) {
            String[] stringArray = fileArray[i].list((FilenameFilter)new JarFilter());
            if (stringArray == null) continue;
            ExtensionDependency.debug("getExtFiles files.length " + stringArray.length);
            for (int j = 0; j < stringArray.length; ++j) {
                File file = new File(fileArray[i], stringArray[j]);
                vector.add(file);
                ExtensionDependency.debug("getExtFiles f[" + j + "] " + file);
            }
        }
        Object[] objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        ExtensionDependency.debug("getExtFiles ua.length " + objectArray.length);
        return objectArray;
    }

    private File[] getInstalledExtensions() throws IOException {
        return (File[])AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
    }

    private Boolean addNewExtensionsToClassLoader(Launcher.ExtClassLoader extClassLoader) {
        try {
            File[] fileArray = this.getInstalledExtensions();
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                URL uRL = (URL)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
                if (uRL == null) continue;
                URL[] uRLArray = extClassLoader.getURLs();
                boolean bl = false;
                for (int j = 0; j < uRLArray.length; ++j) {
                    ExtensionDependency.debug("URL[" + j + "] is " + uRLArray[j] + " looking for " + uRL);
                    if (uRLArray[j].toString().compareToIgnoreCase(uRL.toString()) != 0) continue;
                    bl = true;
                    ExtensionDependency.debug("Found !");
                }
                if (bl) continue;
                ExtensionDependency.debug("Not Found ! adding to the classloader " + uRL);
                extClassLoader.addExtURL(uRL);
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return Boolean.TRUE;
    }

    private static void debug(String string) {
    }

    private void debugException(Throwable throwable) {
    }

    static /* synthetic */ File[] access$000() {
        return ExtensionDependency.getExtDirs();
    }

    static /* synthetic */ void access$100(String string) {
        ExtensionDependency.debug(string);
    }

    static /* synthetic */ void access$200(ExtensionDependency extensionDependency, Throwable throwable) {
        extensionDependency.debugException(throwable);
    }

    static /* synthetic */ File[] access$300(File[] fileArray) throws IOException {
        return ExtensionDependency.getExtFiles(fileArray);
    }
}

