/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.awt.image.BufferedImage;
import java.awt.peer.ComponentPeer;
import java.security.AccessController;
import sun.awt.EmbeddedFrame;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.windows.WEmbeddedFrame;
import sun.awt.windows.WEmbeddedFramePeer;
import sun.awt.windows.WFramePeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;
import sun.security.action.GetPropertyAction;

public class WEmbeddedFrame
extends EmbeddedFrame {
    private long handle;
    private int bandWidth = 0;
    private int bandHeight = 0;
    private int imgWid = 0;
    private int imgHgt = 0;
    private static int pScale;
    private static final int MAX_BAND_SIZE = 30720;
    private boolean isEmbeddedInIE = false;
    private static String printScale;

    public WEmbeddedFrame() {
        this(0L);
    }

    @Deprecated
    public WEmbeddedFrame(int n) {
        this((long)n);
    }

    public WEmbeddedFrame(long l) {
        this.handle = l;
        if (l != 0L) {
            this.addNotify();
            this.show();
        }
    }

    @Override
    public void addNotify() {
        if (this.getPeer() == null) {
            WToolkit wToolkit = (WToolkit)Toolkit.getDefaultToolkit();
            this.setPeer((ComponentPeer)wToolkit.createEmbeddedFrame(this));
        }
        super.addNotify();
    }

    public long getEmbedderHandle() {
        return this.handle;
    }

    void print(long l) {
        BufferedImage bufferedImage = null;
        int n = 1;
        int n2 = 1;
        if (this.isPrinterDC(l)) {
            n = n2 = WEmbeddedFrame.getPrintScaleFactor();
        }
        int n3 = this.getHeight();
        if (bufferedImage == null) {
            this.bandWidth = this.getWidth();
            if (this.bandWidth % 4 != 0) {
                this.bandWidth += 4 - this.bandWidth % 4;
            }
            if (this.bandWidth <= 0) {
                return;
            }
            this.bandHeight = Math.min(30720 / this.bandWidth, n3);
            this.imgWid = this.bandWidth * n;
            this.imgHgt = this.bandHeight * n2;
            bufferedImage = new BufferedImage(this.imgWid, this.imgHgt, 5);
        }
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.white);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.translate(0, this.imgHgt);
        graphics2D.scale(n, -n2);
        ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)bufferedImage.getRaster();
        byte[] byArray = byteInterleavedRaster.getDataStorage();
        for (int i = 0; i < n3; i += this.bandHeight) {
            graphics.fillRect(0, 0, this.bandWidth, this.bandHeight);
            this.printComponents(graphics2D);
            int n4 = 0;
            int n5 = this.bandHeight;
            int n6 = this.imgHgt;
            if (i + this.bandHeight > n3) {
                n5 = n3 - i;
                n6 = n5 * n2;
                n4 = this.imgWid * (this.imgHgt - n6) * 3;
            }
            this.printBand(l, byArray, n4, 0, 0, this.imgWid, n6, 0, i, this.bandWidth, n5);
            graphics2D.translate(0, -this.bandHeight);
        }
    }

    protected static int getPrintScaleFactor() {
        int n;
        if (pScale != 0) {
            return pScale;
        }
        if (printScale == null) {
            printScale = (String)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
        }
        int n2 = n = 4;
        if (printScale != null) {
            try {
                n2 = Integer.parseInt(printScale);
                if (n2 > 8 || n2 < 1) {
                    n2 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        pScale = n2;
        return pScale;
    }

    private native boolean isPrinterDC(long var1);

    private native void printBand(long var1, byte[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    private static native void initIDs();

    public void activateEmbeddingTopLevel() {
    }

    @Override
    public void synthesizeWindowActivation(boolean bl) {
        if (!bl || EventQueue.isDispatchThread()) {
            ((WFramePeer)this.getPeer()).emulateActivation(bl);
        } else {
            2 var2_2 = new /* Unavailable Anonymous Inner Class!! */;
            WToolkit.postEvent(WToolkit.targetToAppContext(this), new InvocationEvent((Object)this, (Runnable)var2_2));
        }
    }

    @Override
    public void registerAccelerator(AWTKeyStroke aWTKeyStroke) {
    }

    @Override
    public void unregisterAccelerator(AWTKeyStroke aWTKeyStroke) {
    }

    @Override
    public void notifyModalBlocked(Dialog dialog, boolean bl) {
        try {
            ComponentPeer componentPeer = (ComponentPeer)WToolkit.targetToPeer(this);
            ComponentPeer componentPeer2 = (ComponentPeer)WToolkit.targetToPeer(dialog);
            this.notifyModalBlockedImpl((WEmbeddedFramePeer)componentPeer, (WWindowPeer)componentPeer2, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    native void notifyModalBlockedImpl(WEmbeddedFramePeer var1, WWindowPeer var2, boolean var3);

    static {
        WEmbeddedFrame.initIDs();
        pScale = 0;
        printScale = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.print.pluginscalefactor"));
    }
}

