/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.BufferStrategy;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public abstract class VSyncedBSManager {
    private static VSyncedBSManager theInstance;
    private static final boolean vSyncLimit;

    private static VSyncedBSManager getInstance(boolean bl) {
        if (theInstance == null && bl) {
            theInstance = vSyncLimit ? new SingleVSyncedBSMgr(null) : new NoLimitVSyncBSMgr(null);
        }
        return theInstance;
    }

    abstract boolean checkAllowed(BufferStrategy var1);

    abstract void relinquishVsync(BufferStrategy var1);

    public static boolean vsyncAllowed(BufferStrategy bufferStrategy) {
        VSyncedBSManager vSyncedBSManager = VSyncedBSManager.getInstance(true);
        return vSyncedBSManager.checkAllowed(bufferStrategy);
    }

    public static synchronized void releaseVsync(BufferStrategy bufferStrategy) {
        VSyncedBSManager vSyncedBSManager = VSyncedBSManager.getInstance(false);
        if (vSyncedBSManager != null) {
            vSyncedBSManager.relinquishVsync(bufferStrategy);
        }
    }

    static {
        vSyncLimit = Boolean.valueOf(AccessController.doPrivileged(new GetPropertyAction("sun.java2d.vsynclimit", "true")));
    }

    private static final class NoLimitVSyncBSMgr
    extends VSyncedBSManager {
        private NoLimitVSyncBSMgr() {
        }

        @Override
        boolean checkAllowed(BufferStrategy bs) {
            return true;
        }

        @Override
        void relinquishVsync(BufferStrategy bs) {
        }
    }

    private static final class SingleVSyncedBSMgr
    extends VSyncedBSManager {
        private WeakReference<BufferStrategy> strategy;

        private SingleVSyncedBSMgr() {
        }

        @Override
        public synchronized boolean checkAllowed(BufferStrategy bs) {
            BufferStrategy current;
            if (this.strategy != null && (current = (BufferStrategy)this.strategy.get()) != null) {
                return current == bs;
            }
            this.strategy = new WeakReference<BufferStrategy>(bs);
            return true;
        }

        @Override
        public synchronized void relinquishVsync(BufferStrategy bs) {
            BufferStrategy b;
            if (this.strategy != null && (b = (BufferStrategy)this.strategy.get()) == bs) {
                this.strategy.clear();
                this.strategy = null;
            }
        }
    }
}

