/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.beans.Transient;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class DefaultMutableTreeNode
implements Cloneable,
MutableTreeNode,
Serializable {
    private static final long serialVersionUID = -4298474751201349152L;
    public static final Enumeration<TreeNode> EMPTY_ENUMERATION = Collections.emptyEnumeration();
    protected MutableTreeNode parent = null;
    protected Vector children;
    protected transient Object userObject;
    protected boolean allowsChildren;

    public DefaultMutableTreeNode() {
        this(null);
    }

    public DefaultMutableTreeNode(Object object) {
        this(object, true);
    }

    public DefaultMutableTreeNode(Object object, boolean bl) {
        this.allowsChildren = bl;
        this.userObject = object;
    }

    @Override
    public void insert(MutableTreeNode mutableTreeNode, int n) {
        if (!this.allowsChildren) {
            throw new IllegalStateException("node does not allow children");
        }
        if (mutableTreeNode == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (this.isNodeAncestor(mutableTreeNode)) {
            throw new IllegalArgumentException("new child is an ancestor");
        }
        MutableTreeNode mutableTreeNode2 = (MutableTreeNode)mutableTreeNode.getParent();
        if (mutableTreeNode2 != null) {
            mutableTreeNode2.remove(mutableTreeNode);
        }
        mutableTreeNode.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(mutableTreeNode, n);
    }

    @Override
    public void remove(int n) {
        MutableTreeNode mutableTreeNode = (MutableTreeNode)this.getChildAt(n);
        this.children.removeElementAt(n);
        mutableTreeNode.setParent(null);
    }

    @Override
    @Transient
    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = mutableTreeNode;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public TreeNode getChildAt(int n) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        return (TreeNode)this.children.elementAt(n);
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(treeNode)) {
            return -1;
        }
        return this.children.indexOf(treeNode);
    }

    @Override
    public Enumeration children() {
        if (this.children == null) {
            return EMPTY_ENUMERATION;
        }
        return this.children.elements();
    }

    public void setAllowsChildren(boolean bl) {
        if (bl != this.allowsChildren) {
            this.allowsChildren = bl;
            if (!this.allowsChildren) {
                this.removeAllChildren();
            }
        }
    }

    @Override
    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    @Override
    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void removeFromParent() {
        MutableTreeNode mutableTreeNode = (MutableTreeNode)this.getParent();
        if (mutableTreeNode != null) {
            mutableTreeNode.remove(this);
        }
    }

    @Override
    public void remove(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(mutableTreeNode)) {
            throw new IllegalArgumentException("argument is not a child");
        }
        this.remove(this.getIndex(mutableTreeNode));
    }

    public void removeAllChildren() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public void add(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode != null && mutableTreeNode.getParent() == this) {
            this.insert(mutableTreeNode, this.getChildCount() - 1);
        } else {
            this.insert(mutableTreeNode, this.getChildCount());
        }
    }

    public boolean isNodeAncestor(TreeNode treeNode) {
        if (treeNode == null) {
            return false;
        }
        TreeNode treeNode2 = this;
        do {
            if (treeNode2 != treeNode) continue;
            return true;
        } while ((treeNode2 = treeNode2.getParent()) != null);
        return false;
    }

    public boolean isNodeDescendant(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return false;
        }
        return defaultMutableTreeNode.isNodeAncestor(this);
    }

    public TreeNode getSharedAncestor(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreeNode treeNode;
        TreeNode treeNode2;
        int n;
        if (defaultMutableTreeNode == this) {
            return this;
        }
        if (defaultMutableTreeNode == null) {
            return null;
        }
        int n2 = this.getLevel();
        int n3 = defaultMutableTreeNode.getLevel();
        if (n3 > n2) {
            n = n3 - n2;
            treeNode2 = defaultMutableTreeNode;
            treeNode = this;
        } else {
            n = n2 - n3;
            treeNode2 = this;
            treeNode = defaultMutableTreeNode;
        }
        while (n > 0) {
            treeNode2 = treeNode2.getParent();
            --n;
        }
        do {
            if (treeNode2 == treeNode) {
                return treeNode2;
            }
            treeNode2 = treeNode2.getParent();
            treeNode = treeNode.getParent();
        } while (treeNode2 != null);
        if (treeNode2 != null || treeNode != null) {
            throw new Error("nodes should be null");
        }
        return null;
    }

    public boolean isNodeRelated(DefaultMutableTreeNode defaultMutableTreeNode) {
        return defaultMutableTreeNode != null && this.getRoot() == defaultMutableTreeNode.getRoot();
    }

    public int getDepth() {
        Object var1_1 = null;
        Enumeration enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            var1_1 = enumeration.nextElement();
        }
        if (var1_1 == null) {
            throw new Error("nodes should be null");
        }
        return ((DefaultMutableTreeNode)var1_1).getLevel() - this.getLevel();
    }

    public int getLevel() {
        int n = 0;
        TreeNode treeNode = this;
        while ((treeNode = treeNode.getParent()) != null) {
            ++n;
        }
        return n;
    }

    public TreeNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode treeNode, int n) {
        TreeNode[] treeNodeArray;
        if (treeNode == null) {
            if (n == 0) {
                return null;
            }
            treeNodeArray = new TreeNode[n];
        } else {
            treeNodeArray = this.getPathToRoot(treeNode.getParent(), ++n);
            treeNodeArray[treeNodeArray.length - n] = treeNode;
        }
        return treeNodeArray;
    }

    public Object[] getUserObjectPath() {
        TreeNode[] treeNodeArray = this.getPath();
        Object[] objectArray = new Object[treeNodeArray.length];
        for (int i = 0; i < treeNodeArray.length; ++i) {
            objectArray[i] = ((DefaultMutableTreeNode)treeNodeArray[i]).getUserObject();
        }
        return objectArray;
    }

    public TreeNode getRoot() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        TreeNode treeNode = this;
        do {
            defaultMutableTreeNode = treeNode;
        } while ((treeNode = treeNode.getParent()) != null);
        return defaultMutableTreeNode;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public DefaultMutableTreeNode getNextNode() {
        if (this.getChildCount() == 0) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.getNextSibling();
            if (defaultMutableTreeNode == null) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.getParent();
                while (true) {
                    if (defaultMutableTreeNode2 == null) {
                        return null;
                    }
                    defaultMutableTreeNode = defaultMutableTreeNode2.getNextSibling();
                    if (defaultMutableTreeNode != null) {
                        return defaultMutableTreeNode;
                    }
                    defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                }
            }
            return defaultMutableTreeNode;
        }
        return (DefaultMutableTreeNode)this.getChildAt(0);
    }

    public DefaultMutableTreeNode getPreviousNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getParent();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getPreviousSibling();
        if (defaultMutableTreeNode2 != null) {
            if (defaultMutableTreeNode2.getChildCount() == 0) {
                return defaultMutableTreeNode2;
            }
            return defaultMutableTreeNode2.getLastLeaf();
        }
        return defaultMutableTreeNode;
    }

    public Enumeration preorderEnumeration() {
        return new PreorderEnumeration(this);
    }

    public Enumeration postorderEnumeration() {
        return new PostorderEnumeration(this, (TreeNode)this);
    }

    public Enumeration breadthFirstEnumeration() {
        return new BreadthFirstEnumeration(this, (TreeNode)this);
    }

    public Enumeration depthFirstEnumeration() {
        return this.postorderEnumeration();
    }

    public Enumeration pathFromAncestorEnumeration(TreeNode treeNode) {
        return new PathBetweenNodesEnumeration(this, treeNode, (TreeNode)this);
    }

    public boolean isNodeChild(TreeNode treeNode) {
        boolean bl = treeNode == null ? false : (this.getChildCount() == 0 ? false : treeNode.getParent() == this);
        return bl;
    }

    public TreeNode getFirstChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChildAt(0);
    }

    public TreeNode getLastChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChildAt(this.getChildCount() - 1);
    }

    public TreeNode getChildAfter(TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int n = this.getIndex(treeNode);
        if (n == -1) {
            throw new IllegalArgumentException("node is not a child");
        }
        if (n < this.getChildCount() - 1) {
            return this.getChildAt(n + 1);
        }
        return null;
    }

    public TreeNode getChildBefore(TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int n = this.getIndex(treeNode);
        if (n == -1) {
            throw new IllegalArgumentException("argument is not a child");
        }
        if (n > 0) {
            return this.getChildAt(n - 1);
        }
        return null;
    }

    public boolean isNodeSibling(TreeNode treeNode) {
        boolean bl;
        if (treeNode == null) {
            bl = false;
        } else if (treeNode == this) {
            bl = true;
        } else {
            TreeNode treeNode2 = this.getParent();
            boolean bl2 = bl = treeNode2 != null && treeNode2 == treeNode.getParent();
            if (bl && !((DefaultMutableTreeNode)this.getParent()).isNodeChild(treeNode)) {
                throw new Error("sibling has different parent");
            }
        }
        return bl;
    }

    public int getSiblingCount() {
        TreeNode treeNode = this.getParent();
        if (treeNode == null) {
            return 1;
        }
        return treeNode.getChildCount();
    }

    public DefaultMutableTreeNode getNextSibling() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getParent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode == null ? null : (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAfter(this);
        if (defaultMutableTreeNode2 != null && !this.isNodeSibling(defaultMutableTreeNode2)) {
            throw new Error("child of parent is not a sibling");
        }
        return defaultMutableTreeNode2;
    }

    public DefaultMutableTreeNode getPreviousSibling() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getParent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode == null ? null : (DefaultMutableTreeNode)defaultMutableTreeNode.getChildBefore(this);
        if (defaultMutableTreeNode2 != null && !this.isNodeSibling(defaultMutableTreeNode2)) {
            throw new Error("child of parent is not a sibling");
        }
        return defaultMutableTreeNode2;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public DefaultMutableTreeNode getFirstLeaf() {
        DefaultMutableTreeNode defaultMutableTreeNode = this;
        while (!defaultMutableTreeNode.isLeaf()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getLastLeaf() {
        DefaultMutableTreeNode defaultMutableTreeNode = this;
        while (!defaultMutableTreeNode.isLeaf()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getLastChild();
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getNextLeaf() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getParent();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getNextSibling();
        if (defaultMutableTreeNode2 != null) {
            return defaultMutableTreeNode2.getFirstLeaf();
        }
        return defaultMutableTreeNode.getNextLeaf();
    }

    public DefaultMutableTreeNode getPreviousLeaf() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getParent();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getPreviousSibling();
        if (defaultMutableTreeNode2 != null) {
            return defaultMutableTreeNode2.getLastLeaf();
        }
        return defaultMutableTreeNode.getPreviousLeaf();
    }

    public int getLeafCount() {
        int n = 0;
        Enumeration enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode = (TreeNode)enumeration.nextElement();
            if (!treeNode.isLeaf()) continue;
            ++n;
        }
        if (n < 1) {
            throw new Error("tree has zero leaves");
        }
        return n;
    }

    public String toString() {
        if (this.userObject == null) {
            return "";
        }
        return this.userObject.toString();
    }

    public Object clone() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        try {
            defaultMutableTreeNode = (DefaultMutableTreeNode)super.clone();
            defaultMutableTreeNode.children = null;
            defaultMutableTreeNode.parent = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException.toString());
        }
        return defaultMutableTreeNode;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Object[] objectArray = this.userObject != null && this.userObject instanceof Serializable ? new Object[]{"userObject", this.userObject} : new Object[]{};
        objectOutputStream.writeObject(objectArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object[] objectArray = (Object[])objectInputStream.readObject();
        if (objectArray.length > 0 && objectArray[0].equals("userObject")) {
            this.userObject = objectArray[1];
        }
    }

    static final class BreadthFirstEnumeration
    implements Enumeration<TreeNode> {
        protected Queue queue;

        public BreadthFirstEnumeration(TreeNode rootNode) {
            Vector<TreeNode> v = new Vector<TreeNode>(1);
            v.addElement(rootNode);
            this.queue = new Queue();
            this.queue.enqueue(v.elements());
        }

        @Override
        public boolean hasMoreElements() {
            return !this.queue.isEmpty() && ((Enumeration)this.queue.firstObject()).hasMoreElements();
        }

        @Override
        public TreeNode nextElement() {
            Enumeration enumer = (Enumeration)this.queue.firstObject();
            TreeNode node = (TreeNode)enumer.nextElement();
            Enumeration children = node.children();
            if (!enumer.hasMoreElements()) {
                this.queue.dequeue();
            }
            if (children.hasMoreElements()) {
                this.queue.enqueue(children);
            }
            return node;
        }

        static final class Queue {
            QNode head;
            QNode tail;

            Queue() {
            }

            public void enqueue(Object anObject) {
                if (this.head == null) {
                    this.head = this.tail = new QNode(anObject, null);
                } else {
                    this.tail = this.tail.next = new QNode(anObject, null);
                }
            }

            public Object dequeue() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                Object retval = this.head.object;
                QNode oldHead = this.head;
                this.head = this.head.next;
                if (this.head == null) {
                    this.tail = null;
                } else {
                    oldHead.next = null;
                }
                return retval;
            }

            public Object firstObject() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                return this.head.object;
            }

            public boolean isEmpty() {
                return this.head == null;
            }

            static final class QNode {
                public Object object;
                public QNode next;

                public QNode(Object object, QNode next) {
                    this.object = object;
                    this.next = next;
                }
            }
        }
    }

    static final class PathBetweenNodesEnumeration
    implements Enumeration<TreeNode> {
        protected Stack<TreeNode> stack;

        public PathBetweenNodesEnumeration(TreeNode ancestor, TreeNode descendant) {
            if (ancestor == null || descendant == null) {
                throw new IllegalArgumentException("argument is null");
            }
            this.stack = new Stack();
            this.stack.push(descendant);
            TreeNode current = descendant;
            while (current != ancestor) {
                if ((current = current.getParent()) == null && descendant != ancestor) {
                    throw new IllegalArgumentException("node " + String.valueOf(ancestor) + " is not an ancestor of " + String.valueOf(descendant));
                }
                this.stack.push(current);
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.stack.size() > 0;
        }

        @Override
        public TreeNode nextElement() {
            try {
                return this.stack.pop();
            }
            catch (EmptyStackException e) {
                throw new NoSuchElementException("No more elements");
            }
        }
    }

    static final class PostorderEnumeration
    implements Enumeration<TreeNode> {
        protected TreeNode root;
        protected Enumeration<? extends TreeNode> children;
        protected Enumeration<TreeNode> subtree;

        public PostorderEnumeration(TreeNode rootNode) {
            this.root = rootNode;
            this.children = this.root.children();
            this.subtree = EMPTY_ENUMERATION;
        }

        @Override
        public boolean hasMoreElements() {
            return this.root != null;
        }

        @Override
        public TreeNode nextElement() {
            TreeNode retval;
            if (this.subtree.hasMoreElements()) {
                retval = this.subtree.nextElement();
            } else if (this.children.hasMoreElements()) {
                this.subtree = new PostorderEnumeration(this.children.nextElement());
                retval = this.subtree.nextElement();
            } else {
                retval = this.root;
                this.root = null;
            }
            return retval;
        }
    }

    private final class PreorderEnumeration
    implements Enumeration<TreeNode> {
        private final Stack<Enumeration> stack = new Stack();

        public PreorderEnumeration(TreeNode treeNode) {
            Vector<TreeNode> vector = new Vector<TreeNode>(1);
            vector.addElement(treeNode);
            this.stack.push(vector.elements());
        }

        @Override
        public boolean hasMoreElements() {
            return !this.stack.empty() && this.stack.peek().hasMoreElements();
        }

        @Override
        public TreeNode nextElement() {
            Enumeration enumeration = this.stack.peek();
            TreeNode treeNode = (TreeNode)enumeration.nextElement();
            Enumeration enumeration2 = treeNode.children();
            if (!enumeration.hasMoreElements()) {
                this.stack.pop();
            }
            if (enumeration2.hasMoreElements()) {
                this.stack.push(enumeration2);
            }
            return treeNode;
        }
    }
}

