/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.CSSBorder;
import javax.swing.text.html.CSSParser;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.MuxingAttributeSet;
import sun.swing.SwingUtilities2;

public class StyleSheet
extends StyleContext {
    static final Border noBorder = new EmptyBorder(0, 0, 0, 0);
    static final int DEFAULT_FONT_SIZE = 3;
    private CSS css;
    private SelectorMapping selectorMapping;
    private Hashtable<String, ResolvedStyle> resolvedStyles;
    private Vector<StyleSheet> linkedStyleSheets;
    private URL base;
    static final int[] sizeMapDefault = new int[]{8, 10, 12, 14, 18, 24, 36};
    private int[] sizeMap = sizeMapDefault;
    private boolean w3cLengthUnits = false;

    public StyleSheet() {
        this.selectorMapping = new SelectorMapping(0);
        this.resolvedStyles = new Hashtable();
        if (this.css == null) {
            this.css = new CSS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Style getRule(HTML.Tag tag, Element element) {
        SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
        try {
            Style style;
            AttributeSet attributeSet;
            Vector vector = searchBuffer.getVector();
            for (Element element2 = element; element2 != null; element2 = element2.getParentElement()) {
                vector.addElement(element2);
            }
            int n = vector.size();
            StringBuffer stringBuffer = searchBuffer.getStringBuffer();
            for (int i = n - 1; i >= 1; --i) {
                element = (Element)vector.elementAt(i);
                attributeSet = element.getAttributes();
                Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
                String string = object.toString();
                stringBuffer.append(string);
                if (attributeSet != null) {
                    if (attributeSet.isDefined(HTML.Attribute.ID)) {
                        stringBuffer.append('#');
                        stringBuffer.append(attributeSet.getAttribute(HTML.Attribute.ID));
                    } else if (attributeSet.isDefined(HTML.Attribute.CLASS)) {
                        stringBuffer.append('.');
                        stringBuffer.append(attributeSet.getAttribute(HTML.Attribute.CLASS));
                    }
                }
                stringBuffer.append(' ');
            }
            stringBuffer.append(tag.toString());
            element = (Element)vector.elementAt(0);
            attributeSet = element.getAttributes();
            if (element.isLeaf()) {
                Object object = attributeSet.getAttribute(tag);
                attributeSet = object instanceof AttributeSet ? (AttributeSet)object : null;
            }
            if (attributeSet != null) {
                if (attributeSet.isDefined(HTML.Attribute.ID)) {
                    stringBuffer.append('#');
                    stringBuffer.append(attributeSet.getAttribute(HTML.Attribute.ID));
                } else if (attributeSet.isDefined(HTML.Attribute.CLASS)) {
                    stringBuffer.append('.');
                    stringBuffer.append(attributeSet.getAttribute(HTML.Attribute.CLASS));
                }
            }
            Style style2 = style = this.getResolvedStyle(stringBuffer.toString(), vector, tag);
            return style2;
        }
        finally {
            SearchBuffer.releaseSearchBuffer(searchBuffer);
        }
    }

    public Style getRule(String string) {
        if ((string = this.cleanSelectorString(string)) != null) {
            Style style = this.getResolvedStyle(string);
            return style;
        }
        return null;
    }

    public void addRule(String string) {
        if (string != null) {
            if (string == "BASE_SIZE_DISABLE") {
                this.sizeMap = sizeMapDefault;
            } else if (string.startsWith("BASE_SIZE ")) {
                this.rebaseSizeMap(Integer.parseInt(string.substring("BASE_SIZE ".length())));
            } else if (string == "W3C_LENGTH_UNITS_ENABLE") {
                this.w3cLengthUnits = true;
            } else if (string == "W3C_LENGTH_UNITS_DISABLE") {
                this.w3cLengthUnits = false;
            } else {
                CssParser cssParser = new CssParser();
                try {
                    cssParser.parse(this.getBase(), new StringReader(string), false, false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public AttributeSet getDeclaration(String string) {
        if (string == null) {
            return SimpleAttributeSet.EMPTY;
        }
        CssParser cssParser = new CssParser();
        return cssParser.parseDeclaration(string);
    }

    public void loadRules(Reader reader, URL uRL) throws IOException {
        CssParser cssParser = new CssParser();
        cssParser.parse(uRL, reader, false, false);
    }

    public AttributeSet getViewAttributes(View view) {
        return new ViewAttributeSet(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStyle(String string) {
        Style style = this.getStyle(string);
        if (style != null) {
            String string2 = this.cleanSelectorString(string);
            String[] stringArray = this.getSimpleSelectors(string2);
            StyleSheet styleSheet = this;
            synchronized (styleSheet) {
                SelectorMapping selectorMapping = this.getRootSelectorMapping();
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    selectorMapping = selectorMapping.getChildSelectorMapping(stringArray[i], true);
                }
                Style style2 = selectorMapping.getStyle();
                if (style2 != null) {
                    selectorMapping.setStyle(null);
                    if (this.resolvedStyles.size() > 0) {
                        Enumeration<ResolvedStyle> enumeration = this.resolvedStyles.elements();
                        while (enumeration.hasMoreElements()) {
                            ResolvedStyle resolvedStyle = enumeration.nextElement();
                            resolvedStyle.removeStyle(style2);
                        }
                    }
                }
            }
        }
        super.removeStyle(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStyleSheet(StyleSheet styleSheet) {
        StyleSheet styleSheet2 = this;
        synchronized (styleSheet2) {
            if (this.linkedStyleSheets == null) {
                this.linkedStyleSheets = new Vector();
            }
            if (!this.linkedStyleSheets.contains(styleSheet)) {
                int n = 0;
                if (styleSheet instanceof UIResource && this.linkedStyleSheets.size() > 1) {
                    n = this.linkedStyleSheets.size() - 1;
                }
                this.linkedStyleSheets.insertElementAt(styleSheet, n);
                this.linkStyleSheetAt(styleSheet, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStyleSheet(StyleSheet styleSheet) {
        StyleSheet styleSheet2 = this;
        synchronized (styleSheet2) {
            int n;
            if (this.linkedStyleSheets != null && (n = this.linkedStyleSheets.indexOf(styleSheet)) != -1) {
                this.linkedStyleSheets.removeElementAt(n);
                this.unlinkStyleSheet(styleSheet, n);
                if (n == 0 && this.linkedStyleSheets.size() == 0) {
                    this.linkedStyleSheets = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleSheet[] getStyleSheets() {
        Object[] objectArray;
        StyleSheet styleSheet = this;
        synchronized (styleSheet) {
            if (this.linkedStyleSheets != null) {
                objectArray = new StyleSheet[this.linkedStyleSheets.size()];
                this.linkedStyleSheets.copyInto(objectArray);
            } else {
                objectArray = null;
            }
        }
        return objectArray;
    }

    public void importStyleSheet(URL uRL) {
        try {
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            CssParser cssParser = new CssParser();
            cssParser.parse(uRL, bufferedReader, false, true);
            ((Reader)bufferedReader).close();
            inputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setBase(URL uRL) {
        this.base = uRL;
    }

    public URL getBase() {
        return this.base;
    }

    public void addCSSAttribute(MutableAttributeSet mutableAttributeSet, CSS.Attribute attribute, String string) {
        this.css.addInternalCSSValue(mutableAttributeSet, attribute, string);
    }

    public boolean addCSSAttributeFromHTML(MutableAttributeSet mutableAttributeSet, CSS.Attribute attribute, String string) {
        Object object = this.css.getCssValue(attribute, string);
        if (object != null) {
            mutableAttributeSet.addAttribute(attribute, object);
            return true;
        }
        return false;
    }

    public AttributeSet translateHTMLToCSS(AttributeSet attributeSet) {
        AttributeSet attributeSet2 = this.css.translateHTMLToCSS(attributeSet);
        Style style = this.addStyle(null, null);
        style.addAttributes(attributeSet2);
        return style;
    }

    @Override
    public AttributeSet addAttribute(AttributeSet attributeSet, Object object, Object object2) {
        if (this.css == null) {
            this.css = new CSS();
        }
        if (object instanceof StyleConstants) {
            CSS.Attribute attribute;
            Object object3;
            HTML.Tag tag = HTML.getTagForStyleConstantsKey((StyleConstants)object);
            if (tag != null && attributeSet.isDefined(tag)) {
                attributeSet = this.removeAttribute(attributeSet, tag);
            }
            if ((object3 = this.css.styleConstantsValueToCSSValue((StyleConstants)object, object2)) != null && (attribute = this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null) {
                return super.addAttribute(attributeSet, attribute, object3);
            }
        }
        return super.addAttribute(attributeSet, object, object2);
    }

    @Override
    public AttributeSet addAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (!(attributeSet2 instanceof HTMLDocument.TaggedAttributeSet)) {
            attributeSet = this.removeHTMLTags(attributeSet, attributeSet2);
        }
        return super.addAttributes(attributeSet, this.convertAttributeSet(attributeSet2));
    }

    @Override
    public AttributeSet removeAttribute(AttributeSet attributeSet, Object object) {
        if (object instanceof StyleConstants) {
            CSS.Attribute attribute;
            HTML.Tag tag = HTML.getTagForStyleConstantsKey((StyleConstants)object);
            if (tag != null) {
                attributeSet = super.removeAttribute(attributeSet, tag);
            }
            if ((attribute = this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null) {
                return super.removeAttribute(attributeSet, attribute);
            }
        }
        return super.removeAttribute(attributeSet, object);
    }

    @Override
    public AttributeSet removeAttributes(AttributeSet attributeSet, Enumeration<?> enumeration) {
        return super.removeAttributes(attributeSet, enumeration);
    }

    @Override
    public AttributeSet removeAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (attributeSet != attributeSet2) {
            attributeSet = this.removeHTMLTags(attributeSet, attributeSet2);
        }
        return super.removeAttributes(attributeSet, this.convertAttributeSet(attributeSet2));
    }

    @Override
    protected StyleContext.SmallAttributeSet createSmallAttributeSet(AttributeSet attributeSet) {
        return new SmallConversionSet(attributeSet);
    }

    @Override
    protected MutableAttributeSet createLargeAttributeSet(AttributeSet attributeSet) {
        return new LargeConversionSet(attributeSet);
    }

    private AttributeSet removeHTMLTags(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (!(attributeSet2 instanceof LargeConversionSet) && !(attributeSet2 instanceof SmallConversionSet)) {
            Enumeration<?> enumeration = attributeSet2.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                HTML.Tag tag;
                Object obj = enumeration.nextElement();
                if (!(obj instanceof StyleConstants) || (tag = HTML.getTagForStyleConstantsKey((StyleConstants)obj)) == null || !attributeSet.isDefined(tag)) continue;
                attributeSet = super.removeAttribute(attributeSet, tag);
            }
        }
        return attributeSet;
    }

    AttributeSet convertAttributeSet(AttributeSet attributeSet) {
        if (attributeSet instanceof LargeConversionSet || attributeSet instanceof SmallConversionSet) {
            return attributeSet;
        }
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (!(obj instanceof StyleConstants)) continue;
            LargeConversionSet largeConversionSet = new LargeConversionSet();
            Enumeration<?> enumeration2 = attributeSet.getAttributeNames();
            while (enumeration2.hasMoreElements()) {
                Object object;
                CSS.Attribute attribute;
                Object obj2 = enumeration2.nextElement();
                Object object2 = null;
                if (obj2 instanceof StyleConstants && (attribute = this.css.styleConstantsKeyToCSSKey((StyleConstants)obj2)) != null && (object2 = this.css.styleConstantsValueToCSSValue((StyleConstants)obj2, object = attributeSet.getAttribute(obj2))) != null) {
                    largeConversionSet.addAttribute(attribute, object2);
                }
                if (object2 != null) continue;
                largeConversionSet.addAttribute(obj2, attributeSet.getAttribute(obj2));
            }
            return largeConversionSet;
        }
        return attributeSet;
    }

    @Override
    public Font getFont(AttributeSet attributeSet) {
        return this.css.getFont(this, attributeSet, 12, this);
    }

    @Override
    public Color getForeground(AttributeSet attributeSet) {
        Color color = this.css.getColor(attributeSet, CSS.Attribute.COLOR);
        if (color == null) {
            return Color.black;
        }
        return color;
    }

    @Override
    public Color getBackground(AttributeSet attributeSet) {
        return this.css.getColor(attributeSet, CSS.Attribute.BACKGROUND_COLOR);
    }

    public BoxPainter getBoxPainter(AttributeSet attributeSet) {
        return new BoxPainter(attributeSet, this.css, this);
    }

    public ListPainter getListPainter(AttributeSet attributeSet) {
        return new ListPainter(attributeSet, this);
    }

    public void setBaseFontSize(int n) {
        this.css.setBaseFontSize(n);
    }

    public void setBaseFontSize(String string) {
        this.css.setBaseFontSize(string);
    }

    public static int getIndexOfSize(float f) {
        return CSS.getIndexOfSize(f, sizeMapDefault);
    }

    public float getPointSize(int n) {
        return this.css.getPointSize(n, this);
    }

    public float getPointSize(String string) {
        return this.css.getPointSize(string, this);
    }

    public Color stringToColor(String string) {
        return CSS.stringToColor(string);
    }

    ImageIcon getBackgroundImage(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(CSS.Attribute.BACKGROUND_IMAGE);
        if (object != null) {
            return ((CSS.BackgroundImage)object).getImage(this.getBase());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRule(String[] stringArray, AttributeSet attributeSet, boolean bl) {
        int n = stringArray.length;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(stringArray[0]);
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(' ');
            stringBuilder.append(stringArray[i]);
        }
        String string = stringBuilder.toString();
        Style style = this.getStyle(string);
        if (style == null) {
            Style style2 = this.addStyle(string, null);
            StyleSheet styleSheet = this;
            synchronized (styleSheet) {
                SelectorMapping selectorMapping = this.getRootSelectorMapping();
                for (int i = n - 1; i >= 0; --i) {
                    selectorMapping = selectorMapping.getChildSelectorMapping(stringArray[i], true);
                }
                style = selectorMapping.getStyle();
                if (style == null) {
                    style = style2;
                    selectorMapping.setStyle(style);
                    this.refreshResolvedRules(string, stringArray, style, selectorMapping.getSpecificity());
                }
            }
        }
        if (bl) {
            style = this.getLinkedStyle(style);
        }
        style.addAttributes(attributeSet);
    }

    private synchronized void linkStyleSheetAt(StyleSheet styleSheet, int n) {
        if (this.resolvedStyles.size() > 0) {
            Enumeration<ResolvedStyle> enumeration = this.resolvedStyles.elements();
            while (enumeration.hasMoreElements()) {
                ResolvedStyle resolvedStyle = enumeration.nextElement();
                resolvedStyle.insertExtendedStyleAt(styleSheet.getRule(resolvedStyle.getName()), n);
            }
        }
    }

    private synchronized void unlinkStyleSheet(StyleSheet styleSheet, int n) {
        if (this.resolvedStyles.size() > 0) {
            Enumeration<ResolvedStyle> enumeration = this.resolvedStyles.elements();
            while (enumeration.hasMoreElements()) {
                ResolvedStyle resolvedStyle = enumeration.nextElement();
                resolvedStyle.removeExtendedStyleAt(n);
            }
        }
    }

    String[] getSimpleSelectors(String string) {
        string = this.cleanSelectorString(string);
        SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
        Vector vector = searchBuffer.getVector();
        int n = 0;
        int n2 = string.length();
        while (n != -1) {
            int n3 = string.indexOf(32, n);
            if (n3 != -1) {
                vector.addElement(string.substring(n, n3));
                if (++n3 == n2) {
                    n = -1;
                    continue;
                }
                n = n3;
                continue;
            }
            vector.addElement(string.substring(n));
            n = -1;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        SearchBuffer.releaseSearchBuffer(searchBuffer);
        return objectArray;
    }

    String cleanSelectorString(String string) {
        boolean bl = true;
        int n = string.length();
        block4: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case ' ': {
                    if (bl) {
                        return this._cleanSelectorString(string);
                    }
                    bl = true;
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    return this._cleanSelectorString(string);
                }
                default: {
                    bl = false;
                }
            }
        }
        if (bl) {
            return this._cleanSelectorString(string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _cleanSelectorString(String string) {
        SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
        StringBuffer stringBuffer = searchBuffer.getStringBuffer();
        boolean bl = true;
        int n = 0;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        String string2 = null;
        try {
            block7: for (int i = 0; i < n2; ++i) {
                switch (cArray[i]) {
                    case ' ': {
                        if (!bl) {
                            bl = true;
                            if (n < i) {
                                stringBuffer.append(cArray, n, 1 + i - n);
                            }
                        }
                        n = i + 1;
                        continue block7;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        if (!bl) {
                            bl = true;
                            if (n < i) {
                                stringBuffer.append(cArray, n, i - n);
                                stringBuffer.append(' ');
                            }
                        }
                        n = i + 1;
                        continue block7;
                    }
                    default: {
                        bl = false;
                    }
                }
            }
            if (bl && stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            } else if (n < n2) {
                stringBuffer.append(cArray, n, n2 - n);
            }
            string2 = stringBuffer.toString();
        }
        finally {
            SearchBuffer.releaseSearchBuffer(searchBuffer);
        }
        return string2;
    }

    private SelectorMapping getRootSelectorMapping() {
        return this.selectorMapping;
    }

    static int getSpecificity(String string) {
        int n = 0;
        boolean bl = true;
        int n2 = string.length();
        block5: for (int i = 0; i < n2; ++i) {
            switch (string.charAt(i)) {
                case '.': {
                    n += 100;
                    continue block5;
                }
                case '#': {
                    n += 10000;
                    continue block5;
                }
                case ' ': {
                    bl = true;
                    continue block5;
                }
                default: {
                    if (!bl) continue block5;
                    bl = false;
                    ++n;
                }
            }
        }
        return n;
    }

    private Style getLinkedStyle(Style style) {
        Style style2 = (Style)style.getResolveParent();
        if (style2 == null) {
            style2 = this.addStyle(null, null);
            style.setResolveParent(style2);
        }
        return style2;
    }

    private synchronized Style getResolvedStyle(String string, Vector vector, HTML.Tag tag) {
        Style style = this.resolvedStyles.get(string);
        if (style == null) {
            style = this.createResolvedStyle(string, vector, tag);
        }
        return style;
    }

    private synchronized Style getResolvedStyle(String string) {
        Style style = this.resolvedStyles.get(string);
        if (style == null) {
            style = this.createResolvedStyle(string);
        }
        return style;
    }

    private void addSortedStyle(SelectorMapping selectorMapping, Vector<SelectorMapping> vector) {
        int n = vector.size();
        if (n > 0) {
            int n2 = selectorMapping.getSpecificity();
            for (int i = 0; i < n; ++i) {
                if (n2 < vector.elementAt(i).getSpecificity()) continue;
                vector.insertElementAt(selectorMapping, i);
                return;
            }
        }
        vector.addElement(selectorMapping);
    }

    private synchronized void getStyles(SelectorMapping selectorMapping, Vector<SelectorMapping> vector, String[] stringArray, String[] stringArray2, String[] stringArray3, int n, int n2, Hashtable<SelectorMapping, SelectorMapping> hashtable) {
        if (hashtable.contains(selectorMapping)) {
            return;
        }
        hashtable.put(selectorMapping, selectorMapping);
        Style style = selectorMapping.getStyle();
        if (style != null) {
            this.addSortedStyle(selectorMapping, vector);
        }
        for (int i = n; i < n2; ++i) {
            String string;
            String string2 = stringArray[i];
            if (string2 == null) continue;
            SelectorMapping selectorMapping2 = selectorMapping.getChildSelectorMapping(string2, false);
            if (selectorMapping2 != null) {
                this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, i + 1, n2, hashtable);
            }
            if (stringArray3[i] != null) {
                string = stringArray3[i];
                selectorMapping2 = selectorMapping.getChildSelectorMapping(string2 + "." + string, false);
                if (selectorMapping2 != null) {
                    this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, i + 1, n2, hashtable);
                }
                if ((selectorMapping2 = selectorMapping.getChildSelectorMapping("." + string, false)) != null) {
                    this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, i + 1, n2, hashtable);
                }
            }
            if (stringArray2[i] == null) continue;
            string = stringArray2[i];
            selectorMapping2 = selectorMapping.getChildSelectorMapping(string2 + "#" + string, false);
            if (selectorMapping2 != null) {
                this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, i + 1, n2, hashtable);
            }
            if ((selectorMapping2 = selectorMapping.getChildSelectorMapping("#" + string, false)) == null) continue;
            this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, i + 1, n2, hashtable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Style createResolvedStyle(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
        Vector vector = searchBuffer.getVector();
        Hashtable hashtable = searchBuffer.getHashtable();
        try {
            Style style;
            int n;
            String string2;
            SelectorMapping selectorMapping = this.getRootSelectorMapping();
            int n2 = stringArray.length;
            String string3 = stringArray[0];
            SelectorMapping selectorMapping2 = selectorMapping.getChildSelectorMapping(string3, false);
            if (selectorMapping2 != null) {
                this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, 1, n2, hashtable);
            }
            if (stringArray3[0] != null) {
                string2 = stringArray3[0];
                selectorMapping2 = selectorMapping.getChildSelectorMapping(string3 + "." + string2, false);
                if (selectorMapping2 != null) {
                    this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, 1, n2, hashtable);
                }
                if ((selectorMapping2 = selectorMapping.getChildSelectorMapping("." + string2, false)) != null) {
                    this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, 1, n2, hashtable);
                }
            }
            if (stringArray2[0] != null) {
                string2 = stringArray2[0];
                selectorMapping2 = selectorMapping.getChildSelectorMapping(string3 + "#" + string2, false);
                if (selectorMapping2 != null) {
                    this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, 1, n2, hashtable);
                }
                if ((selectorMapping2 = selectorMapping.getChildSelectorMapping("#" + string2, false)) != null) {
                    this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, 1, n2, hashtable);
                }
            }
            int n3 = this.linkedStyleSheets != null ? this.linkedStyleSheets.size() : 0;
            int n4 = vector.size();
            AttributeSet[] attributeSetArray = new AttributeSet[n4 + n3];
            for (n = 0; n < n4; ++n) {
                attributeSetArray[n] = ((SelectorMapping)vector.elementAt(n)).getStyle();
            }
            for (n = 0; n < n3; ++n) {
                style = this.linkedStyleSheets.elementAt(n).getRule(string);
                attributeSetArray[n + n4] = style == null ? SimpleAttributeSet.EMPTY : style;
            }
            ResolvedStyle resolvedStyle = new ResolvedStyle(string, attributeSetArray, n4);
            this.resolvedStyles.put(string, resolvedStyle);
            style = resolvedStyle;
            return style;
        }
        finally {
            SearchBuffer.releaseSearchBuffer(searchBuffer);
        }
    }

    private Style createResolvedStyle(String string, Vector vector, HTML.Tag tag) {
        int n = vector.size();
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        String[] stringArray3 = new String[n];
        for (int i = 0; i < n; ++i) {
            Object object;
            Element element = (Element)vector.elementAt(i);
            AttributeSet attributeSet = element.getAttributes();
            if (i == 0 && element.isLeaf()) {
                object = attributeSet.getAttribute(tag);
                attributeSet = object instanceof AttributeSet ? (AttributeSet)object : null;
            }
            if (attributeSet != null) {
                object = (HTML.Tag)attributeSet.getAttribute(StyleConstants.NameAttribute);
                stringArray[i] = object != null ? ((HTML.Tag)object).toString() : null;
                stringArray3[i] = attributeSet.isDefined(HTML.Attribute.CLASS) ? attributeSet.getAttribute(HTML.Attribute.CLASS).toString() : null;
                if (attributeSet.isDefined(HTML.Attribute.ID)) {
                    stringArray2[i] = attributeSet.getAttribute(HTML.Attribute.ID).toString();
                    continue;
                }
                stringArray2[i] = null;
                continue;
            }
            stringArray3[i] = null;
            stringArray2[i] = null;
            stringArray[i] = null;
        }
        stringArray[0] = tag.toString();
        return this.createResolvedStyle(string, stringArray, stringArray2, stringArray3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Style createResolvedStyle(String string) {
        SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
        Vector vector = searchBuffer.getVector();
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = string.length();
            while (n3 < n4) {
                int n5;
                if (n == n3) {
                    n = string.indexOf(46, n3);
                }
                if (n2 == n3) {
                    n2 = string.indexOf(35, n3);
                }
                if ((n5 = string.indexOf(32, n3)) == -1) {
                    n5 = n4;
                }
                if (n != -1 && n2 != -1 && n < n5 && n2 < n5) {
                    if (n2 < n) {
                        if (n3 == n2) {
                            vector.addElement("");
                        } else {
                            vector.addElement(string.substring(n3, n2));
                        }
                        if (n + 1 < n5) {
                            vector.addElement(string.substring(n + 1, n5));
                        } else {
                            vector.addElement(null);
                        }
                        if (n2 + 1 == n) {
                            vector.addElement(null);
                        } else {
                            vector.addElement(string.substring(n2 + 1, n));
                        }
                    } else if (n2 < n5) {
                        if (n3 == n) {
                            vector.addElement("");
                        } else {
                            vector.addElement(string.substring(n3, n));
                        }
                        if (n + 1 < n2) {
                            vector.addElement(string.substring(n + 1, n2));
                        } else {
                            vector.addElement(null);
                        }
                        if (n2 + 1 == n5) {
                            vector.addElement(null);
                        } else {
                            vector.addElement(string.substring(n2 + 1, n5));
                        }
                    }
                    n = n2 = n5 + 1;
                } else if (n != -1 && n < n5) {
                    if (n == n3) {
                        vector.addElement("");
                    } else {
                        vector.addElement(string.substring(n3, n));
                    }
                    if (n + 1 == n5) {
                        vector.addElement(null);
                    } else {
                        vector.addElement(string.substring(n + 1, n5));
                    }
                    vector.addElement(null);
                    n = n5 + 1;
                } else if (n2 != -1 && n2 < n5) {
                    if (n2 == n3) {
                        vector.addElement("");
                    } else {
                        vector.addElement(string.substring(n3, n2));
                    }
                    vector.addElement(null);
                    if (n2 + 1 == n5) {
                        vector.addElement(null);
                    } else {
                        vector.addElement(string.substring(n2 + 1, n5));
                    }
                    n2 = n5 + 1;
                } else {
                    vector.addElement(string.substring(n3, n5));
                    vector.addElement(null);
                    vector.addElement(null);
                }
                n3 = n5 + 1;
            }
            int n6 = vector.size();
            int n7 = n6 / 3;
            String[] stringArray = new String[n7];
            String[] stringArray2 = new String[n7];
            String[] stringArray3 = new String[n7];
            int n8 = 0;
            int n9 = n6 - 3;
            while (n8 < n7) {
                stringArray[n8] = (String)vector.elementAt(n9);
                stringArray3[n8] = (String)vector.elementAt(n9 + 1);
                stringArray2[n8] = (String)vector.elementAt(n9 + 2);
                ++n8;
                n9 -= 3;
            }
            Style style = this.createResolvedStyle(string, stringArray, stringArray2, stringArray3);
            return style;
        }
        finally {
            SearchBuffer.releaseSearchBuffer(searchBuffer);
        }
    }

    private synchronized void refreshResolvedRules(String string, String[] stringArray, Style style, int n) {
        if (this.resolvedStyles.size() > 0) {
            Enumeration<ResolvedStyle> enumeration = this.resolvedStyles.elements();
            while (enumeration.hasMoreElements()) {
                ResolvedStyle resolvedStyle = enumeration.nextElement();
                if (!resolvedStyle.matches(string)) continue;
                resolvedStyle.insertStyle(style, n);
            }
        }
    }

    void rebaseSizeMap(int n) {
        this.sizeMap = new int[sizeMapDefault.length];
        for (int i = 0; i < sizeMapDefault.length; ++i) {
            this.sizeMap[i] = Math.max(n * sizeMapDefault[i] / sizeMapDefault[CSS.baseFontSizeIndex], 4);
        }
    }

    int[] getSizeMap() {
        return this.sizeMap;
    }

    boolean isW3CLengthUnits() {
        return this.w3cLengthUnits;
    }

    static class BackgroundImagePainter
    implements Serializable {
        ImageIcon backgroundImage;
        float hPosition;
        float vPosition;
        short flags;
        private int paintX;
        private int paintY;
        private int paintMaxX;
        private int paintMaxY;

        BackgroundImagePainter(AttributeSet a, CSS css, StyleSheet ss) {
            CSS.Value repeats;
            this.backgroundImage = ss.getBackgroundImage(a);
            CSS.BackgroundPosition pos = (CSS.BackgroundPosition)a.getAttribute(CSS.Attribute.BACKGROUND_POSITION);
            if (pos != null) {
                this.hPosition = pos.getHorizontalPosition();
                this.vPosition = pos.getVerticalPosition();
                if (pos.isHorizontalPositionRelativeToSize()) {
                    this.flags = (short)(this.flags | 4);
                } else if (pos.isHorizontalPositionRelativeToFontSize()) {
                    this.hPosition *= (float)CSS.getFontSize(a, 12, ss);
                }
                if (pos.isVerticalPositionRelativeToSize()) {
                    this.flags = (short)(this.flags | 8);
                } else if (pos.isVerticalPositionRelativeToFontSize()) {
                    this.vPosition *= (float)CSS.getFontSize(a, 12, ss);
                }
            }
            if ((repeats = (CSS.Value)a.getAttribute(CSS.Attribute.BACKGROUND_REPEAT)) == null || repeats == CSS.Value.BACKGROUND_REPEAT) {
                this.flags = (short)(this.flags | 3);
            } else if (repeats == CSS.Value.BACKGROUND_REPEAT_X) {
                this.flags = (short)(this.flags | 1);
            } else if (repeats == CSS.Value.BACKGROUND_REPEAT_Y) {
                this.flags = (short)(this.flags | 2);
            }
        }

        void paint(Graphics g, float x, float y, float w, float h, View v) {
            Rectangle clip = g.getClipRect();
            if (clip != null) {
                g.clipRect((int)x, (int)y, (int)w, (int)h);
            }
            if ((this.flags & 3) == 0) {
                int width = this.backgroundImage.getIconWidth();
                int height = this.backgroundImage.getIconWidth();
                this.paintX = (this.flags & 4) == 4 ? (int)(x + w * this.hPosition - (float)width * this.hPosition) : (int)x + (int)this.hPosition;
                this.paintY = (this.flags & 8) == 8 ? (int)(y + h * this.vPosition - (float)height * this.vPosition) : (int)y + (int)this.vPosition;
                if (clip == null || this.paintX + width > clip.x && this.paintY + height > clip.y && this.paintX < clip.x + clip.width && this.paintY < clip.y + clip.height) {
                    this.backgroundImage.paintIcon(null, g, this.paintX, this.paintY);
                }
            } else {
                int width = this.backgroundImage.getIconWidth();
                int height = this.backgroundImage.getIconHeight();
                if (width > 0 && height > 0) {
                    this.paintX = (int)x;
                    this.paintY = (int)y;
                    this.paintMaxX = (int)(x + w);
                    this.paintMaxY = (int)(y + h);
                    if (this.updatePaintCoordinates(clip, width, height)) {
                        while (this.paintX < this.paintMaxX) {
                            for (int ySpot = this.paintY; ySpot < this.paintMaxY; ySpot += height) {
                                this.backgroundImage.paintIcon(null, g, this.paintX, ySpot);
                            }
                            this.paintX += width;
                        }
                    }
                }
            }
            if (clip != null) {
                g.setClip(clip.x, clip.y, clip.width, clip.height);
            }
        }

        private boolean updatePaintCoordinates(Rectangle clip, int width, int height) {
            if ((this.flags & 3) == 1) {
                this.paintMaxY = this.paintY + 1;
            } else if ((this.flags & 3) == 2) {
                this.paintMaxX = this.paintX + 1;
            }
            if (clip != null) {
                if ((this.flags & 3) == 1 && (this.paintY + height <= clip.y || this.paintY > clip.y + clip.height)) {
                    return false;
                }
                if ((this.flags & 3) == 2 && (this.paintX + width <= clip.x || this.paintX > clip.x + clip.width)) {
                    return false;
                }
                if ((this.flags & 1) == 1) {
                    if (clip.x + clip.width < this.paintMaxX) {
                        this.paintMaxX = (clip.x + clip.width - this.paintX) % width == 0 ? clip.x + clip.width : ((clip.x + clip.width - this.paintX) / width + 1) * width + this.paintX;
                    }
                    if (clip.x > this.paintX) {
                        this.paintX = (clip.x - this.paintX) / width * width + this.paintX;
                    }
                }
                if ((this.flags & 2) == 2) {
                    if (clip.y + clip.height < this.paintMaxY) {
                        this.paintMaxY = (clip.y + clip.height - this.paintY) % height == 0 ? clip.y + clip.height : ((clip.y + clip.height - this.paintY) / height + 1) * height + this.paintY;
                    }
                    if (clip.y > this.paintY) {
                        this.paintY = (clip.y - this.paintY) / height * height + this.paintY;
                    }
                }
            }
            return true;
        }
    }

    public static class BoxPainter
    implements Serializable {
        float topMargin;
        float bottomMargin;
        float leftMargin;
        float rightMargin;
        short marginFlags;
        Border border;
        Insets binsets;
        CSS css;
        StyleSheet ss;
        Color bg;
        BackgroundImagePainter bgPainter;

        BoxPainter(AttributeSet attributeSet, CSS cSS, StyleSheet styleSheet) {
            this.ss = styleSheet;
            this.css = cSS;
            this.border = this.getBorder(attributeSet);
            this.binsets = this.border.getBorderInsets(null);
            this.topMargin = this.getLength(CSS.Attribute.MARGIN_TOP, attributeSet);
            this.bottomMargin = this.getLength(CSS.Attribute.MARGIN_BOTTOM, attributeSet);
            this.leftMargin = this.getLength(CSS.Attribute.MARGIN_LEFT, attributeSet);
            this.rightMargin = this.getLength(CSS.Attribute.MARGIN_RIGHT, attributeSet);
            this.bg = styleSheet.getBackground(attributeSet);
            if (styleSheet.getBackgroundImage(attributeSet) != null) {
                this.bgPainter = new BackgroundImagePainter(attributeSet, cSS, styleSheet);
            }
        }

        Border getBorder(AttributeSet attributeSet) {
            return new CSSBorder(attributeSet);
        }

        Color getBorderColor(AttributeSet attributeSet) {
            Color color = this.css.getColor(attributeSet, CSS.Attribute.BORDER_COLOR);
            if (color == null && (color = this.css.getColor(attributeSet, CSS.Attribute.COLOR)) == null) {
                return Color.black;
            }
            return color;
        }

        public float getInset(int n, View view) {
            AttributeSet attributeSet = view.getAttributes();
            float f = 0.0f;
            switch (n) {
                case 2: {
                    f += this.getOrientationMargin(HorizontalMargin.LEFT, this.leftMargin, attributeSet, BoxPainter.isLeftToRight(view));
                    f += (float)this.binsets.left;
                    f += this.getLength(CSS.Attribute.PADDING_LEFT, attributeSet);
                    break;
                }
                case 4: {
                    f += this.getOrientationMargin(HorizontalMargin.RIGHT, this.rightMargin, attributeSet, BoxPainter.isLeftToRight(view));
                    f += (float)this.binsets.right;
                    f += this.getLength(CSS.Attribute.PADDING_RIGHT, attributeSet);
                    break;
                }
                case 1: {
                    f += this.topMargin;
                    f += (float)this.binsets.top;
                    f += this.getLength(CSS.Attribute.PADDING_TOP, attributeSet);
                    break;
                }
                case 3: {
                    f += this.bottomMargin;
                    f += (float)this.binsets.bottom;
                    f += this.getLength(CSS.Attribute.PADDING_BOTTOM, attributeSet);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid side: " + n);
                }
            }
            return f;
        }

        public void paint(Graphics graphics, float f, float f2, float f3, float f4, View view) {
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            AttributeSet attributeSet = view.getAttributes();
            boolean bl = BoxPainter.isLeftToRight(view);
            float f9 = this.getOrientationMargin(HorizontalMargin.LEFT, this.leftMargin, attributeSet, bl);
            float f10 = this.getOrientationMargin(HorizontalMargin.RIGHT, this.rightMargin, attributeSet, bl);
            if (!(view instanceof HTMLEditorKit.HTMLFactory.BodyBlockView)) {
                f5 = f9;
                f6 = this.topMargin;
                f7 = -(f9 + f10);
                f8 = -(this.topMargin + this.bottomMargin);
            }
            if (this.bg != null) {
                graphics.setColor(this.bg);
                graphics.fillRect((int)(f + f5), (int)(f2 + f6), (int)(f3 + f7), (int)(f4 + f8));
            }
            if (this.bgPainter != null) {
                this.bgPainter.paint(graphics, f + f5, f2 + f6, f3 + f7, f4 + f8, view);
            }
            f += f9;
            f2 += this.topMargin;
            f3 -= f9 + f10;
            f4 -= this.topMargin + this.bottomMargin;
            if (this.border instanceof BevelBorder) {
                int n = (int)this.getLength(CSS.Attribute.BORDER_TOP_WIDTH, attributeSet);
                for (int i = n - 1; i >= 0; --i) {
                    this.border.paintBorder(null, graphics, (int)f + i, (int)f2 + i, (int)f3 - 2 * i, (int)f4 - 2 * i);
                }
            } else {
                this.border.paintBorder(null, graphics, (int)f, (int)f2, (int)f3, (int)f4);
            }
        }

        float getLength(CSS.Attribute attribute, AttributeSet attributeSet) {
            return this.css.getLength(attributeSet, attribute, this.ss);
        }

        static boolean isLeftToRight(View view) {
            Container container;
            boolean bl = true;
            if (BoxPainter.isOrientationAware(view) && view != null && (container = view.getContainer()) != null) {
                bl = container.getComponentOrientation().isLeftToRight();
            }
            return bl;
        }

        static boolean isOrientationAware(View view) {
            Object object;
            AttributeSet attributeSet;
            boolean bl = false;
            if (view != null && (attributeSet = view.getElement().getAttributes()) != null && (object = attributeSet.getAttribute(StyleConstants.NameAttribute)) instanceof HTML.Tag && (object == HTML.Tag.DIR || object == HTML.Tag.MENU || object == HTML.Tag.UL || object == HTML.Tag.OL)) {
                bl = true;
            }
            return bl;
        }

        float getOrientationMargin(HorizontalMargin horizontalMargin, float f, AttributeSet attributeSet, boolean bl) {
            float f2 = f;
            float f3 = f;
            Object object = null;
            switch (horizontalMargin) {
                case RIGHT: {
                    f3 = bl ? this.getLength(CSS.Attribute.MARGIN_RIGHT_LTR, attributeSet) : this.getLength(CSS.Attribute.MARGIN_RIGHT_RTL, attributeSet);
                    object = attributeSet.getAttribute(CSS.Attribute.MARGIN_RIGHT);
                    break;
                }
                case LEFT: {
                    f3 = bl ? this.getLength(CSS.Attribute.MARGIN_LEFT_LTR, attributeSet) : this.getLength(CSS.Attribute.MARGIN_LEFT_RTL, attributeSet);
                    object = attributeSet.getAttribute(CSS.Attribute.MARGIN_LEFT);
                }
            }
            if (object == null && f3 != -2.1474836E9f) {
                f2 = f3;
            }
            return f2;
        }

        static enum HorizontalMargin {
            LEFT,
            RIGHT;

        }
    }

    class CssParser
    implements CSSParser.CSSParserCallback {
        Vector<String[]> selectors = new Vector();
        Vector<String> selectorTokens = new Vector();
        String propertyName;
        MutableAttributeSet declaration = new SimpleAttributeSet();
        boolean parsingDeclaration;
        boolean isLink;
        URL base;
        CSSParser parser = new CSSParser();

        CssParser() {
        }

        public AttributeSet parseDeclaration(String string) {
            try {
                return this.parseDeclaration(new StringReader(string));
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public AttributeSet parseDeclaration(Reader reader) throws IOException {
            this.parse(this.base, reader, true, false);
            return this.declaration.copyAttributes();
        }

        public void parse(URL uRL, Reader reader, boolean bl, boolean bl2) throws IOException {
            this.base = uRL;
            this.isLink = bl2;
            this.parsingDeclaration = bl;
            this.declaration.removeAttributes(this.declaration);
            this.selectorTokens.removeAllElements();
            this.selectors.removeAllElements();
            this.propertyName = null;
            this.parser.parse(reader, this, bl);
        }

        @Override
        public void handleImport(String string) {
            URL uRL = CSS.getURL(this.base, string);
            if (uRL != null) {
                StyleSheet.this.importStyleSheet(uRL);
            }
        }

        @Override
        public void handleSelector(String string) {
            if (!string.startsWith(".") && !string.startsWith("#")) {
                string = string.toLowerCase();
            }
            int n = string.length();
            if (string.endsWith(",")) {
                if (n > 1) {
                    string = string.substring(0, n - 1);
                    this.selectorTokens.addElement(string);
                }
                this.addSelector();
            } else if (n > 0) {
                this.selectorTokens.addElement(string);
            }
        }

        @Override
        public void startRule() {
            if (this.selectorTokens.size() > 0) {
                this.addSelector();
            }
            this.propertyName = null;
        }

        @Override
        public void handleProperty(String string) {
            this.propertyName = string;
        }

        @Override
        public void handleValue(String string) {
            if (this.propertyName != null && string != null && string.length() > 0) {
                CSS.Attribute attribute = CSS.getAttribute(this.propertyName);
                if (attribute != null) {
                    URL uRL;
                    if (attribute == CSS.Attribute.LIST_STYLE_IMAGE && string != null && !string.equals("none") && (uRL = CSS.getURL(this.base, string)) != null) {
                        string = uRL.toString();
                    }
                    StyleSheet.this.addCSSAttribute(this.declaration, attribute, string);
                }
                this.propertyName = null;
            }
        }

        @Override
        public void endRule() {
            int n = this.selectors.size();
            for (int i = 0; i < n; ++i) {
                String[] stringArray = this.selectors.elementAt(i);
                if (stringArray.length <= 0) continue;
                StyleSheet.this.addRule(stringArray, this.declaration, this.isLink);
            }
            this.declaration.removeAttributes(this.declaration);
            this.selectors.removeAllElements();
        }

        private void addSelector() {
            Object[] objectArray = new String[this.selectorTokens.size()];
            this.selectorTokens.copyInto(objectArray);
            this.selectors.addElement((String[])objectArray);
            this.selectorTokens.removeAllElements();
        }
    }

    class LargeConversionSet
    extends SimpleAttributeSet {
        public LargeConversionSet(AttributeSet attributeSet) {
            super(attributeSet);
        }

        public LargeConversionSet() {
        }

        @Override
        public boolean isDefined(Object object) {
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null) {
                return super.isDefined(attribute);
            }
            return super.isDefined(object);
        }

        @Override
        public Object getAttribute(Object object) {
            Object object2;
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null && (object2 = super.getAttribute(attribute)) != null) {
                return StyleSheet.this.css.cssValueToStyleConstantsValue((StyleConstants)object, object2);
            }
            return super.getAttribute(object);
        }
    }

    public static final class ListPainter
    implements Serializable {
        static final char[][] romanChars = new char[][]{{'i', 'v'}, {'x', 'l'}, {'c', 'd'}, {'m', '?'}};
        private Rectangle paintRect;
        private boolean checkedForStart;
        private int start;
        private CSS.Value type;
        private StyleSheet ss = null;
        Icon img = null;
        private int bulletgap = 5;
        private boolean isLeftToRight;

        ListPainter(AttributeSet attr, StyleSheet ss) {
            this.ss = ss;
            String imgstr = (String)attr.getAttribute(CSS.Attribute.LIST_STYLE_IMAGE);
            this.type = null;
            if (imgstr != null && !imgstr.equals("none")) {
                String tmpstr = null;
                try {
                    StringTokenizer st = new StringTokenizer(imgstr, "()");
                    if (st.hasMoreTokens()) {
                        tmpstr = st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        tmpstr = st.nextToken();
                    }
                    URL u = new URL(tmpstr);
                    this.img = new ImageIcon(u);
                }
                catch (MalformedURLException e) {
                    if (tmpstr != null && ss != null && ss.getBase() != null) {
                        try {
                            URL u = new URL(ss.getBase(), tmpstr);
                            this.img = new ImageIcon(u);
                        }
                        catch (MalformedURLException murle) {
                            this.img = null;
                        }
                    }
                    this.img = null;
                }
            }
            if (this.img == null) {
                this.type = (CSS.Value)attr.getAttribute(CSS.Attribute.LIST_STYLE_TYPE);
            }
            this.start = 1;
            this.paintRect = new Rectangle();
        }

        private CSS.Value getChildType(View childView) {
            CSS.Value childtype = (CSS.Value)childView.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE);
            if (childtype == null) {
                if (this.type == null) {
                    View v = childView.getParent();
                    HTMLDocument doc = (HTMLDocument)v.getDocument();
                    childtype = HTMLDocument.matchNameAttribute(v.getElement().getAttributes(), HTML.Tag.OL) ? CSS.Value.DECIMAL : CSS.Value.DISC;
                } else {
                    childtype = this.type;
                }
            }
            return childtype;
        }

        private void getStart(View parent) {
            Object startValue;
            AttributeSet attr;
            this.checkedForStart = true;
            Element element = parent.getElement();
            if (element != null && (attr = element.getAttributes()) != null && attr.isDefined(HTML.Attribute.START) && (startValue = attr.getAttribute(HTML.Attribute.START)) != null && startValue instanceof String) {
                try {
                    this.start = Integer.parseInt((String)startValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        private int getRenderIndex(View parentView, int childIndex) {
            if (!this.checkedForStart) {
                this.getStart(parentView);
            }
            int retIndex = childIndex;
            for (int counter = childIndex; counter >= 0; --counter) {
                Object value;
                AttributeSet as = parentView.getElement().getElement(counter).getAttributes();
                if (as.getAttribute(StyleConstants.NameAttribute) != HTML.Tag.LI) {
                    --retIndex;
                    continue;
                }
                if (!as.isDefined(HTML.Attribute.VALUE) || !((value = as.getAttribute(HTML.Attribute.VALUE)) instanceof String)) continue;
                String s = (String)value;
                try {
                    int iValue = Integer.parseInt(s);
                    return retIndex - counter + iValue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return retIndex + this.start;
        }

        public void paint(Graphics g, float x, float y, float w, float h, View v, int item) {
            View pView;
            Object cName;
            View cv = v.getView(item);
            Container host = v.getContainer();
            Object name = cv.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (!(name instanceof HTML.Tag) || name != HTML.Tag.LI) {
                return;
            }
            this.isLeftToRight = host.getComponentOrientation().isLeftToRight();
            float align = 0.0f;
            if (cv.getViewCount() > 0 && ((cName = (pView = cv.getView(0)).getElement().getAttributes().getAttribute(StyleConstants.NameAttribute)) == HTML.Tag.P || cName == HTML.Tag.IMPLIED) && pView.getViewCount() > 0) {
                this.paintRect.setBounds((int)x, (int)y, (int)w, (int)h);
                Shape shape = cv.getChildAllocation(0, this.paintRect);
                if (shape != null && (shape = pView.getView(0).getChildAllocation(0, shape)) != null) {
                    Rectangle rect = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                    align = pView.getView(0).getAlignment(1);
                    y = rect.y;
                    h = rect.height;
                }
            }
            Color c = host.isEnabled() ? (this.ss != null ? this.ss.getForeground(cv.getAttributes()) : host.getForeground()) : UIManager.getColor("textInactiveText");
            g.setColor(c);
            if (this.img != null) {
                this.drawIcon(g, (int)x, (int)y, (int)w, (int)h, align, host);
                return;
            }
            CSS.Value childtype = this.getChildType(cv);
            Font font = ((StyledDocument)cv.getDocument()).getFont(cv.getAttributes());
            if (font != null) {
                g.setFont(font);
            }
            if (childtype == CSS.Value.SQUARE || childtype == CSS.Value.CIRCLE || childtype == CSS.Value.DISC) {
                this.drawShape(g, childtype, (int)x, (int)y, (int)w, (int)h, align);
            } else if (childtype == CSS.Value.DECIMAL) {
                this.drawLetter(g, '1', (int)x, (int)y, (int)w, (int)h, align, this.getRenderIndex(v, item));
            } else if (childtype == CSS.Value.LOWER_ALPHA) {
                this.drawLetter(g, 'a', (int)x, (int)y, (int)w, (int)h, align, this.getRenderIndex(v, item));
            } else if (childtype == CSS.Value.UPPER_ALPHA) {
                this.drawLetter(g, 'A', (int)x, (int)y, (int)w, (int)h, align, this.getRenderIndex(v, item));
            } else if (childtype == CSS.Value.LOWER_ROMAN) {
                this.drawLetter(g, 'i', (int)x, (int)y, (int)w, (int)h, align, this.getRenderIndex(v, item));
            } else if (childtype == CSS.Value.UPPER_ROMAN) {
                this.drawLetter(g, 'I', (int)x, (int)y, (int)w, (int)h, align, this.getRenderIndex(v, item));
            }
        }

        void drawIcon(Graphics g, int ax, int ay, int aw, int ah, float align, Component c) {
            int gap = this.isLeftToRight ? -(this.img.getIconWidth() + this.bulletgap) : aw + this.bulletgap;
            int x = ax + gap;
            int y = Math.max(ay, ay + (int)(align * (float)ah) - this.img.getIconHeight());
            this.img.paintIcon(c, g, x, y);
        }

        void drawShape(Graphics g, CSS.Value type, int ax, int ay, int aw, int ah, float align) {
            Object origAA = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int size = g.getFont().getSize();
            int gap = this.isLeftToRight ? -(this.bulletgap + size / 3) : aw + this.bulletgap;
            int x = ax + gap;
            int y = Math.max(ay, ay + (int)Math.ceil(ah / 2));
            if (type == CSS.Value.SQUARE) {
                g.drawRect(x, y, size / 3, size / 3);
            } else if (type == CSS.Value.CIRCLE) {
                g.drawOval(x, y, size / 3, size / 3);
            } else {
                g.fillOval(x, y, size / 3, size / 3);
            }
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, origAA);
        }

        void drawLetter(Graphics g, char letter, int ax, int ay, int aw, int ah, float align, int index) {
            Object str = this.formatItemNum(index, letter);
            str = this.isLeftToRight ? (String)str + "." : "." + (String)str;
            FontMetrics fm = SwingUtilities2.getFontMetrics(null, g);
            int stringwidth = SwingUtilities2.stringWidth(null, fm, (String)str);
            int gap = this.isLeftToRight ? -(stringwidth + this.bulletgap) : aw + this.bulletgap;
            int x = ax + gap;
            int y = Math.max(ay + fm.getAscent(), ay + (int)((float)ah * align));
            SwingUtilities2.drawString(null, g, (String)str, x, y);
        }

        String formatItemNum(int itemNum, char type) {
            String formattedNum;
            String numStyle = "1";
            boolean uppercase = false;
            switch (type) {
                default: {
                    formattedNum = String.valueOf(itemNum);
                    break;
                }
                case 'A': {
                    uppercase = true;
                }
                case 'a': {
                    formattedNum = this.formatAlphaNumerals(itemNum);
                    break;
                }
                case 'I': {
                    uppercase = true;
                }
                case 'i': {
                    formattedNum = this.formatRomanNumerals(itemNum);
                }
            }
            if (uppercase) {
                formattedNum = formattedNum.toUpperCase();
            }
            return formattedNum;
        }

        String formatAlphaNumerals(int itemNum) {
            Object result = itemNum > 26 ? this.formatAlphaNumerals(itemNum / 26) + this.formatAlphaNumerals(itemNum % 26) : String.valueOf((char)(97 + itemNum - 1));
            return result;
        }

        String formatRomanNumerals(int num) {
            return this.formatRomanNumerals(0, num);
        }

        String formatRomanNumerals(int level, int num) {
            if (num < 10) {
                return this.formatRomanDigit(level, num);
            }
            return this.formatRomanNumerals(level + 1, num / 10) + this.formatRomanDigit(level, num % 10);
        }

        String formatRomanDigit(int level, int digit) {
            Object result = "";
            if (digit == 9) {
                result = (String)result + romanChars[level][0];
                result = (String)result + romanChars[level + 1][0];
                return result;
            }
            if (digit == 4) {
                result = (String)result + romanChars[level][0];
                result = (String)result + romanChars[level][1];
                return result;
            }
            if (digit >= 5) {
                result = (String)result + romanChars[level][1];
                digit -= 5;
            }
            for (int i = 0; i < digit; ++i) {
                result = (String)result + romanChars[level][0];
            }
            return result;
        }
    }

    static class ResolvedStyle
    extends MuxingAttributeSet
    implements Serializable,
    Style {
        String name;
        private int extendedIndex;

        ResolvedStyle(String string, AttributeSet[] attributeSetArray, int n) {
            super(attributeSetArray);
            this.name = string;
            this.extendedIndex = n;
        }

        synchronized void insertStyle(Style style, int n) {
            int n2;
            AttributeSet[] attributeSetArray = this.getAttributes();
            int n3 = attributeSetArray.length;
            for (n2 = 0; n2 < this.extendedIndex && n <= StyleSheet.getSpecificity(((Style)attributeSetArray[n2]).getName()); ++n2) {
            }
            this.insertAttributeSetAt(style, n2);
            ++this.extendedIndex;
        }

        synchronized void removeStyle(Style style) {
            AttributeSet[] attributeSetArray = this.getAttributes();
            for (int i = attributeSetArray.length - 1; i >= 0; --i) {
                if (attributeSetArray[i] != style) continue;
                this.removeAttributeSetAt(i);
                if (i >= this.extendedIndex) break;
                --this.extendedIndex;
                break;
            }
        }

        synchronized void insertExtendedStyleAt(Style style, int n) {
            this.insertAttributeSetAt(style, this.extendedIndex + n);
        }

        synchronized void addExtendedStyle(Style style) {
            this.insertAttributeSetAt(style, this.getAttributes().length);
        }

        synchronized void removeExtendedStyleAt(int n) {
            this.removeAttributeSetAt(this.extendedIndex + n);
        }

        protected boolean matches(String string) {
            int n = string.length();
            if (n == 0) {
                return false;
            }
            int n2 = this.name.length();
            int n3 = string.lastIndexOf(32);
            int n4 = this.name.lastIndexOf(32);
            if (n3 >= 0) {
                ++n3;
            }
            if (n4 >= 0) {
                ++n4;
            }
            if (!this.matches(string, n3, n, n4, n2)) {
                return false;
            }
            while (n3 != -1) {
                n = n3 - 1;
                if ((n3 = string.lastIndexOf(32, n - 1)) >= 0) {
                    ++n3;
                }
                boolean bl = false;
                while (!bl && n4 != -1) {
                    n2 = n4 - 1;
                    if ((n4 = this.name.lastIndexOf(32, n2 - 1)) >= 0) {
                        ++n4;
                    }
                    bl = this.matches(string, n3, n, n4, n2);
                }
                if (bl) continue;
                return false;
            }
            return true;
        }

        boolean matches(String string, int n, int n2, int n3, int n4) {
            n = Math.max(n, 0);
            n3 = Math.max(n3, 0);
            int n5 = this.boundedIndexOf(this.name, '.', n3, n4);
            int n6 = this.boundedIndexOf(this.name, '#', n3, n4);
            int n7 = this.boundedIndexOf(string, '.', n, n2);
            int n8 = this.boundedIndexOf(string, '#', n, n2);
            if (n7 != -1) {
                if (n5 == -1) {
                    return false;
                }
                return !(n == n7 ? n4 - n5 != n2 - n7 || !string.regionMatches(n, this.name, n5, n4 - n5) : n2 - n != n4 - n3 || !string.regionMatches(n, this.name, n3, n4 - n3));
            }
            if (n8 != -1) {
                if (n6 == -1) {
                    return false;
                }
                return !(n == n8 ? n4 - n6 != n2 - n8 || !string.regionMatches(n, this.name, n6, n4 - n6) : n2 - n != n4 - n3 || !string.regionMatches(n, this.name, n3, n4 - n3));
            }
            if (n5 != -1) {
                return n5 - n3 == n2 - n && string.regionMatches(n, this.name, n3, n5 - n3);
            }
            if (n6 != -1) {
                return n6 - n3 == n2 - n && string.regionMatches(n, this.name, n3, n6 - n3);
            }
            return n4 - n3 == n2 - n && string.regionMatches(n, this.name, n3, n4 - n3);
        }

        int boundedIndexOf(String string, char c, int n, int n2) {
            int n3 = string.indexOf(c, n);
            if (n3 >= n2) {
                return -1;
            }
            return n3;
        }

        @Override
        public void addAttribute(Object object, Object object2) {
        }

        @Override
        public void addAttributes(AttributeSet attributeSet) {
        }

        @Override
        public void removeAttribute(Object object) {
        }

        @Override
        public void removeAttributes(Enumeration<?> enumeration) {
        }

        @Override
        public void removeAttributes(AttributeSet attributeSet) {
        }

        @Override
        public void setResolveParent(AttributeSet attributeSet) {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
        }

        public ChangeListener[] getChangeListeners() {
            return new ChangeListener[0];
        }
    }

    private static class SearchBuffer {
        static Stack<SearchBuffer> searchBuffers = new Stack();
        Vector vector = null;
        StringBuffer stringBuffer = null;
        Hashtable hashtable = null;

        private SearchBuffer() {
        }

        static SearchBuffer obtainSearchBuffer() {
            SearchBuffer searchBuffer;
            try {
                searchBuffer = !searchBuffers.empty() ? searchBuffers.pop() : new SearchBuffer();
            }
            catch (EmptyStackException emptyStackException) {
                searchBuffer = new SearchBuffer();
            }
            return searchBuffer;
        }

        static void releaseSearchBuffer(SearchBuffer searchBuffer) {
            searchBuffer.empty();
            searchBuffers.push(searchBuffer);
        }

        StringBuffer getStringBuffer() {
            if (this.stringBuffer == null) {
                this.stringBuffer = new StringBuffer();
            }
            return this.stringBuffer;
        }

        Vector getVector() {
            if (this.vector == null) {
                this.vector = new Vector();
            }
            return this.vector;
        }

        Hashtable getHashtable() {
            if (this.hashtable == null) {
                this.hashtable = new Hashtable();
            }
            return this.hashtable;
        }

        void empty() {
            if (this.stringBuffer != null) {
                this.stringBuffer.setLength(0);
            }
            if (this.vector != null) {
                this.vector.removeAllElements();
            }
            if (this.hashtable != null) {
                this.hashtable.clear();
            }
        }
    }

    static class SelectorMapping
    implements Serializable {
        private int specificity;
        private Style style;
        private HashMap<String, SelectorMapping> children;

        public SelectorMapping(int n) {
            this.specificity = n;
        }

        public int getSpecificity() {
            return this.specificity;
        }

        public void setStyle(Style style) {
            this.style = style;
        }

        public Style getStyle() {
            return this.style;
        }

        public SelectorMapping getChildSelectorMapping(String string, boolean bl) {
            SelectorMapping selectorMapping = null;
            if (this.children != null) {
                selectorMapping = this.children.get(string);
            } else if (bl) {
                this.children = new HashMap(7);
            }
            if (selectorMapping == null && bl) {
                int n = this.getChildSpecificity(string);
                selectorMapping = this.createChildSelectorMapping(n);
                this.children.put(string, selectorMapping);
            }
            return selectorMapping;
        }

        protected SelectorMapping createChildSelectorMapping(int n) {
            return new SelectorMapping(n);
        }

        protected int getChildSpecificity(String string) {
            char c = string.charAt(0);
            int n = this.getSpecificity();
            if (c == '.') {
                n += 100;
            } else if (c == '#') {
                n += 10000;
            } else {
                ++n;
                if (string.indexOf(46) != -1) {
                    n += 100;
                }
                if (string.indexOf(35) != -1) {
                    n += 10000;
                }
            }
            return n;
        }
    }

    class SmallConversionSet
    extends StyleContext.SmallAttributeSet {
        public SmallConversionSet(AttributeSet attributeSet) {
            super((StyleContext)StyleSheet.this, attributeSet);
        }

        @Override
        public boolean isDefined(Object object) {
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null) {
                return super.isDefined(attribute);
            }
            return super.isDefined(object);
        }

        @Override
        public Object getAttribute(Object object) {
            Object object2;
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null && (object2 = super.getAttribute(attribute)) != null) {
                return StyleSheet.this.css.cssValueToStyleConstantsValue((StyleConstants)object, object2);
            }
            return super.getAttribute(object);
        }
    }

    class ViewAttributeSet
    extends MuxingAttributeSet {
        View host;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ViewAttributeSet(View view) {
            this.host = view;
            Document document = view.getDocument();
            SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
            Vector vector = searchBuffer.getVector();
            try {
                Object[] objectArray2;
                if (document instanceof HTMLDocument) {
                    objectArray2 = StyleSheet.this;
                    Element element = view.getElement();
                    AttributeSet attributeSet = element.getAttributes();
                    AttributeSet attributeSet2 = objectArray2.translateHTMLToCSS(attributeSet);
                    if (attributeSet2.getAttributeCount() != 0) {
                        vector.addElement(attributeSet2);
                    }
                    if (element.isLeaf()) {
                        Enumeration<?> enumeration = attributeSet.getAttributeNames();
                        while (enumeration.hasMoreElements()) {
                            AttributeSet attributeSet3;
                            Object object;
                            Object obj = enumeration.nextElement();
                            if (!(obj instanceof HTML.Tag) || obj == HTML.Tag.A && (object = attributeSet.getAttribute(obj)) != null && object instanceof AttributeSet && (attributeSet3 = (AttributeSet)object).getAttribute(HTML.Attribute.HREF) == null || (object = objectArray2.getRule((HTML.Tag)obj, element)) == null) continue;
                            vector.addElement(object);
                        }
                    } else {
                        HTML.Tag tag = (HTML.Tag)attributeSet.getAttribute(StyleConstants.NameAttribute);
                        Style style = objectArray2.getRule(tag, element);
                        if (style != null) {
                            vector.addElement(style);
                        }
                    }
                }
                objectArray2 = new AttributeSet[vector.size()];
                vector.copyInto(objectArray2);
                this.setAttributes((AttributeSet[])objectArray2);
            }
            finally {
                SearchBuffer.releaseSearchBuffer(searchBuffer);
            }
        }

        @Override
        public boolean isDefined(Object object) {
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null) {
                object = attribute;
            }
            return super.isDefined(object);
        }

        @Override
        public Object getAttribute(Object object) {
            Object object2;
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null && (object2 = this.doGetAttribute(attribute)) instanceof CSS.CssValue) {
                return ((CSS.CssValue)object2).toStyleConstants((StyleConstants)object, this.host);
            }
            return this.doGetAttribute(object);
        }

        Object doGetAttribute(Object object) {
            AttributeSet attributeSet;
            CSS.Attribute attribute;
            Object object2 = super.getAttribute(object);
            if (object2 != null) {
                return object2;
            }
            if (object instanceof CSS.Attribute && (attribute = (CSS.Attribute)object).isInherited() && (attributeSet = this.getResolveParent()) != null) {
                return attributeSet.getAttribute(object);
            }
            return null;
        }

        @Override
        public AttributeSet getResolveParent() {
            if (this.host == null) {
                return null;
            }
            View view = this.host.getParent();
            return view != null ? view.getAttributes() : null;
        }
    }
}

