/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import sun.font.FontUtilities;

public class StyleContext
implements Serializable,
AbstractDocument.AttributeContext {
    private static StyleContext defaultContext;
    public static final String DEFAULT_STYLE = "default";
    private static Hashtable<Object, String> freezeKeyMap;
    private static Hashtable<String, Object> thawKeyMap;
    private Style styles;
    private transient FontKey fontSearch = new FontKey(null, 0, 0);
    private transient Hashtable<FontKey, Font> fontTable = new Hashtable();
    private transient Map<SmallAttributeSet, WeakReference<SmallAttributeSet>> attributesPool = Collections.synchronizedMap(new WeakHashMap());
    private transient MutableAttributeSet search = new SimpleAttributeSet();
    private int unusedSets;
    static final int THRESHOLD = 9;

    public static final StyleContext getDefaultStyleContext() {
        if (defaultContext == null) {
            defaultContext = new StyleContext();
        }
        return defaultContext;
    }

    public StyleContext() {
        this.styles = new NamedStyle(null);
        this.addStyle(DEFAULT_STYLE, null);
    }

    public Style addStyle(String string, Style style) {
        NamedStyle namedStyle = new NamedStyle(string, style);
        if (string != null) {
            this.styles.addAttribute(string, namedStyle);
        }
        return namedStyle;
    }

    public void removeStyle(String string) {
        this.styles.removeAttribute(string);
    }

    public Style getStyle(String string) {
        return (Style)this.styles.getAttribute(string);
    }

    public Enumeration<?> getStyleNames() {
        return this.styles.getAttributeNames();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.styles.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.styles.removeChangeListener(changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return ((NamedStyle)this.styles).getChangeListeners();
    }

    public Font getFont(AttributeSet attributeSet) {
        int n = 0;
        if (StyleConstants.isBold(attributeSet)) {
            n |= 1;
        }
        if (StyleConstants.isItalic(attributeSet)) {
            n |= 2;
        }
        String string = StyleConstants.getFontFamily(attributeSet);
        int n2 = StyleConstants.getFontSize(attributeSet);
        if (StyleConstants.isSuperscript(attributeSet) || StyleConstants.isSubscript(attributeSet)) {
            n2 -= 2;
        }
        return this.getFont(string, n, n2);
    }

    public Color getForeground(AttributeSet attributeSet) {
        return StyleConstants.getForeground(attributeSet);
    }

    public Color getBackground(AttributeSet attributeSet) {
        return StyleConstants.getBackground(attributeSet);
    }

    public Font getFont(String string, int n, int n2) {
        this.fontSearch.setValue(string, n, n2);
        Font font = this.fontTable.get(this.fontSearch);
        if (font == null) {
            Font font2;
            Style style = this.getStyle(DEFAULT_STYLE);
            if (style != null && (font2 = (Font)style.getAttribute("FONT_ATTRIBUTE_KEY")) != null && font2.getFamily().equalsIgnoreCase(string)) {
                font = font2.deriveFont(n, n2);
            }
            if (font == null) {
                font = new Font(string, n, n2);
            }
            if (!FontUtilities.fontSupportsDefaultEncoding(font)) {
                font = FontUtilities.getCompositeFontUIResource(font);
            }
            FontKey fontKey = new FontKey(string, n, n2);
            this.fontTable.put(fontKey, font);
        }
        return font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    @Override
    public synchronized AttributeSet addAttribute(AttributeSet attributeSet, Object object, Object object2) {
        if (attributeSet.getAttributeCount() + 1 <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.addAttribute(object, object2);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.addAttribute(object, object2);
        return mutableAttributeSet;
    }

    @Override
    public synchronized AttributeSet addAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (attributeSet.getAttributeCount() + attributeSet2.getAttributeCount() <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.addAttributes(attributeSet2);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.addAttributes(attributeSet2);
        return mutableAttributeSet;
    }

    @Override
    public synchronized AttributeSet removeAttribute(AttributeSet attributeSet, Object object) {
        if (attributeSet.getAttributeCount() - 1 <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.removeAttribute(object);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.removeAttribute(object);
        return mutableAttributeSet;
    }

    @Override
    public synchronized AttributeSet removeAttributes(AttributeSet attributeSet, Enumeration<?> enumeration) {
        if (attributeSet.getAttributeCount() <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.removeAttributes(enumeration);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.removeAttributes(enumeration);
        return mutableAttributeSet;
    }

    @Override
    public synchronized AttributeSet removeAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (attributeSet.getAttributeCount() <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.removeAttributes(attributeSet2);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.removeAttributes(attributeSet2);
        return mutableAttributeSet;
    }

    @Override
    public AttributeSet getEmptySet() {
        return SimpleAttributeSet.EMPTY;
    }

    @Override
    public void reclaim(AttributeSet attributeSet) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.attributesPool.size();
        }
    }

    protected int getCompressionThreshold() {
        return 9;
    }

    protected SmallAttributeSet createSmallAttributeSet(AttributeSet attributeSet) {
        return new SmallAttributeSet(attributeSet);
    }

    protected MutableAttributeSet createLargeAttributeSet(AttributeSet attributeSet) {
        return new SimpleAttributeSet(attributeSet);
    }

    synchronized void removeUnusedSets() {
        this.attributesPool.size();
    }

    AttributeSet getImmutableUniqueSet() {
        SmallAttributeSet smallAttributeSet;
        SmallAttributeSet smallAttributeSet2 = this.createSmallAttributeSet(this.search);
        WeakReference<SmallAttributeSet> weakReference = this.attributesPool.get(smallAttributeSet2);
        if (weakReference == null || (smallAttributeSet = (SmallAttributeSet)weakReference.get()) == null) {
            smallAttributeSet = smallAttributeSet2;
            this.attributesPool.put(smallAttributeSet, new WeakReference<SmallAttributeSet>(smallAttributeSet));
        }
        return smallAttributeSet;
    }

    MutableAttributeSet getMutableAttributeSet(AttributeSet attributeSet) {
        if (attributeSet instanceof MutableAttributeSet && attributeSet != SimpleAttributeSet.EMPTY) {
            return (MutableAttributeSet)attributeSet;
        }
        return this.createLargeAttributeSet(attributeSet);
    }

    public String toString() {
        this.removeUnusedSets();
        String string = "";
        for (SmallAttributeSet smallAttributeSet : this.attributesPool.keySet()) {
            string = string + smallAttributeSet + "\n";
        }
        return string;
    }

    public void writeAttributes(ObjectOutputStream objectOutputStream, AttributeSet attributeSet) throws IOException {
        StyleContext.writeAttributeSet(objectOutputStream, attributeSet);
    }

    public void readAttributes(ObjectInputStream objectInputStream, MutableAttributeSet mutableAttributeSet) throws ClassNotFoundException, IOException {
        StyleContext.readAttributeSet(objectInputStream, mutableAttributeSet);
    }

    public static void writeAttributeSet(ObjectOutputStream objectOutputStream, AttributeSet attributeSet) throws IOException {
        int n = attributeSet.getAttributeCount();
        objectOutputStream.writeInt(n);
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object obj = enumeration.nextElement();
            if (obj instanceof Serializable) {
                objectOutputStream.writeObject(obj);
            } else {
                object = freezeKeyMap.get(obj);
                if (object == null) {
                    throw new NotSerializableException(obj.getClass().getName() + " is not serializable as a key in an AttributeSet");
                }
                objectOutputStream.writeObject(object);
            }
            object = attributeSet.getAttribute(obj);
            String string = freezeKeyMap.get(object);
            if (object instanceof Serializable) {
                objectOutputStream.writeObject(string != null ? string : object);
                continue;
            }
            if (string == null) {
                throw new NotSerializableException(object.getClass().getName() + " is not serializable as a value in an AttributeSet");
            }
            objectOutputStream.writeObject(string);
        }
    }

    public static void readAttributeSet(ObjectInputStream objectInputStream, MutableAttributeSet mutableAttributeSet) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (thawKeyMap != null) {
                Object object3;
                Object object4 = thawKeyMap.get(object);
                if (object4 != null) {
                    object = object4;
                }
                if ((object3 = thawKeyMap.get(object2)) != null) {
                    object2 = object3;
                }
            }
            mutableAttributeSet.addAttribute(object, object2);
        }
    }

    public static void registerStaticAttributeKey(Object object) {
        String string = object.getClass().getName() + "." + object.toString();
        if (freezeKeyMap == null) {
            freezeKeyMap = new Hashtable();
            thawKeyMap = new Hashtable();
        }
        freezeKeyMap.put(object, string);
        thawKeyMap.put(string, object);
    }

    public static Object getStaticAttribute(Object object) {
        if (thawKeyMap == null || object == null) {
            return null;
        }
        return thawKeyMap.get(object);
    }

    public static Object getStaticAttributeKey(Object object) {
        return object.getClass().getName() + "." + object.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.removeUnusedSets();
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.fontSearch = new FontKey(null, 0, 0);
        this.fontTable = new Hashtable();
        this.search = new SimpleAttributeSet();
        this.attributesPool = Collections.synchronizedMap(new WeakHashMap());
        objectInputStream.defaultReadObject();
    }

    static {
        try {
            int n = StyleConstants.keys.length;
            for (int i = 0; i < n; ++i) {
                StyleContext.registerStaticAttributeKey(StyleConstants.keys[i]);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static class FontKey {
        private String family;
        private int style;
        private int size;

        public FontKey(String string, int n, int n2) {
            this.setValue(string, n, n2);
        }

        public void setValue(String string, int n, int n2) {
            this.family = string != null ? string.intern() : null;
            this.style = n;
            this.size = n2;
        }

        public int hashCode() {
            int n = this.family != null ? this.family.hashCode() : 0;
            return n ^ this.style ^ this.size;
        }

        public boolean equals(Object object) {
            if (object instanceof FontKey) {
                FontKey fontKey = (FontKey)object;
                return this.size == fontKey.size && this.style == fontKey.style && this.family == fontKey.family;
            }
            return false;
        }
    }

    static class KeyBuilder {
        private Vector<Object> keys = new Vector();
        private Vector<Object> data = new Vector();

        KeyBuilder() {
        }

        public void initialize(AttributeSet a) {
            if (a instanceof SmallAttributeSet) {
                this.initialize(((SmallAttributeSet)a).attributes);
            } else {
                this.keys.removeAllElements();
                this.data.removeAllElements();
                Enumeration<?> names = a.getAttributeNames();
                while (names.hasMoreElements()) {
                    Object name = names.nextElement();
                    this.addAttribute(name, a.getAttribute(name));
                }
            }
        }

        private void initialize(Object[] sorted) {
            this.keys.removeAllElements();
            this.data.removeAllElements();
            int n = sorted.length;
            for (int i = 0; i < n; i += 2) {
                this.keys.addElement(sorted[i]);
                this.data.addElement(sorted[i + 1]);
            }
        }

        public Object[] createTable() {
            int n = this.keys.size();
            Object[] tbl = new Object[2 * n];
            for (int i = 0; i < n; ++i) {
                int offs = 2 * i;
                tbl[offs] = this.keys.elementAt(i);
                tbl[offs + 1] = this.data.elementAt(i);
            }
            return tbl;
        }

        int getCount() {
            return this.keys.size();
        }

        public void addAttribute(Object key, Object value) {
            this.keys.addElement(key);
            this.data.addElement(value);
        }

        public void addAttributes(AttributeSet attr) {
            if (attr instanceof SmallAttributeSet) {
                Object[] tbl = ((SmallAttributeSet)attr).attributes;
                int n = tbl.length;
                for (int i = 0; i < n; i += 2) {
                    this.addAttribute(tbl[i], tbl[i + 1]);
                }
            } else {
                Enumeration<?> names = attr.getAttributeNames();
                while (names.hasMoreElements()) {
                    Object name = names.nextElement();
                    this.addAttribute(name, attr.getAttribute(name));
                }
            }
        }

        public void removeAttribute(Object key) {
            int n = this.keys.size();
            for (int i = 0; i < n; ++i) {
                if (!this.keys.elementAt(i).equals(key)) continue;
                this.keys.removeElementAt(i);
                this.data.removeElementAt(i);
                return;
            }
        }

        public void removeAttributes(Enumeration<?> names) {
            while (names.hasMoreElements()) {
                Object name = names.nextElement();
                this.removeAttribute(name);
            }
        }

        public void removeAttributes(AttributeSet attr) {
            Enumeration<?> names = attr.getAttributeNames();
            while (names.hasMoreElements()) {
                Object name = names.nextElement();
                Object value = attr.getAttribute(name);
                this.removeSearchAttribute(name, value);
            }
        }

        private void removeSearchAttribute(Object ikey, Object value) {
            int n = this.keys.size();
            for (int i = 0; i < n; ++i) {
                if (!this.keys.elementAt(i).equals(ikey)) continue;
                if (this.data.elementAt(i).equals(value)) {
                    this.keys.removeElementAt(i);
                    this.data.removeElementAt(i);
                }
                return;
            }
        }
    }

    class KeyEnumeration
    implements Enumeration<Object> {
        Object[] attr;
        int i;

        KeyEnumeration(Object[] objectArray) {
            this.attr = objectArray;
            this.i = 0;
        }

        @Override
        public boolean hasMoreElements() {
            return this.i < this.attr.length;
        }

        @Override
        public Object nextElement() {
            if (this.i < this.attr.length) {
                Object object = this.attr[this.i];
                this.i += 2;
                return object;
            }
            throw new NoSuchElementException();
        }
    }

    public class NamedStyle
    implements Style,
    Serializable {
        protected EventListenerList listenerList = new EventListenerList();
        protected transient ChangeEvent changeEvent = null;
        private transient AttributeSet attributes;

        public NamedStyle(String string, Style style) {
            this.attributes = StyleContext.this.getEmptySet();
            if (string != null) {
                this.setName(string);
            }
            if (style != null) {
                this.setResolveParent(style);
            }
        }

        public NamedStyle(Style style) {
            this(null, style);
        }

        public NamedStyle() {
            this.attributes = StyleContext.this.getEmptySet();
        }

        public String toString() {
            return "NamedStyle:" + this.getName() + " " + this.attributes;
        }

        @Override
        public String getName() {
            if (this.isDefined(StyleConstants.NameAttribute)) {
                return this.getAttribute(StyleConstants.NameAttribute).toString();
            }
            return null;
        }

        public void setName(String string) {
            if (string != null) {
                this.addAttribute(StyleConstants.NameAttribute, string);
            }
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
            this.listenerList.add(ChangeListener.class, changeListener);
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
            this.listenerList.remove(ChangeListener.class, changeListener);
        }

        public ChangeListener[] getChangeListeners() {
            return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        }

        protected void fireStateChanged() {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ChangeListener.class) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
            }
        }

        public <T extends EventListener> T[] getListeners(Class<T> clazz) {
            return this.listenerList.getListeners(clazz);
        }

        @Override
        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        @Override
        public boolean isDefined(Object object) {
            return this.attributes.isDefined(object);
        }

        @Override
        public boolean isEqual(AttributeSet attributeSet) {
            return this.attributes.isEqual(attributeSet);
        }

        @Override
        public AttributeSet copyAttributes() {
            NamedStyle namedStyle = new NamedStyle();
            namedStyle.attributes = this.attributes.copyAttributes();
            return namedStyle;
        }

        @Override
        public Object getAttribute(Object object) {
            return this.attributes.getAttribute(object);
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        @Override
        public boolean containsAttribute(Object object, Object object2) {
            return this.attributes.containsAttribute(object, object2);
        }

        @Override
        public boolean containsAttributes(AttributeSet attributeSet) {
            return this.attributes.containsAttributes(attributeSet);
        }

        @Override
        public AttributeSet getResolveParent() {
            return this.attributes.getResolveParent();
        }

        @Override
        public void addAttribute(Object object, Object object2) {
            StyleContext styleContext = StyleContext.this;
            this.attributes = styleContext.addAttribute(this.attributes, object, object2);
            this.fireStateChanged();
        }

        @Override
        public void addAttributes(AttributeSet attributeSet) {
            StyleContext styleContext = StyleContext.this;
            this.attributes = styleContext.addAttributes(this.attributes, attributeSet);
            this.fireStateChanged();
        }

        @Override
        public void removeAttribute(Object object) {
            StyleContext styleContext = StyleContext.this;
            this.attributes = styleContext.removeAttribute(this.attributes, object);
            this.fireStateChanged();
        }

        @Override
        public void removeAttributes(Enumeration<?> enumeration) {
            StyleContext styleContext = StyleContext.this;
            this.attributes = styleContext.removeAttributes(this.attributes, enumeration);
            this.fireStateChanged();
        }

        @Override
        public void removeAttributes(AttributeSet attributeSet) {
            StyleContext styleContext = StyleContext.this;
            this.attributes = attributeSet == this ? styleContext.getEmptySet() : styleContext.removeAttributes(this.attributes, attributeSet);
            this.fireStateChanged();
        }

        @Override
        public void setResolveParent(AttributeSet attributeSet) {
            if (attributeSet != null) {
                this.addAttribute(StyleConstants.ResolveAttribute, attributeSet);
            } else {
                this.removeAttribute(StyleConstants.ResolveAttribute);
            }
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            StyleContext.writeAttributeSet(objectOutputStream, this.attributes);
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            this.attributes = SimpleAttributeSet.EMPTY;
            StyleContext.readAttributeSet(objectInputStream, this);
        }
    }

    public class SmallAttributeSet
    implements AttributeSet {
        Object[] attributes;
        AttributeSet resolveParent;

        public SmallAttributeSet(Object[] objectArray) {
            this.attributes = objectArray;
            this.updateResolveParent();
        }

        public SmallAttributeSet(AttributeSet attributeSet) {
            int n = attributeSet.getAttributeCount();
            Object[] objectArray = new Object[2 * n];
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                objectArray[n2] = enumeration.nextElement();
                objectArray[n2 + 1] = attributeSet.getAttribute(objectArray[n2]);
                n2 += 2;
            }
            this.attributes = objectArray;
            this.updateResolveParent();
        }

        private void updateResolveParent() {
            this.resolveParent = null;
            Object[] objectArray = this.attributes;
            for (int i = 0; i < objectArray.length; i += 2) {
                if (objectArray[i] != StyleConstants.ResolveAttribute) continue;
                this.resolveParent = (AttributeSet)objectArray[i + 1];
                break;
            }
        }

        Object getLocalAttribute(Object object) {
            if (object == StyleConstants.ResolveAttribute) {
                return this.resolveParent;
            }
            Object[] objectArray = this.attributes;
            for (int i = 0; i < objectArray.length; i += 2) {
                if (!object.equals(objectArray[i])) continue;
                return objectArray[i + 1];
            }
            return null;
        }

        public String toString() {
            String string = "{";
            Object[] objectArray = this.attributes;
            for (int i = 0; i < objectArray.length; i += 2) {
                string = objectArray[i + 1] instanceof AttributeSet ? string + objectArray[i] + "=" + "AttributeSet" + "," : string + objectArray[i] + "=" + objectArray[i + 1] + ",";
            }
            string = string + "}";
            return string;
        }

        public int hashCode() {
            int n = 0;
            Object[] objectArray = this.attributes;
            for (int i = 1; i < objectArray.length; i += 2) {
                n ^= objectArray[i].hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof AttributeSet) {
                AttributeSet attributeSet = (AttributeSet)object;
                return this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
            }
            return false;
        }

        public Object clone() {
            return this;
        }

        @Override
        public int getAttributeCount() {
            return this.attributes.length / 2;
        }

        @Override
        public boolean isDefined(Object object) {
            Object[] objectArray = this.attributes;
            int n = objectArray.length;
            for (int i = 0; i < n; i += 2) {
                if (!object.equals(objectArray[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEqual(AttributeSet attributeSet) {
            if (attributeSet instanceof SmallAttributeSet) {
                return attributeSet == this;
            }
            return this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
        }

        @Override
        public AttributeSet copyAttributes() {
            return this;
        }

        @Override
        public Object getAttribute(Object object) {
            AttributeSet attributeSet;
            Object object2 = this.getLocalAttribute(object);
            if (object2 == null && (attributeSet = this.getResolveParent()) != null) {
                object2 = attributeSet.getAttribute(object);
            }
            return object2;
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return new KeyEnumeration(this.attributes);
        }

        @Override
        public boolean containsAttribute(Object object, Object object2) {
            return object2.equals(this.getAttribute(object));
        }

        @Override
        public boolean containsAttributes(AttributeSet attributeSet) {
            boolean bl = true;
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (bl && enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                bl = attributeSet.getAttribute(obj).equals(this.getAttribute(obj));
            }
            return bl;
        }

        @Override
        public AttributeSet getResolveParent() {
            return this.resolveParent;
        }
    }
}

