/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import sun.swing.CachedPainter;
import sun.swing.ImageIconUIResource;

class MetalUtils {
    MetalUtils() {
    }

    static void drawFlush3DBorder(Graphics graphics, Rectangle rectangle) {
        MetalUtils.drawFlush3DBorder(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    static void drawFlush3DBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.translate(n, n2);
        graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
        graphics.drawRect(0, 0, n3 - 2, n4 - 2);
        graphics.setColor(MetalLookAndFeel.getControlHighlight());
        graphics.drawRect(1, 1, n3 - 2, n4 - 2);
        graphics.setColor(MetalLookAndFeel.getControl());
        graphics.drawLine(0, n4 - 1, 1, n4 - 2);
        graphics.drawLine(n3 - 1, 0, n3 - 2, 1);
        graphics.translate(-n, -n2);
    }

    static void drawPressed3DBorder(Graphics graphics, Rectangle rectangle) {
        MetalUtils.drawPressed3DBorder(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    static void drawDisabledBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.translate(n, n2);
        graphics.setColor(MetalLookAndFeel.getControlShadow());
        graphics.drawRect(0, 0, n3 - 1, n4 - 1);
        graphics.translate(-n, -n2);
    }

    static void drawPressed3DBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.translate(n, n2);
        MetalUtils.drawFlush3DBorder(graphics, 0, 0, n3, n4);
        graphics.setColor(MetalLookAndFeel.getControlShadow());
        graphics.drawLine(1, 1, 1, n4 - 2);
        graphics.drawLine(1, 1, n3 - 2, 1);
        graphics.translate(-n, -n2);
    }

    static void drawDark3DBorder(Graphics graphics, Rectangle rectangle) {
        MetalUtils.drawDark3DBorder(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    static void drawDark3DBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.translate(n, n2);
        MetalUtils.drawFlush3DBorder(graphics, 0, 0, n3, n4);
        graphics.setColor(MetalLookAndFeel.getControl());
        graphics.drawLine(1, 1, 1, n4 - 2);
        graphics.drawLine(1, 1, n3 - 2, 1);
        graphics.setColor(MetalLookAndFeel.getControlShadow());
        graphics.drawLine(1, n4 - 2, 1, n4 - 2);
        graphics.drawLine(n3 - 2, 1, n3 - 2, 1);
        graphics.translate(-n, -n2);
    }

    static void drawButtonBorder(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            MetalUtils.drawActiveButtonBorder(graphics, n, n2, n3, n4);
        } else {
            MetalUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
        }
    }

    static void drawActiveButtonBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        MetalUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
        graphics.setColor(MetalLookAndFeel.getPrimaryControl());
        graphics.drawLine(n + 1, n2 + 1, n + 1, n4 - 3);
        graphics.drawLine(n + 1, n2 + 1, n3 - 3, n + 1);
        graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
        graphics.drawLine(n + 2, n4 - 2, n3 - 2, n4 - 2);
        graphics.drawLine(n3 - 2, n2 + 2, n3 - 2, n4 - 2);
    }

    static void drawDefaultButtonBorder(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        MetalUtils.drawButtonBorder(graphics, n + 1, n2 + 1, n3 - 1, n4 - 1, bl);
        graphics.translate(n, n2);
        graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
        graphics.drawRect(0, 0, n3 - 3, n4 - 3);
        graphics.drawLine(n3 - 2, 0, n3 - 2, 0);
        graphics.drawLine(0, n4 - 2, 0, n4 - 2);
        graphics.translate(-n, -n2);
    }

    static void drawDefaultButtonPressedBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        MetalUtils.drawPressed3DBorder(graphics, n + 1, n2 + 1, n3 - 1, n4 - 1);
        graphics.translate(n, n2);
        graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
        graphics.drawRect(0, 0, n3 - 3, n4 - 3);
        graphics.drawLine(n3 - 2, 0, n3 - 2, 0);
        graphics.drawLine(0, n4 - 2, 0, n4 - 2);
        graphics.setColor(MetalLookAndFeel.getControl());
        graphics.drawLine(n3 - 1, 0, n3 - 1, 0);
        graphics.drawLine(0, n4 - 1, 0, n4 - 1);
        graphics.translate(-n, -n2);
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    static int getInt(Object object, int n) {
        Object object2 = UIManager.get(object);
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        if (object2 instanceof String) {
            try {
                return Integer.parseInt((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    static boolean drawGradient(Component component, Graphics graphics, String string, int n, int n2, int n3, int n4, boolean bl) {
        List list = (List)UIManager.get(string);
        if (list == null || !(graphics instanceof Graphics2D)) {
            return false;
        }
        if (n3 <= 0 || n4 <= 0) {
            return true;
        }
        GradientPainter.INSTANCE.paint(component, (Graphics2D)graphics, list, n, n2, n3, n4, bl);
        return true;
    }

    static boolean isToolBarButton(JComponent jComponent) {
        return jComponent.getParent() instanceof JToolBar;
    }

    static Icon getOceanToolBarIcon(Image image) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new OceanToolBarImageFilter());
        return new ImageIconUIResource(Toolkit.getDefaultToolkit().createImage(filteredImageSource));
    }

    static Icon getOceanDisabledButtonIcon(Image image) {
        Object[] objectArray = (Object[])UIManager.get("Button.disabledGrayRange");
        int n = 180;
        int n2 = 215;
        if (objectArray != null) {
            n = (Integer)objectArray[0];
            n2 = (Integer)objectArray[1];
        }
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new OceanDisabledButtonImageFilter(n, n2));
        return new ImageIconUIResource(Toolkit.getDefaultToolkit().createImage(filteredImageSource));
    }

    private static class GradientPainter
    extends CachedPainter {
        public static final GradientPainter INSTANCE = new GradientPainter(8);
        private static final int IMAGE_SIZE = 64;
        private int w;
        private int h;

        GradientPainter(int n) {
            super(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Component component, Graphics2D graphics2D, List list, int n, int n2, int n3, int n4, boolean bl) {
            int n5;
            int n6;
            if (bl) {
                n6 = 64;
                n5 = n4;
            } else {
                n6 = n3;
                n5 = 64;
            }
            Object object = component.getTreeLock();
            synchronized (object) {
                this.w = n3;
                this.h = n4;
                this.paint(component, (Graphics)graphics2D, n, n2, n6, n5, list, bl);
            }
        }

        @Override
        protected void paintToImage(Component component, Image image, Graphics graphics, int n, int n2, Object[] objectArray) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            List list = (List)objectArray[0];
            boolean bl = (Boolean)objectArray[1];
            if (bl) {
                this.drawVerticalGradient(graphics2D, ((Number)list.get(0)).floatValue(), ((Number)list.get(1)).floatValue(), (Color)list.get(2), (Color)list.get(3), (Color)list.get(4), n, n2);
            } else {
                this.drawHorizontalGradient(graphics2D, ((Number)list.get(0)).floatValue(), ((Number)list.get(1)).floatValue(), (Color)list.get(2), (Color)list.get(3), (Color)list.get(4), n, n2);
            }
        }

        @Override
        protected void paintImage(Component component, Graphics graphics, int n, int n2, int n3, int n4, Image image, Object[] objectArray) {
            boolean bl = (Boolean)objectArray[1];
            graphics.translate(n, n2);
            if (bl) {
                for (int i = 0; i < this.w; i += 64) {
                    int n5 = Math.min(64, this.w - i);
                    graphics.drawImage(image, i, 0, i + n5, this.h, 0, 0, n5, this.h, null);
                }
            } else {
                for (int i = 0; i < this.h; i += 64) {
                    int n6 = Math.min(64, this.h - i);
                    graphics.drawImage(image, 0, i, this.w, i + n6, 0, 0, this.w, n6, null);
                }
            }
            graphics.translate(-n, -n2);
        }

        private void drawVerticalGradient(Graphics2D graphics2D, float f, float f2, Color color, Color color2, Color color3, int n, int n2) {
            int n3 = (int)(f * (float)n2);
            int n4 = (int)(f2 * (float)n2);
            if (n3 > 0) {
                graphics2D.setPaint(this.getGradient(0.0f, 0.0f, color, 0.0f, n3, color2));
                graphics2D.fillRect(0, 0, n, n3);
            }
            if (n4 > 0) {
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, n3, n, n4);
            }
            if (n3 > 0) {
                graphics2D.setPaint(this.getGradient(0.0f, (float)n3 + (float)n4, color2, 0.0f, (float)n3 * 2.0f + (float)n4, color));
                graphics2D.fillRect(0, n3 + n4, n, n3);
            }
            if (n2 - n3 * 2 - n4 > 0) {
                graphics2D.setPaint(this.getGradient(0.0f, (float)n3 * 2.0f + (float)n4, color, 0.0f, n2, color3));
                graphics2D.fillRect(0, n3 * 2 + n4, n, n2 - n3 * 2 - n4);
            }
        }

        private void drawHorizontalGradient(Graphics2D graphics2D, float f, float f2, Color color, Color color2, Color color3, int n, int n2) {
            int n3 = (int)(f * (float)n);
            int n4 = (int)(f2 * (float)n);
            if (n3 > 0) {
                graphics2D.setPaint(this.getGradient(0.0f, 0.0f, color, n3, 0.0f, color2));
                graphics2D.fillRect(0, 0, n3, n2);
            }
            if (n4 > 0) {
                graphics2D.setColor(color2);
                graphics2D.fillRect(n3, 0, n4, n2);
            }
            if (n3 > 0) {
                graphics2D.setPaint(this.getGradient((float)n3 + (float)n4, 0.0f, color2, (float)n3 * 2.0f + (float)n4, 0.0f, color));
                graphics2D.fillRect(n3 + n4, 0, n3, n2);
            }
            if (n - n3 * 2 - n4 > 0) {
                graphics2D.setPaint(this.getGradient((float)n3 * 2.0f + (float)n4, 0.0f, color, n, 0.0f, color3));
                graphics2D.fillRect(n3 * 2 + n4, 0, n - n3 * 2 - n4, n2);
            }
        }

        private GradientPaint getGradient(float f, float f2, Color color, float f3, float f4, Color color2) {
            return new GradientPaint(f, f2, color, f3, f4, color2, true);
        }
    }

    private static class OceanDisabledButtonImageFilter
    extends RGBImageFilter {
        private float min;
        private float factor;

        OceanDisabledButtonImageFilter(int min, int max) {
            this.canFilterIndexColorModel = true;
            this.min = min;
            this.factor = (float)(max - min) / 255.0f;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int gray = Math.min(255, (int)((0.2125f * (float)(rgb >> 16 & 0xFF) + 0.7154f * (float)(rgb >> 8 & 0xFF) + 0.0721f * (float)(rgb & 0xFF) + 0.5f) * this.factor + this.min));
            return rgb & 0xFF000000 | gray << 16 | gray << 8 | gray << 0;
        }
    }

    private static class OceanToolBarImageFilter
    extends RGBImageFilter {
        OceanToolBarImageFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            int gray = Math.max(Math.max(r, g), b);
            return rgb & 0xFF000000 | gray << 16 | gray << 8 | gray << 0;
        }
    }
}

