/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import javax.swing.plaf.metal.MetalTitlePane;

public class MetalRootPaneUI
extends BasicRootPaneUI {
    private static final String[] borderKeys = new String[]{null, "RootPane.frameBorder", "RootPane.plainDialogBorder", "RootPane.informationDialogBorder", "RootPane.errorDialogBorder", "RootPane.colorChooserDialogBorder", "RootPane.fileChooserDialogBorder", "RootPane.questionDialogBorder", "RootPane.warningDialogBorder"};
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private Window window;
    private JComponent titlePane;
    private MouseInputListener mouseInputListener;
    private LayoutManager layoutManager;
    private LayoutManager savedOldLayout;
    private JRootPane root;
    private Cursor lastCursor = Cursor.getPredefinedCursor(0);
    private static final int[] cursorMapping = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalRootPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.root = (JRootPane)jComponent;
        int n = this.root.getWindowDecorationStyle();
        if (n != 0) {
            this.installClientDecorations(this.root);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallClientDecorations(this.root);
        this.layoutManager = null;
        this.mouseInputListener = null;
        this.root = null;
    }

    void installBorder(JRootPane jRootPane) {
        int n = jRootPane.getWindowDecorationStyle();
        if (n == 0) {
            LookAndFeel.uninstallBorder(jRootPane);
        } else {
            LookAndFeel.installBorder(jRootPane, borderKeys[n]);
        }
    }

    private void uninstallBorder(JRootPane jRootPane) {
        LookAndFeel.uninstallBorder(jRootPane);
    }

    private void installWindowListeners(JRootPane jRootPane, Component component) {
        this.window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        if (this.window != null) {
            if (this.mouseInputListener == null) {
                this.mouseInputListener = this.createWindowMouseInputListener(jRootPane);
            }
            this.window.addMouseListener(this.mouseInputListener);
            this.window.addMouseMotionListener(this.mouseInputListener);
        }
    }

    private void uninstallWindowListeners(JRootPane jRootPane) {
        if (this.window != null) {
            this.window.removeMouseListener(this.mouseInputListener);
            this.window.removeMouseMotionListener(this.mouseInputListener);
        }
    }

    private void installLayout(JRootPane jRootPane) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
        }
        this.savedOldLayout = jRootPane.getLayout();
        jRootPane.setLayout(this.layoutManager);
    }

    private void uninstallLayout(JRootPane jRootPane) {
        if (this.savedOldLayout != null) {
            jRootPane.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    private void installClientDecorations(JRootPane jRootPane) {
        this.installBorder(jRootPane);
        JComponent jComponent = this.createTitlePane(jRootPane);
        this.setTitlePane(jRootPane, jComponent);
        this.installWindowListeners(jRootPane, jRootPane.getParent());
        this.installLayout(jRootPane);
        if (this.window != null) {
            jRootPane.revalidate();
            jRootPane.repaint();
        }
    }

    private void uninstallClientDecorations(JRootPane jRootPane) {
        this.uninstallBorder(jRootPane);
        this.uninstallWindowListeners(jRootPane);
        this.setTitlePane(jRootPane, null);
        this.uninstallLayout(jRootPane);
        int n = jRootPane.getWindowDecorationStyle();
        if (n == 0) {
            jRootPane.repaint();
            jRootPane.revalidate();
        }
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.window = null;
    }

    private JComponent createTitlePane(JRootPane jRootPane) {
        return new MetalTitlePane(jRootPane, this);
    }

    private MouseInputListener createWindowMouseInputListener(JRootPane jRootPane) {
        return new MouseInputHandler(this, null);
    }

    private LayoutManager createLayoutManager() {
        return new MetalRootLayout(null);
    }

    private void setTitlePane(JRootPane jRootPane, JComponent jComponent) {
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        JComponent jComponent2 = this.getTitlePane();
        if (jComponent2 != null) {
            jComponent2.setVisible(false);
            jLayeredPane.remove(jComponent2);
        }
        if (jComponent != null) {
            jLayeredPane.add((Component)jComponent, JLayeredPane.FRAME_CONTENT_LAYER);
            jComponent.setVisible(true);
        }
        this.titlePane = jComponent;
    }

    private JComponent getTitlePane() {
        return this.titlePane;
    }

    private JRootPane getRootPane() {
        return this.root;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (string.equals("windowDecorationStyle")) {
            JRootPane jRootPane = (JRootPane)propertyChangeEvent.getSource();
            int n = jRootPane.getWindowDecorationStyle();
            this.uninstallClientDecorations(jRootPane);
            if (n != 0) {
                this.installClientDecorations(jRootPane);
            }
        } else if (string.equals("ancestor")) {
            this.uninstallWindowListeners(this.root);
            if (((JRootPane)propertyChangeEvent.getSource()).getWindowDecorationStyle() != 0) {
                this.installWindowListeners(this.root, this.root.getParent());
            }
        }
    }

    static /* synthetic */ JComponent access$200(MetalRootPaneUI metalRootPaneUI) {
        return metalRootPaneUI.getTitlePane();
    }

    static /* synthetic */ JRootPane access$300(MetalRootPaneUI metalRootPaneUI) {
        return metalRootPaneUI.getRootPane();
    }

    static /* synthetic */ Window access$400(MetalRootPaneUI metalRootPaneUI) {
        return metalRootPaneUI.window;
    }

    static /* synthetic */ Cursor access$500(MetalRootPaneUI metalRootPaneUI) {
        return metalRootPaneUI.lastCursor;
    }

    static /* synthetic */ Cursor access$502(MetalRootPaneUI metalRootPaneUI, Cursor cursor) {
        metalRootPaneUI.lastCursor = cursor;
        return metalRootPaneUI.lastCursor;
    }

    static /* synthetic */ int[] access$600() {
        return cursorMapping;
    }

    private static class MetalRootLayout
    implements LayoutManager2 {
        private MetalRootLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getPreferredSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof MetalRootPaneUI && (titlePane = ((MetalRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpHeight + i.top + i.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getMinimumSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMinimumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof MetalRootPaneUI && (titlePane = ((MetalRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMinimumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpHeight + i.top + i.bottom);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            int maxWidth;
            int maxHeight;
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            Dimension cpd;
            int cpWidth = Integer.MAX_VALUE;
            int cpHeight = Integer.MAX_VALUE;
            int mbWidth = Integer.MAX_VALUE;
            int mbHeight = Integer.MAX_VALUE;
            int tpWidth = Integer.MAX_VALUE;
            int tpHeight = Integer.MAX_VALUE;
            Insets i = target.getInsets();
            JRootPane root = (JRootPane)target;
            if (root.getContentPane() != null && (cpd = root.getContentPane().getMaximumSize()) != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMaximumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof MetalRootPaneUI && (titlePane = ((MetalRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMaximumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            if ((maxHeight = Math.max(Math.max(cpHeight, mbHeight), tpHeight)) != Integer.MAX_VALUE) {
                maxHeight = cpHeight + mbHeight + tpHeight + i.top + i.bottom;
            }
            if ((maxWidth = Math.max(Math.max(cpWidth, mbWidth), tpWidth)) != Integer.MAX_VALUE) {
                maxWidth += i.left + i.right;
            }
            return new Dimension(maxWidth, maxHeight);
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            JRootPane root = (JRootPane)parent;
            Rectangle b = root.getBounds();
            Insets i = root.getInsets();
            int nextY = 0;
            int w = b.width - i.right - i.left;
            int h = b.height - i.top - i.bottom;
            if (root.getLayeredPane() != null) {
                root.getLayeredPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getGlassPane() != null) {
                root.getGlassPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof MetalRootPaneUI && (titlePane = ((MetalRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                int tpHeight = tpd.height;
                titlePane.setBounds(0, 0, w, tpHeight);
                nextY += tpHeight;
            }
            if (root.getJMenuBar() != null) {
                Dimension mbd = root.getJMenuBar().getPreferredSize();
                root.getJMenuBar().setBounds(0, nextY, w, mbd.height);
                nextY += mbd.height;
            }
            if (root.getContentPane() != null) {
                Dimension cpd = root.getContentPane().getPreferredSize();
                root.getContentPane().setBounds(0, nextY, w, h < nextY ? 0 : h - nextY);
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;

        private MouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            int frameState;
            JRootPane rootPane = MetalRootPaneUI.this.getRootPane();
            if (rootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point dragWindowOffset = ev.getPoint();
            Window w = (Window)ev.getSource();
            if (w != null) {
                w.toFront();
            }
            Point convertedDragWindowOffset = SwingUtilities.convertPoint(w, dragWindowOffset, MetalRootPaneUI.this.getTitlePane());
            Frame f = null;
            Dialog d = null;
            if (w instanceof Frame) {
                f = (Frame)w;
            } else if (w instanceof Dialog) {
                d = (Dialog)w;
            }
            int n = frameState = f != null ? f.getExtendedState() : 0;
            if (MetalRootPaneUI.this.getTitlePane() != null && MetalRootPaneUI.this.getTitlePane().contains(convertedDragWindowOffset)) {
                if ((f != null && (frameState & 6) == 0 || d != null) && dragWindowOffset.y >= 5 && dragWindowOffset.x >= 5 && dragWindowOffset.x < w.getWidth() - 5) {
                    this.isMovingWindow = true;
                    this.dragOffsetX = dragWindowOffset.x;
                    this.dragOffsetY = dragWindowOffset.y;
                }
            } else if (f != null && f.isResizable() && (frameState & 6) == 0 || d != null && d.isResizable()) {
                this.dragOffsetX = dragWindowOffset.x;
                this.dragOffsetY = dragWindowOffset.y;
                this.dragWidth = w.getWidth();
                this.dragHeight = w.getHeight();
                this.dragCursor = this.getCursor(this.calculateCorner(w, dragWindowOffset.x, dragWindowOffset.y));
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (this.dragCursor != 0 && MetalRootPaneUI.this.window != null && !MetalRootPaneUI.this.window.isValid()) {
                MetalRootPaneUI.this.window.validate();
                MetalRootPaneUI.this.getRootPane().repaint();
            }
            this.isMovingWindow = false;
            this.dragCursor = 0;
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
            JRootPane root = MetalRootPaneUI.this.getRootPane();
            if (root.getWindowDecorationStyle() == 0) {
                return;
            }
            Window w = (Window)ev.getSource();
            Frame f = null;
            Dialog d = null;
            if (w instanceof Frame) {
                f = (Frame)w;
            } else if (w instanceof Dialog) {
                d = (Dialog)w;
            }
            int cursor = this.getCursor(this.calculateCorner(w, ev.getX(), ev.getY()));
            if (cursor != 0 && (f != null && f.isResizable() && (f.getExtendedState() & 6) == 0 || d != null && d.isResizable())) {
                w.setCursor(Cursor.getPredefinedCursor(cursor));
            } else {
                w.setCursor(MetalRootPaneUI.this.lastCursor);
            }
        }

        private void adjust(Rectangle bounds, Dimension min, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
            bounds.x += deltaX;
            bounds.y += deltaY;
            bounds.width += deltaWidth;
            bounds.height += deltaHeight;
            if (min != null) {
                int correction;
                if (bounds.width < min.width) {
                    correction = min.width - bounds.width;
                    if (deltaX != 0) {
                        bounds.x -= correction;
                    }
                    bounds.width = min.width;
                }
                if (bounds.height < min.height) {
                    correction = min.height - bounds.height;
                    if (deltaY != 0) {
                        bounds.y -= correction;
                    }
                    bounds.height = min.height;
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            Point pt = ev.getPoint();
            if (this.isMovingWindow) {
                Point eventLocationOnScreen = ev.getLocationOnScreen();
                w.setLocation(eventLocationOnScreen.x - this.dragOffsetX, eventLocationOnScreen.y - this.dragOffsetY);
            } else if (this.dragCursor != 0) {
                Rectangle r = w.getBounds();
                Rectangle startBounds = new Rectangle(r);
                Dimension min = w.getMinimumSize();
                switch (this.dragCursor) {
                    case 11: {
                        this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, 0);
                        break;
                    }
                    case 9: {
                        this.adjust(r, min, 0, 0, 0, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                    case 8: {
                        this.adjust(r, min, 0, pt.y - this.dragOffsetY, 0, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 10: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), 0);
                        break;
                    }
                    case 7: {
                        this.adjust(r, min, 0, pt.y - this.dragOffsetY, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 5: {
                        this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                    case 6: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, pt.y - this.dragOffsetY, -(pt.x - this.dragOffsetX), -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 4: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                }
                if (!r.equals(startBounds)) {
                    w.setBounds(r);
                    if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                        w.validate();
                        MetalRootPaneUI.this.getRootPane().repaint();
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            MetalRootPaneUI.this.lastCursor = w.getCursor();
            this.mouseMoved(ev);
        }

        @Override
        public void mouseExited(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            w.setCursor(MetalRootPaneUI.this.lastCursor);
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            Frame f = null;
            if (!(w instanceof Frame)) {
                return;
            }
            f = (Frame)w;
            Point convertedPoint = SwingUtilities.convertPoint(w, ev.getPoint(), MetalRootPaneUI.this.getTitlePane());
            int state = f.getExtendedState();
            if (MetalRootPaneUI.this.getTitlePane() != null && MetalRootPaneUI.this.getTitlePane().contains(convertedPoint) && ev.getClickCount() % 2 == 0 && (ev.getModifiers() & 0x10) != 0 && f.isResizable()) {
                if ((state & 6) != 0) {
                    f.setExtendedState(state & 0xFFFFFFF9);
                } else {
                    f.setExtendedState(state | 6);
                }
                return;
            }
        }

        private int calculateCorner(Window w, int x, int y) {
            Insets insets = w.getInsets();
            int xPosition = this.calculatePosition(x - insets.left, w.getWidth() - insets.left - insets.right);
            int yPosition = this.calculatePosition(y - insets.top, w.getHeight() - insets.top - insets.bottom);
            if (xPosition == -1 || yPosition == -1) {
                return -1;
            }
            return yPosition * 5 + xPosition;
        }

        private int getCursor(int corner) {
            if (corner == -1) {
                return 0;
            }
            return cursorMapping[corner];
        }

        private int calculatePosition(int spot, int width) {
            if (spot < 5) {
                return 0;
            }
            if (spot < 16) {
                return 1;
            }
            if (spot >= width - 5) {
                return 4;
            }
            if (spot >= width - 16) {
                return 3;
            }
            return 2;
        }
    }
}

