/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalToolBarUI;
import javax.swing.plaf.metal.MetalUtils;
import javax.swing.text.JTextComponent;
import sun.swing.StringUIClientPropertyKey;
import sun.swing.SwingUtilities2;

public class MetalBorders {
    static Object NO_BUTTON_ROLLOVER = new StringUIClientPropertyKey("NoButtonRollover");
    private static Border buttonBorder;
    private static Border textBorder;
    private static Border textFieldBorder;
    private static Border toggleButtonBorder;

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(), new BasicBorders.MarginBorder());
        }
        return buttonBorder;
    }

    public static Border getTextBorder() {
        if (textBorder == null) {
            textBorder = new BorderUIResource.CompoundBorderUIResource(new Flush3DBorder(), new BasicBorders.MarginBorder());
        }
        return textBorder;
    }

    public static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new TextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textFieldBorder;
    }

    public static Border getToggleButtonBorder() {
        if (toggleButtonBorder == null) {
            toggleButtonBorder = new BorderUIResource.CompoundBorderUIResource(new ToggleButtonBorder(), new BasicBorders.MarginBorder());
        }
        return toggleButtonBorder;
    }

    public static Border getDesktopIconBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new LineBorder(MetalLookAndFeel.getControlDarkShadow(), 1), new MatteBorder(2, 2, 1, 2, MetalLookAndFeel.getControl()));
    }

    static Border getToolBarRolloverBorder() {
        if (MetalLookAndFeel.usingOcean()) {
            return new CompoundBorder(new ButtonBorder(), new RolloverMarginBorder());
        }
        return new CompoundBorder(new RolloverButtonBorder(), new RolloverMarginBorder());
    }

    static Border getToolBarNonrolloverBorder() {
        if (MetalLookAndFeel.usingOcean()) {
            new CompoundBorder(new ButtonBorder(), new RolloverMarginBorder());
        }
        return new CompoundBorder(new ButtonBorder(), new RolloverMarginBorder());
    }

    public static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(3, 3, 3, 3);

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!(component instanceof AbstractButton)) {
                return;
            }
            if (MetalLookAndFeel.usingOcean()) {
                this.paintOceanBorder(component, graphics, n, n2, n3, n4);
                return;
            }
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isEnabled()) {
                boolean bl;
                boolean bl2 = buttonModel.isPressed() && buttonModel.isArmed();
                boolean bl3 = bl = abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton();
                if (bl2 && bl) {
                    MetalUtils.drawDefaultButtonPressedBorder(graphics, n, n2, n3, n4);
                } else if (bl2) {
                    MetalUtils.drawPressed3DBorder(graphics, n, n2, n3, n4);
                } else if (bl) {
                    MetalUtils.drawDefaultButtonBorder(graphics, n, n2, n3, n4, false);
                } else {
                    MetalUtils.drawButtonBorder(graphics, n, n2, n3, n4, false);
                }
            } else {
                MetalUtils.drawDisabledBorder(graphics, n, n2, n3 - 1, n4 - 1);
            }
        }

        private void paintOceanBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = ((AbstractButton)component).getModel();
            graphics.translate(n, n2);
            if (MetalUtils.isToolBarButton(abstractButton)) {
                if (buttonModel.isEnabled()) {
                    if (buttonModel.isPressed()) {
                        graphics.setColor(MetalLookAndFeel.getWhite());
                        graphics.fillRect(1, n4 - 1, n3 - 1, 1);
                        graphics.fillRect(n3 - 1, 1, 1, n4 - 1);
                        graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                        graphics.drawRect(0, 0, n3 - 2, n4 - 2);
                        graphics.fillRect(1, 1, n3 - 3, 1);
                    } else if (buttonModel.isSelected() || buttonModel.isRollover()) {
                        graphics.setColor(MetalLookAndFeel.getWhite());
                        graphics.fillRect(1, n4 - 1, n3 - 1, 1);
                        graphics.fillRect(n3 - 1, 1, 1, n4 - 1);
                        graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                        graphics.drawRect(0, 0, n3 - 2, n4 - 2);
                    } else {
                        graphics.setColor(MetalLookAndFeel.getWhite());
                        graphics.drawRect(1, 1, n3 - 2, n4 - 2);
                        graphics.setColor(UIManager.getColor("Button.toolBarBorderBackground"));
                        graphics.drawRect(0, 0, n3 - 2, n4 - 2);
                    }
                } else {
                    graphics.setColor(UIManager.getColor("Button.disabledToolBarBorderBackground"));
                    graphics.drawRect(0, 0, n3 - 2, n4 - 2);
                }
            } else if (buttonModel.isEnabled()) {
                boolean bl = buttonModel.isPressed();
                boolean bl2 = buttonModel.isArmed();
                if (component instanceof JButton && ((JButton)component).isDefaultButton()) {
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                    graphics.drawRect(1, 1, n3 - 3, n4 - 3);
                } else if (bl) {
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.fillRect(0, 0, n3, 2);
                    graphics.fillRect(0, 2, 2, n4 - 2);
                    graphics.fillRect(n3 - 1, 1, 1, n4 - 1);
                    graphics.fillRect(1, n4 - 1, n3 - 2, 1);
                } else if (buttonModel.isRollover() && abstractButton.getClientProperty(NO_BUTTON_ROLLOVER) == null) {
                    graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                    graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                    graphics.drawRect(2, 2, n3 - 5, n4 - 5);
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawRect(1, 1, n3 - 3, n4 - 3);
                } else {
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                }
            } else {
                graphics.setColor(MetalLookAndFeel.getInactiveControlTextColor());
                graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                if (component instanceof JButton && ((JButton)component).isDefaultButton()) {
                    graphics.drawRect(1, 1, n3 - 3, n4 - 3);
                }
            }
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.set(3, 3, 3, 3);
            return insets;
        }
    }

    static sealed class DialogBorder
    extends AbstractMetalWindowBorder
    implements UIResource
    permits ErrorDialogBorder, QuestionDialogBorder, WarningDialogBorder {
        DialogBorder() {
        }

        protected Color getActiveBackground() {
            return MetalLookAndFeel.getPrimaryControlDarkShadow();
        }

        protected final Color getActiveHighlight() {
            return MetalLookAndFeel.getPrimaryControlShadow();
        }

        protected final Color getActiveShadow() {
            return MetalLookAndFeel.getPrimaryControlInfo();
        }

        protected final Color getInactiveBackground() {
            return MetalLookAndFeel.getControlDarkShadow();
        }

        protected final Color getInactiveHighlight() {
            return MetalLookAndFeel.getControlShadow();
        }

        protected final Color getInactiveShadow() {
            return MetalLookAndFeel.getControlInfo();
        }

        @Override
        protected final void updateColors(Component c) {
            if (this.isActive(c)) {
                this.background = this.getActiveBackground();
                this.highlight = this.getActiveHighlight();
                this.shadow = this.getActiveShadow();
            } else {
                this.background = this.getInactiveBackground();
                this.highlight = this.getInactiveHighlight();
                this.shadow = this.getInactiveShadow();
            }
        }

        @Override
        protected final boolean isActive(Component c) {
            Window window = SwingUtilities.getWindowAncestor(c);
            return window != null && window.isActive();
        }

        @Override
        protected final boolean isResizable(Component c) {
            Window window = SwingUtilities.getWindowAncestor(c);
            return window instanceof Dialog && ((Dialog)window).isResizable();
        }
    }

    static final class ErrorDialogBorder
    extends DialogBorder
    implements UIResource {
        ErrorDialogBorder() {
        }

        @Override
        protected Color getActiveBackground() {
            return UIManager.getColor("OptionPane.errorDialog.border.background");
        }
    }

    public static class Flush3DBorder
    extends AbstractBorder
    implements UIResource {
        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (component.isEnabled()) {
                MetalUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
            } else {
                MetalUtils.drawDisabledBorder(graphics, n, n2, n3, n4);
            }
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.set(2, 2, 2, 2);
            return insets;
        }
    }

    static final class FrameBorder
    extends AbstractMetalWindowBorder
    implements UIResource {
        FrameBorder() {
        }

        @Override
        protected boolean isActive(Component c) {
            Window window = SwingUtilities.getWindowAncestor(c);
            return window != null && window.isActive();
        }

        @Override
        protected boolean isResizable(Component c) {
            Window window = SwingUtilities.getWindowAncestor(c);
            return window instanceof Frame && ((Frame)window).isResizable();
        }
    }

    public static class InternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        private final InternalFrameBorderImpl border = new InternalFrameBorderImpl();

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            this.border.paintBorder(c, g, x, y, w, h);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            return this.border.getBorderInsets(c, newInsets);
        }
    }

    public static class MenuBarBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(1, 0, 1, 0);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            if (MetalLookAndFeel.usingOcean()) {
                if (c instanceof JMenuBar && !MetalToolBarUI.doesMenuBarBorderToolBar((JMenuBar)c)) {
                    g.setColor(MetalLookAndFeel.getControl());
                    SwingUtilities2.drawHLine(g, 0, w - 1, h - 2);
                    g.setColor(UIManager.getColor("MenuBar.borderColor"));
                    SwingUtilities2.drawHLine(g, 0, w - 1, h - 1);
                }
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
                SwingUtilities2.drawHLine(g, 0, w - 1, h - 1);
            }
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            if (MetalLookAndFeel.usingOcean()) {
                newInsets.set(0, 0, 2, 0);
            } else {
                newInsets.set(1, 0, 1, 0);
            }
            return newInsets;
        }
    }

    public static class MenuItemBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(2, 2, 2, 2);

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!(component instanceof JMenuItem)) {
                return;
            }
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            graphics.translate(n, n2);
            if (component.getParent() instanceof JMenuBar) {
                if (buttonModel.isArmed() || buttonModel.isSelected()) {
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawLine(0, 0, n3 - 2, 0);
                    graphics.drawLine(0, 0, 0, n4 - 1);
                    graphics.drawLine(n3 - 2, 2, n3 - 2, n4 - 1);
                    graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
                    graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 1);
                    graphics.setColor(MetalLookAndFeel.getMenuBackground());
                    graphics.drawLine(n3 - 1, 0, n3 - 1, 0);
                }
            } else if (buttonModel.isArmed() || component instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                graphics.drawLine(0, 0, n3 - 1, 0);
                graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
                graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            } else {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
                graphics.drawLine(0, 0, 0, n4 - 1);
            }
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.set(2, 2, 2, 2);
            return insets;
        }
    }

    public static class OptionDialogBorder
    extends AbstractBorder
    implements UIResource {
        int titleHeight = 0;

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Object obj;
            g.translate(x, y);
            int messageType = -1;
            if (c instanceof JInternalFrame && (obj = ((JInternalFrame)c).getClientProperty("JInternalFrame.messageType")) instanceof Integer) {
                messageType = (Integer)obj;
            }
            g.setColor(switch (messageType) {
                case 0 -> UIManager.getColor("OptionPane.errorDialog.border.background");
                case 3 -> UIManager.getColor("OptionPane.questionDialog.border.background");
                case 2 -> UIManager.getColor("OptionPane.warningDialog.border.background");
                default -> MetalLookAndFeel.getPrimaryControlDarkShadow();
            });
            g.drawLine(1, 0, w - 2, 0);
            g.drawLine(0, 1, 0, h - 2);
            g.drawLine(w - 1, 1, w - 1, h - 2);
            g.drawLine(1, h - 1, w - 2, h - 1);
            for (int i = 1; i < 3; ++i) {
                g.drawRect(i, i, w - i * 2 - 1, h - i * 2 - 1);
            }
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.set(3, 3, 3, 3);
            return newInsets;
        }
    }

    public static class PaletteBorder
    extends AbstractBorder
    implements UIResource {
        int titleHeight = 0;

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            g.drawLine(0, 1, 0, h - 2);
            g.drawLine(1, h - 1, w - 2, h - 1);
            g.drawLine(w - 1, 1, w - 1, h - 2);
            g.drawLine(1, 0, w - 2, 0);
            g.drawRect(1, 1, w - 3, h - 3);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.set(1, 1, 1, 1);
            return newInsets;
        }
    }

    public static class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(3, 1, 2, 1);

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(1, 1, n3 - 2, 1);
            graphics.drawLine(1, 2, 1, 2);
            graphics.drawLine(1, n4 - 2, 1, n4 - 2);
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.set(3, 1, 2, 1);
            return insets;
        }
    }

    static final class QuestionDialogBorder
    extends DialogBorder
    implements UIResource {
        QuestionDialogBorder() {
        }

        @Override
        protected Color getActiveBackground() {
            return UIManager.getColor("OptionPane.questionDialog.border.background");
        }
    }

    public static class RolloverButtonBorder
    extends ButtonBorder {
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            if (model.isRollover() && (!model.isPressed() || model.isArmed())) {
                super.paintBorder(c, g, x, y, w, h);
            }
        }
    }

    static class RolloverMarginBorder
    extends EmptyBorder {
        public RolloverMarginBorder() {
            super(3, 3, 3, 3);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets margin = null;
            if (c instanceof AbstractButton) {
                margin = ((AbstractButton)c).getMargin();
            }
            if (margin == null || margin instanceof UIResource) {
                insets.left = this.left;
                insets.top = this.top;
                insets.right = this.right;
                insets.bottom = this.bottom;
            } else {
                insets.left = margin.left;
                insets.top = margin.top;
                insets.right = margin.right;
                insets.bottom = margin.bottom;
            }
            return insets;
        }
    }

    public static class ScrollPaneBorder
    extends AbstractBorder
    implements UIResource {
        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!(component instanceof JScrollPane)) {
                return;
            }
            JScrollPane jScrollPane = (JScrollPane)component;
            JViewport jViewport = jScrollPane.getColumnHeader();
            int n5 = 0;
            if (jViewport != null) {
                n5 = jViewport.getHeight();
            }
            JViewport jViewport2 = jScrollPane.getRowHeader();
            int n6 = 0;
            if (jViewport2 != null) {
                n6 = jViewport2.getWidth();
            }
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawRect(0, 0, n3 - 2, n4 - 2);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 1);
            graphics.drawLine(1, n4 - 1, n3 - 1, n4 - 1);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.drawLine(n3 - 2, 2 + n5, n3 - 2, 2 + n5);
            graphics.drawLine(1 + n6, n4 - 2, 1 + n6, n4 - 2);
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.set(1, 1, 2, 2);
            return insets;
        }
    }

    public static class TableHeaderBorder
    extends AbstractBorder {
        protected Insets editorBorderInsets = new Insets(2, 2, 2, 0);

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
            graphics.drawLine(1, n4 - 1, n3 - 1, n4 - 1);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(0, 0, n3 - 2, 0);
            graphics.drawLine(0, 0, 0, n4 - 2);
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.set(2, 2, 2, 0);
            return insets;
        }
    }

    public static class TextFieldBorder
    extends Flush3DBorder {
        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!(component instanceof JTextComponent)) {
                if (component.isEnabled()) {
                    MetalUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
                } else {
                    MetalUtils.drawDisabledBorder(graphics, n, n2, n3, n4);
                }
                return;
            }
            if (component.isEnabled() && ((JTextComponent)component).isEditable()) {
                MetalUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
            } else {
                MetalUtils.drawDisabledBorder(graphics, n, n2, n3, n4);
            }
        }
    }

    public static class ToggleButtonBorder
    extends ButtonBorder {
        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (MetalLookAndFeel.usingOcean()) {
                if (buttonModel.isArmed() || !abstractButton.isEnabled()) {
                    super.paintBorder(component, graphics, n, n2, n3, n4);
                } else {
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                }
                return;
            }
            if (!component.isEnabled()) {
                MetalUtils.drawDisabledBorder(graphics, n, n2, n3 - 1, n4 - 1);
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                MetalUtils.drawPressed3DBorder(graphics, n, n2, n3, n4);
            } else if (buttonModel.isSelected()) {
                MetalUtils.drawDark3DBorder(graphics, n, n2, n3, n4);
            } else {
                MetalUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
            }
        }
    }

    public static class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        private MetalBumps bumps = new MetalBumps(10, 10, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), UIManager.getColor("ToolBar.background"));

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (!(c instanceof JToolBar)) {
                return;
            }
            g.translate(x, y);
            if (((JToolBar)c).isFloatable()) {
                if (((JToolBar)c).getOrientation() == 0) {
                    int shift = MetalLookAndFeel.usingOcean() ? -1 : 0;
                    this.bumps.setBumpArea(10, h - 4);
                    if (MetalUtils.isLeftToRight(c)) {
                        this.bumps.paintIcon(c, g, 2, 2 + shift);
                    } else {
                        this.bumps.paintIcon(c, g, w - 12, 2 + shift);
                    }
                } else {
                    this.bumps.setBumpArea(w - 4, 10);
                    this.bumps.paintIcon(c, g, 2, 2);
                }
            }
            if (((JToolBar)c).getOrientation() == 0 && MetalLookAndFeel.usingOcean()) {
                g.setColor(MetalLookAndFeel.getControl());
                g.drawLine(0, h - 2, w, h - 2);
                g.setColor(UIManager.getColor("ToolBar.borderColor"));
                g.drawLine(0, h - 1, w, h - 1);
            }
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            Insets margin;
            if (MetalLookAndFeel.usingOcean()) {
                newInsets.set(1, 2, 3, 2);
            } else {
                newInsets.right = 2;
                newInsets.bottom = 2;
                newInsets.left = 2;
                newInsets.top = 2;
            }
            if (!(c instanceof JToolBar)) {
                return newInsets;
            }
            if (((JToolBar)c).isFloatable()) {
                if (((JToolBar)c).getOrientation() == 0) {
                    if (c.getComponentOrientation().isLeftToRight()) {
                        newInsets.left = 16;
                    } else {
                        newInsets.right = 16;
                    }
                } else {
                    newInsets.top = 16;
                }
            }
            if ((margin = ((JToolBar)c).getMargin()) != null) {
                newInsets.left += margin.left;
                newInsets.top += margin.top;
                newInsets.right += margin.right;
                newInsets.bottom += margin.bottom;
            }
            return newInsets;
        }
    }

    static final class WarningDialogBorder
    extends DialogBorder
    implements UIResource {
        WarningDialogBorder() {
        }

        @Override
        protected Color getActiveBackground() {
            return UIManager.getColor("OptionPane.warningDialog.border.background");
        }
    }
}

