/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import sun.swing.DefaultLookup;

public class BasicSplitPaneDivider
extends Container
implements PropertyChangeListener {
    protected static final int ONE_TOUCH_SIZE = 6;
    protected static final int ONE_TOUCH_OFFSET = 2;
    protected DragController dragger;
    protected BasicSplitPaneUI splitPaneUI;
    protected int dividerSize = 0;
    protected Component hiddenDivider;
    protected JSplitPane splitPane;
    protected MouseHandler mouseHandler;
    protected int orientation;
    protected JButton leftButton;
    protected JButton rightButton;
    private Border border;
    private boolean mouseOver;
    private int oneTouchSize;
    private int oneTouchOffset;
    private boolean centerOneTouchButtons;

    public BasicSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
        this.oneTouchSize = DefaultLookup.getInt(basicSplitPaneUI.getSplitPane(), basicSplitPaneUI, "SplitPane.oneTouchButtonSize", 6);
        this.oneTouchOffset = DefaultLookup.getInt(basicSplitPaneUI.getSplitPane(), basicSplitPaneUI, "SplitPane.oneTouchButtonOffset", 2);
        this.centerOneTouchButtons = DefaultLookup.getBoolean(basicSplitPaneUI.getSplitPane(), basicSplitPaneUI, "SplitPane.centerOneTouchButtons", true);
        this.setLayout(new DividerLayout());
        this.setBasicSplitPaneUI(basicSplitPaneUI);
        this.orientation = this.splitPane.getOrientation();
        this.setCursor(this.orientation == 1 ? Cursor.getPredefinedCursor(11) : Cursor.getPredefinedCursor(9));
        this.setBackground(UIManager.getColor("SplitPane.background"));
    }

    private void revalidateSplitPane() {
        this.invalidate();
        if (this.splitPane != null) {
            this.splitPane.revalidate();
        }
    }

    public void setBasicSplitPaneUI(BasicSplitPaneUI basicSplitPaneUI) {
        if (this.splitPane != null) {
            this.splitPane.removePropertyChangeListener(this);
            if (this.mouseHandler != null) {
                this.splitPane.removeMouseListener(this.mouseHandler);
                this.splitPane.removeMouseMotionListener(this.mouseHandler);
                this.removeMouseListener(this.mouseHandler);
                this.removeMouseMotionListener(this.mouseHandler);
                this.mouseHandler = null;
            }
        }
        this.splitPaneUI = basicSplitPaneUI;
        if (basicSplitPaneUI != null) {
            this.splitPane = basicSplitPaneUI.getSplitPane();
            if (this.splitPane != null) {
                if (this.mouseHandler == null) {
                    this.mouseHandler = new MouseHandler();
                }
                this.splitPane.addMouseListener(this.mouseHandler);
                this.splitPane.addMouseMotionListener(this.mouseHandler);
                this.addMouseListener(this.mouseHandler);
                this.addMouseMotionListener(this.mouseHandler);
                this.splitPane.addPropertyChangeListener(this);
                if (this.splitPane.isOneTouchExpandable()) {
                    this.oneTouchExpandableChanged();
                }
            }
        } else {
            this.splitPane = null;
        }
    }

    public BasicSplitPaneUI getBasicSplitPaneUI() {
        return this.splitPaneUI;
    }

    public void setDividerSize(int n) {
        this.dividerSize = n;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setBorder(Border border) {
        Border border2 = this.border;
        this.border = border;
    }

    public Border getBorder() {
        return this.border;
    }

    @Override
    public Insets getInsets() {
        Border border = this.getBorder();
        if (border != null) {
            return border.getBorderInsets(this);
        }
        return super.getInsets();
    }

    protected void setMouseOver(boolean bl) {
        this.mouseOver = bl;
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.orientation == 1) {
            return new Dimension(this.getDividerSize(), 1);
        }
        return new Dimension(1, this.getDividerSize());
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.splitPane) {
            if (propertyChangeEvent.getPropertyName() == "orientation") {
                this.orientation = this.splitPane.getOrientation();
                this.setCursor(this.orientation == 1 ? Cursor.getPredefinedCursor(11) : Cursor.getPredefinedCursor(9));
                this.revalidateSplitPane();
            } else if (propertyChangeEvent.getPropertyName() == "oneTouchExpandable") {
                this.oneTouchExpandableChanged();
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Border border = this.getBorder();
        if (border != null) {
            Dimension dimension = this.getSize();
            border.paintBorder(this, graphics, 0, 0, dimension.width, dimension.height);
        }
    }

    protected void oneTouchExpandableChanged() {
        if (!DefaultLookup.getBoolean(this.splitPane, this.splitPaneUI, "SplitPane.supportsOneTouchButtons", true)) {
            return;
        }
        if (this.splitPane.isOneTouchExpandable() && this.leftButton == null && this.rightButton == null) {
            this.leftButton = this.createLeftOneTouchButton();
            if (this.leftButton != null) {
                this.leftButton.addActionListener(new OneTouchActionHandler(true));
            }
            this.rightButton = this.createRightOneTouchButton();
            if (this.rightButton != null) {
                this.rightButton.addActionListener(new OneTouchActionHandler(false));
            }
            if (this.leftButton != null && this.rightButton != null) {
                this.add(this.leftButton);
                this.add(this.rightButton);
            }
        }
        this.revalidateSplitPane();
    }

    protected JButton createLeftOneTouchButton() {
        JButton jButton = new JButton(){

            @Override
            public void setBorder(Border b) {
            }

            @Override
            public void paint(Graphics g) {
                if (BasicSplitPaneDivider.this.splitPane != null) {
                    int[] xs = new int[3];
                    int[] ys = new int[3];
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(Color.black);
                    if (BasicSplitPaneDivider.this.orientation == 0) {
                        int blockSize;
                        xs[0] = blockSize = Math.min(this.getHeight(), BasicSplitPaneDivider.this.oneTouchSize);
                        xs[1] = 0;
                        xs[2] = blockSize << 1;
                        ys[0] = 0;
                        ys[1] = ys[2] = blockSize;
                        g.drawPolygon(xs, ys, 3);
                    } else {
                        int blockSize;
                        xs[0] = xs[2] = (blockSize = Math.min(this.getWidth(), BasicSplitPaneDivider.this.oneTouchSize));
                        xs[1] = 0;
                        ys[0] = 0;
                        ys[1] = blockSize;
                        ys[2] = blockSize << 1;
                    }
                    g.fillPolygon(xs, ys, 3);
                }
            }

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        jButton.setMinimumSize(new Dimension(this.oneTouchSize, this.oneTouchSize));
        jButton.setCursor(Cursor.getPredefinedCursor(0));
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setRequestFocusEnabled(false);
        return jButton;
    }

    protected JButton createRightOneTouchButton() {
        JButton jButton = new JButton(){

            @Override
            public void setBorder(Border border) {
            }

            @Override
            public void paint(Graphics g) {
                if (BasicSplitPaneDivider.this.splitPane != null) {
                    int[] xs = new int[3];
                    int[] ys = new int[3];
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (BasicSplitPaneDivider.this.orientation == 0) {
                        int blockSize;
                        xs[0] = blockSize = Math.min(this.getHeight(), BasicSplitPaneDivider.this.oneTouchSize);
                        xs[1] = blockSize << 1;
                        xs[2] = 0;
                        ys[0] = blockSize;
                        ys[2] = 0;
                        ys[1] = 0;
                    } else {
                        int blockSize = Math.min(this.getWidth(), BasicSplitPaneDivider.this.oneTouchSize);
                        xs[2] = 0;
                        xs[0] = 0;
                        xs[1] = blockSize;
                        ys[0] = 0;
                        ys[1] = blockSize;
                        ys[2] = blockSize << 1;
                    }
                    g.setColor(Color.black);
                    g.fillPolygon(xs, ys, 3);
                }
            }

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        jButton.setMinimumSize(new Dimension(this.oneTouchSize, this.oneTouchSize));
        jButton.setCursor(Cursor.getPredefinedCursor(0));
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setRequestFocusEnabled(false);
        return jButton;
    }

    protected void prepareForDragging() {
        this.splitPaneUI.startDragging();
    }

    protected void dragDividerTo(int n) {
        this.splitPaneUI.dragDividerTo(n);
    }

    protected void finishDraggingTo(int n) {
        this.splitPaneUI.finishDraggingTo(n);
    }

    protected class DividerLayout
    implements LayoutManager {
        protected DividerLayout() {
        }

        @Override
        public void layoutContainer(Container container) {
            if (BasicSplitPaneDivider.this.leftButton != null && BasicSplitPaneDivider.this.rightButton != null && container == BasicSplitPaneDivider.this) {
                if (BasicSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    Insets insets = BasicSplitPaneDivider.this.getInsets();
                    if (BasicSplitPaneDivider.this.orientation == 0) {
                        int n = insets != null ? insets.left : 0;
                        int n2 = BasicSplitPaneDivider.this.getHeight();
                        if (insets != null) {
                            n2 -= insets.top + insets.bottom;
                            n2 = Math.max(n2, 0);
                        }
                        n2 = Math.min(n2, BasicSplitPaneDivider.this.oneTouchSize);
                        int n3 = (container.getSize().height - n2) / 2;
                        if (!BasicSplitPaneDivider.this.centerOneTouchButtons) {
                            n3 = insets != null ? insets.top : 0;
                            n = 0;
                        }
                        BasicSplitPaneDivider.this.leftButton.setBounds(n + BasicSplitPaneDivider.this.oneTouchOffset, n3, n2 * 2, n2);
                        BasicSplitPaneDivider.this.rightButton.setBounds(n + BasicSplitPaneDivider.this.oneTouchOffset + BasicSplitPaneDivider.this.oneTouchSize * 2, n3, n2 * 2, n2);
                    } else {
                        int n = insets != null ? insets.top : 0;
                        int n4 = BasicSplitPaneDivider.this.getWidth();
                        if (insets != null) {
                            n4 -= insets.left + insets.right;
                            n4 = Math.max(n4, 0);
                        }
                        n4 = Math.min(n4, BasicSplitPaneDivider.this.oneTouchSize);
                        int n5 = (container.getSize().width - n4) / 2;
                        if (!BasicSplitPaneDivider.this.centerOneTouchButtons) {
                            n5 = insets != null ? insets.left : 0;
                            n = 0;
                        }
                        BasicSplitPaneDivider.this.leftButton.setBounds(n5, n + BasicSplitPaneDivider.this.oneTouchOffset, n4, n4 * 2);
                        BasicSplitPaneDivider.this.rightButton.setBounds(n5, n + BasicSplitPaneDivider.this.oneTouchOffset + BasicSplitPaneDivider.this.oneTouchSize * 2, n4, n4 * 2);
                    }
                } else {
                    BasicSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    BasicSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            int n;
            if (container != BasicSplitPaneDivider.this || BasicSplitPaneDivider.this.splitPane == null) {
                return new Dimension(0, 0);
            }
            Dimension dimension = null;
            if (BasicSplitPaneDivider.this.splitPane.isOneTouchExpandable() && BasicSplitPaneDivider.this.leftButton != null) {
                dimension = BasicSplitPaneDivider.this.leftButton.getMinimumSize();
            }
            Insets insets = BasicSplitPaneDivider.this.getInsets();
            int n2 = n = BasicSplitPaneDivider.this.getDividerSize();
            if (BasicSplitPaneDivider.this.orientation == 0) {
                if (dimension != null) {
                    int n3 = dimension.height;
                    if (insets != null) {
                        n3 += insets.top + insets.bottom;
                    }
                    n2 = Math.max(n2, n3);
                }
                n = 1;
            } else {
                if (dimension != null) {
                    int n4 = dimension.width;
                    if (insets != null) {
                        n4 += insets.left + insets.right;
                    }
                    n = Math.max(n, n4);
                }
                n2 = 1;
            }
            return new Dimension(n, n2);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }
    }

    protected class DragController {
        int initialX;
        int maxX;
        int minX;
        int offset;

        protected DragController(MouseEvent mouseEvent) {
            JSplitPane jSplitPane = BasicSplitPaneDivider.this.splitPaneUI.getSplitPane();
            Component component = jSplitPane.getLeftComponent();
            Component component2 = jSplitPane.getRightComponent();
            this.initialX = BasicSplitPaneDivider.this.getLocation().x;
            this.offset = mouseEvent.getSource() == BasicSplitPaneDivider.this ? mouseEvent.getX() : mouseEvent.getX() - this.initialX;
            if (component == null || component2 == null || this.offset < -1 || this.offset >= BasicSplitPaneDivider.this.getSize().width) {
                this.maxX = -1;
            } else {
                Insets insets = jSplitPane.getInsets();
                if (component.isVisible()) {
                    this.minX = component.getMinimumSize().width;
                    if (insets != null) {
                        this.minX += insets.left;
                    }
                } else {
                    this.minX = 0;
                }
                if (component2.isVisible()) {
                    int n = insets != null ? insets.right : 0;
                    this.maxX = Math.max(0, jSplitPane.getSize().width - (BasicSplitPaneDivider.this.getSize().width + n) - component2.getMinimumSize().width);
                } else {
                    int n = insets != null ? insets.right : 0;
                    this.maxX = Math.max(0, jSplitPane.getSize().width - (BasicSplitPaneDivider.this.getSize().width + n));
                }
                if (this.maxX < this.minX) {
                    this.maxX = 0;
                    this.minX = 0;
                }
            }
        }

        protected boolean isValid() {
            return this.maxX > 0;
        }

        protected int positionForMouseEvent(MouseEvent mouseEvent) {
            int n = mouseEvent.getSource() == BasicSplitPaneDivider.this ? mouseEvent.getX() + BasicSplitPaneDivider.this.getLocation().x : mouseEvent.getX();
            n = Math.min(this.maxX, Math.max(this.minX, n - this.offset));
            return n;
        }

        protected int getNeededLocation(int n, int n2) {
            int n3 = Math.min(this.maxX, Math.max(this.minX, n - this.offset));
            return n3;
        }

        protected void continueDrag(int n, int n2) {
            BasicSplitPaneDivider.this.dragDividerTo(this.getNeededLocation(n, n2));
        }

        protected void continueDrag(MouseEvent mouseEvent) {
            BasicSplitPaneDivider.this.dragDividerTo(this.positionForMouseEvent(mouseEvent));
        }

        protected void completeDrag(int n, int n2) {
            BasicSplitPaneDivider.this.finishDraggingTo(this.getNeededLocation(n, n2));
        }

        protected void completeDrag(MouseEvent mouseEvent) {
            BasicSplitPaneDivider.this.finishDraggingTo(this.positionForMouseEvent(mouseEvent));
        }
    }

    protected class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        protected MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if ((mouseEvent.getSource() == BasicSplitPaneDivider.this || mouseEvent.getSource() == BasicSplitPaneDivider.this.splitPane) && BasicSplitPaneDivider.this.dragger == null && BasicSplitPaneDivider.this.splitPane.isEnabled()) {
                Component component = BasicSplitPaneDivider.this.splitPaneUI.getNonContinuousLayoutDivider();
                if (BasicSplitPaneDivider.this.hiddenDivider != component) {
                    if (BasicSplitPaneDivider.this.hiddenDivider != null) {
                        BasicSplitPaneDivider.this.hiddenDivider.removeMouseListener(this);
                        BasicSplitPaneDivider.this.hiddenDivider.removeMouseMotionListener(this);
                    }
                    BasicSplitPaneDivider.this.hiddenDivider = component;
                    if (BasicSplitPaneDivider.this.hiddenDivider != null) {
                        BasicSplitPaneDivider.this.hiddenDivider.addMouseMotionListener(this);
                        BasicSplitPaneDivider.this.hiddenDivider.addMouseListener(this);
                    }
                }
                if (BasicSplitPaneDivider.this.splitPane.getLeftComponent() != null && BasicSplitPaneDivider.this.splitPane.getRightComponent() != null) {
                    BasicSplitPaneDivider.this.dragger = BasicSplitPaneDivider.this.orientation == 1 ? new DragController(mouseEvent) : new VerticalDragController(mouseEvent);
                    if (!BasicSplitPaneDivider.this.dragger.isValid()) {
                        BasicSplitPaneDivider.this.dragger = null;
                    } else {
                        BasicSplitPaneDivider.this.prepareForDragging();
                        BasicSplitPaneDivider.this.dragger.continueDrag(mouseEvent);
                    }
                }
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (BasicSplitPaneDivider.this.dragger != null) {
                if (mouseEvent.getSource() == BasicSplitPaneDivider.this.splitPane) {
                    BasicSplitPaneDivider.this.dragger.completeDrag(mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getSource() == BasicSplitPaneDivider.this) {
                    Point point = BasicSplitPaneDivider.this.getLocation();
                    BasicSplitPaneDivider.this.dragger.completeDrag(mouseEvent.getX() + point.x, mouseEvent.getY() + point.y);
                } else if (mouseEvent.getSource() == BasicSplitPaneDivider.this.hiddenDivider) {
                    Point point = BasicSplitPaneDivider.this.hiddenDivider.getLocation();
                    int n = mouseEvent.getX() + point.x;
                    int n2 = mouseEvent.getY() + point.y;
                    BasicSplitPaneDivider.this.dragger.completeDrag(n, n2);
                }
                BasicSplitPaneDivider.this.dragger = null;
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (BasicSplitPaneDivider.this.dragger != null) {
                if (mouseEvent.getSource() == BasicSplitPaneDivider.this.splitPane) {
                    BasicSplitPaneDivider.this.dragger.continueDrag(mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getSource() == BasicSplitPaneDivider.this) {
                    Point point = BasicSplitPaneDivider.this.getLocation();
                    BasicSplitPaneDivider.this.dragger.continueDrag(mouseEvent.getX() + point.x, mouseEvent.getY() + point.y);
                } else if (mouseEvent.getSource() == BasicSplitPaneDivider.this.hiddenDivider) {
                    Point point = BasicSplitPaneDivider.this.hiddenDivider.getLocation();
                    int n = mouseEvent.getX() + point.x;
                    int n2 = mouseEvent.getY() + point.y;
                    BasicSplitPaneDivider.this.dragger.continueDrag(n, n2);
                }
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == BasicSplitPaneDivider.this) {
                BasicSplitPaneDivider.this.setMouseOver(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == BasicSplitPaneDivider.this) {
                BasicSplitPaneDivider.this.setMouseOver(false);
            }
        }
    }

    private class OneTouchActionHandler
    implements ActionListener {
        private boolean toMinimum;

        OneTouchActionHandler(boolean bl) {
            this.toMinimum = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Insets insets = BasicSplitPaneDivider.this.splitPane.getInsets();
            int n2 = BasicSplitPaneDivider.this.splitPane.getLastDividerLocation();
            int n3 = BasicSplitPaneDivider.this.splitPaneUI.getDividerLocation(BasicSplitPaneDivider.this.splitPane);
            if (this.toMinimum) {
                if (BasicSplitPaneDivider.this.orientation == 0) {
                    if (n3 >= BasicSplitPaneDivider.this.splitPane.getHeight() - insets.bottom - BasicSplitPaneDivider.this.getHeight()) {
                        int n4 = BasicSplitPaneDivider.this.splitPane.getMaximumDividerLocation();
                        n = Math.min(n2, n4);
                        BasicSplitPaneDivider.this.splitPaneUI.setKeepHidden(false);
                    } else {
                        n = insets.top;
                        BasicSplitPaneDivider.this.splitPaneUI.setKeepHidden(true);
                    }
                } else if (n3 >= BasicSplitPaneDivider.this.splitPane.getWidth() - insets.right - BasicSplitPaneDivider.this.getWidth()) {
                    int n5 = BasicSplitPaneDivider.this.splitPane.getMaximumDividerLocation();
                    n = Math.min(n2, n5);
                    BasicSplitPaneDivider.this.splitPaneUI.setKeepHidden(false);
                } else {
                    n = insets.left;
                    BasicSplitPaneDivider.this.splitPaneUI.setKeepHidden(true);
                }
            } else if (BasicSplitPaneDivider.this.orientation == 0) {
                if (n3 == insets.top) {
                    int n6 = BasicSplitPaneDivider.this.splitPane.getMaximumDividerLocation();
                    n = Math.min(n2, n6);
                    BasicSplitPaneDivider.this.splitPaneUI.setKeepHidden(false);
                } else {
                    n = BasicSplitPaneDivider.this.splitPane.getHeight() - BasicSplitPaneDivider.this.getHeight() - insets.top;
                    BasicSplitPaneDivider.this.splitPaneUI.setKeepHidden(true);
                }
            } else if (n3 == insets.left) {
                int n7 = BasicSplitPaneDivider.this.splitPane.getMaximumDividerLocation();
                n = Math.min(n2, n7);
                BasicSplitPaneDivider.this.splitPaneUI.setKeepHidden(false);
            } else {
                n = BasicSplitPaneDivider.this.splitPane.getWidth() - BasicSplitPaneDivider.this.getWidth() - insets.left;
                BasicSplitPaneDivider.this.splitPaneUI.setKeepHidden(true);
            }
            if (n3 != n) {
                BasicSplitPaneDivider.this.splitPane.setDividerLocation(n);
                BasicSplitPaneDivider.this.splitPane.setLastDividerLocation(n3);
            }
        }
    }

    protected class VerticalDragController
    extends DragController {
        protected VerticalDragController(MouseEvent mouseEvent) {
            super(mouseEvent);
            JSplitPane jSplitPane = BasicSplitPaneDivider.this.splitPaneUI.getSplitPane();
            Component component = jSplitPane.getLeftComponent();
            Component component2 = jSplitPane.getRightComponent();
            this.initialX = BasicSplitPaneDivider.this.getLocation().y;
            this.offset = mouseEvent.getSource() == BasicSplitPaneDivider.this ? mouseEvent.getY() : mouseEvent.getY() - this.initialX;
            if (component == null || component2 == null || this.offset < -1 || this.offset > BasicSplitPaneDivider.this.getSize().height) {
                this.maxX = -1;
            } else {
                Insets insets = jSplitPane.getInsets();
                if (component.isVisible()) {
                    this.minX = component.getMinimumSize().height;
                    if (insets != null) {
                        this.minX += insets.top;
                    }
                } else {
                    this.minX = 0;
                }
                if (component2.isVisible()) {
                    int n = insets != null ? insets.bottom : 0;
                    this.maxX = Math.max(0, jSplitPane.getSize().height - (BasicSplitPaneDivider.this.getSize().height + n) - component2.getMinimumSize().height);
                } else {
                    int n = insets != null ? insets.bottom : 0;
                    this.maxX = Math.max(0, jSplitPane.getSize().height - (BasicSplitPaneDivider.this.getSize().height + n));
                }
                if (this.maxX < this.minX) {
                    this.maxX = 0;
                    this.minX = 0;
                }
            }
        }

        @Override
        protected int getNeededLocation(int n, int n2) {
            int n3 = Math.min(this.maxX, Math.max(this.minX, n2 - this.offset));
            return n3;
        }

        @Override
        protected int positionForMouseEvent(MouseEvent mouseEvent) {
            int n = mouseEvent.getSource() == BasicSplitPaneDivider.this ? mouseEvent.getY() + BasicSplitPaneDivider.this.getLocation().y : mouseEvent.getY();
            n = Math.min(this.maxX, Math.max(this.minX, n - this.offset));
            return n;
        }
    }
}

