/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.UIResource;

public class BorderUIResource
implements Border,
UIResource,
Serializable {
    static Border etched;
    static Border loweredBevel;
    static Border raisedBevel;
    static Border blackLine;
    private Border delegate;

    public static Border getEtchedBorderUIResource() {
        if (etched == null) {
            etched = new EtchedBorderUIResource();
        }
        return etched;
    }

    public static Border getLoweredBevelBorderUIResource() {
        if (loweredBevel == null) {
            loweredBevel = new BevelBorderUIResource(1);
        }
        return loweredBevel;
    }

    public static Border getRaisedBevelBorderUIResource() {
        if (raisedBevel == null) {
            raisedBevel = new BevelBorderUIResource(0);
        }
        return raisedBevel;
    }

    public static Border getBlackLineBorderUIResource() {
        if (blackLine == null) {
            blackLine = new LineBorderUIResource(Color.black);
        }
        return blackLine;
    }

    public BorderUIResource(Border border) {
        if (border == null) {
            throw new IllegalArgumentException("null border delegate argument");
        }
        this.delegate = border;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        this.delegate.paintBorder(component, graphics, n, n2, n3, n4);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.delegate.getBorderInsets(component);
    }

    @Override
    public boolean isBorderOpaque() {
        return this.delegate.isBorderOpaque();
    }

    public static class BevelBorderUIResource
    extends BevelBorder
    implements UIResource {
        public BevelBorderUIResource(int bevelType) {
            super(bevelType);
        }

        public BevelBorderUIResource(int bevelType, Color highlight, Color shadow) {
            super(bevelType, highlight, shadow);
        }

        @ConstructorProperties(value={"bevelType", "highlightOuterColor", "highlightInnerColor", "shadowOuterColor", "shadowInnerColor"})
        public BevelBorderUIResource(int bevelType, Color highlightOuter, Color highlightInner, Color shadowOuter, Color shadowInner) {
            super(bevelType, highlightOuter, highlightInner, shadowOuter, shadowInner);
        }
    }

    public static class CompoundBorderUIResource
    extends CompoundBorder
    implements UIResource {
        @ConstructorProperties(value={"outsideBorder", "insideBorder"})
        public CompoundBorderUIResource(Border border, Border border2) {
            super(border, border2);
        }
    }

    public static class EmptyBorderUIResource
    extends EmptyBorder
    implements UIResource {
        public EmptyBorderUIResource(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
        }

        @ConstructorProperties(value={"borderInsets"})
        public EmptyBorderUIResource(Insets insets) {
            super(insets);
        }
    }

    public static class EtchedBorderUIResource
    extends EtchedBorder
    implements UIResource {
        public EtchedBorderUIResource() {
        }

        public EtchedBorderUIResource(int n) {
            super(n);
        }

        public EtchedBorderUIResource(Color color, Color color2) {
            super(color, color2);
        }

        @ConstructorProperties(value={"etchType", "highlightColor", "shadowColor"})
        public EtchedBorderUIResource(int n, Color color, Color color2) {
            super(n, color, color2);
        }
    }

    public static class LineBorderUIResource
    extends LineBorder
    implements UIResource {
        public LineBorderUIResource(Color color) {
            super(color);
        }

        @ConstructorProperties(value={"lineColor", "thickness"})
        public LineBorderUIResource(Color color, int n) {
            super(color, n);
        }
    }

    public static class MatteBorderUIResource
    extends MatteBorder
    implements UIResource {
        public MatteBorderUIResource(int top, int left, int bottom, int right, Color color) {
            super(top, left, bottom, right, color);
        }

        public MatteBorderUIResource(int top, int left, int bottom, int right, Icon tileIcon) {
            super(top, left, bottom, right, tileIcon);
        }

        public MatteBorderUIResource(Icon tileIcon) {
            super(tileIcon);
        }
    }

    public static class TitledBorderUIResource
    extends TitledBorder
    implements UIResource {
        public TitledBorderUIResource(String title) {
            super(title);
        }

        public TitledBorderUIResource(Border border) {
            super(border);
        }

        public TitledBorderUIResource(Border border, String title) {
            super(border, title);
        }

        public TitledBorderUIResource(Border border, String title, int titleJustification, int titlePosition) {
            super(border, title, titleJustification, titlePosition);
        }

        public TitledBorderUIResource(Border border, String title, int titleJustification, int titlePosition, Font titleFont) {
            super(border, title, titleJustification, titlePosition, titleFont);
        }

        @ConstructorProperties(value={"border", "title", "titleJustification", "titlePosition", "titleFont", "titleColor"})
        public TitledBorderUIResource(Border border, String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
            super(border, title, titleJustification, titlePosition, titleFont, titleColor);
        }
    }
}

