/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.PopupMenuUI;

public class JMenu
extends JMenuItem
implements Accessible,
MenuElement {
    private static final String uiClassID = "MenuUI";
    private JPopupMenu popupMenu;
    private ChangeListener menuChangeListener = null;
    private MenuEvent menuEvent = null;
    private int delay;
    private Point customMenuLocation = null;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    protected WinListener popupListener;

    public JMenu() {
        this("");
    }

    public JMenu(String string) {
        super(string);
    }

    public JMenu(Action action) {
        this();
        this.setAction(action);
    }

    public JMenu(String string, boolean bl) {
        this(string);
    }

    @Override
    void initFocusability() {
    }

    @Override
    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
        if (this.popupMenu != null) {
            this.popupMenu.setUI((PopupMenuUI)UIManager.getUI(this.popupMenu));
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void setModel(ButtonModel buttonModel) {
        ButtonModel buttonModel2 = this.getModel();
        super.setModel(buttonModel);
        if (buttonModel2 != null && this.menuChangeListener != null) {
            buttonModel2.removeChangeListener(this.menuChangeListener);
            this.menuChangeListener = null;
        }
        this.model = buttonModel;
        if (buttonModel != null) {
            this.menuChangeListener = this.createMenuChangeListener();
            buttonModel.addChangeListener(this.menuChangeListener);
        }
    }

    @Override
    public boolean isSelected() {
        return this.getModel().isSelected();
    }

    @Override
    public void setSelected(boolean bl) {
        ButtonModel buttonModel = this.getModel();
        boolean bl2 = buttonModel.isSelected();
        if (bl != buttonModel.isSelected()) {
            this.getModel().setSelected(bl);
        }
    }

    public boolean isPopupMenuVisible() {
        this.ensurePopupMenuCreated();
        return this.popupMenu.isVisible();
    }

    public void setPopupMenuVisible(boolean bl) {
        boolean bl2 = this.isPopupMenuVisible();
        if (bl != bl2 && (this.isEnabled() || !bl)) {
            this.ensurePopupMenuCreated();
            if (bl && this.isShowing()) {
                Point point = this.getCustomMenuLocation();
                if (point == null) {
                    point = this.getPopupMenuOrigin();
                }
                this.getPopupMenu().show(this, point.x, point.y);
            } else {
                this.getPopupMenu().setVisible(false);
            }
        }
    }

    protected Point getPopupMenuOrigin() {
        int n;
        int n2;
        Container container;
        JPopupMenu jPopupMenu = this.getPopupMenu();
        Dimension dimension = this.getSize();
        Dimension dimension2 = jPopupMenu.getSize();
        if (dimension2.width == 0) {
            dimension2 = jPopupMenu.getPreferredSize();
        }
        Point point = this.getLocationOnScreen();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        Rectangle rectangle = new Rectangle(toolkit.getScreenSize());
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsConfiguration graphicsConfiguration2;
            if (graphicsDeviceArray[i].getType() != 0 || !(graphicsConfiguration2 = graphicsDeviceArray[i].getDefaultConfiguration()).getBounds().contains(point)) continue;
            graphicsConfiguration = graphicsConfiguration2;
            break;
        }
        if (graphicsConfiguration != null) {
            rectangle = graphicsConfiguration.getBounds();
            Insets insets = toolkit.getScreenInsets(graphicsConfiguration);
            rectangle.width -= Math.abs(insets.left + insets.right);
            rectangle.height -= Math.abs(insets.top + insets.bottom);
            point.x -= Math.abs(insets.left);
            point.y -= Math.abs(insets.top);
        }
        if ((container = this.getParent()) instanceof JPopupMenu) {
            int n3 = UIManager.getInt("Menu.submenuPopupOffsetX");
            int n4 = UIManager.getInt("Menu.submenuPopupOffsetY");
            if (SwingUtilities.isLeftToRight(this)) {
                n2 = dimension.width + n3;
                if (point.x + n2 + dimension2.width >= rectangle.width + rectangle.x && rectangle.width - dimension.width < 2 * (point.x - rectangle.x)) {
                    n2 = 0 - n3 - dimension2.width;
                }
            } else {
                n2 = 0 - n3 - dimension2.width;
                if (point.x + n2 < rectangle.x && rectangle.width - dimension.width > 2 * (point.x - rectangle.x)) {
                    n2 = dimension.width + n3;
                }
            }
            if (point.y + (n = n4) + dimension2.height >= rectangle.height + rectangle.y && rectangle.height - dimension.height < 2 * (point.y - rectangle.y)) {
                n = dimension.height - n4 - dimension2.height;
            }
        } else {
            int n5 = UIManager.getInt("Menu.menuPopupOffsetX");
            int n6 = UIManager.getInt("Menu.menuPopupOffsetY");
            if (SwingUtilities.isLeftToRight(this)) {
                n2 = n5;
                if (point.x + n2 + dimension2.width >= rectangle.width + rectangle.x && rectangle.width - dimension.width < 2 * (point.x - rectangle.x)) {
                    n2 = dimension.width - n5 - dimension2.width;
                }
            } else {
                n2 = dimension.width - n5 - dimension2.width;
                if (point.x + n2 < rectangle.x && rectangle.width - dimension.width > 2 * (point.x - rectangle.x)) {
                    n2 = n5;
                }
            }
            if (point.y + (n = dimension.height + n6) + dimension2.height >= rectangle.height + rectangle.y && rectangle.height - dimension.height < 2 * (point.y - rectangle.y)) {
                n = 0 - n6 - dimension2.height;
            }
        }
        return new Point(n2, n);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Delay must be a positive integer");
        }
        this.delay = n;
    }

    private void ensurePopupMenuCreated() {
        if (this.popupMenu == null) {
            JMenu jMenu = this;
            this.popupMenu = new JPopupMenu();
            this.popupMenu.setInvoker(this);
            this.popupListener = this.createWinListener(this.popupMenu);
        }
    }

    private Point getCustomMenuLocation() {
        return this.customMenuLocation;
    }

    public void setMenuLocation(int n, int n2) {
        this.customMenuLocation = new Point(n, n2);
        if (this.popupMenu != null) {
            this.popupMenu.setLocation(n, n2);
        }
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        this.ensurePopupMenuCreated();
        return this.popupMenu.add(jMenuItem);
    }

    @Override
    public Component add(Component component) {
        this.ensurePopupMenuCreated();
        this.popupMenu.add(component);
        return component;
    }

    @Override
    public Component add(Component component, int n) {
        this.ensurePopupMenuCreated();
        this.popupMenu.add(component, n);
        return component;
    }

    public JMenuItem add(String string) {
        return this.add(new JMenuItem(string));
    }

    public JMenuItem add(Action action) {
        JMenuItem jMenuItem = this.createActionComponent(action);
        jMenuItem.setAction(action);
        this.add(jMenuItem);
        return jMenuItem;
    }

    protected JMenuItem createActionComponent(Action action) {
        JMenuItem jMenuItem = new JMenuItem(){

            @Override
            protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
                PropertyChangeListener propertyChangeListener = JMenu.this.createActionChangeListener(this);
                if (propertyChangeListener == null) {
                    propertyChangeListener = super.createActionPropertyChangeListener(action);
                }
                return propertyChangeListener;
            }
        };
        jMenuItem.setHorizontalTextPosition(11);
        jMenuItem.setVerticalTextPosition(0);
        return jMenuItem;
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem jMenuItem) {
        return jMenuItem.createActionPropertyChangeListener0(jMenuItem.getAction());
    }

    public void addSeparator() {
        this.ensurePopupMenuCreated();
        this.popupMenu.addSeparator();
    }

    public void insert(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(new JMenuItem(string), n);
    }

    public JMenuItem insert(JMenuItem jMenuItem, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(jMenuItem, n);
        return jMenuItem;
    }

    public JMenuItem insert(Action action, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        JMenuItem jMenuItem = new JMenuItem(action);
        jMenuItem.setHorizontalTextPosition(11);
        jMenuItem.setVerticalTextPosition(0);
        this.popupMenu.insert(jMenuItem, n);
        return jMenuItem;
    }

    public void insertSeparator(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(new JPopupMenu.Separator(), n);
    }

    public JMenuItem getItem(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        Component component = this.getMenuComponent(n);
        if (component instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)component;
            return jMenuItem;
        }
        return null;
    }

    public int getItemCount() {
        return this.getMenuComponentCount();
    }

    public boolean isTearOff() {
        throw new Error("boolean isTearOff() {} not yet implemented");
    }

    public void remove(JMenuItem jMenuItem) {
        if (this.popupMenu != null) {
            this.popupMenu.remove(jMenuItem);
        }
    }

    @Override
    public void remove(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        if (n > this.getItemCount()) {
            throw new IllegalArgumentException("index greater than the number of items.");
        }
        if (this.popupMenu != null) {
            this.popupMenu.remove(n);
        }
    }

    @Override
    public void remove(Component component) {
        if (this.popupMenu != null) {
            this.popupMenu.remove(component);
        }
    }

    @Override
    public void removeAll() {
        if (this.popupMenu != null) {
            this.popupMenu.removeAll();
        }
    }

    public int getMenuComponentCount() {
        int n = 0;
        if (this.popupMenu != null) {
            n = this.popupMenu.getComponentCount();
        }
        return n;
    }

    public Component getMenuComponent(int n) {
        if (this.popupMenu != null) {
            return this.popupMenu.getComponent(n);
        }
        return null;
    }

    public Component[] getMenuComponents() {
        if (this.popupMenu != null) {
            return this.popupMenu.getComponents();
        }
        return new Component[0];
    }

    public boolean isTopLevelMenu() {
        return this.getParent() instanceof JMenuBar;
    }

    public boolean isMenuComponent(Component component) {
        JPopupMenu jPopupMenu;
        if (component == this) {
            return true;
        }
        if (component instanceof JPopupMenu && (jPopupMenu = (JPopupMenu)component) == this.getPopupMenu()) {
            return true;
        }
        int n = this.getMenuComponentCount();
        Component[] componentArray = this.getMenuComponents();
        for (int i = 0; i < n; ++i) {
            JMenu jMenu;
            Component component2 = componentArray[i];
            if (component2 == component) {
                return true;
            }
            if (!(component2 instanceof JMenu) || !(jMenu = (JMenu)component2).isMenuComponent(component)) continue;
            return true;
        }
        return false;
    }

    private Point translateToPopupMenu(Point point) {
        return this.translateToPopupMenu(point.x, point.y);
    }

    private Point translateToPopupMenu(int n, int n2) {
        int n3;
        int n4;
        if (this.getParent() instanceof JPopupMenu) {
            n4 = n - this.getSize().width;
            n3 = n2;
        } else {
            n4 = n;
            n3 = n2 - this.getSize().height;
        }
        return new Point(n4, n3);
    }

    public JPopupMenu getPopupMenu() {
        this.ensurePopupMenuCreated();
        return this.popupMenu;
    }

    public void addMenuListener(MenuListener menuListener) {
        this.listenerList.add(MenuListener.class, menuListener);
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.listenerList.remove(MenuListener.class, menuListener);
    }

    public MenuListener[] getMenuListeners() {
        return (MenuListener[])this.listenerList.getListeners(MenuListener.class);
    }

    protected void fireMenuSelected() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MenuListener.class) continue;
            if (objectArray[i + 1] == null) {
                throw new Error(this.getText() + " has a NULL Listener!! " + i);
            }
            if (this.menuEvent == null) {
                this.menuEvent = new MenuEvent(this);
            }
            ((MenuListener)objectArray[i + 1]).menuSelected(this.menuEvent);
        }
    }

    protected void fireMenuDeselected() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MenuListener.class) continue;
            if (objectArray[i + 1] == null) {
                throw new Error(this.getText() + " has a NULL Listener!! " + i);
            }
            if (this.menuEvent == null) {
                this.menuEvent = new MenuEvent(this);
            }
            ((MenuListener)objectArray[i + 1]).menuDeselected(this.menuEvent);
        }
    }

    protected void fireMenuCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MenuListener.class) continue;
            if (objectArray[i + 1] == null) {
                throw new Error(this.getText() + " has a NULL Listener!! " + i);
            }
            if (this.menuEvent == null) {
                this.menuEvent = new MenuEvent(this);
            }
            ((MenuListener)objectArray[i + 1]).menuCanceled(this.menuEvent);
        }
    }

    @Override
    void configureAcceleratorFromAction(Action action) {
    }

    private ChangeListener createMenuChangeListener() {
        return new MenuChangeListener();
    }

    protected WinListener createWinListener(JPopupMenu jPopupMenu) {
        return new WinListener(jPopupMenu);
    }

    @Override
    public void menuSelectionChanged(boolean bl) {
        this.setSelected(bl);
    }

    @Override
    public MenuElement[] getSubElements() {
        if (this.popupMenu == null) {
            return new MenuElement[0];
        }
        MenuElement[] menuElementArray = new MenuElement[]{this.popupMenu};
        return menuElementArray;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        super.applyComponentOrientation(componentOrientation);
        if (this.popupMenu != null) {
            int n = this.getMenuComponentCount();
            for (int i = 0; i < n; ++i) {
                this.getMenuComponent(i).applyComponentOrientation(componentOrientation);
            }
            this.popupMenu.setComponentOrientation(componentOrientation);
        }
    }

    @Override
    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        super.setComponentOrientation(componentOrientation);
        if (this.popupMenu != null) {
            this.popupMenu.setComponentOrientation(componentOrientation);
        }
    }

    @Override
    public void setAccelerator(KeyStroke keyStroke) {
        throw new Error("setAccelerator() is not defined for JMenu.  Use setMnemonic() instead.");
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        super.processKeyEvent(keyEvent);
    }

    @Override
    public void doClick(int n) {
        MenuElement[] menuElementArray = this.buildMenuElementArray(this);
        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
    }

    private MenuElement[] buildMenuElementArray(JMenu jMenu) {
        Vector<JComponent> vector = new Vector<JComponent>();
        Component component = jMenu.getPopupMenu();
        while (true) {
            if (component instanceof JPopupMenu) {
                JPopupMenu jPopupMenu = component;
                vector.insertElementAt(jPopupMenu, 0);
                component = jPopupMenu.getInvoker();
                continue;
            }
            if (component instanceof JMenu) {
                JMenu jMenu2 = (JMenu)component;
                vector.insertElementAt(jMenu2, 0);
                component = jMenu2.getParent();
                continue;
            }
            if (component instanceof JMenuBar) break;
        }
        JMenuBar jMenuBar = (JMenuBar)component;
        vector.insertElementAt(jMenuBar, 0);
        Object[] objectArray = new MenuElement[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    @Override
    protected String paramString() {
        return super.paramString();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenu();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJMenu
    extends JMenuItem.AccessibleJMenuItem
    implements AccessibleSelection {
        protected AccessibleJMenu() {
            super(JMenu.this);
        }

        @Override
        public int getAccessibleChildrenCount() {
            Component[] componentArray = JMenu.this.getMenuComponents();
            int n = 0;
            for (Component component : componentArray) {
                if (!(component instanceof Accessible)) continue;
                ++n;
            }
            return n;
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            Component[] componentArray = JMenu.this.getMenuComponents();
            int n2 = 0;
            for (Component component : componentArray) {
                if (!(component instanceof Accessible)) continue;
                if (n2 == n) {
                    if (component instanceof JComponent) {
                        AccessibleContext accessibleContext = component.getAccessibleContext();
                        accessibleContext.setAccessibleParent(JMenu.this);
                    }
                    return (Accessible)((Object)component);
                }
                ++n2;
            }
            return null;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public int getAccessibleSelectionCount() {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                for (int i = 0; i < menuElementArray.length; ++i) {
                    if (menuElementArray[i] != JMenu.this || i + 1 >= menuElementArray.length) continue;
                    return 1;
                }
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleSelection(int n) {
            if (n < 0 || n >= JMenu.this.getItemCount()) {
                return null;
            }
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                for (int i = 0; i < menuElementArray.length; ++i) {
                    if (menuElementArray[i] != JMenu.this) continue;
                    while (++i < menuElementArray.length) {
                        if (!(menuElementArray[i] instanceof JMenuItem)) continue;
                        return (Accessible)((Object)menuElementArray[i]);
                    }
                }
            }
            return null;
        }

        @Override
        public boolean isAccessibleChildSelected(int n) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                JMenuItem jMenuItem = JMenu.this.getItem(n);
                for (int i = 0; i < menuElementArray.length; ++i) {
                    if (menuElementArray[i] != jMenuItem) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void addAccessibleSelection(int n) {
            if (n < 0 || n >= JMenu.this.getItemCount()) {
                return;
            }
            JMenuItem jMenuItem = JMenu.this.getItem(n);
            if (jMenuItem != null) {
                if (jMenuItem instanceof JMenu) {
                    MenuElement[] menuElementArray = JMenu.this.buildMenuElementArray((JMenu)jMenuItem);
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                } else {
                    MenuSelectionManager.defaultManager().setSelectedPath(null);
                }
            }
        }

        @Override
        public void removeAccessibleSelection(int n) {
            if (n < 0 || n >= JMenu.this.getItemCount()) {
                return;
            }
            JMenuItem jMenuItem = JMenu.this.getItem(n);
            if (jMenuItem != null && jMenuItem instanceof JMenu && jMenuItem.isSelected()) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                for (int i = 0; i < menuElementArray.length - 2; ++i) {
                    menuElementArray2[i] = menuElementArray[i];
                }
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            }
        }

        @Override
        public void clearAccessibleSelection() {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                for (int i = 0; i < menuElementArray.length; ++i) {
                    if (menuElementArray[i] != JMenu.this) continue;
                    MenuElement[] menuElementArray2 = new MenuElement[i + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, i);
                    menuElementArray2[i] = JMenu.this.getPopupMenu();
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                }
            }
        }

        @Override
        public void selectAllAccessibleSelection() {
        }
    }

    class MenuChangeListener
    implements ChangeListener,
    Serializable {
        boolean isSelected = false;

        MenuChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ButtonModel buttonModel = (ButtonModel)changeEvent.getSource();
            boolean bl = buttonModel.isSelected();
            if (bl != this.isSelected) {
                if (bl) {
                    JMenu.this.fireMenuSelected();
                } else {
                    JMenu.this.fireMenuDeselected();
                }
                this.isSelected = bl;
            }
        }
    }

    protected class WinListener
    extends WindowAdapter
    implements Serializable {
        JPopupMenu popupMenu;

        public WinListener(JPopupMenu jPopupMenu) {
            this.popupMenu = jPopupMenu;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            JMenu.this.setSelected(false);
        }
    }
}

