/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.metadata;

import java.lang.reflect.Method;
import java.security.AccessController;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataController;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOMetadataFormatImpl;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public abstract class IIOMetadata {
    protected boolean standardFormatSupported;
    protected String nativeMetadataFormatName = null;
    protected String nativeMetadataFormatClassName = null;
    protected String[] extraMetadataFormatNames = null;
    protected String[] extraMetadataFormatClassNames = null;
    protected IIOMetadataController defaultController = null;
    protected IIOMetadataController controller = null;

    protected IIOMetadata() {
    }

    protected IIOMetadata(boolean bl, String string, String string2, String[] stringArray, String[] stringArray2) {
        this.standardFormatSupported = bl;
        this.nativeMetadataFormatName = string;
        this.nativeMetadataFormatClassName = string2;
        if (stringArray != null) {
            if (stringArray.length == 0) {
                throw new IllegalArgumentException("extraMetadataFormatNames.length == 0!");
            }
            if (stringArray2 == null) {
                throw new IllegalArgumentException("extraMetadataFormatNames != null && extraMetadataFormatClassNames == null!");
            }
            if (stringArray2.length != stringArray.length) {
                throw new IllegalArgumentException("extraMetadataFormatClassNames.length != extraMetadataFormatNames.length!");
            }
            this.extraMetadataFormatNames = (String[])stringArray.clone();
            this.extraMetadataFormatClassNames = (String[])stringArray2.clone();
        } else if (stringArray2 != null) {
            throw new IllegalArgumentException("extraMetadataFormatNames == null && extraMetadataFormatClassNames != null!");
        }
    }

    public boolean isStandardMetadataFormatSupported() {
        return this.standardFormatSupported;
    }

    public abstract boolean isReadOnly();

    public String getNativeMetadataFormatName() {
        return this.nativeMetadataFormatName;
    }

    public String[] getExtraMetadataFormatNames() {
        if (this.extraMetadataFormatNames == null) {
            return null;
        }
        return (String[])this.extraMetadataFormatNames.clone();
    }

    public String[] getMetadataFormatNames() {
        String string = this.getNativeMetadataFormatName();
        String string2 = this.isStandardMetadataFormatSupported() ? "javax_imageio_1.0" : null;
        String[] stringArray = this.getExtraMetadataFormatNames();
        int n = 0;
        if (string != null) {
            ++n;
        }
        if (string2 != null) {
            ++n;
        }
        if (stringArray != null) {
            n += stringArray.length;
        }
        if (n == 0) {
            return null;
        }
        String[] stringArray2 = new String[n];
        int n2 = 0;
        if (string != null) {
            stringArray2[n2++] = string;
        }
        if (string2 != null) {
            stringArray2[n2++] = string2;
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[n2++] = stringArray[i];
            }
        }
        return stringArray2;
    }

    public IIOMetadataFormat getMetadataFormat(String string) {
        if (string == null) {
            throw new IllegalArgumentException("formatName == null!");
        }
        if (this.standardFormatSupported && string.equals("javax_imageio_1.0")) {
            return IIOMetadataFormatImpl.getStandardFormatInstance();
        }
        String string2 = null;
        if (string.equals(this.nativeMetadataFormatName)) {
            string2 = this.nativeMetadataFormatClassName;
        } else if (this.extraMetadataFormatNames != null) {
            for (int i = 0; i < this.extraMetadataFormatNames.length; ++i) {
                if (!string.equals(this.extraMetadataFormatNames[i])) continue;
                string2 = this.extraMetadataFormatClassNames[i];
                break;
            }
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Unsupported format name");
        }
        try {
            Class<?> clazz = null;
            IIOMetadata iIOMetadata = this;
            ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
            try {
                clazz = Class.forName(string2, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classLoader = (ClassLoader)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
                try {
                    clazz = Class.forName(string2, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    clazz = Class.forName(string2, true, ClassLoader.getSystemClassLoader());
                }
            }
            Method method = clazz.getMethod("getInstance", new Class[0]);
            return (IIOMetadataFormat)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            IllegalStateException illegalStateException = new IllegalStateException("Can't obtain format");
            illegalStateException.initCause(exception);
            throw illegalStateException;
        }
    }

    public abstract Node getAsTree(String var1);

    public abstract void mergeTree(String var1, Node var2) throws IIOInvalidTreeException;

    protected IIOMetadataNode getStandardChromaNode() {
        return null;
    }

    protected IIOMetadataNode getStandardCompressionNode() {
        return null;
    }

    protected IIOMetadataNode getStandardDataNode() {
        return null;
    }

    protected IIOMetadataNode getStandardDimensionNode() {
        return null;
    }

    protected IIOMetadataNode getStandardDocumentNode() {
        return null;
    }

    protected IIOMetadataNode getStandardTextNode() {
        return null;
    }

    protected IIOMetadataNode getStandardTileNode() {
        return null;
    }

    protected IIOMetadataNode getStandardTransparencyNode() {
        return null;
    }

    private void append(IIOMetadataNode iIOMetadataNode, IIOMetadataNode iIOMetadataNode2) {
        if (iIOMetadataNode2 != null) {
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
    }

    protected final IIOMetadataNode getStandardTree() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("javax_imageio_1.0");
        this.append(iIOMetadataNode, this.getStandardChromaNode());
        this.append(iIOMetadataNode, this.getStandardCompressionNode());
        this.append(iIOMetadataNode, this.getStandardDataNode());
        this.append(iIOMetadataNode, this.getStandardDimensionNode());
        this.append(iIOMetadataNode, this.getStandardDocumentNode());
        this.append(iIOMetadataNode, this.getStandardTextNode());
        this.append(iIOMetadataNode, this.getStandardTileNode());
        this.append(iIOMetadataNode, this.getStandardTransparencyNode());
        return iIOMetadataNode;
    }

    public void setFromTree(String string, Node node) throws IIOInvalidTreeException {
        this.reset();
        this.mergeTree(string, node);
    }

    public abstract void reset();

    public void setController(IIOMetadataController iIOMetadataController) {
        this.controller = iIOMetadataController;
    }

    public IIOMetadataController getController() {
        return this.controller;
    }

    public IIOMetadataController getDefaultController() {
        return this.defaultController;
    }

    public boolean hasController() {
        return this.getController() != null;
    }

    public boolean activateController() {
        if (!this.hasController()) {
            throw new IllegalStateException("hasController() == false!");
        }
        return this.getController().activate(this);
    }
}

