/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class ImageTypeSpecifier {
    protected ColorModel colorModel;
    protected SampleModel sampleModel;
    private static ImageTypeSpecifier[] BISpecifier;
    private static ColorSpace sRGB;

    private ImageTypeSpecifier() {
    }

    public ImageTypeSpecifier(ColorModel colorModel, SampleModel sampleModel) {
        if (colorModel == null) {
            throw new IllegalArgumentException("colorModel == null!");
        }
        if (sampleModel == null) {
            throw new IllegalArgumentException("sampleModel == null!");
        }
        if (!colorModel.isCompatibleSampleModel(sampleModel)) {
            throw new IllegalArgumentException("sampleModel is incompatible with colorModel!");
        }
        this.colorModel = colorModel;
        this.sampleModel = sampleModel;
    }

    public ImageTypeSpecifier(RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new IllegalArgumentException("image == null!");
        }
        this.colorModel = renderedImage.getColorModel();
        this.sampleModel = renderedImage.getSampleModel();
    }

    public static ImageTypeSpecifier createPacked(ColorSpace colorSpace, int n, int n2, int n3, int n4, int n5, boolean bl) {
        return new Packed(colorSpace, n, n2, n3, n4, n5, bl);
    }

    static ColorModel createComponentCM(ColorSpace colorSpace, int n, int n2, boolean bl, boolean bl2) {
        int n3 = bl ? 3 : 1;
        int[] nArray = new int[n];
        int n4 = DataBuffer.getDataTypeSize(n2);
        for (int i = 0; i < n; ++i) {
            nArray[i] = n4;
        }
        return new ComponentColorModel(colorSpace, nArray, bl, bl2, n3, n2);
    }

    public static ImageTypeSpecifier createInterleaved(ColorSpace colorSpace, int[] nArray, int n, boolean bl, boolean bl2) {
        return new Interleaved(colorSpace, nArray, n, bl, bl2);
    }

    public static ImageTypeSpecifier createBanded(ColorSpace colorSpace, int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
        return new Banded(colorSpace, nArray, nArray2, n, bl, bl2);
    }

    public static ImageTypeSpecifier createGrayscale(int n, int n2, boolean bl) {
        return new Grayscale(n, n2, bl, false, false);
    }

    public static ImageTypeSpecifier createGrayscale(int n, int n2, boolean bl, boolean bl2) {
        return new Grayscale(n, n2, bl, true, bl2);
    }

    public static ImageTypeSpecifier createIndexed(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n, int n2) {
        return new Indexed(byArray, byArray2, byArray3, byArray4, n, n2);
    }

    public static ImageTypeSpecifier createFromBufferedImageType(int n) {
        if (n >= 1 && n <= 13) {
            return ImageTypeSpecifier.getSpecifier(n);
        }
        if (n == 0) {
            throw new IllegalArgumentException("Cannot create from TYPE_CUSTOM!");
        }
        throw new IllegalArgumentException("Invalid BufferedImage type!");
    }

    public static ImageTypeSpecifier createFromRenderedImage(RenderedImage renderedImage) {
        int n;
        if (renderedImage == null) {
            throw new IllegalArgumentException("image == null!");
        }
        if (renderedImage instanceof BufferedImage && (n = ((BufferedImage)renderedImage).getType()) != 0) {
            return ImageTypeSpecifier.getSpecifier(n);
        }
        return new ImageTypeSpecifier(renderedImage);
    }

    public int getBufferedImageType() {
        BufferedImage bufferedImage = this.createBufferedImage(1, 1);
        return bufferedImage.getType();
    }

    public int getNumComponents() {
        return this.colorModel.getNumComponents();
    }

    public int getNumBands() {
        return this.sampleModel.getNumBands();
    }

    public int getBitsPerBand(int n) {
        if (n < 0 | n >= this.getNumBands()) {
            throw new IllegalArgumentException("band out of range!");
        }
        return this.sampleModel.getSampleSize(n);
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public SampleModel getSampleModel(int n, int n2) {
        if ((long)n * (long)n2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("width*height > Integer.MAX_VALUE!");
        }
        return this.sampleModel.createCompatibleSampleModel(n, n2);
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public BufferedImage createBufferedImage(int n, int n2) {
        try {
            SampleModel sampleModel = this.getSampleModel(n, n2);
            WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, new Point(0, 0));
            return new BufferedImage(this.colorModel, writableRaster, this.colorModel.isAlphaPremultiplied(), new Hashtable());
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new IllegalArgumentException("Array size > Integer.MAX_VALUE!");
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ImageTypeSpecifier)) {
            return false;
        }
        ImageTypeSpecifier imageTypeSpecifier = (ImageTypeSpecifier)object;
        return this.colorModel.equals(imageTypeSpecifier.colorModel) && this.sampleModel.equals(imageTypeSpecifier.sampleModel);
    }

    public int hashCode() {
        return 9 * this.colorModel.hashCode() + 14 * this.sampleModel.hashCode();
    }

    private static ImageTypeSpecifier getSpecifier(int n) {
        if (BISpecifier[n] == null) {
            ImageTypeSpecifier.BISpecifier[n] = ImageTypeSpecifier.createSpecifier(n);
        }
        return BISpecifier[n];
    }

    private static ImageTypeSpecifier createSpecifier(int n) {
        switch (n) {
            case 1: {
                return ImageTypeSpecifier.createPacked(sRGB, 0xFF0000, 65280, 255, 0, 3, false);
            }
            case 2: {
                return ImageTypeSpecifier.createPacked(sRGB, 0xFF0000, 65280, 255, -16777216, 3, false);
            }
            case 3: {
                return ImageTypeSpecifier.createPacked(sRGB, 0xFF0000, 65280, 255, -16777216, 3, true);
            }
            case 4: {
                return ImageTypeSpecifier.createPacked(sRGB, 255, 65280, 0xFF0000, 0, 3, false);
            }
            case 5: {
                return ImageTypeSpecifier.createInterleaved(sRGB, new int[]{2, 1, 0}, 0, false, false);
            }
            case 6: {
                return ImageTypeSpecifier.createInterleaved(sRGB, new int[]{3, 2, 1, 0}, 0, true, false);
            }
            case 7: {
                return ImageTypeSpecifier.createInterleaved(sRGB, new int[]{3, 2, 1, 0}, 0, true, true);
            }
            case 8: {
                return ImageTypeSpecifier.createPacked(sRGB, 63488, 2016, 31, 0, 1, false);
            }
            case 9: {
                return ImageTypeSpecifier.createPacked(sRGB, 31744, 992, 31, 0, 1, false);
            }
            case 10: {
                return ImageTypeSpecifier.createGrayscale(8, 0, false);
            }
            case 11: {
                return ImageTypeSpecifier.createGrayscale(16, 1, false);
            }
            case 12: {
                return ImageTypeSpecifier.createGrayscale(1, 0, false);
            }
            case 13: {
                BufferedImage bufferedImage = new BufferedImage(1, 1, 13);
                IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
                int n2 = indexColorModel.getMapSize();
                byte[] byArray = new byte[n2];
                byte[] byArray2 = new byte[n2];
                byte[] byArray3 = new byte[n2];
                byte[] byArray4 = new byte[n2];
                indexColorModel.getReds(byArray);
                indexColorModel.getGreens(byArray2);
                indexColorModel.getBlues(byArray3);
                indexColorModel.getAlphas(byArray4);
                return ImageTypeSpecifier.createIndexed(byArray, byArray2, byArray3, byArray4, 8, 0);
            }
        }
        throw new IllegalArgumentException("Invalid BufferedImage type!");
    }

    static {
        sRGB = ColorSpace.getInstance(1000);
        BISpecifier = new ImageTypeSpecifier[14];
    }

    static class Banded
    extends ImageTypeSpecifier {
        ColorSpace colorSpace;
        int[] bankIndices;
        int[] bandOffsets;
        int dataType;
        boolean hasAlpha;
        boolean isAlphaPremultiplied;

        public Banded(ColorSpace colorSpace, int[] bankIndices, int[] bandOffsets, int dataType, boolean hasAlpha, boolean isAlphaPremultiplied) {
            if (colorSpace == null) {
                throw new IllegalArgumentException("colorSpace == null!");
            }
            if (bankIndices == null) {
                throw new IllegalArgumentException("bankIndices == null!");
            }
            if (bandOffsets == null) {
                throw new IllegalArgumentException("bandOffsets == null!");
            }
            if (bankIndices.length != bandOffsets.length) {
                throw new IllegalArgumentException("bankIndices.length != bandOffsets.length!");
            }
            if (dataType != 0 && dataType != 2 && dataType != 1 && dataType != 3 && dataType != 4 && dataType != 5) {
                throw new IllegalArgumentException("Bad value for dataType!");
            }
            int numBands = colorSpace.getNumComponents() + (hasAlpha ? 1 : 0);
            if (bandOffsets.length != numBands) {
                throw new IllegalArgumentException("bandOffsets.length is wrong!");
            }
            this.colorSpace = colorSpace;
            this.bankIndices = (int[])bankIndices.clone();
            this.bandOffsets = (int[])bandOffsets.clone();
            this.dataType = dataType;
            this.hasAlpha = hasAlpha;
            this.isAlphaPremultiplied = isAlphaPremultiplied;
            this.colorModel = ImageTypeSpecifier.createComponentCM(colorSpace, bankIndices.length, dataType, hasAlpha, isAlphaPremultiplied);
            int w = 1;
            int h = 1;
            this.sampleModel = new BandedSampleModel(dataType, w, h, w, bankIndices, bandOffsets);
        }

        @Override
        public boolean equals(Object o) {
            int i;
            if (!(o instanceof Banded)) {
                return false;
            }
            Banded that = (Banded)o;
            if (!this.colorSpace.equals(that.colorSpace) || this.dataType != that.dataType || this.hasAlpha != that.hasAlpha || this.isAlphaPremultiplied != that.isAlphaPremultiplied || this.bankIndices.length != that.bankIndices.length || this.bandOffsets.length != that.bandOffsets.length) {
                return false;
            }
            for (i = 0; i < this.bankIndices.length; ++i) {
                if (this.bankIndices[i] == that.bankIndices[i]) continue;
                return false;
            }
            for (i = 0; i < this.bandOffsets.length; ++i) {
                if (this.bandOffsets[i] == that.bandOffsets[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 3 * this.bandOffsets.length + 7 * this.bankIndices.length + 21 * this.dataType + (this.hasAlpha ? 19 : 29);
        }
    }

    static class Grayscale
    extends ImageTypeSpecifier {
        int bits;
        int dataType;
        boolean isSigned;
        boolean hasAlpha;
        boolean isAlphaPremultiplied;

        public Grayscale(int bits, int dataType, boolean isSigned, boolean hasAlpha, boolean isAlphaPremultiplied) {
            if (bits != 1 && bits != 2 && bits != 4 && bits != 8 && bits != 16) {
                throw new IllegalArgumentException("Bad value for bits!");
            }
            if (dataType != 0 && dataType != 2 && dataType != 1) {
                throw new IllegalArgumentException("Bad value for dataType!");
            }
            if (bits > 8 && dataType == 0) {
                throw new IllegalArgumentException("Too many bits for dataType!");
            }
            this.bits = bits;
            this.dataType = dataType;
            this.isSigned = isSigned;
            this.hasAlpha = hasAlpha;
            this.isAlphaPremultiplied = isAlphaPremultiplied;
            ColorSpace colorSpace = ColorSpace.getInstance(1003);
            if (bits == 8 && dataType == 0 || bits == 16 && (dataType == 2 || dataType == 1)) {
                int numBands = hasAlpha ? 2 : 1;
                int transparency = hasAlpha ? 3 : 1;
                int[] nBits = new int[numBands];
                nBits[0] = bits;
                if (numBands == 2) {
                    nBits[1] = bits;
                }
                this.colorModel = new ComponentColorModel(colorSpace, nBits, hasAlpha, isAlphaPremultiplied, transparency, dataType);
                int[] bandOffsets = new int[numBands];
                bandOffsets[0] = 0;
                if (numBands == 2) {
                    bandOffsets[1] = 1;
                }
                int w = 1;
                int h = 1;
                this.sampleModel = new PixelInterleavedSampleModel(dataType, w, h, numBands, w * numBands, bandOffsets);
            } else {
                int numEntries = 1 << bits;
                byte[] arr = new byte[numEntries];
                for (int i = 0; i < numEntries; ++i) {
                    arr[i] = (byte)(i * 255 / (numEntries - 1));
                }
                this.colorModel = new IndexColorModel(bits, numEntries, arr, arr, arr);
                this.sampleModel = new MultiPixelPackedSampleModel(dataType, 1, 1, bits);
            }
        }
    }

    static class Indexed
    extends ImageTypeSpecifier {
        byte[] redLUT;
        byte[] greenLUT;
        byte[] blueLUT;
        byte[] alphaLUT = null;
        int bits;
        int dataType;

        public Indexed(byte[] redLUT, byte[] greenLUT, byte[] blueLUT, byte[] alphaLUT, int bits, int dataType) {
            if (redLUT == null || greenLUT == null || blueLUT == null) {
                throw new IllegalArgumentException("LUT is null!");
            }
            if (bits != 1 && bits != 2 && bits != 4 && bits != 8 && bits != 16) {
                throw new IllegalArgumentException("Bad value for bits!");
            }
            if (dataType != 0 && dataType != 2 && dataType != 1 && dataType != 3) {
                throw new IllegalArgumentException("Bad value for dataType!");
            }
            if (bits > 8 && dataType == 0 || bits > 16 && dataType != 3) {
                throw new IllegalArgumentException("Too many bits for dataType!");
            }
            int len = 1 << bits;
            if (redLUT.length != len || greenLUT.length != len || blueLUT.length != len || alphaLUT != null && alphaLUT.length != len) {
                throw new IllegalArgumentException("LUT has improper length!");
            }
            this.redLUT = (byte[])redLUT.clone();
            this.greenLUT = (byte[])greenLUT.clone();
            this.blueLUT = (byte[])blueLUT.clone();
            if (alphaLUT != null) {
                this.alphaLUT = (byte[])alphaLUT.clone();
            }
            this.bits = bits;
            this.dataType = dataType;
            this.colorModel = alphaLUT == null ? new IndexColorModel(bits, redLUT.length, redLUT, greenLUT, blueLUT) : new IndexColorModel(bits, redLUT.length, redLUT, greenLUT, blueLUT, alphaLUT);
            if (bits == 8 && dataType == 0 || bits == 16 && (dataType == 2 || dataType == 1)) {
                int[] bandOffsets = new int[]{0};
                this.sampleModel = new PixelInterleavedSampleModel(dataType, 1, 1, 1, 1, bandOffsets);
            } else {
                this.sampleModel = new MultiPixelPackedSampleModel(dataType, 1, 1, bits);
            }
        }
    }

    static class Interleaved
    extends ImageTypeSpecifier {
        ColorSpace colorSpace;
        int[] bandOffsets;
        int dataType;
        boolean hasAlpha;
        boolean isAlphaPremultiplied;

        public Interleaved(ColorSpace colorSpace, int[] nArray, int n, boolean bl, boolean bl2) {
            int n2;
            int n3;
            int n4;
            if (colorSpace == null) {
                throw new IllegalArgumentException("colorSpace == null!");
            }
            if (nArray == null) {
                throw new IllegalArgumentException("bandOffsets == null!");
            }
            int n5 = colorSpace.getNumComponents() + (bl ? 1 : 0);
            if (nArray.length != n5) {
                throw new IllegalArgumentException("bandOffsets.length is wrong!");
            }
            if (n != 0 && n != 2 && n != 1 && n != 3 && n != 4 && n != 5) {
                throw new IllegalArgumentException("Bad value for dataType!");
            }
            this.colorSpace = colorSpace;
            this.bandOffsets = (int[])nArray.clone();
            this.dataType = n;
            this.hasAlpha = bl;
            this.isAlphaPremultiplied = bl2;
            this.colorModel = ImageTypeSpecifier.createComponentCM(colorSpace, nArray.length, n, bl, bl2);
            int n6 = n4 = nArray[0];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = nArray[n3];
                n4 = Math.min(n2, n4);
                n6 = Math.max(n2, n6);
            }
            n3 = n6 - n4 + 1;
            n2 = 1;
            int n7 = 1;
            this.sampleModel = new PixelInterleavedSampleModel(n, n2, n7, n3, n2 * n3, nArray);
        }

        @Override
        public boolean equals(Object object) {
            if (object == null || !(object instanceof Interleaved)) {
                return false;
            }
            Interleaved interleaved = (Interleaved)object;
            if (!this.colorSpace.equals(interleaved.colorSpace) || this.dataType != interleaved.dataType || this.hasAlpha != interleaved.hasAlpha || this.isAlphaPremultiplied != interleaved.isAlphaPremultiplied || this.bandOffsets.length != interleaved.bandOffsets.length) {
                return false;
            }
            for (int i = 0; i < this.bandOffsets.length; ++i) {
                if (this.bandOffsets[i] == interleaved.bandOffsets[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 4 * this.bandOffsets.length + 25 * this.dataType + (this.hasAlpha ? 17 : 18);
        }
    }

    static class Packed
    extends ImageTypeSpecifier {
        ColorSpace colorSpace;
        int redMask;
        int greenMask;
        int blueMask;
        int alphaMask;
        int transferType;
        boolean isAlphaPremultiplied;

        public Packed(ColorSpace colorSpace, int n, int n2, int n3, int n4, int n5, boolean bl) {
            if (colorSpace == null) {
                throw new IllegalArgumentException("colorSpace == null!");
            }
            if (colorSpace.getType() != 5) {
                throw new IllegalArgumentException("colorSpace is not of type TYPE_RGB!");
            }
            if (n5 != 0 && n5 != 1 && n5 != 3) {
                throw new IllegalArgumentException("Bad value for transferType!");
            }
            if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
                throw new IllegalArgumentException("No mask has at least 1 bit set!");
            }
            this.colorSpace = colorSpace;
            this.redMask = n;
            this.greenMask = n2;
            this.blueMask = n3;
            this.alphaMask = n4;
            this.transferType = n5;
            this.isAlphaPremultiplied = bl;
            int n6 = 32;
            this.colorModel = new DirectColorModel(colorSpace, n6, n, n2, n3, n4, bl, n5);
            this.sampleModel = this.colorModel.createCompatibleSampleModel(1, 1);
        }
    }
}

