/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CertPath;
import java.security.cert.CertPathChecker;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import sun.security.jca.GetInstance;

public class CertPathValidator {
    private static final String CPV_TYPE = "certpathvalidator.type";
    private final CertPathValidatorSpi validatorSpi;
    private final Provider provider;
    private final String algorithm;

    protected CertPathValidator(CertPathValidatorSpi certPathValidatorSpi, Provider provider, String string) {
        this.validatorSpi = certPathValidatorSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public static CertPathValidator getInstance(String string) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = GetInstance.getInstance("CertPathValidator", CertPathValidatorSpi.class, string);
        return new CertPathValidator((CertPathValidatorSpi)instance.impl, instance.provider, string);
    }

    public static CertPathValidator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        GetInstance.Instance instance = GetInstance.getInstance("CertPathValidator", CertPathValidatorSpi.class, string, string2);
        return new CertPathValidator((CertPathValidatorSpi)instance.impl, instance.provider, string);
    }

    public static CertPathValidator getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = GetInstance.getInstance("CertPathValidator", CertPathValidatorSpi.class, string, provider);
        return new CertPathValidator((CertPathValidatorSpi)instance.impl, instance.provider, string);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final CertPathValidatorResult validate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        return this.validatorSpi.engineValidate(certPath, certPathParameters);
    }

    public static final String getDefaultType() {
        String string = (String)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
        return string == null ? "PKIX" : string;
    }

    public final CertPathChecker getRevocationChecker() {
        return this.validatorSpi.engineGetRevocationChecker();
    }
}

