/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import sun.security.util.Debug;

public class KeyStore {
    private static final Debug pdebug = Debug.getInstance("provider", "Provider");
    private static final boolean skipDebug = Debug.isOn("engine=") && !Debug.isOn("keystore");
    private static final String KEYSTORE_TYPE = "keystore.type";
    private String type;
    private Provider provider;
    private KeyStoreSpi keyStoreSpi;
    private boolean initialized = false;

    protected KeyStore(KeyStoreSpi keyStoreSpi, Provider provider, String string) {
        this.keyStoreSpi = keyStoreSpi;
        this.provider = provider;
        this.type = string;
        if (!skipDebug && pdebug != null) {
            pdebug.println("KeyStore." + string.toUpperCase() + " type from: " + this.provider.getName());
        }
    }

    public static KeyStore getInstance(String string) throws KeyStoreException {
        try {
            Object[] objectArray = Security.getImpl(string, "KeyStore", (String)null);
            return new KeyStore((KeyStoreSpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException(string + " not found", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyStoreException(string + " not found", noSuchProviderException);
        }
    }

    public static KeyStore getInstance(String string, String string2) throws KeyStoreException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        try {
            Object[] objectArray = Security.getImpl(string, "KeyStore", string2);
            return new KeyStore((KeyStoreSpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException(string + " not found", noSuchAlgorithmException);
        }
    }

    public static KeyStore getInstance(String string, Provider provider) throws KeyStoreException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        try {
            Object[] objectArray = Security.getImpl(string, "KeyStore", provider);
            return new KeyStore((KeyStoreSpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException(string + " not found", noSuchAlgorithmException);
        }
    }

    public static final String getDefaultType() {
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty(KeyStore.KEYSTORE_TYPE);
            }
        });
        if (string == null) {
            string = "jks";
        }
        return string;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }

    public final Key getKey(String string, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineGetKey(string, cArray);
    }

    public final Certificate[] getCertificateChain(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineGetCertificateChain(string);
    }

    public final Certificate getCertificate(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineGetCertificate(string);
    }

    public final Date getCreationDate(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineGetCreationDate(string);
    }

    public final void setKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        if (key instanceof PrivateKey && (certificateArray == null || certificateArray.length == 0)) {
            throw new IllegalArgumentException("Private key must be accompanied by certificate chain");
        }
        this.keyStoreSpi.engineSetKeyEntry(string, key, cArray, certificateArray);
    }

    public final void setKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.keyStoreSpi.engineSetKeyEntry(string, byArray, certificateArray);
    }

    public final void setCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.keyStoreSpi.engineSetCertificateEntry(string, certificate);
    }

    public final void deleteEntry(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.keyStoreSpi.engineDeleteEntry(string);
    }

    public final Enumeration<String> aliases() throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineAliases();
    }

    public final boolean containsAlias(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineContainsAlias(string);
    }

    public final int size() throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineSize();
    }

    public final boolean isKeyEntry(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineIsKeyEntry(string);
    }

    public final boolean isCertificateEntry(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineIsCertificateEntry(string);
    }

    public final String getCertificateAlias(Certificate certificate) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineGetCertificateAlias(certificate);
    }

    public final void store(OutputStream outputStream, char[] cArray) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.keyStoreSpi.engineStore(outputStream, cArray);
    }

    public final void store(LoadStoreParameter loadStoreParameter) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.keyStoreSpi.engineStore(loadStoreParameter);
    }

    public final void load(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStoreSpi.engineLoad(inputStream, cArray);
        this.initialized = true;
    }

    public final void load(LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStoreSpi.engineLoad(loadStoreParameter);
        this.initialized = true;
    }

    public final Entry getEntry(String string, ProtectionParameter protectionParameter) throws NoSuchAlgorithmException, UnrecoverableEntryException, KeyStoreException {
        if (string == null) {
            throw new NullPointerException("invalid null input");
        }
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineGetEntry(string, protectionParameter);
    }

    public final void setEntry(String string, Entry entry, ProtectionParameter protectionParameter) throws KeyStoreException {
        if (string == null || entry == null) {
            throw new NullPointerException("invalid null input");
        }
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.keyStoreSpi.engineSetEntry(string, entry, protectionParameter);
    }

    public final boolean entryInstanceOf(String string, Class<? extends Entry> clazz) throws KeyStoreException {
        if (string == null || clazz == null) {
            throw new NullPointerException("invalid null input");
        }
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineEntryInstanceOf(string, clazz);
    }

    static /* synthetic */ boolean access$000(KeyStore keyStore) {
        return keyStore.initialized;
    }

    public static abstract class Builder {
        static final int MAX_CALLBACK_TRIES = 3;

        protected Builder() {
        }

        public abstract KeyStore getKeyStore() throws KeyStoreException;

        public abstract ProtectionParameter getProtectionParameter(String var1) throws KeyStoreException;

        public static Builder newInstance(final KeyStore keyStore, final ProtectionParameter protectionParameter) {
            if (keyStore == null || protectionParameter == null) {
                throw new NullPointerException();
            }
            if (!keyStore.initialized) {
                throw new IllegalArgumentException("KeyStore not initialized");
            }
            return new Builder(){
                private volatile boolean getCalled;

                @Override
                public KeyStore getKeyStore() {
                    this.getCalled = true;
                    return keyStore;
                }

                @Override
                public ProtectionParameter getProtectionParameter(String alias) {
                    if (alias == null) {
                        throw new NullPointerException();
                    }
                    if (!this.getCalled) {
                        throw new IllegalStateException("getKeyStore() must be called first");
                    }
                    return protectionParameter;
                }
            };
        }

        public static Builder newInstance(String type, Provider provider, File file, ProtectionParameter protection) {
            if (type == null || file == null || protection == null) {
                throw new NullPointerException();
            }
            if (!(protection instanceof PasswordProtection) && !(protection instanceof CallbackHandlerProtection)) {
                throw new IllegalArgumentException("Protection must be PasswordProtection or CallbackHandlerProtection");
            }
            if (!file.isFile()) {
                throw new IllegalArgumentException("File does not exist or it does not refer to a normal file: " + file);
            }
            AccessControlContext acc = AccessController.getContext();
            return new FileBuilder(type, provider, file, protection, acc);
        }

        public static Builder newInstance(File file, ProtectionParameter protection) {
            return Builder.newInstance("", null, file, protection);
        }

        public static Builder newInstance(final String type, final Provider provider, final ProtectionParameter protection) {
            if (type == null || protection == null) {
                throw new NullPointerException();
            }
            final AccessControlContext context = AccessController.getContext();
            return new Builder(){
                private volatile boolean getCalled;
                private IOException oldException;
                private final PrivilegedExceptionAction<KeyStore> action = new PrivilegedExceptionAction<KeyStore>(){

                    @Override
                    public KeyStore run() throws Exception {
                        KeyStore ks = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
                        SimpleLoadStoreParameter param = new SimpleLoadStoreParameter(protection);
                        if (!(protection instanceof CallbackHandlerProtection)) {
                            ks.load(param);
                        } else {
                            int tries = 0;
                            while (true) {
                                ++tries;
                                try {
                                    ks.load(param);
                                }
                                catch (IOException e) {
                                    if (e.getCause() instanceof UnrecoverableKeyException) {
                                        if (tries < 3) continue;
                                        oldException = e;
                                    }
                                    throw e;
                                }
                                break;
                            }
                        }
                        getCalled = true;
                        return ks;
                    }
                };

                @Override
                public synchronized KeyStore getKeyStore() throws KeyStoreException {
                    if (this.oldException != null) {
                        throw new KeyStoreException("Previous KeyStore instantiation failed", this.oldException);
                    }
                    try {
                        return AccessController.doPrivileged(this.action, context);
                    }
                    catch (PrivilegedActionException e) {
                        Throwable cause = e.getCause();
                        throw new KeyStoreException("KeyStore instantiation failed", cause);
                    }
                }

                @Override
                public ProtectionParameter getProtectionParameter(String alias) {
                    if (alias == null) {
                        throw new NullPointerException();
                    }
                    if (!this.getCalled) {
                        throw new IllegalStateException("getKeyStore() must be called first");
                    }
                    return protection;
                }
            };
        }

        private static final class FileBuilder
        extends Builder {
            private final String type;
            private final Provider provider;
            private final File file;
            private final ProtectionParameter protection;
            private ProtectionParameter keyProtection;
            private final AccessControlContext context;
            private KeyStore keyStore;
            private Throwable oldException;

            FileBuilder(String type, Provider provider, File file, ProtectionParameter protection, AccessControlContext context) {
                this.type = type;
                this.provider = provider;
                this.file = file;
                this.protection = protection;
                this.context = context;
            }

            @Override
            public synchronized KeyStore getKeyStore() throws KeyStoreException {
                if (this.keyStore != null) {
                    return this.keyStore;
                }
                if (this.oldException != null) {
                    throw new KeyStoreException("Previous KeyStore instantiation failed", this.oldException);
                }
                PrivilegedExceptionAction<KeyStore> action = new PrivilegedExceptionAction<KeyStore>(){

                    @Override
                    public KeyStore run() throws Exception {
                        if (!(protection instanceof CallbackHandlerProtection)) {
                            return this.run0();
                        }
                        int tries = 0;
                        while (true) {
                            ++tries;
                            try {
                                return this.run0();
                            }
                            catch (IOException e) {
                                if (tries < 3 && e.getCause() instanceof UnrecoverableKeyException) continue;
                                throw e;
                            }
                            break;
                        }
                    }

                    public KeyStore run0() throws Exception {
                        KeyStore ks;
                        char[] password;
                        if (protection instanceof PasswordProtection) {
                            password = ((PasswordProtection)protection).getPassword();
                            keyProtection = protection;
                        } else {
                            CallbackHandler handler = ((CallbackHandlerProtection)protection).getCallbackHandler();
                            PasswordCallback callback = new PasswordCallback("Password for keystore " + file.getName(), false);
                            handler.handle(new Callback[]{callback});
                            password = callback.getPassword();
                            if (password == null) {
                                throw new KeyStoreException("No password provided");
                            }
                            callback.clearPassword();
                            keyProtection = new PasswordProtection(password);
                        }
                        if (type.isEmpty()) {
                            ks = KeyStore.getInstance((File)file, (char[])password);
                        } else {
                            ks = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
                            try (FileInputStream in = new FileInputStream(file);){
                                ks.load(in, password);
                            }
                        }
                        return ks;
                    }
                };
                try {
                    this.keyStore = AccessController.doPrivileged(action, this.context);
                    return this.keyStore;
                }
                catch (PrivilegedActionException e) {
                    this.oldException = e.getCause();
                    throw new KeyStoreException("KeyStore instantiation failed", this.oldException);
                }
            }

            @Override
            public synchronized ProtectionParameter getProtectionParameter(String alias) {
                if (alias == null) {
                    throw new NullPointerException();
                }
                if (this.keyStore == null) {
                    throw new IllegalStateException("getKeyStore() must be called first");
                }
                return this.keyProtection;
            }
        }
    }

    public static class CallbackHandlerProtection
    implements ProtectionParameter {
        private final CallbackHandler handler;

        public CallbackHandlerProtection(CallbackHandler handler) {
            if (handler == null) {
                throw new NullPointerException("handler must not be null");
            }
            this.handler = handler;
        }

        public CallbackHandler getCallbackHandler() {
            return this.handler;
        }
    }

    public static interface Entry {
        default public Set<Attribute> getAttributes() {
            return Collections.emptySet();
        }

        public static interface Attribute {
            public String getName();

            public String getValue();
        }
    }

    public static interface LoadStoreParameter {
        public ProtectionParameter getProtectionParameter();
    }

    public static class PasswordProtection
    implements ProtectionParameter,
    Destroyable {
        private final char[] password;
        private final String protectionAlgorithm;
        private final AlgorithmParameterSpec protectionParameters;
        private volatile boolean destroyed;

        public PasswordProtection(char[] password) {
            this.password = password == null ? null : (char[])password.clone();
            this.protectionAlgorithm = null;
            this.protectionParameters = null;
        }

        public PasswordProtection(char[] password, String protectionAlgorithm, AlgorithmParameterSpec protectionParameters) {
            if (protectionAlgorithm == null) {
                throw new NullPointerException("invalid null input");
            }
            this.password = password == null ? null : (char[])password.clone();
            this.protectionAlgorithm = protectionAlgorithm;
            this.protectionParameters = protectionParameters;
        }

        public String getProtectionAlgorithm() {
            return this.protectionAlgorithm;
        }

        public AlgorithmParameterSpec getProtectionParameters() {
            return this.protectionParameters;
        }

        public synchronized char[] getPassword() {
            if (this.destroyed) {
                throw new IllegalStateException("password has been cleared");
            }
            return this.password;
        }

        @Override
        public synchronized void destroy() throws DestroyFailedException {
            this.destroyed = true;
            if (this.password != null) {
                Arrays.fill(this.password, ' ');
            }
        }

        @Override
        public synchronized boolean isDestroyed() {
            return this.destroyed;
        }
    }

    public static final class PrivateKeyEntry
    implements Entry {
        private final PrivateKey privKey;
        private final Certificate[] chain;
        private final Set<Entry.Attribute> attributes;

        public PrivateKeyEntry(PrivateKey privateKey, Certificate[] chain) {
            this(privateKey, chain, Collections.emptySet());
        }

        public PrivateKeyEntry(PrivateKey privateKey, Certificate[] chain, Set<Entry.Attribute> attributes) {
            if (privateKey == null || chain == null || attributes == null) {
                throw new NullPointerException("invalid null input");
            }
            if (chain.length == 0) {
                throw new IllegalArgumentException("invalid zero-length input chain");
            }
            Certificate[] clonedChain = (Certificate[])chain.clone();
            String certType = clonedChain[0].getType();
            for (int i = 1; i < clonedChain.length; ++i) {
                if (certType.equals(clonedChain[i].getType())) continue;
                throw new IllegalArgumentException("chain does not contain certificates of the same type");
            }
            if (!privateKey.getAlgorithm().equals(clonedChain[0].getPublicKey().getAlgorithm())) {
                throw new IllegalArgumentException("private key algorithm does not match algorithm of public key in end entity certificate (at index 0)");
            }
            this.privKey = privateKey;
            if (clonedChain[0] instanceof X509Certificate && !(clonedChain instanceof X509Certificate[])) {
                this.chain = new X509Certificate[clonedChain.length];
                System.arraycopy(clonedChain, 0, this.chain, 0, clonedChain.length);
            } else {
                this.chain = clonedChain;
            }
            this.attributes = Collections.unmodifiableSet(new HashSet<Entry.Attribute>(attributes));
        }

        public PrivateKey getPrivateKey() {
            return this.privKey;
        }

        public Certificate[] getCertificateChain() {
            return (Certificate[])this.chain.clone();
        }

        public Certificate getCertificate() {
            return this.chain[0];
        }

        @Override
        public Set<Entry.Attribute> getAttributes() {
            return this.attributes;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Private key entry and certificate chain with " + this.chain.length + " elements:\r\n");
            for (Certificate cert : this.chain) {
                sb.append(cert);
                sb.append("\r\n");
            }
            return sb.toString();
        }
    }

    public static interface ProtectionParameter {
    }

    public static final class SecretKeyEntry
    implements Entry {
        private final SecretKey sKey;
        private final Set<Entry.Attribute> attributes;

        public SecretKeyEntry(SecretKey secretKey) {
            if (secretKey == null) {
                throw new NullPointerException("invalid null input");
            }
            this.sKey = secretKey;
            this.attributes = Collections.emptySet();
        }

        public SecretKeyEntry(SecretKey secretKey, Set<Entry.Attribute> attributes) {
            if (secretKey == null || attributes == null) {
                throw new NullPointerException("invalid null input");
            }
            this.sKey = secretKey;
            this.attributes = Collections.unmodifiableSet(new HashSet<Entry.Attribute>(attributes));
        }

        public SecretKey getSecretKey() {
            return this.sKey;
        }

        @Override
        public Set<Entry.Attribute> getAttributes() {
            return this.attributes;
        }

        public String toString() {
            return "Secret key entry with algorithm " + this.sKey.getAlgorithm();
        }
    }

    static class SimpleLoadStoreParameter
    implements LoadStoreParameter {
        private final ProtectionParameter protection;

        SimpleLoadStoreParameter(ProtectionParameter protection) {
            this.protection = protection;
        }

        @Override
        public ProtectionParameter getProtectionParameter() {
            return this.protection;
        }
    }

    public static final class TrustedCertificateEntry
    implements Entry {
        private final Certificate cert;
        private final Set<Entry.Attribute> attributes;

        public TrustedCertificateEntry(Certificate trustedCert) {
            if (trustedCert == null) {
                throw new NullPointerException("invalid null input");
            }
            this.cert = trustedCert;
            this.attributes = Collections.emptySet();
        }

        public TrustedCertificateEntry(Certificate trustedCert, Set<Entry.Attribute> attributes) {
            if (trustedCert == null || attributes == null) {
                throw new NullPointerException("invalid null input");
            }
            this.cert = trustedCert;
            this.attributes = Collections.unmodifiableSet(new HashSet<Entry.Attribute>(attributes));
        }

        public Certificate getTrustedCertificate() {
            return this.cert;
        }

        @Override
        public Set<Entry.Attribute> getAttributes() {
            return this.attributes;
        }

        public String toString() {
            return "Trusted certificate entry:\r\n" + this.cert.toString();
        }
    }
}

