/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import sun.misc.SharedSecrets;
import sun.reflect.CallerSensitive;
import sun.reflect.ConstantPool;
import sun.reflect.FieldAccessor;
import sun.reflect.Reflection;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationSupport;
import sun.reflect.annotation.TypeAnnotation;
import sun.reflect.annotation.TypeAnnotationParser;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.FieldRepository;
import sun.reflect.generics.scope.ClassScope;

public final class Field
extends AccessibleObject
implements Member {
    private Class<?> clazz;
    private int slot;
    private String name;
    private Class<?> type;
    private int modifiers;
    private transient String signature;
    private transient FieldRepository genericInfo;
    private byte[] annotations;
    private FieldAccessor fieldAccessor;
    private FieldAccessor overrideFieldAccessor;
    private Field root;
    private transient Map<Class<? extends Annotation>, Annotation> declaredAnnotations;

    private String getGenericSignature() {
        return this.signature;
    }

    private GenericsFactory getFactory() {
        Class<?> clazz = this.getDeclaringClass();
        return CoreReflectionFactory.make(clazz, ClassScope.make(clazz));
    }

    private FieldRepository getGenericInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = FieldRepository.make(this.getGenericSignature(), this.getFactory());
        }
        return this.genericInfo;
    }

    Field(Class<?> clazz, String string, Class<?> clazz2, int n, int n2, String string2, byte[] byArray) {
        this.clazz = clazz;
        this.name = string;
        this.type = clazz2;
        this.modifiers = n;
        this.slot = n2;
        this.signature = string2;
        this.annotations = byArray;
    }

    Field copy() {
        if (this.root != null) {
            throw new IllegalArgumentException("Can not copy a non-root Field");
        }
        Field field = new Field(this.clazz, this.name, this.type, this.modifiers, this.slot, this.signature, this.annotations);
        field.root = this;
        field.fieldAccessor = this.fieldAccessor;
        field.overrideFieldAccessor = this.overrideFieldAccessor;
        return field;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isEnumConstant() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    public Class<?> getType() {
        return this.type;
    }

    public Type getGenericType() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getGenericType();
        }
        return this.getType();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Field) {
            Field field = (Field)object;
            return this.getDeclaringClass() == field.getDeclaringClass() && this.getName() == field.getName() && this.getType() == field.getType();
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        int n = this.getModifiers();
        return (n == 0 ? "" : Modifier.toString(n) + " ") + this.getType().getTypeName() + " " + this.getDeclaringClass().getTypeName() + "." + this.getName();
    }

    public String toGenericString() {
        int n = this.getModifiers();
        Type type = this.getGenericType();
        return (n == 0 ? "" : Modifier.toString(n) + " ") + type.getTypeName() + " " + this.getDeclaringClass().getTypeName() + "." + this.getName();
    }

    @CallerSensitive
    public Object get(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class<?> clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        return this.getFieldAccessor(object).get(object);
    }

    @CallerSensitive
    public boolean getBoolean(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class<?> clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        return this.getFieldAccessor(object).getBoolean(object);
    }

    @CallerSensitive
    public byte getByte(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class<?> clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        return this.getFieldAccessor(object).getByte(object);
    }

    @CallerSensitive
    public char getChar(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class<?> clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        return this.getFieldAccessor(object).getChar(object);
    }

    @CallerSensitive
    public short getShort(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class<?> clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        return this.getFieldAccessor(object).getShort(object);
    }

    @CallerSensitive
    public int getInt(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class<?> clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        return this.getFieldAccessor(object).getInt(object);
    }

    @CallerSensitive
    public long getLong(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class<?> clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        return this.getFieldAccessor(object).getLong(object);
    }

    @CallerSensitive
    public float getFloat(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class<?> clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        return this.getFieldAccessor(object).getFloat(object);
    }

    @CallerSensitive
    public double getDouble(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class<?> clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        return this.getFieldAccessor(object).getDouble(object);
    }

    @CallerSensitive
    public void set(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class<?> clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        this.getFieldAccessor(object).set(object, object2);
    }

    @CallerSensitive
    public void setBoolean(Object object, boolean bl) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class<?> clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        this.getFieldAccessor(object).setBoolean(object, bl);
    }

    @CallerSensitive
    public void setByte(Object object, byte by) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class<?> clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        this.getFieldAccessor(object).setByte(object, by);
    }

    @CallerSensitive
    public void setChar(Object object, char c) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class<?> clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        this.getFieldAccessor(object).setChar(object, c);
    }

    @CallerSensitive
    public void setShort(Object object, short s) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class<?> clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        this.getFieldAccessor(object).setShort(object, s);
    }

    @CallerSensitive
    public void setInt(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class<?> clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        this.getFieldAccessor(object).setInt(object, n);
    }

    @CallerSensitive
    public void setLong(Object object, long l) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class<?> clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        this.getFieldAccessor(object).setLong(object, l);
    }

    @CallerSensitive
    public void setFloat(Object object, float f) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class<?> clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        this.getFieldAccessor(object).setFloat(object, f);
    }

    @CallerSensitive
    public void setDouble(Object object, double d) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class<?> clazz = Reflection.getCallerClass();
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
        this.getFieldAccessor(object).setDouble(object, d);
    }

    private FieldAccessor getFieldAccessor(Object object) throws IllegalAccessException {
        boolean bl = this.override;
        FieldAccessor fieldAccessor = bl ? this.overrideFieldAccessor : this.fieldAccessor;
        return fieldAccessor != null ? fieldAccessor : this.acquireFieldAccessor(bl);
    }

    private FieldAccessor acquireFieldAccessor(boolean bl) {
        FieldAccessor fieldAccessor = null;
        if (this.root != null) {
            fieldAccessor = this.root.getFieldAccessor(bl);
        }
        if (fieldAccessor != null) {
            if (bl) {
                this.overrideFieldAccessor = fieldAccessor;
            } else {
                this.fieldAccessor = fieldAccessor;
            }
        } else {
            fieldAccessor = reflectionFactory.newFieldAccessor(this, bl);
            this.setFieldAccessor(fieldAccessor, bl);
        }
        return fieldAccessor;
    }

    private FieldAccessor getFieldAccessor(boolean bl) {
        return bl ? this.overrideFieldAccessor : this.fieldAccessor;
    }

    private void setFieldAccessor(FieldAccessor fieldAccessor, boolean bl) {
        if (bl) {
            this.overrideFieldAccessor = fieldAccessor;
        } else {
            this.fieldAccessor = fieldAccessor;
        }
        if (this.root != null) {
            this.root.setFieldAccessor(fieldAccessor, bl);
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return (T)((Annotation)clazz.cast(this.declaredAnnotations().get(clazz)));
    }

    @Override
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return AnnotationSupport.getDirectlyAndIndirectlyPresent(this.declaredAnnotations(), clazz);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return AnnotationParser.toArray(this.declaredAnnotations());
    }

    private synchronized Map<Class<? extends Annotation>, Annotation> declaredAnnotations() {
        if (this.declaredAnnotations == null) {
            Field field = this.root;
            this.declaredAnnotations = field != null ? field.declaredAnnotations() : AnnotationParser.parseAnnotations(this.annotations, SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
        }
        return this.declaredAnnotations;
    }

    private native byte[] getTypeAnnotationBytes0();

    public AnnotatedType getAnnotatedType() {
        return TypeAnnotationParser.buildAnnotatedType((byte[])this.getTypeAnnotationBytes0(), (ConstantPool)SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), (AnnotatedElement)this, this.getDeclaringClass(), (Type)this.getGenericType(), (TypeAnnotation.TypeAnnotationTarget)TypeAnnotation.TypeAnnotationTarget.FIELD);
    }
}

