/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.DelegatingMethodHandle;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.ForceInline;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SimpleMethodHandle;
import java.lang.invoke.Stable;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;
import jdk.internal.vm.annotation.Hidden;
import sun.invoke.empty.Empty;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;

abstract class MethodHandleImpl {
    private static final int MAX_ARITY;
    private static final Function<MethodHandle, LambdaForm> PRODUCE_BLOCK_INLINING_FORM;
    private static final Function<MethodHandle, LambdaForm> PRODUCE_REINVOKER_FORM;
    static MethodHandle[] FAKE_METHOD_HANDLE_INVOKE;
    private static final Object[] NO_ARGS_ARRAY;
    private static final int FILL_ARRAYS_COUNT = 11;
    private static final int LEFT_ARGS = 10;
    private static final MethodHandle[] FILL_ARRAY_TO_RIGHT;
    private static final ClassValue<MethodHandle[]> TYPED_COLLECTORS;
    static final int MAX_JVM_ARITY = 255;

    MethodHandleImpl() {
    }

    static void initStatics() {
        MemberName.Factory.INSTANCE.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MethodHandle makeArrayElementAccessor(Class<?> clazz, boolean bl) {
        int n;
        if (clazz == Object[].class) {
            return bl ? ArrayAccessor.OBJECT_ARRAY_SETTER : ArrayAccessor.OBJECT_ARRAY_GETTER;
        }
        if (!clazz.isArray()) {
            throw MethodHandleStatics.newIllegalArgumentException("not an array: " + clazz);
        }
        MethodHandle[] methodHandleArray = ArrayAccessor.TYPED_ACCESSORS.get(clazz);
        MethodHandle methodHandle = methodHandleArray[n = bl ? 1 : 0];
        if (methodHandle != null) {
            return methodHandle;
        }
        methodHandle = ArrayAccessor.getAccessor(clazz, (boolean)bl);
        MethodType methodType = ArrayAccessor.correctType(clazz, (boolean)bl);
        if (methodHandle.type() != methodType) {
            assert (methodHandle.type().parameterType(0) == Object[].class);
            assert ((bl ? methodHandle.type().parameterType(2) : methodHandle.type().returnType()) == Object.class);
            assert (bl || methodType.parameterType(0).getComponentType() == methodType.returnType());
            methodHandle = methodHandle.viewAsType(methodType, false);
        }
        methodHandle = MethodHandleImpl.makeIntrinsic(methodHandle, bl ? Intrinsic.ARRAY_STORE : Intrinsic.ARRAY_LOAD);
        MethodHandle[] methodHandleArray2 = methodHandleArray;
        synchronized (methodHandleArray) {
            if (methodHandleArray[n] == null) {
                methodHandleArray[n] = methodHandle;
            } else {
                methodHandle = methodHandleArray[n];
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return methodHandle;
        }
    }

    static MethodHandle makePairwiseConvert(MethodHandle methodHandle, MethodType methodType, boolean bl, boolean bl2) {
        MethodType methodType2 = methodHandle.type();
        if (methodType == methodType2) {
            return methodHandle;
        }
        return MethodHandleImpl.makePairwiseConvertByEditor(methodHandle, methodType, bl, bl2);
    }

    private static int countNonNull(Object[] objectArray) {
        int n = 0;
        for (Object object : objectArray) {
            if (object == null) continue;
            ++n;
        }
        return n;
    }

    static MethodHandle makePairwiseConvertByEditor(MethodHandle methodHandle, MethodType methodType, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        Object[] objectArray = MethodHandleImpl.computeValueConversions(methodType, methodHandle.type(), bl, bl2);
        int n = MethodHandleImpl.countNonNull(objectArray);
        if (n == 0) {
            return methodHandle.viewAsType(methodType, bl);
        }
        MethodType methodType2 = methodType.basicType();
        MethodType methodType3 = methodHandle.type().basicType();
        BoundMethodHandle boundMethodHandle = methodHandle.rebind();
        for (int i = 0; i < objectArray.length - 1; ++i) {
            object3 = objectArray[i];
            if (object3 == null) continue;
            object2 = object3 instanceof Class ? Lazy.MH_castReference.bindTo(object3) : (MethodHandle)object3;
            object = methodType2.parameterType(i);
            methodType3 = --n == 0 ? methodType : methodType3.changeParameterType(i, (Class<?>)object);
            LambdaForm lambdaForm = boundMethodHandle.editor().filterArgumentForm(1 + i, LambdaForm.BasicType.basicType(object));
            boundMethodHandle = boundMethodHandle.copyWithExtendL(methodType3, lambdaForm, object2);
            boundMethodHandle = boundMethodHandle.rebind();
        }
        Object object4 = objectArray[objectArray.length - 1];
        if (object4 != null) {
            object3 = object4 instanceof Class ? (object4 == Void.TYPE ? null : Lazy.MH_castReference.bindTo(object4)) : (MethodHandle)object4;
            object2 = methodType2.returnType();
            assert (--n == 0);
            methodType3 = methodType;
            if (object3 != null) {
                boundMethodHandle = boundMethodHandle.rebind();
                object = boundMethodHandle.editor().filterReturnForm(LambdaForm.BasicType.basicType(object2), false);
                boundMethodHandle = boundMethodHandle.copyWithExtendL(methodType3, (LambdaForm)object, object3);
            } else {
                object = boundMethodHandle.editor().filterReturnForm(LambdaForm.BasicType.basicType(object2), true);
                boundMethodHandle = boundMethodHandle.copyWith(methodType3, (LambdaForm)object);
            }
        }
        assert (n == 0);
        assert (boundMethodHandle.type().equals((Object)methodType));
        return boundMethodHandle;
    }

    static MethodHandle makePairwiseConvertIndirect(MethodHandle methodHandle, MethodType methodType, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        boolean bl3;
        assert (methodHandle.type().parameterCount() == methodType.parameterCount());
        Object[] objectArray = MethodHandleImpl.computeValueConversions(methodType, methodHandle.type(), bl, bl2);
        int n = methodType.parameterCount();
        int n2 = MethodHandleImpl.countNonNull(objectArray);
        boolean bl4 = objectArray[n] != null;
        boolean bl5 = bl3 = methodType.returnType() == Void.TYPE;
        if (bl4 && bl3) {
            --n2;
            bl4 = false;
        }
        int n3 = 1 + n;
        int n4 = n3 + n2 + 1;
        int n5 = !bl4 ? -1 : n4 - 1;
        int n6 = (!bl4 ? n4 : n5) - 1;
        int n7 = bl3 ? -1 : n4 - 1;
        MethodType methodType2 = methodType.basicType().invokerType();
        LambdaForm.Name[] nameArray = LambdaForm.arguments(n4 - n3, methodType2);
        Object[] objectArray2 = new Object[0 + n];
        int n8 = n3;
        for (int i = 0; i < n; ++i) {
            Object object3;
            object2 = objectArray[i];
            if (object2 == null) {
                objectArray2[0 + i] = nameArray[1 + i];
                continue;
            }
            if (object2 instanceof Class) {
                object3 = (Class)object2;
                object = new LambdaForm.Name(Lazy.MH_castReference, object3, nameArray[1 + i]);
            } else {
                object3 = (MethodHandle)object2;
                object = new LambdaForm.Name((MethodHandle)object3, nameArray[1 + i]);
            }
            assert (nameArray[n8] == null);
            nameArray[n8++] = object;
            assert (objectArray2[0 + i] == null);
            objectArray2[0 + i] = object;
        }
        assert (n8 == n6);
        nameArray[n6] = new LambdaForm.Name(methodHandle, objectArray2);
        Object object4 = objectArray[n];
        if (!bl4) {
            assert (n6 == nameArray.length - 1);
        } else {
            if (object4 == Void.TYPE) {
                object2 = new LambdaForm.Name(LambdaForm.constantZero(LambdaForm.BasicType.basicType(methodType.returnType())), new Object[0]);
            } else if (object4 instanceof Class) {
                object = (Class)object4;
                object2 = new LambdaForm.Name(Lazy.MH_castReference, object, nameArray[n6]);
            } else {
                object = (MethodHandle)object4;
                object2 = ((MethodHandle)object).type().parameterCount() == 0 ? new LambdaForm.Name((MethodHandle)object, new Object[0]) : new LambdaForm.Name((MethodHandle)object, nameArray[n6]);
            }
            assert (nameArray[n5] == null);
            nameArray[n5] = object2;
            assert (n5 == nameArray.length - 1);
        }
        object2 = new LambdaForm("convert", methodType2.parameterCount(), nameArray, n7);
        return SimpleMethodHandle.make(methodType, (LambdaForm)object2);
    }

    @ForceInline
    static <T, U> T castReference(Class<? extends T> clazz, U u) {
        if (u != null && !clazz.isInstance(u)) {
            throw MethodHandleImpl.newClassCastException(clazz, u);
        }
        return (T)u;
    }

    private static ClassCastException newClassCastException(Class<?> clazz, Object object) {
        return new ClassCastException("Cannot cast " + object.getClass().getName() + " to " + clazz.getName());
    }

    static Object[] computeValueConversions(MethodType methodType, MethodType methodType2, boolean bl, boolean bl2) {
        int n = methodType.parameterCount();
        Object[] objectArray = new Object[n + 1];
        for (int i = 0; i <= n; ++i) {
            Class<?> clazz;
            boolean bl3 = i == n;
            Class<?> clazz2 = bl3 ? methodType2.returnType() : methodType.parameterType(i);
            Class<?> clazz3 = clazz = bl3 ? methodType.returnType() : methodType2.parameterType(i);
            if (VerifyType.isNullConversion(clazz2, clazz, bl)) continue;
            objectArray[i] = MethodHandleImpl.valueConversion(clazz2, clazz, bl, bl2);
        }
        return objectArray;
    }

    static MethodHandle makePairwiseConvert(MethodHandle methodHandle, MethodType methodType, boolean bl) {
        return MethodHandleImpl.makePairwiseConvert(methodHandle, methodType, bl, false);
    }

    static Object valueConversion(Class<?> clazz, Class<?> clazz2, boolean bl, boolean bl2) {
        MethodHandle methodHandle;
        assert (!VerifyType.isNullConversion(clazz, clazz2, bl));
        if (clazz2 == Void.TYPE) {
            return clazz2;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                return Void.TYPE;
            }
            if (clazz2.isPrimitive()) {
                methodHandle = ValueConversions.convertPrimitive(clazz, clazz2);
            } else {
                Wrapper wrapper = Wrapper.forPrimitiveType(clazz);
                methodHandle = ValueConversions.boxExact(wrapper);
                assert (methodHandle.type().parameterType(0) == wrapper.primitiveType());
                assert (methodHandle.type().returnType() == wrapper.wrapperType());
                if (!VerifyType.isNullConversion(wrapper.wrapperType(), clazz2, bl)) {
                    MethodType methodType = MethodType.methodType(clazz2, clazz);
                    methodHandle = bl ? methodHandle.asType(methodType) : MethodHandleImpl.makePairwiseConvert(methodHandle, methodType, false);
                }
            }
        } else if (clazz2.isPrimitive()) {
            Wrapper wrapper = Wrapper.forPrimitiveType(clazz2);
            methodHandle = bl2 || clazz == wrapper.wrapperType() ? ValueConversions.unboxExact(wrapper, bl) : (bl ? ValueConversions.unboxWiden(wrapper) : ValueConversions.unboxCast(wrapper));
        } else {
            return clazz2;
        }
        assert (methodHandle.type().parameterCount() <= 1) : "pc" + Arrays.asList(clazz.getSimpleName(), clazz2.getSimpleName(), methodHandle);
        return methodHandle;
    }

    static MethodHandle makeVarargsCollector(MethodHandle methodHandle, Class<?> clazz) {
        int n;
        MethodType methodType = methodHandle.type();
        if (methodType.parameterType(n = methodType.parameterCount() - 1) != clazz) {
            methodHandle = methodHandle.asType(methodType.changeParameterType(n, clazz));
        }
        methodHandle = methodHandle.asFixedArity();
        return new AsVarargsCollector(methodHandle, clazz);
    }

    static MethodHandle makeSpreadArguments(MethodHandle methodHandle, Class<?> clazz, int n, int n2) {
        Class<?> clazz2;
        MethodType methodType = methodHandle.type();
        for (int i = 0; i < n2; ++i) {
            clazz2 = VerifyType.spreadArgElementType(clazz, i);
            if (clazz2 == null) {
                clazz2 = Object.class;
            }
            methodType = methodType.changeParameterType(n + i, clazz2);
        }
        methodHandle = methodHandle.asType(methodType);
        MethodType methodType2 = methodType.replaceParameterTypes(n, n + n2, clazz);
        clazz2 = methodType2.invokerType();
        LambdaForm.Name[] nameArray = LambdaForm.arguments(n2 + 2, (MethodType)((Object)clazz2));
        int n3 = ((MethodType)((Object)clazz2)).parameterCount();
        int[] nArray = new int[methodType.parameterCount()];
        int n4 = 0;
        int n5 = 1;
        while (n4 < methodType.parameterCount() + 1) {
            Class<?> clazz3 = ((MethodType)((Object)clazz2)).parameterType(n4);
            if (n4 == n) {
                MethodHandle methodHandle2 = MethodHandles.arrayElementGetter(clazz);
                LambdaForm.Name name = nameArray[n5];
                nameArray[n3++] = new LambdaForm.Name(Lazy.NF_checkSpreadArgument, name, n2);
                for (int i = 0; i < n2; ++i) {
                    nArray[n4] = n3;
                    nameArray[n3++] = new LambdaForm.Name(methodHandle2, name, i);
                    ++n4;
                }
            } else if (n4 < nArray.length) {
                nArray[n4] = n5;
            }
            ++n4;
            ++n5;
        }
        assert (n3 == nameArray.length - 1);
        LambdaForm.Name[] nameArray2 = new LambdaForm.Name[methodType.parameterCount()];
        for (n5 = 0; n5 < methodType.parameterCount(); ++n5) {
            int n6 = nArray[n5];
            nameArray2[n5] = nameArray[n6];
        }
        nameArray[nameArray.length - 1] = new LambdaForm.Name(methodHandle, (Object[])nameArray2);
        LambdaForm lambdaForm = new LambdaForm("spread", ((MethodType)((Object)clazz2)).parameterCount(), nameArray);
        return SimpleMethodHandle.make(methodType2, lambdaForm);
    }

    static void checkSpreadArgument(Object object, int n) {
        int n2;
        int n3;
        if (object == null ? n == 0 : (object instanceof Object[] ? (n3 = ((Object[])object).length) == n : (n2 = Array.getLength(object)) == n)) {
            return;
        }
        throw MethodHandleStatics.newIllegalArgumentException("array is not of length " + n);
    }

    static MethodHandle makeCollectArguments(MethodHandle methodHandle, MethodHandle methodHandle2, int n, boolean bl) {
        MethodType methodType = methodHandle.type();
        MethodType methodType2 = methodHandle2.type();
        int n2 = methodType2.parameterCount();
        Class<?> clazz = methodType2.returnType();
        int n3 = clazz == Void.TYPE ? 0 : 1;
        MethodType methodType3 = methodType.dropParameterTypes(n, n + n3);
        if (!bl) {
            methodType3 = methodType3.insertParameterTypes(n, methodType2.parameterList());
        }
        MethodType methodType4 = methodType3.invokerType();
        LambdaForm.Name[] nameArray = LambdaForm.arguments(2, methodType4);
        int n4 = nameArray.length - 2;
        int n5 = nameArray.length - 1;
        LambdaForm.Name[] nameArray2 = Arrays.copyOfRange(nameArray, 1 + n, 1 + n + n2);
        nameArray[n4] = new LambdaForm.Name(methodHandle2, (Object[])nameArray2);
        LambdaForm.Name[] nameArray3 = new LambdaForm.Name[methodType.parameterCount()];
        int n6 = 1;
        int n7 = 0;
        int n8 = n;
        System.arraycopy(nameArray, n6, nameArray3, n7, n8);
        n6 += n8;
        n7 += n8;
        if (clazz != Void.TYPE) {
            nameArray3[n7++] = nameArray[n4];
        }
        n8 = n2;
        if (bl) {
            System.arraycopy(nameArray, n6, nameArray3, n7, n8);
            n7 += n8;
        }
        n6 += n8;
        n8 = nameArray3.length - n7;
        System.arraycopy(nameArray, n6, nameArray3, n7, n8);
        assert (n6 + n8 == n4);
        nameArray[n5] = new LambdaForm.Name(methodHandle, (Object[])nameArray3);
        LambdaForm lambdaForm = new LambdaForm("collect", methodType4.parameterCount(), nameArray);
        return SimpleMethodHandle.make(methodType3, lambdaForm);
    }

    @LambdaForm.Hidden
    static MethodHandle selectAlternative(boolean bl, MethodHandle methodHandle, MethodHandle methodHandle2) {
        if (bl) {
            return methodHandle;
        }
        return methodHandle2;
    }

    @LambdaForm.Hidden
    static boolean profileBoolean(boolean bl, int[] nArray) {
        int n = bl ? 1 : 0;
        try {
            nArray[n] = Math.addExact(nArray[n], 1);
        }
        catch (ArithmeticException arithmeticException) {
            nArray[n] = nArray[n] / 2;
        }
        return bl;
    }

    static MethodHandle makeGuardWithTest(MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) {
        BoundMethodHandle boundMethodHandle;
        MethodType methodType = methodHandle2.type();
        assert (methodHandle.type().equals((Object)methodType.changeReturnType(Boolean.TYPE)) && methodHandle3.type().equals((Object)methodType));
        MethodType methodType2 = methodType.basicType();
        LambdaForm lambdaForm = MethodHandleImpl.makeGuardWithTestForm(methodType2);
        try {
            if (MethodHandleStatics.PROFILE_GWT) {
                int[] nArray = new int[2];
                boundMethodHandle = BoundMethodHandle.speciesData_LLLL().constructor().invokeBasic(methodType, lambdaForm, methodHandle, MethodHandleImpl.profile(methodHandle2), MethodHandleImpl.profile(methodHandle3), nArray);
            } else {
                boundMethodHandle = BoundMethodHandle.speciesData_LLL().constructor().invokeBasic(methodType, lambdaForm, methodHandle, MethodHandleImpl.profile(methodHandle2), MethodHandleImpl.profile(methodHandle3));
            }
        }
        catch (Throwable throwable) {
            throw MethodHandleStatics.uncaughtException(throwable);
        }
        assert (boundMethodHandle.type() == methodType);
        return boundMethodHandle;
    }

    static MethodHandle profile(MethodHandle methodHandle) {
        if (MethodHandleStatics.DONT_INLINE_THRESHOLD >= 0) {
            return MethodHandleImpl.makeBlockInlningWrapper(methodHandle);
        }
        return methodHandle;
    }

    static MethodHandle makeBlockInlningWrapper(MethodHandle methodHandle) {
        LambdaForm lambdaForm = PRODUCE_BLOCK_INLINING_FORM.apply(methodHandle);
        return new CountingWrapper(methodHandle, lambdaForm, PRODUCE_BLOCK_INLINING_FORM, PRODUCE_REINVOKER_FORM, MethodHandleStatics.DONT_INLINE_THRESHOLD, null);
    }

    static LambdaForm makeGuardWithTestForm(MethodType methodType) {
        int n;
        LambdaForm lambdaForm = methodType.form().cachedLambdaForm(17);
        if (lambdaForm != null) {
            return lambdaForm;
        }
        int n2 = n = 1 + methodType.parameterCount();
        int n3 = n2++;
        int n4 = n2++;
        int n5 = n2++;
        int n6 = MethodHandleStatics.PROFILE_GWT ? n2++ : -1;
        int n7 = n2++;
        int n8 = n6 != -1 ? n2++ : -1;
        int n9 = n2 - 1;
        int n10 = n2++;
        int n11 = n2++;
        assert (n11 == n10 + 1);
        MethodType methodType2 = methodType.invokerType();
        LambdaForm.Name[] nameArray = LambdaForm.arguments(n2 - n, methodType2);
        BoundMethodHandle.SpeciesData speciesData = n6 != -1 ? BoundMethodHandle.speciesData_LLLL() : BoundMethodHandle.speciesData_LLL();
        nameArray[0] = nameArray[0].withConstraint(speciesData);
        nameArray[n3] = new LambdaForm.Name(speciesData.getterFunction(0), nameArray[0]);
        nameArray[n4] = new LambdaForm.Name(speciesData.getterFunction(1), nameArray[0]);
        nameArray[n5] = new LambdaForm.Name(speciesData.getterFunction(2), nameArray[0]);
        if (n6 != -1) {
            nameArray[n6] = new LambdaForm.Name(speciesData.getterFunction(3), nameArray[0]);
        }
        Object[] objectArray = Arrays.copyOfRange(nameArray, 0, n, Object[].class);
        MethodType methodType3 = methodType.changeReturnType(Boolean.TYPE).basicType();
        objectArray[0] = nameArray[n3];
        nameArray[n7] = new LambdaForm.Name(methodType3, objectArray);
        if (n8 != -1) {
            nameArray[n8] = new LambdaForm.Name(Lazy.NF_profileBoolean, nameArray[n7], nameArray[n6]);
        }
        nameArray[n10] = new LambdaForm.Name(Lazy.MH_selectAlternative, nameArray[n9], nameArray[n4], nameArray[n5]);
        objectArray[0] = nameArray[n10];
        nameArray[n11] = new LambdaForm.Name(methodType, objectArray);
        lambdaForm = new LambdaForm("guard", methodType2.parameterCount(), nameArray, true);
        return methodType.form().setCachedLambdaForm(17, lambdaForm);
    }

    private static LambdaForm makeGuardWithCatchForm(MethodType methodType) {
        int n;
        MethodType methodType2 = methodType.invokerType();
        LambdaForm lambdaForm = methodType.form().cachedLambdaForm(16);
        if (lambdaForm != null) {
            return lambdaForm;
        }
        int n2 = n = 1 + methodType.parameterCount();
        int n3 = n2++;
        int n4 = n2++;
        int n5 = n2++;
        int n6 = n2++;
        int n7 = n2++;
        int n8 = n2++;
        int n9 = n2++;
        int n10 = n2++;
        LambdaForm.Name[] nameArray = LambdaForm.arguments(n2 - n, methodType2);
        BoundMethodHandle.SpeciesData speciesData = BoundMethodHandle.speciesData_LLLLL();
        nameArray[0] = nameArray[0].withConstraint(speciesData);
        nameArray[n3] = new LambdaForm.Name(speciesData.getterFunction(0), nameArray[0]);
        nameArray[n4] = new LambdaForm.Name(speciesData.getterFunction(1), nameArray[0]);
        nameArray[n5] = new LambdaForm.Name(speciesData.getterFunction(2), nameArray[0]);
        nameArray[n6] = new LambdaForm.Name(speciesData.getterFunction(3), nameArray[0]);
        nameArray[n7] = new LambdaForm.Name(speciesData.getterFunction(4), nameArray[0]);
        MethodType methodType3 = methodType.changeReturnType(Object.class);
        MethodHandle methodHandle = MethodHandles.basicInvoker(methodType3);
        Object[] objectArray = new Object[methodHandle.type().parameterCount()];
        objectArray[0] = nameArray[n6];
        System.arraycopy(nameArray, 1, objectArray, 1, n - 1);
        nameArray[n8] = new LambdaForm.Name(MethodHandleImpl.makeIntrinsic(methodHandle, Intrinsic.GUARD_WITH_CATCH), objectArray);
        Object[] objectArray2 = new Object[]{nameArray[n3], nameArray[n4], nameArray[n5], nameArray[n8]};
        nameArray[n9] = new LambdaForm.Name(Lazy.NF_guardWithCatch, objectArray2);
        MethodHandle methodHandle2 = MethodHandles.basicInvoker(MethodType.methodType(methodType.rtype(), Object.class));
        Object[] objectArray3 = new Object[]{nameArray[n7], nameArray[n9]};
        nameArray[n10] = new LambdaForm.Name(methodHandle2, objectArray3);
        lambdaForm = new LambdaForm("guardWithCatch", methodType2.parameterCount(), nameArray);
        return methodType.form().setCachedLambdaForm(16, lambdaForm);
    }

    static MethodHandle makeGuardWithCatch(MethodHandle methodHandle, Class<? extends Throwable> clazz, MethodHandle methodHandle2) {
        BoundMethodHandle boundMethodHandle;
        Object object;
        MethodHandle methodHandle3;
        MethodType methodType = methodHandle.type();
        LambdaForm lambdaForm = MethodHandleImpl.makeGuardWithCatchForm(methodType.basicType());
        MethodType methodType2 = methodType.changeReturnType(Object[].class);
        MethodHandle methodHandle4 = MethodHandleImpl.varargsArray(methodType.parameterCount()).asType(methodType2);
        Class<?> clazz2 = methodType.returnType();
        if (clazz2.isPrimitive()) {
            if (clazz2 == Void.TYPE) {
                methodHandle3 = ValueConversions.ignore();
            } else {
                object = Wrapper.forPrimitiveType(methodType.returnType());
                methodHandle3 = ValueConversions.unboxExact((Wrapper)((Object)object));
            }
        } else {
            methodHandle3 = MethodHandles.identity(Object.class);
        }
        object = BoundMethodHandle.speciesData_LLLLL();
        try {
            boundMethodHandle = ((BoundMethodHandle.SpeciesData)object).constructor().invokeBasic(methodType, lambdaForm, methodHandle, clazz, methodHandle2, methodHandle4, methodHandle3);
        }
        catch (Throwable throwable) {
            throw MethodHandleStatics.uncaughtException(throwable);
        }
        assert (boundMethodHandle.type() == methodType);
        return boundMethodHandle;
    }

    @LambdaForm.Hidden
    static Object guardWithCatch(MethodHandle methodHandle, Class<? extends Throwable> clazz, MethodHandle methodHandle2, Object ... objectArray) throws Throwable {
        try {
            return methodHandle.asFixedArity().invokeWithArguments(objectArray);
        }
        catch (Throwable throwable) {
            if (!clazz.isInstance(throwable)) {
                throw throwable;
            }
            return methodHandle2.asFixedArity().invokeWithArguments(MethodHandleImpl.prepend(throwable, objectArray));
        }
    }

    @LambdaForm.Hidden
    private static Object[] prepend(Object object, Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        objectArray2[0] = object;
        System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        return objectArray2;
    }

    static MethodHandle throwException(MethodType methodType) {
        assert (Throwable.class.isAssignableFrom(methodType.parameterType(0)));
        int n = methodType.parameterCount();
        if (n > 1) {
            MethodHandle methodHandle = MethodHandleImpl.throwException(methodType.dropParameterTypes(1, n));
            methodHandle = MethodHandles.dropArguments(methodHandle, 1, methodType.parameterList().subList(1, n));
            return methodHandle;
        }
        return MethodHandleImpl.makePairwiseConvert(Lazy.NF_throwException.resolvedHandle(), methodType, false, true);
    }

    static <T extends Throwable> Empty throwException(T t) throws T {
        throw t;
    }

    static MethodHandle fakeMethodHandleInvoke(MemberName memberName) {
        int n;
        assert (memberName.isMethodHandleInvoke());
        switch (memberName.getName()) {
            case "invoke": {
                n = 0;
                break;
            }
            case "invokeExact": {
                n = 1;
                break;
            }
            default: {
                throw new InternalError(memberName.getName());
            }
        }
        Object object = FAKE_METHOD_HANDLE_INVOKE[n];
        if (object != null) {
            return object;
        }
        MethodType methodType = MethodType.methodType(Object.class, UnsupportedOperationException.class, MethodHandle.class, Object[].class);
        object = MethodHandleImpl.throwException(methodType);
        object = ((MethodHandle)object).bindTo(new UnsupportedOperationException("cannot reflectively invoke MethodHandle"));
        if (!memberName.getInvocationType().equals((Object)((MethodHandle)object).type())) {
            throw new InternalError(memberName.toString());
        }
        object = ((MethodHandle)object).withInternalMemberName(memberName, false);
        object = ((MethodHandle)object).asVarargsCollector(Object[].class);
        assert (memberName.isVarargs());
        MethodHandleImpl.FAKE_METHOD_HANDLE_INVOKE[n] = object;
        return object;
    }

    static MethodHandle bindCaller(MethodHandle methodHandle, Class<?> clazz) {
        return BindCaller.bindCaller(methodHandle, clazz);
    }

    static MethodHandle makeWrappedMember(MethodHandle methodHandle, MemberName memberName, boolean bl) {
        if (memberName.equals(methodHandle.internalMemberName()) && bl == methodHandle.isInvokeSpecial()) {
            return methodHandle;
        }
        return new WrappedMember(methodHandle, methodHandle.type(), memberName, bl, null, null);
    }

    static MethodHandle makeIntrinsic(MethodHandle methodHandle, Intrinsic intrinsic) {
        if (intrinsic == methodHandle.intrinsicName()) {
            return methodHandle;
        }
        return new IntrinsicMethodHandle(methodHandle, intrinsic);
    }

    static MethodHandle makeIntrinsic(MethodType methodType, LambdaForm lambdaForm, Intrinsic intrinsic) {
        return new IntrinsicMethodHandle(SimpleMethodHandle.make(methodType, lambdaForm), intrinsic);
    }

    private static MethodHandle findCollector(String string, int n, Class<?> clazz, Class<?> ... classArray) {
        MethodType methodType = MethodType.genericMethodType(n).changeReturnType(clazz).insertParameterTypes(0, classArray);
        try {
            return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, string, methodType);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return null;
        }
    }

    private static Object[] makeArray(Object ... objectArray) {
        return objectArray;
    }

    private static Object[] array() {
        return NO_ARGS_ARRAY;
    }

    private static Object[] array(Object object) {
        return MethodHandleImpl.makeArray(object);
    }

    private static Object[] array(Object object, Object object2) {
        return MethodHandleImpl.makeArray(object, object2);
    }

    private static Object[] array(Object object, Object object2, Object object3) {
        return MethodHandleImpl.makeArray(object, object2, object3);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4) {
        return MethodHandleImpl.makeArray(object, object2, object3, object4);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5) {
        return MethodHandleImpl.makeArray(object, object2, object3, object4, object5);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return MethodHandleImpl.makeArray(object, object2, object3, object4, object5, object6);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        return MethodHandleImpl.makeArray(object, object2, object3, object4, object5, object6, object7);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        return MethodHandleImpl.makeArray(object, object2, object3, object4, object5, object6, object7, object8);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        return MethodHandleImpl.makeArray(object, object2, object3, object4, object5, object6, object7, object8, object9);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        return MethodHandleImpl.makeArray(object, object2, object3, object4, object5, object6, object7, object8, object9, object10);
    }

    private static MethodHandle[] makeArrays() {
        MethodHandle methodHandle;
        ArrayList<MethodHandle> arrayList = new ArrayList<MethodHandle>();
        while ((methodHandle = MethodHandleImpl.findCollector("array", arrayList.size(), Object[].class, new Class[0])) != null) {
            methodHandle = MethodHandleImpl.makeIntrinsic(methodHandle, Intrinsic.NEW_ARRAY);
            arrayList.add(methodHandle);
        }
        assert (arrayList.size() == 11);
        return arrayList.toArray(new MethodHandle[MAX_ARITY + 1]);
    }

    private static Object[] fillNewArray(Integer n, Object[] objectArray) {
        Object[] objectArray2 = new Object[n.intValue()];
        MethodHandleImpl.fillWithArguments(objectArray2, 0, objectArray);
        return objectArray2;
    }

    private static Object[] fillNewTypedArray(Object[] objectArray, Integer n, Object[] objectArray2) {
        Object[] objectArray3 = Arrays.copyOf(objectArray, (int)n);
        assert (objectArray3.getClass() != Object[].class);
        MethodHandleImpl.fillWithArguments(objectArray3, 0, objectArray2);
        return objectArray3;
    }

    private static void fillWithArguments(Object[] objectArray, int n, Object ... objectArray2) {
        System.arraycopy(objectArray2, 0, objectArray, n, objectArray2.length);
    }

    private static Object[] fillArray(Integer n, Object[] objectArray, Object object) {
        MethodHandleImpl.fillWithArguments(objectArray, n, object);
        return objectArray;
    }

    private static Object[] fillArray(Integer n, Object[] objectArray, Object object, Object object2) {
        MethodHandleImpl.fillWithArguments(objectArray, n, object, object2);
        return objectArray;
    }

    private static Object[] fillArray(Integer n, Object[] objectArray, Object object, Object object2, Object object3) {
        MethodHandleImpl.fillWithArguments(objectArray, n, object, object2, object3);
        return objectArray;
    }

    private static Object[] fillArray(Integer n, Object[] objectArray, Object object, Object object2, Object object3, Object object4) {
        MethodHandleImpl.fillWithArguments(objectArray, n, object, object2, object3, object4);
        return objectArray;
    }

    private static Object[] fillArray(Integer n, Object[] objectArray, Object object, Object object2, Object object3, Object object4, Object object5) {
        MethodHandleImpl.fillWithArguments(objectArray, n, object, object2, object3, object4, object5);
        return objectArray;
    }

    private static Object[] fillArray(Integer n, Object[] objectArray, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        MethodHandleImpl.fillWithArguments(objectArray, n, object, object2, object3, object4, object5, object6);
        return objectArray;
    }

    private static Object[] fillArray(Integer n, Object[] objectArray, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        MethodHandleImpl.fillWithArguments(objectArray, n, object, object2, object3, object4, object5, object6, object7);
        return objectArray;
    }

    private static Object[] fillArray(Integer n, Object[] objectArray, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        MethodHandleImpl.fillWithArguments(objectArray, n, object, object2, object3, object4, object5, object6, object7, object8);
        return objectArray;
    }

    private static Object[] fillArray(Integer n, Object[] objectArray, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        MethodHandleImpl.fillWithArguments(objectArray, n, object, object2, object3, object4, object5, object6, object7, object8, object9);
        return objectArray;
    }

    private static Object[] fillArray(Integer n, Object[] objectArray, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        MethodHandleImpl.fillWithArguments(objectArray, n, object, object2, object3, object4, object5, object6, object7, object8, object9, object10);
        return objectArray;
    }

    private static MethodHandle[] makeFillArrays() {
        MethodHandle methodHandle;
        ArrayList<MethodHandle> arrayList = new ArrayList<MethodHandle>();
        arrayList.add(null);
        while ((methodHandle = MethodHandleImpl.findCollector("fillArray", arrayList.size(), Object[].class, Integer.class, Object[].class)) != null) {
            arrayList.add(methodHandle);
        }
        assert (arrayList.size() == 11);
        return arrayList.toArray(new MethodHandle[0]);
    }

    private static Object copyAsPrimitiveArray(Wrapper wrapper, Object ... objectArray) {
        Object object = wrapper.makeArray(objectArray.length);
        wrapper.copyArrayUnboxing(objectArray, 0, object, 0, objectArray.length);
        return object;
    }

    static MethodHandle varargsArray(int n) {
        MethodHandle methodHandle = Lazy.ARRAYS[n];
        if (methodHandle != null) {
            return methodHandle;
        }
        methodHandle = MethodHandleImpl.findCollector("array", n, Object[].class, new Class[0]);
        if (methodHandle != null) {
            methodHandle = MethodHandleImpl.makeIntrinsic(methodHandle, Intrinsic.NEW_ARRAY);
        }
        if (methodHandle != null) {
            MethodHandle methodHandle2 = methodHandle;
            Lazy.ARRAYS[n] = methodHandle2;
            return methodHandle2;
        }
        methodHandle = MethodHandleImpl.buildVarargsArray(Lazy.MH_fillNewArray, Lazy.MH_arrayIdentity, n);
        assert (MethodHandleImpl.assertCorrectArity(methodHandle, n));
        MethodHandle methodHandle3 = methodHandle = MethodHandleImpl.makeIntrinsic(methodHandle, Intrinsic.NEW_ARRAY);
        Lazy.ARRAYS[n] = methodHandle3;
        return methodHandle3;
    }

    private static boolean assertCorrectArity(MethodHandle methodHandle, int n) {
        assert (methodHandle.type().parameterCount() == n) : "arity != " + n + ": " + methodHandle;
        return true;
    }

    static <T> T[] identity(T[] TArray) {
        return TArray;
    }

    private static MethodHandle buildVarargsArray(MethodHandle methodHandle, MethodHandle methodHandle2, int n) {
        int n2 = Math.min(n, 10);
        int n3 = n - n2;
        MethodHandle methodHandle3 = methodHandle.bindTo(n);
        methodHandle3 = methodHandle3.asCollector(Object[].class, n2);
        MethodHandle methodHandle4 = methodHandle2;
        if (n3 > 0) {
            MethodHandle methodHandle5 = MethodHandleImpl.fillToRight(10 + n3);
            methodHandle4 = methodHandle4 == Lazy.MH_arrayIdentity ? methodHandle5 : MethodHandles.collectArguments(methodHandle4, 0, methodHandle5);
        }
        methodHandle4 = methodHandle4 == Lazy.MH_arrayIdentity ? methodHandle3 : MethodHandles.collectArguments(methodHandle4, 0, methodHandle3);
        return methodHandle4;
    }

    private static MethodHandle fillToRight(int n) {
        MethodHandle methodHandle = FILL_ARRAY_TO_RIGHT[n];
        if (methodHandle != null) {
            return methodHandle;
        }
        methodHandle = MethodHandleImpl.buildFiller(n);
        assert (MethodHandleImpl.assertCorrectArity(methodHandle, n - 10 + 1));
        MethodHandleImpl.FILL_ARRAY_TO_RIGHT[n] = methodHandle;
        return MethodHandleImpl.FILL_ARRAY_TO_RIGHT[n];
    }

    private static MethodHandle buildFiller(int n) {
        if (n <= 10) {
            return Lazy.MH_arrayIdentity;
        }
        int n2 = n % 10;
        int n3 = n - n2;
        if (n2 == 0) {
            n2 = 10;
            n3 = n - 10;
            if (FILL_ARRAY_TO_RIGHT[n3] == null) {
                for (int i = 0; i < n3; i += 10) {
                    if (i <= 10) continue;
                    MethodHandleImpl.fillToRight(i);
                }
            }
        }
        if (n3 < 10) {
            n3 = 10;
            n2 = n - 10;
        }
        assert (n2 > 0);
        MethodHandle methodHandle = MethodHandleImpl.fillToRight(n3);
        MethodHandle methodHandle2 = Lazy.FILL_ARRAYS[n2].bindTo(n3);
        assert (methodHandle.type().parameterCount() == 1 + n3 - 10);
        assert (methodHandle2.type().parameterCount() == 1 + n2);
        if (n3 == 10) {
            return methodHandle2;
        }
        return MethodHandles.collectArguments(methodHandle2, 0, methodHandle);
    }

    static MethodHandle varargsArray(Class<?> clazz, int n) {
        MethodHandle methodHandle;
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 == null) {
            throw new IllegalArgumentException("not an array: " + clazz);
        }
        if (n >= 126) {
            int n2 = n;
            if (n2 <= 254 && clazz2.isPrimitive()) {
                n2 *= Wrapper.forPrimitiveType(clazz2).stackSlots();
            }
            if (n2 > 254) {
                throw new IllegalArgumentException("too many arguments: " + clazz.getSimpleName() + ", length " + n);
            }
        }
        if (clazz2 == Object.class) {
            return MethodHandleImpl.varargsArray(n);
        }
        MethodHandle[] methodHandleArray = TYPED_COLLECTORS.get(clazz2);
        MethodHandle methodHandle2 = methodHandle = n < methodHandleArray.length ? methodHandleArray[n] : null;
        if (methodHandle != null) {
            return methodHandle;
        }
        if (n == 0) {
            Object object = Array.newInstance(clazz.getComponentType(), 0);
            methodHandle = MethodHandles.constant(clazz, object);
        } else if (clazz2.isPrimitive()) {
            MethodHandle methodHandle3 = Lazy.MH_fillNewArray;
            MethodHandle methodHandle4 = MethodHandleImpl.buildArrayProducer(clazz);
            methodHandle = MethodHandleImpl.buildVarargsArray(methodHandle3, methodHandle4, n);
        } else {
            Class<Object[]> clazz3 = clazz.asSubclass(Object[].class);
            T[] TArray = Arrays.copyOf(NO_ARGS_ARRAY, 0, clazz3);
            MethodHandle methodHandle5 = Lazy.MH_fillNewTypedArray.bindTo(TArray);
            MethodHandle methodHandle6 = Lazy.MH_arrayIdentity;
            methodHandle = MethodHandleImpl.buildVarargsArray(methodHandle5, methodHandle6, n);
        }
        methodHandle = methodHandle.asType(MethodType.methodType(clazz, Collections.nCopies(n, clazz2)));
        methodHandle = MethodHandleImpl.makeIntrinsic(methodHandle, Intrinsic.NEW_ARRAY);
        assert (MethodHandleImpl.assertCorrectArity(methodHandle, n));
        if (n < methodHandleArray.length) {
            methodHandleArray[n] = methodHandle;
        }
        return methodHandle;
    }

    private static MethodHandle buildArrayProducer(Class<?> clazz) {
        Class<?> clazz2 = clazz.getComponentType();
        assert (clazz2.isPrimitive());
        return Lazy.MH_copyAsPrimitiveArray.bindTo((Object)Wrapper.forPrimitiveType(clazz2));
    }

    static void assertSame(Object object, Object object2) {
        if (object != object2) {
            String string = String.format("mh1 != mh2: mh1 = %s (form: %s); mh2 = %s (form: %s)", object, ((MethodHandle)object).form, object2, ((MethodHandle)object2).form);
            throw MethodHandleStatics.newInternalError(string);
        }
    }

    static /* synthetic */ MethodHandle[] access$000() {
        return MethodHandleImpl.makeArrays();
    }

    static /* synthetic */ MethodHandle[] access$100() {
        return MethodHandleImpl.makeFillArrays();
    }

    static {
        final Object[] objectArray = new Object[]{255};
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                objectArray[0] = Integer.getInteger(MethodHandleImpl.class.getName() + ".MAX_ARITY", 255);
                return null;
            }
        });
        MAX_ARITY = (Integer)objectArray[0];
        PRODUCE_BLOCK_INLINING_FORM = new Function<MethodHandle, LambdaForm>(){

            @Override
            public LambdaForm apply(MethodHandle methodHandle) {
                return DelegatingMethodHandle.makeReinvokerForm(methodHandle, 9, CountingWrapper.class, "reinvoker.dontInline", false, DelegatingMethodHandle.NF_getTarget, CountingWrapper.NF_maybeStopCounting);
            }
        };
        PRODUCE_REINVOKER_FORM = new Function<MethodHandle, LambdaForm>(){

            @Override
            public LambdaForm apply(MethodHandle methodHandle) {
                return DelegatingMethodHandle.makeReinvokerForm(methodHandle, 8, DelegatingMethodHandle.class, DelegatingMethodHandle.NF_getTarget);
            }
        };
        FAKE_METHOD_HANDLE_INVOKE = new MethodHandle[2];
        NO_ARGS_ARRAY = new Object[0];
        FILL_ARRAY_TO_RIGHT = new MethodHandle[MAX_ARITY + 1];
        TYPED_COLLECTORS = new ClassValue<MethodHandle[]>(){

            @Override
            protected MethodHandle[] computeValue(Class<?> clazz) {
                return new MethodHandle[256];
            }
        };
    }

    static final class ArrayAccessor {
        static final int GETTER_INDEX = 0;
        static final int SETTER_INDEX = 1;
        static final int LENGTH_INDEX = 2;
        static final int INDEX_LIMIT = 3;
        static final ClassValue<MethodHandle[]> TYPED_ACCESSORS = new ClassValue<MethodHandle[]>(){

            @Override
            protected MethodHandle[] computeValue(Class<?> type) {
                return new MethodHandle[3];
            }
        };
        static final MethodHandle OBJECT_ARRAY_GETTER;
        static final MethodHandle OBJECT_ARRAY_SETTER;
        static final MethodHandle OBJECT_ARRAY_LENGTH;

        ArrayAccessor() {
        }

        static int getElementI(int[] a, int i) {
            return a[i];
        }

        static long getElementJ(long[] a, int i) {
            return a[i];
        }

        static float getElementF(float[] a, int i) {
            return a[i];
        }

        static double getElementD(double[] a, int i) {
            return a[i];
        }

        static boolean getElementZ(boolean[] a, int i) {
            return a[i];
        }

        static byte getElementB(byte[] a, int i) {
            return a[i];
        }

        static short getElementS(short[] a, int i) {
            return a[i];
        }

        static char getElementC(char[] a, int i) {
            return a[i];
        }

        static Object getElementL(Object[] a, int i) {
            return a[i];
        }

        static void setElementI(int[] a, int i, int x) {
            a[i] = x;
        }

        static void setElementJ(long[] a, int i, long x) {
            a[i] = x;
        }

        static void setElementF(float[] a, int i, float x) {
            a[i] = x;
        }

        static void setElementD(double[] a, int i, double x) {
            a[i] = x;
        }

        static void setElementZ(boolean[] a, int i, boolean x) {
            a[i] = x;
        }

        static void setElementB(byte[] a, int i, byte x) {
            a[i] = x;
        }

        static void setElementS(short[] a, int i, short x) {
            a[i] = x;
        }

        static void setElementC(char[] a, int i, char x) {
            a[i] = x;
        }

        static void setElementL(Object[] a, int i, Object x) {
            a[i] = x;
        }

        static int lengthI(int[] a) {
            return a.length;
        }

        static int lengthJ(long[] a) {
            return a.length;
        }

        static int lengthF(float[] a) {
            return a.length;
        }

        static int lengthD(double[] a) {
            return a.length;
        }

        static int lengthZ(boolean[] a) {
            return a.length;
        }

        static int lengthB(byte[] a) {
            return a.length;
        }

        static int lengthS(short[] a) {
            return a.length;
        }

        static int lengthC(char[] a) {
            return a.length;
        }

        static int lengthL(Object[] a) {
            return a.length;
        }

        static String name(Class<?> arrayClass, ArrayAccess access) {
            Class<?> elemClass = arrayClass.getComponentType();
            if (elemClass == null) {
                throw MethodHandleStatics.newIllegalArgumentException("not an array", arrayClass);
            }
            return ArrayAccess.opName(access) + Wrapper.basicTypeChar(elemClass);
        }

        static MethodType type(Class<?> arrayClass, ArrayAccess access) {
            Class<Object> elemClass = arrayClass.getComponentType();
            Class<Object> arrayArgClass = arrayClass;
            if (!elemClass.isPrimitive()) {
                arrayArgClass = Object[].class;
                elemClass = Object.class;
            }
            return switch (access.ordinal()) {
                case 0 -> MethodType.methodType(elemClass, arrayArgClass, Integer.TYPE);
                case 1 -> MethodType.methodType(Void.TYPE, arrayArgClass, Integer.TYPE, elemClass);
                case 2 -> MethodType.methodType(Integer.TYPE, arrayArgClass);
                default -> throw MethodHandleImpl.unmatchedArrayAccess((ArrayAccess)access);
            };
        }

        static MethodType correctType(Class<?> arrayClass, ArrayAccess access) {
            Class<?> elemClass = arrayClass.getComponentType();
            return switch (access.ordinal()) {
                case 0 -> MethodType.methodType(elemClass, arrayClass, Integer.TYPE);
                case 1 -> MethodType.methodType(Void.TYPE, arrayClass, Integer.TYPE, elemClass);
                case 2 -> MethodType.methodType(Integer.TYPE, arrayClass);
                default -> throw MethodHandleImpl.unmatchedArrayAccess((ArrayAccess)access);
            };
        }

        static MethodHandle getAccessor(Class<?> arrayClass, ArrayAccess access) {
            String name = ArrayAccessor.name(arrayClass, access);
            MethodType type = ArrayAccessor.type(arrayClass, access);
            try {
                return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(ArrayAccessor.class, name, type);
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }

        static {
            MethodHandle[] cache = TYPED_ACCESSORS.get(Object[].class);
            cache[0] = OBJECT_ARRAY_GETTER = MethodHandleImpl.makeIntrinsic(ArrayAccessor.getAccessor(Object[].class, ArrayAccess.GET), Intrinsic.ARRAY_LOAD);
            cache[1] = OBJECT_ARRAY_SETTER = MethodHandleImpl.makeIntrinsic(ArrayAccessor.getAccessor(Object[].class, ArrayAccess.SET), Intrinsic.ARRAY_STORE);
            cache[2] = OBJECT_ARRAY_LENGTH = MethodHandleImpl.makeIntrinsic(ArrayAccessor.getAccessor(Object[].class, ArrayAccess.LENGTH), Intrinsic.ARRAY_LENGTH);
            assert (InvokerBytecodeGenerator.isStaticallyInvocable(OBJECT_ARRAY_GETTER.internalMemberName()));
            assert (InvokerBytecodeGenerator.isStaticallyInvocable(OBJECT_ARRAY_SETTER.internalMemberName()));
            assert (InvokerBytecodeGenerator.isStaticallyInvocable(OBJECT_ARRAY_LENGTH.internalMemberName()));
        }
    }

    private static final class AsVarargsCollector
    extends DelegatingMethodHandle {
        private final MethodHandle target;
        private final Class<?> arrayType;
        @Stable
        private MethodHandle asCollectorCache;

        AsVarargsCollector(MethodHandle methodHandle, Class<?> clazz) {
            this(methodHandle.type(), methodHandle, clazz);
        }

        AsVarargsCollector(MethodType methodType, MethodHandle methodHandle, Class<?> clazz) {
            super(methodType, methodHandle);
            this.target = methodHandle;
            this.arrayType = clazz;
            this.asCollectorCache = methodHandle.asCollector(clazz, 0);
        }

        @Override
        public boolean isVarargsCollector() {
            return true;
        }

        @Override
        protected MethodHandle getTarget() {
            return this.target;
        }

        @Override
        public MethodHandle asFixedArity() {
            return this.target;
        }

        @Override
        MethodHandle setVarargs(MemberName memberName) {
            if (memberName.isVarargs()) {
                return this;
            }
            return this.asFixedArity();
        }

        @Override
        public MethodHandle asTypeUncached(MethodType methodType) {
            MethodHandle methodHandle;
            MethodType methodType2 = this.type();
            int n = methodType2.parameterCount() - 1;
            int n2 = methodType.parameterCount();
            if (n2 == n + 1 && methodType2.parameterType(n).isAssignableFrom(methodType.parameterType(n))) {
                this.asTypeCache = this.asFixedArity().asType(methodType);
                return this.asTypeCache;
            }
            MethodHandle methodHandle2 = this.asCollectorCache;
            if (methodHandle2 != null && methodHandle2.type().parameterCount() == n2) {
                this.asTypeCache = methodHandle2.asType(methodType);
                return this.asTypeCache;
            }
            int n3 = n2 - n;
            try {
                methodHandle = this.asFixedArity().asCollector(this.arrayType, n3);
                assert (methodHandle.type().parameterCount() == n2) : "newArity=" + n2 + " but collector=" + methodHandle;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new WrongMethodTypeException("cannot build collector", illegalArgumentException);
            }
            this.asCollectorCache = methodHandle;
            this.asTypeCache = methodHandle.asType(methodType);
            return this.asTypeCache;
        }

        @Override
        boolean viewAsTypeChecks(MethodType methodType, boolean bl) {
            super.viewAsTypeChecks(methodType, true);
            if (bl) {
                return true;
            }
            assert (this.type().lastParameterType().getComponentType().isAssignableFrom(methodType.lastParameterType().getComponentType())) : Arrays.asList(this, methodType);
            return true;
        }
    }

    private static class BindCaller {
        private static MethodType INVOKER_MT = MethodType.methodType(Object.class, MethodHandle.class, Object[].class);
        private static MethodType REFLECT_INVOKER_MT = MethodType.methodType(Object.class, MethodHandle.class, Object.class, Object[].class);
        private static ClassValue<InjectedInvokerHolder> CV_makeInjectedInvoker = new ClassValue<InjectedInvokerHolder>(){

            @Override
            protected InjectedInvokerHolder computeValue(Class<?> hostClass) {
                return new InjectedInvokerHolder(BindCaller.makeInjectedInvoker(hostClass));
            }
        };
        private static final MethodHandle MH_checkCallerClass;
        private static final byte[] INJECTED_INVOKER_TEMPLATE;

        private BindCaller() {
        }

        static MethodHandle bindCaller(MethodHandle mh, Class<?> hostClass) {
            MemberName csmAdapter;
            if (hostClass == null || hostClass.isArray() || hostClass.isPrimitive() || hostClass.getName().startsWith("java.lang.invoke.")) {
                throw new InternalError();
            }
            MemberName member = mh.internalMemberName();
            if (member != null && (csmAdapter = MethodHandles.Lookup.IMPL_LOOKUP.resolveOrNull(member.getReferenceKind(), new MemberName(member.getDeclaringClass(), member.getName(), member.getMethodType().appendParameterTypes(Class.class), member.getReferenceKind()))) != null) {
                assert (!csmAdapter.isCallerSensitive());
                MethodHandle dmh = DirectMethodHandle.make(csmAdapter);
                dmh = MethodHandles.insertArguments(dmh, dmh.type().parameterCount() - 1, hostClass);
                dmh = new WrappedMember(dmh, mh.type(), member, mh.isInvokeSpecial(), hostClass);
                return dmh;
            }
            try {
                return BindCaller.bindCallerWithInjectedInvoker(mh, hostClass);
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }

        private static MethodHandle bindCallerWithInjectedInvoker(MethodHandle mh, Class<?> hostClass) throws ReflectiveOperationException {
            MethodHandle vamh = BindCaller.prepareForInvoker(mh);
            MethodHandle bccInvoker = CV_makeInjectedInvoker.get(hostClass).invoker();
            return BindCaller.restoreToType(bccInvoker.bindTo(vamh), mh, hostClass);
        }

        private static Class<?> makeInjectedInvoker(Class<?> targetClass) {
            String name = targetClass.getName() + "$$InjectedInvoker";
            if (targetClass.isHidden()) {
                name = name.replace('/', '_');
            }
            name = name.replace('.', '/');
            Class<?> invokerClass = new MethodHandles.Lookup(targetClass).makeHiddenClassDefiner(name, INJECTED_INVOKER_TEMPLATE, Set.of((Object)((Object)MethodHandles.Lookup.ClassOption.NESTMATE)), MethodHandleStatics.dumper()).defineClass(true, targetClass);
            assert (BindCaller.checkInjectedInvoker(targetClass, invokerClass));
            return invokerClass;
        }

        static MethodHandle reflectiveInvoker(Class<?> caller) {
            return CV_makeInjectedInvoker.get(caller).reflectInvoker();
        }

        private static MethodHandle prepareForInvoker(MethodHandle mh) {
            mh = mh.asFixedArity();
            MethodType mt = mh.type();
            int arity = mt.parameterCount();
            MethodHandle vamh = mh.asType(mt.generic());
            vamh.internalForm().compileToBytecode();
            vamh = vamh.asSpreader(Object[].class, arity);
            vamh.internalForm().compileToBytecode();
            return vamh;
        }

        private static MethodHandle restoreToType(MethodHandle vamh, MethodHandle original, Class<?> hostClass) {
            MethodType type = original.type();
            MethodHandle mh = vamh.asCollector(Object[].class, type.parameterCount());
            MemberName member = original.internalMemberName();
            mh = mh.asType(type);
            mh = new WrappedMember(mh, type, member, original.isInvokeSpecial(), hostClass);
            return mh;
        }

        private static boolean checkInjectedInvoker(Class<?> hostClass, Class<?> invokerClass) {
            assert (hostClass.getClassLoader() == invokerClass.getClassLoader()) : hostClass.getName() + " (CL)";
            try {
                assert (hostClass.getProtectionDomain() == invokerClass.getProtectionDomain()) : hostClass.getName() + " (PD)";
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                MethodHandle invoker = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(invokerClass, "invoke_V", INVOKER_MT);
                MethodHandle vamh = BindCaller.prepareForInvoker(MH_checkCallerClass);
                return invoker.invoke(vamh, new Object[]{invokerClass});
            }
            catch (Error | RuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new InternalError(ex);
            }
        }

        @CallerSensitive
        @jdk.internal.vm.annotation.ForceInline
        private static boolean checkCallerClass(Class<?> expected) {
            Class<?> actual = Reflection.getCallerClass();
            if (actual != expected) {
                throw new InternalError("found " + actual.getName() + ", expected " + expected.getName());
            }
            return true;
        }

        private static byte[] generateInvokerTemplate() {
            ClassWriter cw = new ClassWriter(0);
            cw.visit(MethodHandleStatics.CLASSFILE_VERSION, 34, "InjectedInvoker", null, "java/lang/Object", null);
            MethodVisitor mv = cw.visitMethod(8, "invoke_V", "(Ljava/lang/invoke/MethodHandle;[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "java/lang/invoke/MethodHandle", "invokeExact", "([Ljava/lang/Object;)Ljava/lang/Object;", false);
            mv.visitInsn(176);
            mv.visitMaxs(2, 2);
            mv.visitEnd();
            cw.visitEnd();
            mv = cw.visitMethod(8, "reflect_invoke_V", "(Ljava/lang/invoke/MethodHandle;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(182, "java/lang/invoke/MethodHandle", "invokeExact", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", false);
            mv.visitInsn(176);
            mv.visitMaxs(3, 3);
            mv.visitEnd();
            return cw.toByteArray();
        }

        static {
            Class<BindCaller> THIS_CLASS = BindCaller.class;
            assert (BindCaller.checkCallerClass(THIS_CLASS));
            try {
                MH_checkCallerClass = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(THIS_CLASS, "checkCallerClass", MethodType.methodType(Boolean.TYPE, Class.class));
                assert (MH_checkCallerClass.invokeExact(THIS_CLASS));
            }
            catch (Throwable ex) {
                throw new InternalError(ex);
            }
            INJECTED_INVOKER_TEMPLATE = BindCaller.generateInvokerTemplate();
        }

        private static final class InjectedInvokerHolder {
            private final Class<?> invokerClass;
            private MethodHandle invoker;
            private MethodHandle reflectInvoker;

            private InjectedInvokerHolder(Class<?> invokerClass) {
                this.invokerClass = invokerClass;
            }

            private MethodHandle invoker() {
                MethodHandle mh = this.invoker;
                if (mh == null) {
                    try {
                        this.invoker = mh = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(this.invokerClass, "invoke_V", INVOKER_MT);
                    }
                    catch (Error | RuntimeException ex) {
                        throw ex;
                    }
                    catch (Throwable ex) {
                        throw new InternalError(ex);
                    }
                }
                return mh;
            }

            private MethodHandle reflectInvoker() {
                MethodHandle mh = this.reflectInvoker;
                if (mh == null) {
                    try {
                        this.reflectInvoker = mh = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(this.invokerClass, "reflect_invoke_V", REFLECT_INVOKER_MT);
                    }
                    catch (Error | RuntimeException ex) {
                        throw ex;
                    }
                    catch (Throwable ex) {
                        throw new InternalError(ex);
                    }
                }
                return mh;
            }
        }
    }

    static final class CountingWrapper
    extends DelegatingMethodHandle {
        private final MethodHandle target;
        private int count;
        private Function<MethodHandle, LambdaForm> countingFormProducer;
        private Function<MethodHandle, LambdaForm> nonCountingFormProducer;
        private volatile boolean isCounting;
        static final LambdaForm.NamedFunction NF_maybeStopCounting;

        private CountingWrapper(MethodHandle target, LambdaForm lform, Function<MethodHandle, LambdaForm> countingFromProducer, Function<MethodHandle, LambdaForm> nonCountingFormProducer, int count) {
            super(target.type(), lform);
            this.target = target;
            this.count = count;
            this.countingFormProducer = countingFromProducer;
            this.nonCountingFormProducer = nonCountingFormProducer;
            this.isCounting = count > 0;
        }

        @Override
        @Hidden
        protected MethodHandle getTarget() {
            return this.target;
        }

        @Override
        public MethodHandle asTypeUncached(MethodType newType) {
            MethodHandle wrapper;
            MethodHandle newTarget = this.target.asType(newType);
            if (this.isCounting) {
                LambdaForm lform = this.countingFormProducer.apply(newTarget);
                wrapper = new CountingWrapper(newTarget, lform, this.countingFormProducer, this.nonCountingFormProducer, MethodHandleStatics.DONT_INLINE_THRESHOLD);
            } else {
                wrapper = newTarget;
            }
            return wrapper;
        }

        boolean countDown() {
            int c = this.count;
            this.target.maybeCustomize();
            if (c <= 1) {
                if (this.isCounting) {
                    this.isCounting = false;
                    return true;
                }
                return false;
            }
            this.count = c - 1;
            return false;
        }

        @Hidden
        static void maybeStopCounting(Object o1) {
            final CountingWrapper wrapper = (CountingWrapper)o1;
            if (wrapper.countDown()) {
                wrapper.updateForm(new Function<LambdaForm, LambdaForm>(){

                    @Override
                    public LambdaForm apply(LambdaForm oldForm) {
                        LambdaForm lform = wrapper.nonCountingFormProducer.apply(wrapper.target);
                        lform.compileToBytecode();
                        return lform;
                    }
                });
            }
        }

        static {
            Class<CountingWrapper> THIS_CLASS = CountingWrapper.class;
            try {
                NF_maybeStopCounting = new LambdaForm.NamedFunction(THIS_CLASS.getDeclaredMethod("maybeStopCounting", Object.class));
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.newInternalError((Exception)ex);
            }
        }
    }

    static enum Intrinsic {
        SELECT_ALTERNATIVE,
        GUARD_WITH_CATCH,
        NEW_ARRAY,
        ARRAY_LOAD,
        ARRAY_STORE,
        IDENTITY,
        ZERO,
        NONE;

    }

    private static final class IntrinsicMethodHandle
    extends DelegatingMethodHandle {
        private final MethodHandle target;
        private final Intrinsic intrinsicName;

        IntrinsicMethodHandle(MethodHandle methodHandle, Intrinsic intrinsic) {
            super(methodHandle.type(), methodHandle);
            this.target = methodHandle;
            this.intrinsicName = intrinsic;
        }

        @Override
        protected MethodHandle getTarget() {
            return this.target;
        }

        @Override
        Intrinsic intrinsicName() {
            return this.intrinsicName;
        }

        @Override
        public MethodHandle asTypeUncached(MethodType methodType) {
            this.asTypeCache = this.target.asType(methodType);
            return this.asTypeCache;
        }

        @Override
        String internalProperties() {
            return super.internalProperties() + "\n& Intrinsic=" + (Object)((Object)this.intrinsicName);
        }

        @Override
        public MethodHandle asCollector(Class<?> clazz, int n) {
            if (this.intrinsicName == Intrinsic.IDENTITY) {
                MethodType methodType = this.type().asCollectorType(clazz, n);
                MethodHandle methodHandle = MethodHandleImpl.varargsArray(clazz, n);
                return methodHandle.asType(methodType);
            }
            return super.asCollector(clazz, n);
        }
    }

    static class Lazy {
        private static final Class<?> MHI = MethodHandleImpl.class;
        private static final MethodHandle[] ARRAYS = MethodHandleImpl.access$000();
        private static final MethodHandle[] FILL_ARRAYS = MethodHandleImpl.access$100();
        static final LambdaForm.NamedFunction NF_checkSpreadArgument;
        static final LambdaForm.NamedFunction NF_guardWithCatch;
        static final LambdaForm.NamedFunction NF_throwException;
        static final LambdaForm.NamedFunction NF_profileBoolean;
        static final MethodHandle MH_castReference;
        static final MethodHandle MH_selectAlternative;
        static final MethodHandle MH_copyAsPrimitiveArray;
        static final MethodHandle MH_fillNewTypedArray;
        static final MethodHandle MH_fillNewArray;
        static final MethodHandle MH_arrayIdentity;

        Lazy() {
        }

        static {
            try {
                NF_checkSpreadArgument = new LambdaForm.NamedFunction(MHI.getDeclaredMethod("checkSpreadArgument", Object.class, Integer.TYPE));
                NF_guardWithCatch = new LambdaForm.NamedFunction(MHI.getDeclaredMethod("guardWithCatch", MethodHandle.class, Class.class, MethodHandle.class, Object[].class));
                NF_throwException = new LambdaForm.NamedFunction(MHI.getDeclaredMethod("throwException", Throwable.class));
                NF_profileBoolean = new LambdaForm.NamedFunction(MHI.getDeclaredMethod("profileBoolean", Boolean.TYPE, int[].class));
                NF_checkSpreadArgument.resolve();
                NF_guardWithCatch.resolve();
                NF_throwException.resolve();
                NF_profileBoolean.resolve();
                MH_castReference = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MHI, "castReference", MethodType.methodType(Object.class, Class.class, Object.class));
                MH_copyAsPrimitiveArray = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MHI, "copyAsPrimitiveArray", MethodType.methodType(Object.class, Wrapper.class, Object[].class));
                MH_arrayIdentity = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MHI, "identity", MethodType.methodType(Object[].class, Object[].class));
                MH_fillNewArray = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MHI, "fillNewArray", MethodType.methodType(Object[].class, Integer.class, Object[].class));
                MH_fillNewTypedArray = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MHI, "fillNewTypedArray", MethodType.methodType(Object[].class, Object[].class, Integer.class, Object[].class));
                MH_selectAlternative = MethodHandleImpl.makeIntrinsic(MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MHI, "selectAlternative", MethodType.methodType(MethodHandle.class, Boolean.TYPE, MethodHandle.class, MethodHandle.class)), Intrinsic.SELECT_ALTERNATIVE);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw MethodHandleStatics.newInternalError(reflectiveOperationException);
            }
        }
    }

    static final class WrappedMember
    extends DelegatingMethodHandle {
        private final MethodHandle target;
        private final MemberName member;
        private final Class<?> callerClass;
        private final boolean isInvokeSpecial;

        private WrappedMember(MethodHandle target, MethodType type, MemberName member, boolean isInvokeSpecial, Class<?> callerClass) {
            super(type, target);
            this.target = target;
            this.member = member;
            this.callerClass = callerClass;
            this.isInvokeSpecial = isInvokeSpecial;
        }

        @Override
        MemberName internalMemberName() {
            return this.member;
        }

        @Override
        Class<?> internalCallerClass() {
            return this.callerClass;
        }

        @Override
        boolean isInvokeSpecial() {
            return this.isInvokeSpecial;
        }

        @Override
        protected MethodHandle getTarget() {
            return this.target;
        }

        @Override
        public MethodHandle asTypeUncached(MethodType newType) {
            return this.target.asType(newType);
        }
    }
}

