/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.ByteBandedRaster;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.image.BytePackedRaster;
import sun.awt.image.IntegerInterleavedRaster;
import sun.awt.image.ShortBandedRaster;
import sun.awt.image.ShortInterleavedRaster;
import sun.awt.image.SunWritableRaster;

public class Raster {
    protected SampleModel sampleModel;
    protected DataBuffer dataBuffer;
    protected int minX;
    protected int minY;
    protected int width;
    protected int height;
    protected int sampleModelTranslateX;
    protected int sampleModelTranslateY;
    protected int numBands;
    protected int numDataElements;
    protected Raster parent;

    private static native void initIDs();

    public static WritableRaster createInterleavedRaster(int n, int n2, int n3, int n4, Point point) {
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = i;
        }
        return Raster.createInterleavedRaster(n, n2, n3, n2 * n4, n4, nArray, point);
    }

    public static WritableRaster createInterleavedRaster(int n, int n2, int n3, int n4, int n5, int[] nArray, Point point) {
        DataBuffer dataBuffer;
        int n6 = n4 * (n3 - 1) + n5 * n2;
        switch (n) {
            case 0: {
                dataBuffer = new DataBufferByte(n6);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n6);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type " + n);
            }
        }
        return Raster.createInterleavedRaster(dataBuffer, n2, n3, n4, n5, nArray, point);
    }

    public static WritableRaster createBandedRaster(int n, int n2, int n3, int n4, Point point) {
        if (n4 < 1) {
            throw new ArrayIndexOutOfBoundsException("Number of bands (" + n4 + ") must" + " be greater than 0");
        }
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = i;
            nArray2[i] = 0;
        }
        return Raster.createBandedRaster(n, n2, n3, n2, nArray, nArray2, point);
    }

    public static WritableRaster createBandedRaster(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, Point point) {
        DataBuffer dataBuffer;
        int n5;
        int n6 = nArray2.length;
        if (nArray == null) {
            throw new ArrayIndexOutOfBoundsException("Bank indices array is null");
        }
        if (nArray2 == null) {
            throw new ArrayIndexOutOfBoundsException("Band offsets array is null");
        }
        int n7 = nArray[0];
        int n8 = nArray2[0];
        for (n5 = 1; n5 < n6; ++n5) {
            if (nArray[n5] > n7) {
                n7 = nArray[n5];
            }
            if (nArray2[n5] <= n8) continue;
            n8 = nArray2[n5];
        }
        n5 = n7 + 1;
        int n9 = n8 + n4 * (n3 - 1) + n2;
        switch (n) {
            case 0: {
                dataBuffer = new DataBufferByte(n9, n5);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n9, n5);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n9, n5);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type " + n);
            }
        }
        return Raster.createBandedRaster(dataBuffer, n2, n3, n4, nArray, nArray2, point);
    }

    public static WritableRaster createPackedRaster(int n, int n2, int n3, int[] nArray, Point point) {
        DataBuffer dataBuffer;
        switch (n) {
            case 0: {
                dataBuffer = new DataBufferByte(n2 * n3);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n2 * n3);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n2 * n3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type " + n);
            }
        }
        return Raster.createPackedRaster(dataBuffer, n2, n3, n2, nArray, point);
    }

    public static WritableRaster createPackedRaster(int n, int n2, int n3, int n4, int n5, Point point) {
        DataBuffer dataBuffer;
        if (n4 <= 0) {
            throw new IllegalArgumentException("Number of bands (" + n4 + ") must be greater than 0");
        }
        if (n5 <= 0) {
            throw new IllegalArgumentException("Bits per band (" + n5 + ") must be greater than 0");
        }
        if (n4 != 1) {
            int[] nArray = new int[n4];
            int n6 = (1 << n5) - 1;
            int n7 = (n4 - 1) * n5;
            if (n7 + n5 > DataBuffer.getDataTypeSize(n)) {
                throw new IllegalArgumentException("bitsPerBand(" + n5 + ") * bands is " + " greater than data type " + "size.");
            }
            switch (n) {
                case 0: 
                case 1: 
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported data type " + n);
                }
            }
            for (int i = 0; i < n4; ++i) {
                nArray[i] = n6 << n7;
                n7 -= n5;
            }
            return Raster.createPackedRaster(n, n2, n3, nArray, point);
        }
        double d = n2;
        switch (n) {
            case 0: {
                dataBuffer = new DataBufferByte((int)Math.ceil(d / (double)(8 / n5)) * n3);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort((int)Math.ceil(d / (double)(16 / n5)) * n3);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt((int)Math.ceil(d / (double)(32 / n5)) * n3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type " + n);
            }
        }
        return Raster.createPackedRaster(dataBuffer, n2, n3, n5, point);
    }

    public static WritableRaster createInterleavedRaster(DataBuffer dataBuffer, int n, int n2, int n3, int n4, int[] nArray, Point point) {
        if (dataBuffer == null) {
            throw new NullPointerException("DataBuffer cannot be null");
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        int n5 = dataBuffer.getDataType();
        PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(n5, n, n2, n4, n3, nArray);
        switch (n5) {
            case 0: {
                return new ByteInterleavedRaster(pixelInterleavedSampleModel, dataBuffer, point);
            }
            case 1: {
                return new ShortInterleavedRaster(pixelInterleavedSampleModel, dataBuffer, point);
            }
        }
        throw new IllegalArgumentException("Unsupported data type " + n5);
    }

    public static WritableRaster createBandedRaster(DataBuffer dataBuffer, int n, int n2, int n3, int[] nArray, int[] nArray2, Point point) {
        if (dataBuffer == null) {
            throw new NullPointerException("DataBuffer cannot be null");
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        int n4 = dataBuffer.getDataType();
        int n5 = nArray.length;
        if (nArray2.length != n5) {
            throw new IllegalArgumentException("bankIndices.length != bandOffsets.length");
        }
        BandedSampleModel bandedSampleModel = new BandedSampleModel(n4, n, n2, n3, nArray, nArray2);
        switch (n4) {
            case 0: {
                return new ByteBandedRaster((SampleModel)bandedSampleModel, dataBuffer, point);
            }
            case 1: {
                return new ShortBandedRaster((SampleModel)bandedSampleModel, dataBuffer, point);
            }
            case 3: {
                return new SunWritableRaster(bandedSampleModel, dataBuffer, point);
            }
        }
        throw new IllegalArgumentException("Unsupported data type " + n4);
    }

    public static WritableRaster createPackedRaster(DataBuffer dataBuffer, int n, int n2, int n3, int[] nArray, Point point) {
        if (dataBuffer == null) {
            throw new NullPointerException("DataBuffer cannot be null");
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        int n4 = dataBuffer.getDataType();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(n4, n, n2, n3, nArray);
        switch (n4) {
            case 0: {
                return new ByteInterleavedRaster(singlePixelPackedSampleModel, dataBuffer, point);
            }
            case 1: {
                return new ShortInterleavedRaster(singlePixelPackedSampleModel, dataBuffer, point);
            }
            case 3: {
                return new IntegerInterleavedRaster(singlePixelPackedSampleModel, dataBuffer, point);
            }
        }
        throw new IllegalArgumentException("Unsupported data type " + n4);
    }

    public static WritableRaster createPackedRaster(DataBuffer dataBuffer, int n, int n2, int n3, Point point) {
        int n4;
        if (dataBuffer == null) {
            throw new NullPointerException("DataBuffer cannot be null");
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        if ((n4 = dataBuffer.getDataType()) != 0 && n4 != 1 && n4 != 3) {
            throw new IllegalArgumentException("Unsupported data type " + n4);
        }
        if (dataBuffer.getNumBanks() != 1) {
            throw new RasterFormatException("DataBuffer for packed Rasters must only have 1 bank.");
        }
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(n4, n, n2, n3);
        if (n4 == 0 && (n3 == 1 || n3 == 2 || n3 == 4)) {
            return new BytePackedRaster(multiPixelPackedSampleModel, dataBuffer, point);
        }
        return new SunWritableRaster(multiPixelPackedSampleModel, dataBuffer, point);
    }

    public static Raster createRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        if (sampleModel == null || dataBuffer == null) {
            throw new NullPointerException("SampleModel and DataBuffer cannot be null");
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        int n = sampleModel.getDataType();
        if (sampleModel instanceof PixelInterleavedSampleModel) {
            switch (n) {
                case 0: {
                    return new ByteInterleavedRaster(sampleModel, dataBuffer, point);
                }
                case 1: {
                    return new ShortInterleavedRaster(sampleModel, dataBuffer, point);
                }
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            switch (n) {
                case 0: {
                    return new ByteInterleavedRaster(sampleModel, dataBuffer, point);
                }
                case 1: {
                    return new ShortInterleavedRaster(sampleModel, dataBuffer, point);
                }
                case 3: {
                    return new IntegerInterleavedRaster(sampleModel, dataBuffer, point);
                }
            }
        } else if (sampleModel instanceof MultiPixelPackedSampleModel && n == 0 && sampleModel.getSampleSize(0) < 8) {
            return new BytePackedRaster(sampleModel, dataBuffer, point);
        }
        return new Raster(sampleModel, dataBuffer, point);
    }

    public static WritableRaster createWritableRaster(SampleModel sampleModel, Point point) {
        if (point == null) {
            point = new Point(0, 0);
        }
        return Raster.createWritableRaster(sampleModel, sampleModel.createDataBuffer(), point);
    }

    public static WritableRaster createWritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        if (sampleModel == null || dataBuffer == null) {
            throw new NullPointerException("SampleModel and DataBuffer cannot be null");
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        int n = sampleModel.getDataType();
        if (sampleModel instanceof PixelInterleavedSampleModel) {
            switch (n) {
                case 0: {
                    return new ByteInterleavedRaster(sampleModel, dataBuffer, point);
                }
                case 1: {
                    return new ShortInterleavedRaster(sampleModel, dataBuffer, point);
                }
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            switch (n) {
                case 0: {
                    return new ByteInterleavedRaster(sampleModel, dataBuffer, point);
                }
                case 1: {
                    return new ShortInterleavedRaster(sampleModel, dataBuffer, point);
                }
                case 3: {
                    return new IntegerInterleavedRaster(sampleModel, dataBuffer, point);
                }
            }
        } else if (sampleModel instanceof MultiPixelPackedSampleModel && n == 0 && sampleModel.getSampleSize(0) < 8) {
            return new BytePackedRaster(sampleModel, dataBuffer, point);
        }
        return new SunWritableRaster(sampleModel, dataBuffer, point);
    }

    protected Raster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    protected Raster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    protected Raster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, Raster raster) {
        if (sampleModel == null || dataBuffer == null || rectangle == null || point == null) {
            throw new NullPointerException("SampleModel, dataBuffer, aRegion and sampleModelTranslate cannot be null");
        }
        this.sampleModel = sampleModel;
        this.dataBuffer = dataBuffer;
        this.minX = rectangle.x;
        this.minY = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
        if (this.width <= 0 || this.height <= 0) {
            throw new RasterFormatException("negative or zero " + (this.width <= 0 ? "width" : "height"));
        }
        if (this.minX + this.width < this.minX) {
            throw new RasterFormatException("overflow condition for X coordinates of Raster");
        }
        if (this.minY + this.height < this.minY) {
            throw new RasterFormatException("overflow condition for Y coordinates of Raster");
        }
        this.sampleModelTranslateX = point.x;
        this.sampleModelTranslateY = point.y;
        this.numBands = sampleModel.getNumBands();
        this.numDataElements = sampleModel.getNumDataElements();
        this.parent = raster;
    }

    public Raster getParent() {
        return this.parent;
    }

    public final int getSampleModelTranslateX() {
        return this.sampleModelTranslateX;
    }

    public final int getSampleModelTranslateY() {
        return this.sampleModelTranslateY;
    }

    public WritableRaster createCompatibleWritableRaster() {
        return new SunWritableRaster(this.sampleModel, new Point(0, 0));
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new RasterFormatException("negative " + (n <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n, n2);
        return new SunWritableRaster(sampleModel, new Point(0, 0));
    }

    public WritableRaster createCompatibleWritableRaster(Rectangle rectangle) {
        if (rectangle == null) {
            throw new NullPointerException("Rect cannot be null");
        }
        return this.createCompatibleWritableRaster(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2, int n3, int n4) {
        WritableRaster writableRaster = this.createCompatibleWritableRaster(n3, n4);
        return writableRaster.createWritableChild(0, 0, n3, n4, n, n2, null);
    }

    public Raster createTranslatedChild(int n, int n2) {
        return this.createChild(this.minX, this.minY, this.width, this.height, n, n2, null);
    }

    public Raster createChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n < this.minX) {
            throw new RasterFormatException("parentX lies outside raster");
        }
        if (n2 < this.minY) {
            throw new RasterFormatException("parentY lies outside raster");
        }
        if (n + n3 < n || n + n3 > this.width + this.minX) {
            throw new RasterFormatException("(parentX + width) is outside raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.height + this.minY) {
            throw new RasterFormatException("(parentY + height) is outside raster");
        }
        SampleModel sampleModel = nArray == null ? this.sampleModel : this.sampleModel.createSubsetSampleModel(nArray);
        int n7 = n5 - n;
        int n8 = n6 - n2;
        return new Raster(sampleModel, this.getDataBuffer(), new Rectangle(n5, n6, n3, n4), new Point(this.sampleModelTranslateX + n7, this.sampleModelTranslateY + n8), this);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.minX, this.minY, this.width, this.height);
    }

    public final int getMinX() {
        return this.minX;
    }

    public final int getMinY() {
        return this.minY;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getNumBands() {
        return this.numBands;
    }

    public final int getNumDataElements() {
        return this.sampleModel.getNumDataElements();
    }

    public final int getTransferType() {
        return this.sampleModel.getTransferType();
    }

    public DataBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public Object getDataElements(int n, int n2, Object object) {
        return this.sampleModel.getDataElements(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, object, this.dataBuffer);
    }

    public Object getDataElements(int n, int n2, int n3, int n4, Object object) {
        return this.sampleModel.getDataElements(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, object, this.dataBuffer);
    }

    public int[] getPixel(int n, int n2, int[] nArray) {
        return this.sampleModel.getPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, nArray, this.dataBuffer);
    }

    public float[] getPixel(int n, int n2, float[] fArray) {
        return this.sampleModel.getPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, fArray, this.dataBuffer);
    }

    public double[] getPixel(int n, int n2, double[] dArray) {
        return this.sampleModel.getPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, dArray, this.dataBuffer);
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray) {
        return this.sampleModel.getPixels(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, nArray, this.dataBuffer);
    }

    public float[] getPixels(int n, int n2, int n3, int n4, float[] fArray) {
        return this.sampleModel.getPixels(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, fArray, this.dataBuffer);
    }

    public double[] getPixels(int n, int n2, int n3, int n4, double[] dArray) {
        return this.sampleModel.getPixels(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, dArray, this.dataBuffer);
    }

    public int getSample(int n, int n2, int n3) {
        return this.sampleModel.getSample(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, this.dataBuffer);
    }

    public float getSampleFloat(int n, int n2, int n3) {
        return this.sampleModel.getSampleFloat(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, this.dataBuffer);
    }

    public double getSampleDouble(int n, int n2, int n3) {
        return this.sampleModel.getSampleDouble(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, this.dataBuffer);
    }

    public int[] getSamples(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        return this.sampleModel.getSamples(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, n5, nArray, this.dataBuffer);
    }

    public float[] getSamples(int n, int n2, int n3, int n4, int n5, float[] fArray) {
        return this.sampleModel.getSamples(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, n5, fArray, this.dataBuffer);
    }

    public double[] getSamples(int n, int n2, int n3, int n4, int n5, double[] dArray) {
        return this.sampleModel.getSamples(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, n5, dArray, this.dataBuffer);
    }

    static {
        ColorModel.loadLibraries();
        Raster.initIDs();
    }
}

