/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.utils;

import com.sun.org.apache.xerces.internal.utils.ObjectFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public final class SecuritySupport {
    private static final SecuritySupport securitySupport = new SecuritySupport();
    static final Properties cacheProps = new Properties();
    static volatile boolean firstTime = true;

    public static SecuritySupport getInstance() {
        return securitySupport;
    }

    static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader cl = null;
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return cl;
            }
        });
    }

    static ClassLoader getSystemClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader cl = null;
                try {
                    cl = ClassLoader.getSystemClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return cl;
            }
        });
    }

    static ClassLoader getParentClassLoader(final ClassLoader cl) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader parent = null;
                try {
                    parent = cl.getParent();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return parent == cl ? null : parent;
            }
        });
    }

    public static String getSystemProperty(final String propName) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(propName);
            }
        });
    }

    static FileInputStream getFileInputStream(File file) throws FileNotFoundException {
        try {
            return (FileInputStream)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    public static InputStream getResourceAsStream(String name) {
        if (System.getSecurityManager() != null) {
            return SecuritySupport.getResourceAsStream(null, name);
        }
        return SecuritySupport.getResourceAsStream(ObjectFactory.findClassLoader(), name);
    }

    public static InputStream getResourceAsStream(ClassLoader cl, String name) {
        return (InputStream)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
    }

    public static ResourceBundle getResourceBundle(String bundle) {
        return SecuritySupport.getResourceBundle(bundle, Locale.getDefault());
    }

    public static ResourceBundle getResourceBundle(String bundle, Locale locale) {
        return (ResourceBundle)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
    }

    static boolean getFileExists(final File f) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return f.exists() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    static long getLastModified(File f) {
        return (Long)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
    }

    public static String sanitizePath(String uri) {
        if (uri == null) {
            return "";
        }
        int i = uri.lastIndexOf("/");
        if (i > 0) {
            return uri.substring(i + 1, uri.length());
        }
        return uri;
    }

    public static String checkAccess(String systemId, String allowedProtocols, String accessAny) throws IOException {
        String protocol;
        if (systemId == null || allowedProtocols != null && allowedProtocols.equalsIgnoreCase(accessAny)) {
            return null;
        }
        if (systemId.indexOf(":") == -1) {
            protocol = "file";
        } else {
            URL url = new URL(systemId);
            protocol = url.getProtocol();
            if (protocol.equalsIgnoreCase("jar")) {
                String path = url.getPath();
                protocol = path.substring(0, path.indexOf(":"));
            }
        }
        if (SecuritySupport.isProtocolAllowed(protocol, allowedProtocols)) {
            return null;
        }
        return protocol;
    }

    private static boolean isProtocolAllowed(String protocol, String allowedProtocols) {
        String[] temp;
        if (allowedProtocols == null) {
            return false;
        }
        for (String t : temp = allowedProtocols.split(",")) {
            if (!(t = t.trim()).equalsIgnoreCase(protocol)) continue;
            return true;
        }
        return false;
    }

    public static String getJAXPSystemProperty(String sysPropertyId) {
        String accessExternal = SecuritySupport.getSystemProperty(sysPropertyId);
        if (accessExternal == null) {
            accessExternal = SecuritySupport.readJAXPProperty(sysPropertyId);
        }
        return accessExternal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readJAXPProperty(String propertyId) {
        String value = null;
        InputStream is = null;
        try {
            if (firstTime) {
                Properties properties = cacheProps;
                synchronized (properties) {
                    if (firstTime) {
                        String configFile = SecuritySupport.getSystemProperty("java.home") + File.separator + "lib" + File.separator + "jaxp.properties";
                        File f = new File(configFile);
                        if (SecuritySupport.getFileExists(f)) {
                            is = SecuritySupport.getFileInputStream(f);
                            cacheProps.load(is);
                        }
                        firstTime = false;
                    }
                }
            }
            value = cacheProps.getProperty(propertyId);
        }
        catch (Exception exception) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return value;
    }

    private SecuritySupport() {
    }
}

