float2 g_TexSize : texsize;

sampler base : register(s0) = sampler_state
{
    minfilter = point;
    magfilter = point;
};

float4 Text( float2 uv : texcoord0 ) : color0
{
    float4 color = tex2D(base, uv);
    color.rgb = float3(0.64, 0.64, 0.64);
    return color;
}

float4 Shadow( float2 uv : texcoord0 ) : color0
{
    float4 color = tex2D(base, uv + float2(-1.0 / 80, -1.0 / 20));
    color.rgb = float3(0.19, 0.19, 0.19);
    return color;
}

technique BasicEffect
{
    pass P1
    {
        PixelShader = compile ps_2_0 Shadow();
    }
    pass P2
    {
        PixelShader = compile ps_2_0 Text();
    }
}
