#include <koan.fx>

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
VS_OUTPUT VSMain( VS_INPUT input )
{
    VS_OUTPUT output = (VS_OUTPUT)0;
    output.pos = mul( mul( mul( input.pos, mWorld ), mView ), mProject );
    output.color = input.color;
    output.tex = input.tex;
    return output;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
Texture2D       texture1 : register( t1 );
SamplerState    sampler1 : register( s1 );
float4 mask( VS_OUTPUT input ) : SV_Target
{
    float4 cr = input.color * texture0.Sample(sampler0, input.tex);
    float4 mask = texture1.Sample(sampler1, input.tex);
    return float4(cr.rgb, cr.a*mask.a);
}

technique11 RenderScene
{
    pass
    {
        SetVertexShader( CompileShader( vs_4_0, VSMain() ) );
        SetGeometryShader( NULL );
        SetPixelShader ( CompileShader( ps_4_0, mask() ) );
    }
}
