#include <koan.fx>

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
VS_OUTPUT VSMain( VS_INPUT input )
{
    VS_OUTPUT output = (VS_OUTPUT)0;
    output.pos = mul( mul( mul( input.pos, mWorld ), mView ), mProject );
    output.color = input.color;
    output.tex = input.tex;
    return output;
}

float3x3 matrixLeft = { 0.4154f, -0.0547f, -0.0458f,
                        0.4170f, -0.0605f, -0.0484f,
                        0.1669f, 0.0128f, -0.0257f                    
                   };   
                   
float3x3 matrixRight = { -0.0109f, -0.0651f, 0.3756f,
                        -0.0364f, -0.1287f, 0.7333f,
                        -0.0060f, 1.2971f, 0.0111f                
                   };

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
Texture2D       texture1 : register( t1 );
SamplerState    sampler1 : register( s1 );
float4 StereoEffect( VS_OUTPUT input ) : SV_Target
{
    float2 uv = input.tex;
    float4 crLeft = texture0.Sample(sampler0, uv);
    float4 crRight = texture1.Sample(sampler1, uv);
    return float4(mul(crLeft.rgb, matrixLeft) + mul(crRight, matrixRight), 1.0);
}

technique11 RenderScene
{
    pass
    {
        SetVertexShader( CompileShader( vs_4_0, VSMain() ) );
        SetGeometryShader( NULL );
        SetPixelShader ( CompileShader( ps_4_0, StereoEffect() ) );
    }
}
