#include <koan.fx>

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
VS_OUTPUT VSMain( VS_INPUT input )
{
    VS_OUTPUT output = (VS_OUTPUT)0;
    output.pos = mul( mul( mul( input.pos, mWorld ), mView ), mProject );
    output.color = input.color;
    output.tex = input.tex;
    return output;
}

float3x3 matrixLeft = { 0.4561f, -0.0400822f, -0.0152161f,
                        0.500484f, -0.0378246f, -0.0205971f,
                        0.176381f, -0.0157589f, -0.00546856f                    
                   };   
                   
float3x3 matrixRight = { -0.0434706f, 0.378476f, -0.0721527f,
                        -0.0879388f, 0.73364f, -0.112961f,
                        -0.00155529f, -0.0184503f, 1.2264f                
                   };

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
Texture2D       texture1 : register( t1 );
SamplerState    sampler1 : register( s1 );
float4 StereoEffect( VS_OUTPUT input ) : SV_Target
{
    float2 uv = input.tex;
    float4 crLeft = texture0.Sample(sampler0, uv);
    float4 crRight = texture1.Sample(sampler1, uv);
    return float4(mul(crLeft.rgb, matrixLeft) + mul(crRight, matrixRight), 1.0);
}

technique11 RenderScene
{
    pass
    {
        SetVertexShader( CompileShader( vs_4_0, VSMain() ) );
        SetGeometryShader( NULL );
        SetPixelShader ( CompileShader( ps_4_0, StereoEffect() ) );
    }
}
