#include <koan.fx>

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
VS_OUTPUT VSMain( VS_INPUT input )
{
    VS_OUTPUT output = (VS_OUTPUT)0;
    output.pos = mul( mul( mul( input.pos, mWorld ), mView ), mProject );
    output.color = input.color;
    output.tex = input.tex;
    return output;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float gAlpha = 1.0;

float4 StereoPlay( VS_OUTPUT input ) : SV_Target
{
    float2 uv = input.tex;
    float2 _uv = float2(uv.x, uv.y/2.0);
    float4 color = texture0.Sample(sampler0, _uv);
    return float4(color.rgb, color.a * gAlpha);
}

technique11 RenderScene
{
    pass
    {
        SetVertexShader( CompileShader( vs_4_0, VSMain() ) );
        SetGeometryShader( NULL );
        SetPixelShader ( CompileShader( ps_4_0, StereoPlay() ) );
    }
}