#include <koan.fx>

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
VS_OUTPUT VSMain( VS_INPUT input )
{
    VS_OUTPUT output = (VS_OUTPUT)0;
    output.pos = mul( mul( mul( input.pos, mWorld ), mView ), mProject );
    output.color = input.color;
    output.tex = input.tex;
    return output;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------

float4 kr = float4(1.0, 0.2230, 0.0095, 0.1320);
float4 kg = float4(1.0, 0.2264, 0.0081, 0.1391);
float4 kb = float4(1.0, 0.2303, 0.0064, 0.1476);
float aspect = 1.0;
float scale = 1.0;
float2 left_edge = float2(-1.0, -1.0);
float2 right_edge = float2(1.0, 1.0);

float4 LensCorrection( VS_OUTPUT input ) : SV_Target
{
    float2 uv = input.tex;
    uv = lerp(left_edge, right_edge, uv);
    uv *= scale;
    uv.y *= aspect;
    float radius = length(uv);
    float radius_2 = radius * radius;
    float radius_4 = radius_2 * radius_2;
    float radius_6 = radius_4 * radius_2;
    float4 rs = float4(1.0, radius_2, radius_4, radius_6);
    float scale_r = dot(kr, rs); 
    float scale_g = dot(kg, rs); 
    float scale_b = dot(kb, rs); 
    
    
    float2 uv_r = uv * scale_r;
    uv_r.y /= aspect;
    uv_r = (uv_r - left_edge) / (right_edge - left_edge);
    float r = texture0.Sample(sampler0, uv_r).r;
    
    float2 uv_g = uv * scale_g;
    uv_g.y /= aspect;
    uv_g = (uv_g - left_edge) / (right_edge - left_edge);
    float g = texture0.Sample(sampler0, uv_g).g;
    
    float2 uv_b = uv * scale_b;
    uv_b.y /= aspect;
    uv_b = (uv_b - left_edge) / (right_edge - left_edge);
    float b = texture0.Sample(sampler0, uv_b).b;
    
    float4 color = (uv_r.x<0.0 || uv_r.x > 1.0 || uv_r.y < 0.0 || uv_r.y > 1.0) ? float4(0.0, 0.0, 0.0, 1.0) : float4(r, g, b, 1.0);
    color = (uv_g.x<0.0 || uv_g.x > 1.0 || uv_g.y < 0.0 || uv_g.y > 1.0) ? float4(0.0, 0.0, 0.0, 1.0) : color;
    color = (uv_b.x<0.0 || uv_b.x > 1.0 || uv_b.y < 0.0 || uv_b.y > 1.0) ? float4(0.0, 0.0, 0.0, 1.0) : color;
    return color;
}

technique11 RenderScene
{
    pass
    {
        SetVertexShader( CompileShader( vs_4_0, VSMain() ) );
        SetGeometryShader( NULL );
        SetPixelShader ( CompileShader( ps_4_0, LensCorrection() ) );
    }
}
