#include <koan.fx>

texture noiseTex : FileTexture
<
    //string SasResourceAddress = "noise.dds";
    string SasResourceAddress = "noise_1d.bmp";
>;


sampler	g_Tex1					: register(s1);
sampler g_TexNoise : register(s2) = sampler_state
{
    texture = (noiseTex);
    magfilter = linear;
    minfilter = linear;
};

/*
sampler baseTex : register(s0) = sampler_state
{
   addressu = clamp;
   addressv = clamp;
};
*/

float time = 0;
float div = 10;

float4 OpenFade( float2 uv: TEXCOORD0, float4 color : COLOR0 ) : COLOR 
{
    float b = clamp(2*time - abs(uv.x-0.5), 0, 1);
    return tex2D( g_Tex, uv) * b;// + tex2D( g_Tex1, uv) * (1-b);
}

float4 Blend( float2 uv: TEXCOORD0, float4 color : COLOR0 ) : COLOR 
{    
    float b = 0;
    float width = 2.0 / div;
    float cell = 0;
    if( uv.x % width > width / 2)       cell += 1;
    if( uv.y % width > width / 2)       cell -= 1;
    if( cell == 0 )
        b = clamp(div * time - uv.x, 0, 1);
    else
        b = clamp(div * time - uv.x - 5.0 / div, 0, 1);
    return tex2D( g_Tex, uv) * b;// + tex2D( g_Tex1, uv) * (1-b);
}

float4 NoiseFunc( float2 uv: TEXCOORD0, float4 color : COLOR0 ) : COLOR 
{    
    float4 noise = tex2D( g_TexNoise, uv);
    float seed  = (noise.r + noise.g + noise.b) / 3.0;
    float b = clamp(time * 2 - seed, 0, 1);
    return tex2D( g_Tex, uv) * b;// + tex2D( g_Tex1, uv) * (1-b);
}


technique dazzle
{
    pass P0 { PixelShader  = compile ps_2_0 NoiseFunc(); }
}

technique open
{
    pass P0 { PixelShader  = compile ps_2_0 OpenFade(); }
}

technique block
{
    pass P0 { PixelShader  = compile ps_2_0 Blend(); }
}

technique BasicEffect
{
	pass P0 {}
}
