#include "koan.fx"
float2 g_TexSize : texsize;

sampler left : register(s0) = sampler_state
{
    minfilter = linear;
    magfilter = linear;
};

sampler right : register(s1) = sampler_state
{
    minfilter = linear;
    magfilter = linear;
};

float3x3 matrixLeft = { 0.4154f, -0.0547f, -0.0458f,
                        0.4170f, -0.0605f, -0.0484f,
                        0.1669f, 0.0128f, -0.0257f                    
                   };   
                   
float3x3 matrixRight = { -0.0109f, -0.0651f, 0.3756f,
                        -0.0364f, -0.1287f, 0.7333f,
                        -0.0060f, 1.2971f, 0.0111f                
                   };

float4 StereoEffect( float2 uv : texcoord0 ) : color0
{
    float4 crLeft = tex2D(left, uv);
    float4 crRight = tex2D(right, uv);
    return float4(mul(crLeft.rgb, matrixLeft) + mul(crRight, matrixRight), 1.0);
}

technique BasicEffect
{
    pass P1
    {
        PixelShader = compile ps_2_0 StereoEffect();
    } 
}
