#include "koan.fx"
float2 g_TexSize : texsize;

sampler left : register(s0) = sampler_state
{
    minfilter = linear;
    magfilter = linear;
};

sampler right : register(s1) = sampler_state
{
    minfilter = linear;
    magfilter = linear;
};

float3x3 matrixLeft = { 0.4561f, -0.0400822f, -0.0152161f,
                        0.500484f, -0.0378246f, -0.0205971f,
                        0.176381f, -0.0157589f, -0.00546856f                    
                   };   
                   
float3x3 matrixRight = { -0.0434706f, 0.378476f, -0.0721527f,
                        -0.0879388f, 0.73364f, -0.112961f,
                        -0.00155529f, -0.0184503f, 1.2264f                
                   };

float4 StereoEffect( float2 uv : texcoord0 ) : color0
{
    float4 crLeft = tex2D(left, uv);
    float4 crRight = tex2D(right, uv);
    return float4(mul(crLeft.rgb, matrixLeft) + mul(crRight, matrixRight), 1.0);
}

technique BasicEffect
{
    pass P1
    {
        PixelShader = compile ps_2_0 StereoEffect();
    } 
}
