#include "koan.fx"

sampler texture0 : register(s0) = sampler_state
{
    minfilter = linear;
    magfilter = linear;
};

float4 kr = float4(1.0, 0.2230, 0.0095, 0.1320);
float4 kg = float4(1.0, 0.2264, 0.0081, 0.1391);
float4 kb = float4(1.0, 0.2303, 0.0064, 0.1476);
float aspect = 1.0;
float scale = 1.0;
float2 left_edge = float2(-1.0, -1.0);
float2 right_edge = float2(1.0, 1.0);

float4 LensCorrection( float2 uv : texcoord0 ) : color0
{
    uv = lerp(left_edge, right_edge, uv);
    uv *= scale;
    uv.y *= aspect;
    float radius = length(uv);
    float radius_2 = radius * radius;
    float radius_4 = radius_2 * radius_2;
    float radius_6 = radius_4 * radius_2;
    float4 rs = float4(1.0, radius_2, radius_4, radius_6);
    float scale_r = dot(kr, rs); 
    float scale_g = dot(kg, rs); 
    float scale_b = dot(kb, rs); 
    
    
    float2 uv_r = uv * scale_r;
    uv_r.y /= aspect;
    uv_r = (uv_r - left_edge) / (right_edge - left_edge);
    float r = tex2D(texture0, uv_r).r;
    
    float2 uv_g = uv * scale_g;
    uv_g.y /= aspect;
    uv_g = (uv_g - left_edge) / (right_edge - left_edge);
    float g = tex2D(texture0, uv_g).g;
    
    float2 uv_b = uv * scale_b;
    uv_b.y /= aspect;
    uv_b = (uv_b - left_edge) / (right_edge - left_edge);
    float b = tex2D(texture0, uv_b).b;
        
    return (uv_g.x<0.0 || uv_g.x > 1.0 || uv_g.y < 0.0 || uv_g.y > 1.0) ? float4(0.0, 0.0, 0.0, 1.0) : float4(r, g, b, 1.0);
}

technique BasicEffect
{
    pass P1
    {
        PixelShader = compile ps_2_0 LensCorrection();
    } 
}
