---
title: "ModdingAPI"
author: "Automatically generated on 5/25/2020"
geometry: margin=1cm
---




## Actor



### ActorInfo
Behavior information for colonists, enemies and animals.

 * **Animal**: Animals have less needs and inhabit barns instead of houses. *(System.Boolean, default: 1)*
 * **CarryPosition**: Relative position of carried items. *(UnityEngine.Vector3, default: 0,0.5,0.45)*
 * **CarryRotation**: Relative rotation of carried items. *(UnityEngine.Vector3, default: 0,0,0)*
 * **DeterministicLoot**: Deterministic loot to drop when killed. *(System.String, no default)*
 * **Drinks**: Drink only a certain item (e.g. robots => oil barrel). Empty = all drinks. *(System.String[], no default)*
 * **Eats**: Eats only a certain item (e.g. robots => oil barrel). Empty = all food. *(System.String[], no default)*
 * **GainsExperience**: Gets better at what it does. *(System.Boolean, default: 1)*
 * **Names**: List of possible names. Use inheritsfrom:xxx to inherit names from another type (used for backer names). *(System.String[], default: System.String[])*
 * **Needs**: List of needs (see DataInfo/Needs). *(System.String[], default: System.String[])*
 * **RandomLootAmount**: How many pieces of loot when killed? *(System.Int32, default: 0)*
 * **Robot**: Robots are not counted as idle colonists. *(System.Boolean, default: 0)*
 * **Speed**: Movement speed in tiles per second. *(System.Single, default: 1)*
 * **SpeedMoodFactor**: By which factor does mood affect movement speed? *(System.Single, default: 0.1)*
 * **TaskGroups**: List of possible tasks (see DataInfo/TaskGroup). *(System.String[], default: System.String[])*
 * **UnarmedMeleeAttack**: How much damage per punch does actor do when unarmed. *(System.Int32, default: 5)*
 * **WaitAfterMovement**: How long is the actor idle after movement. (e.g. spiders) *(System.Single, default: 0)*



### BirdInfo
Birds like the seagull automatically move between Water tiles.

 * **Height**: Height above ground. *(System.Single, default: 3)*
 * **NextTargetMaxDistance**: How far away can the next target be from the current position? *(System.Int32, default: 30)*
 * **RecalculationThreshold**: At what distance to the next target should it be recalculated? *(System.Single, default: 20)*
 * **Speed**: Speed in tiles per second. *(System.Single, default: 1)*



### CombatRobotInfo
Information for combat robots.




### DomesticAnimalInfo
Domestic animal (can do jobs like your colonists).




### HitpointInfo
Things with hitpoints can get hurt and die.

 * **MaxHitpoints**: HP when at full health. *(System.Int32, default: 50)*
 * **RegenPerSecond**: Regeneration while sleeping in hp/s *(System.Int32, default: 1)*



### PastureAnimalInfo
Pasture animal (lives on pasture).

 * **TamingDifficulty**: How hard is it to tame this animal. *(System.Single, default: 1)*
 * **Yield**: What can be yielded from this animal? Single object type. *(System.String, no default)*
 * **YieldInterval**: How long does it take until this animal can be milked etc.? *(System.Single, default: 120)*



### ProjectileInfo
A projectile fired from a weapon.

 * **Damage**: Damage done by projectile when hitting an enemy. *(System.Single, default: 0)*
 * **Speed**: Speed in t/s at which projectile travels. *(System.Single, default: 0)*



### RobotInfo
Information for robots (still needs ActorInfo).




### StepCloudInfo
Spawns small particle clouds on every animation step.

 * **OnlyWhenRunning**: Only create clouds when running. *(System.Boolean, default: 1)*
 * **PositionFrame0**: Relative position of cloud on frame 0. Leave at null for no cloud. *(System.Nullable`1[UnityEngine.Vector3], no default)*
 * **PositionFrame1**: Relative position of cloud on frame 1. Leave at null for no cloud. *(System.Nullable`1[UnityEngine.Vector3], no default)*
 * **PositionFrame2**: Relative position of cloud on frame 2. Leave at null for no cloud. *(System.Nullable`1[UnityEngine.Vector3], no default)*
 * **PositionFrame3**: Relative position of cloud on frame 3. Leave at null for no cloud. *(System.Nullable`1[UnityEngine.Vector3], no default)*



### VisibilityUpdaterInfo
Adds a visibility updater that regular checks if an object is under the fog of war.

 * **InverseFogOfWar**: Visible only when inside fog of war. (e.g. camp marker) *(System.Boolean, default: 0)*
 * **StayRevealed**: Stay revealed. *(System.Boolean, default: 0)*



## Building



### AutoFarmInfo
Adds the behavior of an automated farm.

 * **ArrangeOnPickup**: Arrange stacks on pickup. *(System.Boolean, default: 1)*
 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **CraneHeight**: Height for the crane. *(System.Single, default: 1)*
 * **CraneHeightMin**: Height for the crane. *(System.Single, default: 0.45)*
 * **CranePrefab**: Name of type to use as crane. *(System.String, no default)*
 * **CraneTransportDurationBase**: How long does a transport take? Base time in s. *(System.Single, default: 1)*
 * **CraneTransportDurationPerDistance**: How long does a transport take? Increment based on distance in s/m. *(System.Single, default: 0)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **FramePrefab**: Name of type to use as frame. *(System.String, no default)*
 * **Grove**: 0 for farm, 1 for grove *(System.Boolean, default: 0)*
 * **GrowEverything**: Grow everything regardless of ground. *(System.Boolean, default: 0)*
 * **HeightSpan**: Height span for the crane. *(System.Single, default: 0.75)*
 * **HighCapacity**: High capacity (for depots). *(System.Boolean, default: 0)*
 * **HookPrefab**: Name of type to use as hook. *(System.String, no default)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **SpawnCrane**: Spawn a crane *(System.Boolean, default: 1)*
 * **StorageTiles**: List of storage tiles, x,y, e.g. 1,1;1,2;1,3... *(System.String, default: )*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### AutomaticWorkshopInfo
A workshop that produces automatically given it has the required inputs.

 * **AnimationMode**: Animation during production. 0 = Frame is selected according to production progress. 1 = Frame is cycled every time the colonist hits the workshop. *(System.Int32, default: 0)*
 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **HitAnimation**: Decrease object scale when hit *(System.Boolean, default: 1)*
 * **InheritRecipiesFrom**: List of workshops from which recipes are inherited. *(System.String, no default)*
 * **InputSpots**: Where are input goods placed. (Must be round relative tile position) *(UnityEngine.Vector3[], default: )*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **OutputSpots**: Where are output goods created. (Must be a round relative tile position) *(UnityEngine.Vector3[], default: )*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **SpawnInputBoxes**: Spawn boxes at input places? *(System.Boolean, default: 0)*
 * **SpawnOutputBoxes**: Spawn boxes at output places? *(System.Boolean, default: 0)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### BuildingRecipeInfo
Things that can be built.

 * **BuildAbove**: Build above resource (o.g. oil well). *(System.String, no default)*
 * **CanBuildOnAllSolidGround**: Can be built on sand and other solid tiles. *(System.Boolean, default: 0)*
 * **CanBuildOutsideTerritory**: Can be built outside of your territory, e.g. outpost bonfires. *(System.Boolean, default: 0)*
 * **HarborPlacement**: Building placement like harbors. *(System.Boolean, default: 0)*
 * **Ingredients**: List of items needed to build it. *(System.String, no default)*
 * **InstaBuild**: Is built instantly (e.g. depot exits/entries). Should only be used when the building requires no ingredients. *(System.Boolean, default: 0)*
 * **MultiBuild**: Colonists can build multiple instances in one go. *(System.Int32, default: 0)*
 * **MultiPlacement**: The player can place multiple instances by dragging an area. *(System.Boolean, default: 0)*
 * **RequiredToolLevel**: Tool level required to build (0-1=hand, 2=wood, 3=iron...), (Note: ignored for building upgrades). *(System.Int32, default: 0)*
 * **RequireFertileGround**: Can only be built on fertile tiles. *(System.Boolean, default: 0)*
 * **ToggleBuild**: Building twice removes previous instance. *(System.Boolean, default: 0)*
 * **VariationBasedOnTile**: Map of tile type → variation (o.g. foundations). *(System.String, no default)*



### CarriageStationInfo
A station inbetween zeppelins can travel. 

 * **ArrangeOnPickup**: Arrange stacks on pickup. *(System.Boolean, default: 1)*
 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **CarriageType**: Type to spawn as carriage. *(System.String, default: )*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **CraneHeight**: Height for the crane. *(System.Single, default: 1)*
 * **CraneHeightMin**: Height for the crane. *(System.Single, default: 0.45)*
 * **CranePrefab**: Name of type to use as crane. *(System.String, no default)*
 * **CraneTransportDurationBase**: How long does a transport take? Base time in s. *(System.Single, default: 1)*
 * **CraneTransportDurationPerDistance**: How long does a transport take? Increment based on distance in s/m. *(System.Single, default: 0)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **FramePrefab**: Name of type to use as frame. *(System.String, no default)*
 * **FreeCarriages**: Number of free carriages to spawn. *(System.Int32, default: 1)*
 * **HeightSpan**: Height span for the crane. *(System.Single, default: 0.75)*
 * **HighCapacity**: High capacity (for depots). *(System.Boolean, default: 0)*
 * **HookPrefab**: Name of type to use as hook. *(System.String, no default)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **SpawnCrane**: Spawn a crane *(System.Boolean, default: 1)*
 * **StorageTiles**: List of storage tiles, x,y, e.g. 1,1;1,2;1,3... *(System.String, default: )*
 * **TileLimitPerLogisticsTarget**: How many tiles can be reserved per logistics target (to prevent deadlocks). *(System.Int32, default: 1)*
 * **Type**: Type of picker (Entry, Exit or Storage). *(System.String, no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### ClaimInfo
Thing that expands territory.

 * **BorderMarkerPrefab**: Type of the border markers. *(System.String, no default)*
 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **ClaimPriority**: Claims with lower priority override claims with higher priority; *(System.Int32, default: 5)*
 * **ClaimRange**: Range of influence. *(System.Int32, default: 0)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **IsOutpost**: Choose random color. *(System.Boolean, default: 0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### ConnectedDecorationInfo
Connected decoration (walls, hedges etc.).

 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### ConveyorBeltInfo
A conveyor belt.

 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **CanRegisterToTile**: Are items that stop on this belt registered to the tile? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **Direction**: In which direction does it move? *(UnityEngine.Vector3, default: 0,0,0)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **HeightIn**: Height in incoming direction. *(System.Single, default: 0)*
 * **HeightOut**: Height in outgoing direction. *(System.Single, default: 0)*
 * **IsDistributor**: Is it a distributor? (can have multiple outputs) *(System.Boolean, default: 0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **Speed**: How fast do elements move? *(System.Single, default: 0.3333333)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### ConveyorBeltModelUpdaterInfo
Creates the conveyor belt effect. 

 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **Effect**: Name of the effect to apply *(System.String, default: effects/ConveyorBeltStraight/ConveyorBeltStraight)*
 * **Height**: Height of effect. *(System.Single, default: 0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### DecorationInfo
A decoration object.

 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **Range**: Range of effect value of the object. *(System.Single, default: 8)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### DepotInfo
Picker (used internally).

 * **ArrangeOnPickup**: Arrange stacks on pickup. *(System.Boolean, default: 1)*
 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **CraneHeight**: Height for the crane. *(System.Single, default: 1)*
 * **CraneHeightMin**: Height for the crane. *(System.Single, default: 0.45)*
 * **CranePrefab**: Name of type to use as crane. *(System.String, no default)*
 * **CraneTransportDurationBase**: How long does a transport take? Base time in s. *(System.Single, default: 1)*
 * **CraneTransportDurationPerDistance**: How long does a transport take? Increment based on distance in s/m. *(System.Single, default: 0)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **FramePrefab**: Name of type to use as frame. *(System.String, no default)*
 * **HeightSpan**: Height span for the crane. *(System.Single, default: 0.75)*
 * **HighCapacity**: High capacity (for depots). *(System.Boolean, default: 0)*
 * **HookPrefab**: Name of type to use as hook. *(System.String, no default)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **SpawnCrane**: Spawn a crane *(System.Boolean, default: 1)*
 * **StorageTiles**: List of storage tiles, x,y, e.g. 1,1;1,2;1,3... *(System.String, default: )*
 * **TileLimitPerLogisticsTarget**: How many tiles can be reserved per logistics target (to prevent deadlocks). *(System.Int32, default: 1)*
 * **Type**: Type of picker (Entry, Exit or Storage). *(System.String, no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### EnemyClaimInfo
Thing that expands territory.

 * **BorderMarkerPrefab**: Type of the border markers. *(System.String, no default)*
 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **ClaimPriority**: Claims with lower priority override claims with higher priority; *(System.Int32, default: 5)*
 * **ClaimRange**: Range of influence. *(System.Int32, default: 0)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **IsOutpost**: Choose random color. *(System.Boolean, default: 0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### FilterInserterInfo
Filter Inserter behavior.

 * **AngleExtentDrop**: At what angle does the arm extend per cycle? *(System.Single, default: 0)*
 * **AngleExtentPickup**: At what angle does the arm extend per cycle? *(System.Single, default: 0)*
 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **InputSpot**: Relative position of from where to grab items. *(UnityEngine.Vector3, default: 0,0,0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **OutputSpot**: Relative position of to where to deliver items. *(UnityEngine.Vector3, default: 0,0,0)*
 * **Part1Offset**: Position offset of inserter part 1 (base) *(System.Single, default: 0.375)*
 * **Part1Prefab**: Type name of inserter part 1 (base) *(System.String, no default)*
 * **Part2Offset**: Position offset of inserter part 2 (arm) *(System.Single, default: 0.9583333)*
 * **Part2Prefab**: Type name of inserter part 2 (arm) *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **TransportDurationFull**: Time to deliver from - to. *(System.Single, default: 0)*
 * **TransportDurationHalf**: Time to deliver from - middle or middle - to. *(System.Single, default: 0)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### FoundationInfo
Info for foundations (make a tile buildable).

 * **MakesGroundFertile**: Makes ground fertile. *(System.Boolean, default: 0)*
 * **NewType**: Treat the tile like this afterwards (map tile type → new type) (for farms). *(System.String, no default)*



### GarbageDumpInfo
Garbage dump behavior.

 * **ArrangeOnPickup**: Arrange stacks on pickup. *(System.Boolean, default: 1)*
 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **CraneHeight**: Height for the crane. *(System.Single, default: 1)*
 * **CraneHeightMin**: Height for the crane. *(System.Single, default: 0.45)*
 * **CranePrefab**: Name of type to use as crane. *(System.String, no default)*
 * **CraneTransportDurationBase**: How long does a transport take? Base time in s. *(System.Single, default: 1)*
 * **CraneTransportDurationPerDistance**: How long does a transport take? Increment based on distance in s/m. *(System.Single, default: 0)*
 * **DecompositionTime**: Time in seconds until a piece of garbage decomposes. *(System.Single, default: 60)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **FramePrefab**: Name of type to use as frame. *(System.String, no default)*
 * **GarbageType**: Type of garbage. *(System.String, default: Garbage)*
 * **HeightSpan**: Height span for the crane. *(System.Single, default: 0.75)*
 * **HighCapacity**: High capacity (for depots). *(System.Boolean, default: 0)*
 * **HookPrefab**: Name of type to use as hook. *(System.String, no default)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **SpawnCrane**: Spawn a crane *(System.Boolean, default: 1)*
 * **StorageTiles**: List of storage tiles, x,y, e.g. 1,1;1,2;1,3... *(System.String, default: )*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### HarbourInfo
Cargo port behavior.

 * **ArrangeOnPickup**: Arrange stacks on pickup. *(System.Boolean, default: 1)*
 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **CraneHeight**: Height for the crane. *(System.Single, default: 1)*
 * **CraneHeightMin**: Height for the crane. *(System.Single, default: 0.45)*
 * **CranePrefab**: Name of type to use as crane. *(System.String, no default)*
 * **CraneTransportDurationBase**: How long does a transport take? Base time in s. *(System.Single, default: 1)*
 * **CraneTransportDurationPerDistance**: How long does a transport take? Increment based on distance in s/m. *(System.Single, default: 0)*
 * **DockingPoint**: Relative coordinate where the ship docks. *(UnityEngine.Vector3, default: 0,0,0)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **ExportTiles**: Tiles for export. *(System.Int32, default: 8)*
 * **FramePrefab**: Name of type to use as frame. *(System.String, no default)*
 * **HeightSpan**: Height span for the crane. *(System.Single, default: 0.75)*
 * **HighCapacity**: High capacity (for depots). *(System.Boolean, default: 0)*
 * **HookPrefab**: Name of type to use as hook. *(System.String, no default)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **SpawnCrane**: Spawn a crane *(System.Boolean, default: 1)*
 * **StorageTiles**: List of storage tiles, x,y, e.g. 1,1;1,2;1,3... *(System.String, default: )*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### HouseInfo
A house where colonists or animals live in.

 * **AllowAnimals**: Allow animals to use this house. *(System.Boolean, default: 0)*
 * **AllowColonists**: Allow colonists to use this house. *(System.Boolean, default: 1)*
 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DisappearWhileSleeping**: Sleeping here makes the actor disappear (to make it look like it entered this house). *(System.Boolean, default: 0)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **Entrance**: Relative point at which colonists enter the house. *(UnityEngine.Vector3, default: 0,0,0)*
 * **HousingCapacity**: How many actors can live here. *(System.Int32, default: 0)*
 * **HousingQuality**: Quality of the housing provided (smaller 3=low, higher or equal 3=high). *(System.Int32, default: 1)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### InserterInfo
Inserter behavior.

 * **AngleExtentDrop**: At what angle does the arm extend per cycle? *(System.Single, default: 0)*
 * **AngleExtentPickup**: At what angle does the arm extend per cycle? *(System.Single, default: 0)*
 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **InputSpot**: Relative position of from where to grab items. *(UnityEngine.Vector3, default: 0,0,0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **OutputSpot**: Relative position of to where to deliver items. *(UnityEngine.Vector3, default: 0,0,0)*
 * **Part1Offset**: Position offset of inserter part 1 (base) *(System.Single, default: 0.375)*
 * **Part1Prefab**: Type name of inserter part 1 (base) *(System.String, no default)*
 * **Part2Offset**: Position offset of inserter part 2 (arm) *(System.Single, default: 0.9583333)*
 * **Part2Prefab**: Type name of inserter part 2 (arm) *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **TransportDurationFull**: Time to deliver from - to. *(System.Single, default: 0)*
 * **TransportDurationHalf**: Time to deliver from - middle or middle - to. *(System.Single, default: 0)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### ManualWorkshopInfo
A workshop operated by your colonists.

 * **AllowsPropagateToStockpiles**: Enables the propagate to stockpiles button. *(System.Boolean, default: 1)*
 * **AnimationMode**: Animation during production. 0 = Frame is selected according to production progress. 1 = Frame is cycled every time the colonist hits the workshop. *(System.Int32, default: 0)*
 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **CraftingSound**: The sound it makes when crafting. *(System.String, default: Construct)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **HitAnimation**: Decrease object scale when hit *(System.Boolean, default: 1)*
 * **InheritRecipiesFrom**: List of workshops from which recipes are inherited. *(System.String, no default)*
 * **InputSpots**: Where are input goods placed. (Must be round relative tile position) *(UnityEngine.Vector3[], default: )*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **OutputSpots**: Where are output goods created. (Must be a round relative tile position) *(UnityEngine.Vector3[], default: )*
 * **RequireOutputStockpiles**: Require output stockpiles. *(System.Boolean, default: 1)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **SpawnInputBoxes**: Spawn boxes at input places? *(System.Boolean, default: 0)*
 * **SpawnOutputBoxes**: Spawn boxes at output places? *(System.Boolean, default: 0)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### OverheadConveyorInfo
Track or station of an overhead conveyor network.

 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **CartPrefab**: Type of the cart to spawn in this network. *(System.String, no default)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **Station**: Is it a station? *(System.Boolean, default: 0)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### PickerInfo
Abstract, something that can store items.

 * **ArrangeOnPickup**: Arrange stacks on pickup. *(System.Boolean, default: 1)*
 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **CraneHeight**: Height for the crane. *(System.Single, default: 1)*
 * **CraneHeightMin**: Height for the crane. *(System.Single, default: 0.45)*
 * **CranePrefab**: Name of type to use as crane. *(System.String, no default)*
 * **CraneTransportDurationBase**: How long does a transport take? Base time in s. *(System.Single, default: 1)*
 * **CraneTransportDurationPerDistance**: How long does a transport take? Increment based on distance in s/m. *(System.Single, default: 0)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **FramePrefab**: Name of type to use as frame. *(System.String, no default)*
 * **HeightSpan**: Height span for the crane. *(System.Single, default: 0.75)*
 * **HighCapacity**: High capacity (for depots). *(System.Boolean, default: 0)*
 * **HookPrefab**: Name of type to use as hook. *(System.String, no default)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **SpawnCrane**: Spawn a crane *(System.Boolean, default: 1)*
 * **StorageTiles**: List of storage tiles, x,y, e.g. 1,1;1,2;1,3... *(System.String, default: )*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### PlainBuildingInfo
Just a building without any special function.

 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### PlayerClaimInfo
Thing that expands territory.

 * **BorderMarkerPrefab**: Type of the border markers. *(System.String, no default)*
 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **ClaimPriority**: Claims with lower priority override claims with higher priority; *(System.Int32, default: 5)*
 * **ClaimRange**: Range of influence. *(System.Int32, default: 0)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **IsOutpost**: Choose random color. *(System.Boolean, default: 0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### PowerGeneratorInfo
Building used to generate power.

 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### PowerLineInfo
A power line.

 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### RailwayCrossingInfo
A railway crossing. Closes when a train passes.

 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **GatePosition**: Relative position of gate. *(UnityEngine.Vector3, default: 0,0,0)*
 * **GateType**: Type to use as gate. *(System.String, no default)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### RecyclingWorkshopInfo
A workshop operated by your colonists.

 * **AnimationMode**: Animation during production. 0 = Frame is selected according to production progress. 1 = Frame is cycled every time the colonist hits the workshop. *(System.Int32, default: 0)*
 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **CraftingSound**: The sound it makes when crafting. *(System.String, default: Construct)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **HitAnimation**: Decrease object scale when hit *(System.Boolean, default: 1)*
 * **InheritRecipiesFrom**: List of workshops from which recipes are inherited. *(System.String, no default)*
 * **InputSpots**: Where are input goods placed. (Must be round relative tile position) *(UnityEngine.Vector3[], default: )*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **OutputSpots**: Where are output goods created. (Must be a round relative tile position) *(UnityEngine.Vector3[], default: )*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **SpawnInputBoxes**: Spawn boxes at input places? *(System.Boolean, default: 0)*
 * **SpawnOutputBoxes**: Spawn boxes at output places? *(System.Boolean, default: 0)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### RoadInfo
A road.

 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **SpeedBonus**: Relative movement speed bonus. *(System.Single, default: 0.2)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### SemaphoreInfo
A semaphore for train tracks.

 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **GatePosition**: Relative position of gate. *(UnityEngine.Vector3, default: 0,0,0)*
 * **GateType**: Type to use as gate. *(System.String, no default)*
 * **LookAhead**: How many segments to look ahead (used for pre-signals). *(System.Int32, default: 1)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### SocialBuildingInfo
A social building like a tavern fulfills the colonists' social/leisure activity.

 * **Animation**: Satisfies drink need (e.g. cocktail bar). *(System.String, default: Sit)*
 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SatisfiesDrink**: Satisfies drink need (e.g. cocktail bar). *(System.Boolean, default: 0)*
 * **SatisfiesFood**: Satisfies food need (e.g. restaurant). *(System.Boolean, default: 0)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### TrackInfo
A track piece.

 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **CanPlaceSemaphore**: Can place a semaphore above this track. *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **Connections**: Relative position of two tiles which this track connects. *(UnityEngine.Vector3[], no default)*
 * **Curve**: Is a curve. *(System.Boolean, default: 0)*
 * **Deconstructable**: Deconstructable. *(System.Boolean, default: 1)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **Points**: Relative points along which the trains will move. *(UnityEngine.Vector3[], no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### TradeCaravanInfo
A house where colonists or animals live in.

 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### TrainFactoryInfo
Train factory.

 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### TrainingDummyInfo
Used by colonists to practice fighting.

 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### TrainStationInfo
Train Station.

 * **ArrangeOnPickup**: Arrange stacks on pickup. *(System.Boolean, default: 1)*
 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **CraneHeight**: Height for the crane. *(System.Single, default: 1)*
 * **CraneHeightMin**: Height for the crane. *(System.Single, default: 0.45)*
 * **CranePrefab**: Name of type to use as crane. *(System.String, no default)*
 * **CraneTransportDurationBase**: How long does a transport take? Base time in s. *(System.Single, default: 1)*
 * **CraneTransportDurationPerDistance**: How long does a transport take? Increment based on distance in s/m. *(System.Single, default: 0)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **FramePrefab**: Name of type to use as frame. *(System.String, no default)*
 * **HeightSpan**: Height span for the crane. *(System.Single, default: 0.75)*
 * **HighCapacity**: High capacity (for depots). *(System.Boolean, default: 0)*
 * **HookPrefab**: Name of type to use as hook. *(System.String, no default)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **SpawnCrane**: Spawn a crane *(System.Boolean, default: 1)*
 * **StorageTiles**: List of storage tiles, x,y, e.g. 1,1;1,2;1,3... *(System.String, default: )*
 * **TileLimitPerLogisticsTarget**: How many tiles can be reserved per logistics target (to prevent deadlocks). *(System.Int32, default: 1)*
 * **Tracks**: List of tiles where trains will stop, separated by ',', multiple platforms separated by 'newline' *(System.String, default: )*
 * **Type**: Type of picker (Entry, Exit or Storage). *(System.String, no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### UpgradeableBuildingInfo
Things that can upgraded (e.g. Bonfire→OutpostBonfire). Note that the target building still needs a BuildingRecipeInfo, even when it is only constructable via upgrading. The upgraded building should have the same size (in tiles) as the base building, otherwise a variety of bugs can occur.

 * **IgnoreItemsOnConstructionSite**: Don't clear items while upgrading (e.g. depot). *(System.Boolean, default: 0)*
 * **Ingredients**: List of items needed to upgrade it. *(System.String, no default)*
 * **TargetType**: Type to which to upgrade to. *(System.String, no default)*



### VisionExtenderInfo
Extends vision around when built.

 * **VisionRange**: How many tiles far can the thing see. *(System.Int32, default: 10)*



### WaterSprinklerInfo
A water sprinkler.

 * **Area**: Area that is sprinkled (square effect, extent in either direction). *(System.Int32, default: 0)*
 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### ZeppelinDepotInfo
A zeppelin factory - produces zeppelins when spawned.

 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*
 * **ZeppelinCount**: Number of zeppelins to spawn. *(System.Int32, default: 3)*
 * **ZeppelinType**: Type of zeppelin to spawn. *(System.String, default: ZeppelinUnit)*



### ZeppelinStationInfo
A station inbetween zeppelins can travel. 

 * **ArrangeOnPickup**: Arrange stacks on pickup. *(System.Boolean, default: 1)*
 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **CraneHeight**: Height for the crane. *(System.Single, default: 1)*
 * **CraneHeightMin**: Height for the crane. *(System.Single, default: 0.45)*
 * **CranePrefab**: Name of type to use as crane. *(System.String, no default)*
 * **CraneTransportDurationBase**: How long does a transport take? Base time in s. *(System.Single, default: 1)*
 * **CraneTransportDurationPerDistance**: How long does a transport take? Increment based on distance in s/m. *(System.Single, default: 0)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **FramePrefab**: Name of type to use as frame. *(System.String, no default)*
 * **HeightSpan**: Height span for the crane. *(System.Single, default: 0.75)*
 * **HighCapacity**: High capacity (for depots). *(System.Boolean, default: 0)*
 * **HookPrefab**: Name of type to use as hook. *(System.String, no default)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **SpawnCrane**: Spawn a crane *(System.Boolean, default: 1)*
 * **StorageTiles**: List of storage tiles, x,y, e.g. 1,1;1,2;1,3... *(System.String, default: )*
 * **TileLimitPerLogisticsTarget**: How many tiles can be reserved per logistics target (to prevent deadlocks). *(System.Int32, default: 1)*
 * **Type**: Type of picker (Entry, Exit or Storage). *(System.String, no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



## Data



### BuildingCategoryInfo
Building category.

 * **CategoryName**: Name of the category. *(System.String, no default)*
 * **Icon**: Name of the icon (can be a UI icon or the name of an object type). *(System.String, no default)*



### CampaignLoadoutInfo
Possible loadout for the campaign.

 * **Content**: Things to spawn (e.g. 3*SettlerFemale,3*SettlerMale,4*Pig). *(System.String, no default)*
 * **Priority**: Priority of this loadout. Only loadouts with the highest priority number will be shown. Use this to replace vanilla loadouts. *(System.Int32, default: 0)*



### CustomMusicInfo
Custom music for the game. Make sure that you have the rights/license to share the music file and credit the artist(s).

 * **Filename**: Name of the music file to load. Path is relative to the mod's base directory. The file must be in OGG format. Keep in mind that filenames are case-sensitive on Linux and Mac. *(System.String, no default)*
 * **PlayAtDaytime**: Play this at daytime (6:00-18:00). *(System.Boolean, default: 1)*
 * **PlayAtNighttime**: Play this at nighttime (18:00-6:00). *(System.Boolean, default: 1)*
 * **PlayInCombat**: Play this while in combat. *(System.Boolean, default: 0)*
 * **RemoveVanillaMusic**: Remove the built-in music from the playlist. *(System.Boolean, default: 0)*



### DeleteObjectsInfo
Used to delete vanilla objects from the game.

 * **Types**: Comma-separated list of things to remove. *(System.String[], no default)*



### DioramaContentInfo
A diorama description (do not edit this directly, use the diorama generator tool instead.)

 * **Content**: A diorama description (do not edit this directly, use the diorama generator tool instead.) *(System.String, no default)*



### NeedType
Need type. (e.g. food or drink)

 * **ActionsToSolve**: Actions to perform when need is low. *(System.String[], no default)*
 * **AffectsNeutrals**: Need affects neutral animals. *(System.Boolean, default: 0)*
 * **changePerMinute**: Level change per minute. *(System.Single, default: 0)*
 * **criticalBelow**: Level it which need is considered critical (0-100). *(System.Single, default: 0)*
 * **icon**: Icon to use for need in UI. *(System.String, default: Close)*
 * **lowBelow**: Level it which need is considered low (0-100). *(System.Single, default: 0)*
 * **StartFulfillment**: Fulfillment level at the start of the game (0-100). *(System.Single, default: 80)*



### TaskGroupInfo
A task group (e.g. agriculture).

 * **DefaultPriority**: 1 for on by default. *(System.Boolean, default: 0)*
 * **DefaultPriorityForAnimals**: 1 for on by default. *(System.Boolean, default: 0)*
 * **ExperienceFactor**: Multiplicator of exp gain. *(System.Single, default: 0)*
 * **HasTool**: There is a tool associated with this group. *(System.Boolean, default: 0)*
 * **Icon**: Icon to use for task group in UI. *(System.String, no default)*
 * **Priority**: Relative priority (lower = higher) *(System.Single, default: 0)*
 * **Selectable**: Can be toggled on/off by player. (E.g. need fulfillment cannot be switched off). *(System.Boolean, default: 1)*



## General



### AudioClipInfo
Need type. (e.g. food or drink)

 * **AudioClips**: (Internal) *(System.Collections.Generic.List`1[UnityEngine.AudioClip], no default)*
 * **BasePitch**: Base level of the pitch. *(System.Single, default: 1)*
 * **BaseVolume**: Base level of the volume, between 0-1 (1=100%). *(System.Single, default: 1)*
 * **PitchVariance**: Random variance of the pitch. *(System.Single, default: 0.1)*
 * **Priority**: Priority (lower = more likely to play). *(System.Int32, default: 100)*
 * **Source**: Link to where this file is from. (Optional, in case of copyright questions) *(System.String, default: ?)*
 * **Variations**: Number of variations. *(System.Int32, default: 1)*
 * **VolumeVariance**: Random variance of the volume. *(System.Single, default: 0.25)*



### BaseInfo
Basic/universal object information.

 * **AddCollider**: Add a collider. This will prevent colonists and other creatures from walking through this object. *(System.Boolean, default: 0)*
 * **AddHeightForItems**: Additional height to be added to other items on this tile. *(System.Single, default: 0)*
 * **AdditionalSpawns**: Other objects to spawn alongside (e.g. the tracks in the train station). List of ObjectType,relx,rely,relz,rot, multiple lines with one entry per line *(System.String, no default)*
 * **AllowBatching**: Allow static batching. *(System.Boolean, default: 1)*
 * **CannotBuildDirectly**: Only buildable via upgrading. *(System.Boolean, default: 0)*
 * **Faction**: Default faction (Player, Neutral, Enemy) *(Faction, default: Neutral)*
 * **IgnoreFogOfWar**: Visible even when inside fog of war. *(System.Boolean, default: 0)*
 * **InvisibleToUser**: Invisible in user interface. *(System.Boolean, default: 0)*
 * **IsAutoRemoveScenery**: Scenery that is automatically removed when something is built on top, e.g. a worm. *(System.Boolean, default: 0)*
 * **PreventSpawn**: Prevent object from spawning (for modding). *(System.Boolean, default: 0)*
 * **RegisterToRepository**: Register in object repository. Should usually be true except for UI elements. *(System.Boolean, default: 1)*
 * **Selectable**: Can be selected by clicking on it. *(System.Boolean, default: 0)*
 * **Serializable**: Is saved to save file. *(System.Boolean, default: 1)*
 * **Size**: How many tiles are occupied by this object in either direction. *(System.Int32, default: 1)*
 * **SizeWidth**: Use if a building is not square. Leave empty/as 0 if square.  *(System.Int32, default: 0)*
 * **SoundOnSelect**: Sound to be played when the object is selected. *(System.String, no default)*
 * **Substitutes**: Substitutes for this item. Used for recommendations. (,-separated list of types. *(System.String, no default)*
 * **Tier**: Tier this item belongs to. *(System.Int32, default: 1)*



### LocalizationInfo
Specifies how a thing is called in the game.

 * **Content**: Newline-separated list of string assignments, e.g. ObjectType.Slime = Slime *(System.String, no default)*
 * **Language**: Language for which this block is. (You can have multiple LocalizationInfos in the same file). *(System.String, no default)*



### ModelInfo
Information regarding the voxel model.

 * **AnimationAutoStart**: Animation starts automatically when object is spawned, e.g. UI or scenery. *(System.Boolean, default: 0)*
 * **AnimationAutoSync**: Animation is synced automatically, e.g. harvest indicators. *(System.Boolean, default: 0)*
 * **AnimationFrames**: Number of animation frames (e.g. walking). *(System.Int32, default: 1)*
 * **AnimationRandomOffset**: Random time offset for animation *(System.Single, default: 0)*
 * **AnimationSpeed**: How many animation steps per second. *(System.Single, default: 1)*
 * **BoundingBoxExtent**: Override the size of the bounding box (where to click to select an object). Note: This is overridden when you specify Walls. *(UnityEngine.Vector3, default: 0,0,0)*
 * **BuildFrames**: Number of building animation frames. *(System.Int32, default: 0)*
 * **CombineMeshes**: Combine adjacent meshes. Do not use for non-static things. (used for floor tiles). *(System.Boolean, default: 0)*
 * **CustomMaterial**: Use special material. Used for ocean and water. *(System.String, no default)*
 * **DestroyAfterAnimationCycle**: Used for UI elements. *(System.Boolean, default: 0)*
 * **DoNotSpawn**: Do not actually spawn (used for ocean). *(System.Boolean, default: 0)*
 * **DrawShadows**: Catches shadows from lights. *(System.Boolean, default: 1)*
 * **FogColor1**: Color of special effect fog. (The game picks a random color between 1 and 2 for every particle) *(UnityEngine.Color, default: #00000000)*
 * **FogColor2**: Color of special effect fog. (The game picks a random color between 1 and 2 for every particle) *(UnityEngine.Color, default: #00000000)*
 * **Height**: Height at which arrows etc. are displayed. *(System.Single, default: 1)*
 * **HeightOverride**: Ignore other modifiers and set the height of this object (e.g. for tile overhangs). *(System.Single, default: -1)*
 * **icon**: Icon. (generated internally) *(UnityEngine.Texture2D, no default)*
 * **IconsForAllVariations**: Generate IconsForAllVariations *(System.Boolean, default: 0)*
 * **IndicationArrowAngle**: Direction for the indication arrow *(System.Int32, default: 0)*
 * **MaterialID**: ID of the material to use. (0=standard, 1=transparent) *(System.Int32, default: 0)*
 * **ModelVariations**: Number of model variations (e.g. colonists). To use this, create as many model files, e.g. xxx1.vox, xxx2.vox etc. *(System.Int32, default: 0)*
 * **ModifierStack**: +-separated list of modifiers to be applied when spawning (rtx, rty, rtz, rr). *(System.String, no default)*
 * **Overhang**: Is overhang between two terrain types. *(System.String, no default)*
 * **ScaleX**: Scale in x-dimension. *(System.Single, default: 1)*
 * **ScaleY**: Scale in y-dimension. *(System.Single, default: 1)*
 * **ScaleZ**: Scale in z-dimension. *(System.Single, default: 1)*
 * **ShowIndicationArrow**: Show an arrow when in build mode, e.g. conveyor belts. *(System.Boolean, default: 0)*
 * **SpecialHeight**: Height of special effects. *(System.Single, default: 0)*
 * **SpecialLightColor**: Color of special effect lights. *(UnityEngine.Color, default: #00000000)*
 * **SpecialLightFlicker**: Flicker intensity of special effect lights. *(System.Single, default: 0)*
 * **SpecialLightIntensity**: Intensity of special effect lights. *(System.Single, default: 0)*
 * **SpecialLightNearPlane**: Near plane of this light's shadows. *(System.Single, default: 0)*
 * **SpecialLightRange**: Range of special effect lights. *(System.Single, default: 0)*
 * **SpecialPrefabs**: Special effects to add. Multiple effects can be separated by ;. The syntax for each element is: name of the object,x,y,z *(System.String, default: )*
 * **TopLayerOnly**: Extract top face. Used for tiles. *(System.Boolean, default: 0)*



### RecommendationInfo
Recommendations.

 * **Items**: Items and buildings to be produced. *(System.String, no default)*
 * **Priority**: Priority (Overrides order in which recommendations show up. Leave empty to sort by reward). *(System.Int32, default: 0)*
 * **Reward**: Reward (coins). *(System.Int32, default: 0)*
 * **Title**: Title of the recommendation (localization reference, leave empty for 'set up...'). *(System.String, no default)*



### SimpleAutoAnimationInfo
Information regarding the voxel model.

 * **DestroyAfterCycle**: Destroy after animation cycle. *(System.Boolean, default: 0)*
 * **Frames**: Number of frames. *(System.Int32, default: 1)*
 * **TimePerFrame**: time per Frame. *(System.Single, default: 1)*



### WorkshopRecipeInfo
Recipes for workshops.

 * **CustomName**: Custom name for the recipe (optional). *(System.String, no default)*
 * **Inputs**: List of items needed to build it. *(System.String, no default)*
 * **Outputs**: Output generated by this recipe. *(System.String, no default)*
 * **Probabilities**: List of probabilities for the individual outputs to spawn (e.g. 0.4,0.6 - the sum should be 1 (or is normalized otherwise)). *(System.Single[], no default)*
 * **ProductionTime**: Base time required to build this. *(System.Int32, default: 15)*
 * **ReplaceExistingRecipe**: Replace existing recipe on this object (for modding).  *(System.Boolean, default: 0)*
 * **RequiredToolLevel**: Tool level required to build (0-1=hand, 2=wood, 3=iron...). *(System.Int32, default: 0)*
 * **Workshops**: List of workshops where it can be built. Leave empty for farm produce etc.  *(System.String, no default)*



### ZoneInfo
Zone info (only used internally).

 * **fencePrefab**: Zone fence prefab (only used internally). *(System.String, no default)*



## Items



### ItemInfo
Things that can be produced/mined.

 * **AssistUnload**: How many of this item are to be unloaded in assisted mode. *(System.Int32, default: 0)*
 * **DefaultCargo**: How many of this item are on your ship at the start of the game. *(System.Int32, default: 0)*
 * **FoodValue**: Maximum saturation that can be reached using this food/drink. *(System.Single, default: 100)*
 * **HighStackCount**: How many of this item can be stacked in one tile (high capacity). Leave at 0 for same capacity as StackCount. *(System.Int32, default: 0)*
 * **IsDrink**: Can be drunk. *(System.Boolean, default: 0)*
 * **IsFood**: Can be eaten. *(System.Boolean, default: 0)*
 * **IsWater**: Can be used to water plants. *(System.Boolean, default: 0)*
 * **OverrideExportFalse**: Set to not exportable. *(System.Boolean, default: 0)*
 * **OverrideExportTrue**: Set to exportable. *(System.Boolean, default: 0)*
 * **OverrideImportFalse**: Set to not importable. *(System.Boolean, default: 0)*
 * **OverrideImportTrue**: Set to importable. *(System.Boolean, default: 0)*
 * **OverridePrice**: Price override (-1 = automatic pricing). *(System.Int32, default: -1)*
 * **ProductionTargetAmount**: Production/inventory target amount. *(System.Int32, default: 0)*
 * **StackCount**: How many of this item can be stacked in one tile. *(System.Int32, default: 1)*
 * **StackDist**: Stacking: horizontal distance between stached items. *(System.Single, default: 2.5)*
 * **StackHeight**: Stacking: vertical distance between stacked items. *(System.Single, default: 3.25)*
 * **StackType**: Stacking: Cross, Beside, EndlessStack or Pyramid. *(System.String, no default)*
 * **Weight**: How heavy is an item. (Decreases colonist speed while carrying.) Should be 0.5 (light), 1 (normal) or 2 (heavy) *(System.Single, default: 1)*



### ToolInfo
A tool or weapon.

 * **BaseEffect**: Quality level of the tool. For weapons: damage. *(System.Int32, default: 1)*
 * **TaskType**: Type of the tool (one of Crafting, Agriculture, Mining). *(System.String, default: )*



## MapModifier



### AddMoneyInfo
Add money.

 * **Amount**: Money. *(System.Int32, default: 0)*



### CustomSpawnInfo
Adds a specific custom spawn (e.g. items, monsters etc.) to the map.

 * **EnemySpawn**: If recruiting flag is spawned: What enemies need to be defeated  *(System.String, default: )*
 * **Faction**: Faction of things in this spawn group: Player, Enemy or Neutral. *(Faction, default: Neutral)*
 * **MainPlayerSpawn**: Is this the main player spawn point? *(System.Boolean, default: 0)*
 * **SpawnLevels**: Height levels on which it can spawn. (0=ocean, 1=water, 2=sand, 3=grass, 4=soil, 5=rock) *(System.Int32[], no default)*
 * **SpawnTiles**: Tile types on which it can spawn. *(System.String[], no default)*
 * **ToSpawn**: Things that will be spawned, e.g. 2*Pig,1*RecruitingFlag *(System.String, default: )*



### DifficultyInfo
How many enemy camps to spawn on this map.

 * **Density**: How many camps to spawn per 1000 map tiles. *(System.Single, default: 1.5)*
 * **Difficulty**: Base difficulty. Nearest camp will have around this as a total strength. Furthest camp will have 2x. *(System.Single, default: 50)*
 * **MaxSpawns**: Maximum number of camps to spawn. (-1 to disable) *(System.Int32, default: -1)*
 * **MinSpawns**: Minimum number of camps to spawn. (-1 to disable) *(System.Int32, default: -1)*



### DisableNeedInfo
Needs to disable (usually for tutorials).

 * **Identifiers**: List of needs to disable. *(System.String[], no default)*



### DisableRecommendations
Disable recommendations (usually for tutorials).




### ExactSpawnInfo
Size of the map.

 * **Spawns**: Newline-separated list of spawns. *(System.String, default: )*
 * **SuppressGenericSpawns**: Suppress scenery and enemy camp spawns. *(System.Boolean, default: 1)*
 * **Translate**: Translate content. *(UnityEngine.Vector3, default: 0,0,0)*



### LockButtonInfo
UI Buttons to lock (usually for tutorials).

 * **Identifiers**: List of buttons to lock. *(System.String[], no default)*



### MapSizeInfo
Size of the map.

 * **MinimumHostileDistance**: How far away from the player can enemies spawn (minimum distance)? *(System.Int32, default: 0)*
 * **Size**: Size of the map (one dimension). *(System.Int32, default: 0)*



### MinimumGoodInfo
Minimum goods to ensure (tutorials).

 * **Goods**: List of goods, e.g. 5*log,5*minedrock. *(System.String, no default)*



### ModifierInfo
A map modifier controls the map generation process or adds objectives and goals.

 * **AutoSpawn**: Automatically add one of this group to every map? *(System.Boolean, default: 1)*
 * **Description**: Description key. *(System.String, default: )*
 * **Group**: Group of this modifier. Only one modifier of a given group can be active at the same time (e.g. map size) *(System.String, no default)*
 * **GroupDefault**: Is default of given group. *(System.Boolean, default: 0)*
 * **GroupIndex**: Order in which group items are placed. *(System.Single, default: 0)*
 * **GroupIsMandatory**: A map needs to have one of these. (e.g. map size) *(System.Boolean, default: 0)*
 * **Icon**: Icon to use in UI. *(System.String, default: )*
 * **IntroText**: Name of the introductory text key. *(System.String, default: )*
 * **SpawnOnRandomMaps**: Spawns on random maps. (vs. only when selected manually on the custom map screen) *(System.Boolean, default: 1)*
 * **Visible**: Visible in the custom map screen. *(System.Boolean, default: 1)*



### ObjectiveGroupInfo
A group of objectives (e.g. setup a workshop). 

 * **Bonus**: Optional objective group, can complete map without doing this. *(System.Boolean, default: 0)*
 * **Description**: Description string of this objective group. *(System.String, no default)*
 * **GroupID**: ID of this group (use in related ObjectiveInfos). *(System.String, no default)*
 * **IntroText**: String to display on loading screen. *(System.String, no default)*
 * **ObjectiveGenerator**: (Internal) function to generate objectives. *(System.String, no default)*
 * **OutroText**: String to display when objective group is complete. *(System.String, no default)*
 * **TutorialNum**: Number of this tutorial. Leave at -1 if no tutorial. *(System.Int32, default: -1)*
 * **UnlockButtons**: Buttons to unlock when this group begins. *(System.String[], no default)*
 * **WaitFor**: Wait for group with this id befor beginning this group. *(System.String, no default)*
 * **WaitForSeconds**: Wait for x seconds before showing this group.  *(System.Int32, default: 0)*



### ObjectiveInfo
An objective to be used for an objective group.

 * **GroupID**: ID of the group it belongs to. *(System.String, no default)*
 * **Object2ID**: Depending on objective: object 2 ID *(System.String, no default)*
 * **ObjectID**: Depending on objective: object ID *(System.String, no default)*
 * **ObjectType**: Depending on objective: object type *(System.String, no default)*
 * **Target**: Depending on objective: target *(System.Int32, default: 0)*
 * **TaskGroup**: Depending on objective: task group *(System.String, no default)*
 * **Type**: Type of this objective.  *(System.String, no default)*



### OverrideCargoInfo
Override cargo with target production (usually for testing).

 * **AddXPLevels**: Add XP level to all friendlies. *(System.Single, default: 0)*
 * **Colonists**: Colonists to add. *(System.String, default: )*
 * **Progress**: Progression within tier. *(System.Single, default: 1)*
 * **Tier**: Tier. *(System.Int32, default: 0)*



### OverrideTargetProductionInfo
Override Target Production. (deprecated)

 * **Target**: New targets. *(System.String, default: )*



### RevealMapInfo
Reveal entire map.




### SpawnModifierInfo
Modify spawning amounts.

 * **SpawnModifiers**: List of modifications, e.g. Tree*1.5,Rock*1.75 *(System.String, default: )*



### TerrainModifierInfo
Change the realtive frequency of the different terrain types.

 * **ForceRainbow**: Force rainbow (line wise terrains) *(System.Boolean, default: 0)*
 * **TerrainFrequencyModifiers**: List of 6 numbers for each terrain type. E.g. 1,1,1,1,2,2 for extra mountains. *(System.Single[], default: System.Single[])*



### WaveInfo
An enemy wave. [not active]

 * **Time**: When does wave arrive in s. *(System.Single, default: 0)*
 * **ToSpawn**: What to spawn. *(System.String, no default)*



## ModDescription



### UserModAuthor
Information about the author of the mod. You can have multiple of these in a file. (optional)

 * **AuthorName**: Name/nickname of the author. *(System.String, no default)*
 * **DiscordID**: Your ID on discord (optional). *(System.String, no default)*
 * **Email**: Email of the author (optional). *(System.String, no default)*
 * **Role**: Creator, Co-Creator etc. (optional). *(System.String, no default)*
 * **SteamID**: Your ID on Steam (optional). *(System.String, no default)*



### UserModInfo
Information about the mod.

 * **ModName**: Name of the mod. *(System.String, no default)*
 * **Priority**: Loading priority of this mod. Lower priority = loaded earlier. If your mod depends on no other mod, leave this at 0. If your mod depends on another mod, make sure your priority number is higher than the other mod's priority. *(System.Single, default: 0)*
 * **Required**: Optional: Names of required other mods. *(System.String[], no default)*
 * **Tags**: Tags to be attached to this item. Tags can be: Item, Animal, Gameplay, Workshop, Vehicle, Terrain, Diorama, Other, Building, Farming, Bundle *(System.String[], default: System.String[])*
 * **Version**: Version number *(System.Single, default: 0.1)*



## Scenario



### ScenarioInfo
A fixed scenario consisting of multiple modifiers.

 * **Description**: Description string. *(System.String, default: )*
 * **Icon**: Icon to show in UI. *(System.String, no default)*
 * **MapSeed**: Seed of the map. Leave at 0 for random seed. *(System.Int32, default: 0)*
 * **Modifiers**: List of modifiers. *(System.String[], default: System.String[])*
 * **Number**: Number of scenario (for sorting in UI). *(System.Int32, default: 0)*
 * **Tutorial**: Is tutorial? For metrics and inclusion in tutorial menu. *(System.Boolean, default: 0)*



## Scenery



### AudioInfo
Play an audioclip in a semi-random interval.

 * **ActiveWhenRaining**: Play at raintime. *(System.Boolean, default: 1)*
 * **Ambience**: Count as ambience (for volume setting). *(System.Boolean, default: 1)*
 * **ClipsDaytime**: Name of the (built-in) audio clips that are to be played at daytime (comma-separated). *(System.String, no default)*
 * **ClipsNighttime**: Name of the (built-in) audio clips that are to be played at nighttime (comma-separated). *(System.String, no default)*
 * **Interval**: Interval in seconds. *(System.Single, default: 20)*
 * **SpawnChance**: Probability to spawn this audio effect. Note: Every component and audio source costs performance. Therefore it makes sense to set this to less than 1 for non-critical objects like trees. *(System.Single, default: 1)*
 * **Volume**: Volume. *(System.Single, default: 1)*



### EnemyCampInfo
Information on the setup of a single enemy camp.

 * **EnemySpawn**: What enemies need to be defeated  *(System.String, default: )*
 * **FriendlySpawn**: What captured colonists/animals should spawn here?  *(System.String, default: )*
 * **SpawnTiles**: Tile types on which it can spawn. *(System.String[], no default)*
 * **ToSpawn**: Things that will be spawned, e.g. 2*Pig,1*RecruitingFlag *(System.String, default: )*



### FarmLandInfo
A Farm land.




### MineableInfo
Things that can be mined, e.g. trees

 * **AttachToSoil**: Attach to underlying object, e.g. ore -> soil tile. *(System.Boolean, default: 0)*
 * **MinesTo**: List of things you get from mining. *(System.String, no default)*
 * **RandomLootAmount**: List of random loot you get from mining. *(System.Int32, default: 0)*
 * **RequiredToolLevel**: Tool level required to mine. (0-1=hand, 2=wood, 3=iron...) *(System.Int32, default: 0)*
 * **RequiredToolType**: Tool type required to mine this. *(System.String, default: Mining)*
 * **ShowInUI**: Show in tooltips as a typical source to get the mined items. *(System.Boolean, default: 1)*
 * **SpawnOnRemove**: Thing to spawn after last element is mined. *(System.String, no default)*
 * **TimeToMine**: Base time required to mine this object. *(System.Int32, default: 30)*



### MountainInfo
A mountain.




### NaturalResourceInfo
Things that can be mined by buildings, e.g. oil wells




### PlantInfo
Thing that grows over time.

 * **GrowsOnTile**: Only grows on specific ground tile. Leave empty for no restriction. *(System.String, no default)*
 * **GrowthRateDay**: Growth rate at day time. *(System.Single, default: 1)*
 * **GrowthRateNight**: Growth rate at night time. *(System.Single, default: 0)*
 * **GrowTime**: Tile until fully grown. *(System.Single, default: 60)*
 * **IsCrop**: Can be grown in farm. *(System.Boolean, default: 0)*
 * **IsTree**: Can be grown in grove. *(System.Boolean, default: 0)*
 * **OnlyGrowIn**: Only grows in specified autofarm/grove. Leave empty for no restriction. *(System.String, no default)*
 * **RandomOrientation**: Random rotation of planted crops/trees. *(System.Boolean, default: 1)*
 * **WaterUsage**: Factor of water usage. 1 = water once per plant. *(System.Single, default: 1)*



### PopupInfo
A popup is something that randomly appears in a time interval like the fish or the worms.

 * **Interval**: Approximate time interval in seconds inbetween popups. *(System.Single, default: 0)*



### RallyInfo
Used for the rally flag

 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### RecruitingInfo
Used for the recruiting flag

 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### SpawnerInfo
Adding this to an object will cause it to be automatically spawned onto maps.

 * **CanSpawnOnOtherItems**: Spawn on top of other objects (e.g. clay and ore). *(System.Boolean, default: 0)*
 * **ExactSpawnNumber**: Set the exact number of spawns. Overrides SpawnMinimum and SpawnFrequency. *(System.Int32, default: 0)*
 * **FixedRotation**: Fix the spawn rotation to an angle (-1 for random). *(System.Int32, default: -1)*
 * **MaxX**: Where on the map should it spawn? (Only x-coordinate). *(System.Single, default: 1)*
 * **MinX**: Where on the map should it spawn? (Only x-coordinate). *(System.Single, default: 0)*
 * **NeedsToBeOnShore**: Only spawn where there is water access to the edge of the map. *(System.Boolean, default: 0)*
 * **RequireLevel**: Require specific height level. *(System.Int32, default: -1)*
 * **RequireWalkable**: Only spawn where your people can go. *(System.Boolean, default: 0)*
 * **SpawnClusterExtent**: How spread apart are things in a spawn cluster. *(System.Int32, default: 1)*
 * **SpawnClusterSize**: Number range of objects per spawn (e.g. 3:5 trees). *(NumRange, default: NumRange)*
 * **SpawnCohesive**: Spawn in clumps (e.g. rocks). *(System.Boolean, default: 0)*
 * **SpawnFrequency**: Relative spawning frequency. *(System.Single, default: 0)*
 * **SpawnLevels**: Height levels on which it can spawn. (0=ocean, 1=water, 2=sand, 3=grass, 4=soil, 5=rock) *(System.Int32[], no default)*
 * **SpawnMinimum**: Minimum number of spawns relative to map size (e.g. 0.0001). *(System.Single, default: 0)*
 * **SpawnMinimumTier**: Minimum tier to spawn (0 = all, 1=grassland, 2=desert, 3=dark...) *(System.Int32, default: 0)*
 * **SpawnTiles**: Tiles types on which it can spawn. *(System.String[], no default)*



### VeinInfo
A vein.




### WindInfo
Add to make item affected by wind.




## Terrain



### ShaderInfo
Controls different shader effects.

 * **AmbientOcclusionIntensity**: Intensity of the ambient occlusion effect. *(System.Single, default: 0)*
 * **AmbientOcclusionRadius**: Radius of the ambient occlusion effect. *(System.Single, default: 0)*
 * **BloomIntensity**: Intensity of the bloom effect. *(System.Single, default: 0)*
 * **BloomThreshold**: Brightness threshold for the bloom effect. *(System.Single, default: 0)*
 * **ColorTemperature**: Color temperature. *(System.Single, default: 5)*
 * **EnvironmentParticleColor**: Color of the little environment blocks. *(UnityEngine.Color, default: #00000000)*
 * **RainDuration**: Duration of rain. *(System.Single, default: 50)*
 * **RainTimeBetween**: Time between rain. *(System.Single, default: 500)*
 * **RainTimeBetweenLightning**: Average time between lightning. *(System.Single, default: 8)*
 * **RainTransitionTime**: Time to transition between rain and no rain. *(System.Single, default: 10)*



### SubBiomeInfo
Adds sub biomes, e.g. oases in deserts.

 * **MaxFrequency**: Frequency with which this biome is spawned (in % of tiles, e.g. 0.0005. *(System.Single, default: 0)*
 * **MinFrequency**: Frequency with which this biome is spawned (in % of tiles, e.g. 0.0005. *(System.Single, default: 0)*
 * **MinSpawns**: Minimum number of spawns *(System.Int32, default: 0)*
 * **ObjectsToSpawn**: List of objects to spawn, e.g. 3*Tree,2*Turtle *(System.String, no default)*
 * **SpawnOn**: On which terrain should this be spawned? *(System.String, no default)*
 * **TerrainToSpawn**: List of terrain to spawn, e.g. 10*Floor_Water,10*Floor_Grass *(System.String, no default)*



### TerrainInfo
Adds a terrain type to the game.

 * **ambiencetrackcenter**: Audio track to be played at the center of the map. *(System.String, no default)*
 * **ColorLogisticsConnection**: Color of UI arrow: Logistics Connection. *(UnityEngine.Color, default: #33A6D9FF)*
 * **ColorSettlerActiveTask**: Color of UI arrow: Set Task. *(UnityEngine.Color, default: #00FF00FF)*
 * **ColorStockpileConnectionIn**: Color of UI arrow: Stockpile Connection (in). *(UnityEngine.Color, default: #CFD900FF)*
 * **ColorStockpileConnectionOut**: Color of UI arrow: Stockpile Connection (in). *(UnityEngine.Color, default: #D98700FF)*
 * **FloorByHeight**: List of 6 different floor type names by height, e.g. Floor_Ocean,Floor_Water,Floor_Sand,Floor_Grass,Floor_Earth,Floor_Earth. *(System.String[], default: System.String[])*
 * **MusicPlaylist**: Music playlist (currently empty = grassland, desert = desert. :) *(System.String, no default)*
 * **PositionInWorld**: Position of this terrain type on the world map, e.g. 0.5,0.5 *(System.Single[], default: System.Single[])*
 * **Seed**: Fixed seed of the map. Leave empty for random seed. *(System.Nullable`1[System.Int32], no default)*
 * **SpawnDensity**: What percentage of the tiles will spawn things? *(System.Single, default: 0)*
 * **TerrainFrequencies**: Relative frequency of the 6 floog types, e.g. 0.6,0.1,0.15,0.4,0.1,0 *(System.Single[], default: System.Single[])*
 * **Tier**: Indication of the difficulty of this terrain. *(System.Int32, default: 0)*



### TileInfo
Info for floor tiles.

 * **BuildableGround**: Can build normal buildings here. *(System.Boolean, default: 0)*
 * **ChildHeight**: Height of every item/building on this tile. *(System.Single, default: 0)*
 * **Fertile**: Can build farms here. *(System.Boolean, default: 0)*
 * **FixedRotation**: Fixed rotation (otherwise random). *(System.Boolean, default: 0)*
 * **Level**: Height level (0-1 = ocean/water, 2=sand, 3 = grass/main, 4-5=mountains) *(System.Int32, default: 0)*
 * **SolidGround**: Can place items here and build things like bonfires. *(System.Boolean, default: 0)*
 * **SpawnOnTop**: Items to always spawn on top, e.g. earth -> mountain). *(System.String, no default)*
 * **Walkable**: Can actors walk here? *(System.Boolean, default: 1)*
 * **Wanderable**: Will actors wander here? *(System.Boolean, default: 1)*
 * **Water**: Ships can drive here. *(System.Boolean, default: 0)*
 * **WMColor**: Color of the tile on the world map *(UnityEngine.Color, default: #000000FF)*
 * **WMHeight**: Height of the tile on the world map *(System.Single, default: 0)*
 * **WMScenery**: Scenery block for the world map, frequency,color,height,width *(System.String, default: )*



## Unspecified



## Vehicle



### BackerRaftInfo
A raft carrying things from other backers. (only used internally)




### CargoShipInfo
Cargo ship behavior.

 * **CargoAmount**: Number of cargo spots. *(System.Int32, default: 8)*
 * **CargoHeight**: Relative height of the cargo. *(System.Single, default: 0.6666667)*
 * **Speed**: Speed of the ship. *(System.Single, default: 1)*



### CarriageInfo
Adds a carriage controller.

 * **CarryPosition**: Relative position at which carried goods are displayed. *(UnityEngine.Vector3, default: 0,0,0)*
 * **RotationSpeed**: Rotation speed in degrees per second. *(System.Single, default: 180)*
 * **Speed**: Travel speed of this carriage. *(System.Single, default: 1)*



### LocomotiveInfo
A locomotive for a train.

 * **Acceleration**: Acceleration force of the locomotive in t/s². *(System.Single, default: 0)*
 * **Deacceleration**: Deceleration force of the locomotive in t/s². *(System.Single, default: 0)*
 * **MaxSpeed**: Maximum speed of the train in t/s. *(System.Single, default: 0)*
 * **Price**: Price of the train. *(System.Int32, default: 0)*
 * **WagonType**: The type of the wagon that belongs to this locomotive. *(System.String, default: TrainWagon)*



### OverheadConveyorCartInfo
An overhead conveyor cart.

 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **HeightElevated**: Height when raised. *(System.Single, default: 0.75)*
 * **HeightLowered**: Height when lowered. *(System.Single, default: -0.125)*
 * **HookPrefab**: Type to use as hook. *(System.String, no default)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **Speed**: Speed at which the cart travels. *(System.Single, default: 1)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **VerticalSpeed**: Vertical speed of the cart. *(System.Single, default: 1)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### ShipInfo
Player ship.

 * **CanOverlap**: Can it be placed on top of other buildings? *(System.Boolean, default: 0)*
 * **Category**: Under which category in the build menu it will show up. *(System.String, default: None)*
 * **DownIndicationArrow**: Draw a down indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **ObstacleMap**: Matrix of where colonists can go and what they should avoid. 0=no penalty, 9=avoid; separated by newline and , *(System.String, no default)*
 * **SettlerInteractionSpots**: SettlerInteractionSpots are where your colonists go to, for example, sit on a table. The format is X,Y,Z and then rotation X,Y,Z - Multiple spots are separated by ; *(PositionAndRotation[], no default)*
 * **UpIndicationArrow**: Draw an up indication arrow when building? *(UnityEngine.Vector3, default: 0,0,0)*
 * **WarningFlagPosition**: Position where the warning flag is placed *(UnityEngine.Vector3, default: -1.5,0,-1.5)*



### TrainWagonInfo
A wagon of a train.

 * **Cargo**: Can carry cargo. *(System.Boolean, default: 0)*
 * **CargoHeight**: Height of carried cargo. *(System.Single, default: 0)*



### ZeppelinInfo
Adds a zeppelin controller.

 * **Acceleration**: Acceleration in t/m². *(System.Single, default: 1)*
 * **Altitude**: Travel altitude. *(System.Single, default: 1)*
 * **Resistance**: Wind resistance. *(System.Single, default: 1)*
