'use strict';

//
// Autogenerated by Thrift Compiler (0.6.0-en-exported)
//
// DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
//


// Define types and services

var Thrift = require('../thrift');
var Types = require('./Types');
var Errors = require('./Errors');

module.exports.EDAM_VERSION_MAJOR = 1;

module.exports.EDAM_VERSION_MINOR = 28;

module.exports.PublicUserInfo = Thrift.Struct.define('PublicUserInfo', {
  1: { alias: 'userId', type: Thrift.Type.I32 },
  7: { alias: 'serviceLevel', type: Thrift.Type.I32 },
  4: { alias: 'username', type: Thrift.Type.STRING },
  5: { alias: 'noteStoreUrl', type: Thrift.Type.STRING },
  6: { alias: 'webApiUrlPrefix', type: Thrift.Type.STRING }
});

module.exports.UserUrls = Thrift.Struct.define('UserUrls', {
  1: { alias: 'noteStoreUrl', type: Thrift.Type.STRING },
  2: { alias: 'webApiUrlPrefix', type: Thrift.Type.STRING },
  3: { alias: 'userStoreUrl', type: Thrift.Type.STRING },
  4: { alias: 'utilityUrl', type: Thrift.Type.STRING },
  5: { alias: 'messageStoreUrl', type: Thrift.Type.STRING },
  6: { alias: 'userWebSocketUrl', type: Thrift.Type.STRING }
});

module.exports.AuthenticationResult = Thrift.Struct.define('AuthenticationResult', {
  1: { alias: 'currentTime', type: Thrift.Type.I64 },
  2: { alias: 'authenticationToken', type: Thrift.Type.STRING },
  3: { alias: 'expiration', type: Thrift.Type.I64 },
  4: { alias: 'user', type: Thrift.Type.STRUCT, def: Types.User },
  5: { alias: 'publicUserInfo', type: Thrift.Type.STRUCT, def: module.exports.PublicUserInfo },
  6: { alias: 'noteStoreUrl', type: Thrift.Type.STRING },
  7: { alias: 'webApiUrlPrefix', type: Thrift.Type.STRING },
  8: { alias: 'secondFactorRequired', type: Thrift.Type.BOOL },
  9: { alias: 'secondFactorDeliveryHint', type: Thrift.Type.STRING },
  10: { alias: 'urls', type: Thrift.Type.STRUCT, def: module.exports.UserUrls }
});

module.exports.BootstrapSettings = Thrift.Struct.define('BootstrapSettings', {
  1: { alias: 'serviceHost', type: Thrift.Type.STRING },
  2: { alias: 'marketingUrl', type: Thrift.Type.STRING },
  3: { alias: 'supportUrl', type: Thrift.Type.STRING },
  4: { alias: 'accountEmailDomain', type: Thrift.Type.STRING },
  5: { alias: 'enableFacebookSharing', type: Thrift.Type.BOOL },
  6: { alias: 'enableGiftSubscriptions', type: Thrift.Type.BOOL },
  7: { alias: 'enableSupportTickets', type: Thrift.Type.BOOL },
  8: { alias: 'enableSharedNotebooks', type: Thrift.Type.BOOL },
  9: { alias: 'enableSingleNoteSharing', type: Thrift.Type.BOOL },
  10: { alias: 'enableSponsoredAccounts', type: Thrift.Type.BOOL },
  11: { alias: 'enableTwitterSharing', type: Thrift.Type.BOOL },
  12: { alias: 'enableLinkedInSharing', type: Thrift.Type.BOOL },
  13: { alias: 'enablePublicNotebooks', type: Thrift.Type.BOOL },
  16: { alias: 'enableGoogle', type: Thrift.Type.BOOL }
});

module.exports.BootstrapProfile = Thrift.Struct.define('BootstrapProfile', {
  1: { alias: 'name', type: Thrift.Type.STRING },
  2: { alias: 'settings', type: Thrift.Type.STRUCT, def: module.exports.BootstrapSettings }
});

module.exports.BootstrapInfo = Thrift.Struct.define('BootstrapInfo', {
  1: { alias: 'profiles', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, module.exports.BootstrapProfile) }
});

var UserStore = module.exports.UserStore = {};

UserStore.checkVersion = Thrift.Method.define({
  alias: 'checkVersion',
  args: Thrift.Struct.define('checkVersionArgs', {
    1: { alias: 'clientName', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'edamVersionMajor', type: Thrift.Type.I16, index: 1 },
    3: { alias: 'edamVersionMinor', type: Thrift.Type.I16, index: 2 }
  }),
  result: Thrift.Struct.define('checkVersionResult', {
    0: { alias: 'returnValue', type: Thrift.Type.BOOL }
  })
});

UserStore.getBootstrapInfo = Thrift.Method.define({
  alias: 'getBootstrapInfo',
  args: Thrift.Struct.define('getBootstrapInfoArgs', {
    1: { alias: 'locale', type: Thrift.Type.STRING, index: 0 }
  }),
  result: Thrift.Struct.define('getBootstrapInfoResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: module.exports.BootstrapInfo }
  })
});

UserStore.authenticateLongSession = Thrift.Method.define({
  alias: 'authenticateLongSession',
  args: Thrift.Struct.define('authenticateLongSessionArgs', {
    1: { alias: 'username', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'password', type: Thrift.Type.STRING, index: 1 },
    3: { alias: 'consumerKey', type: Thrift.Type.STRING, index: 2 },
    4: { alias: 'consumerSecret', type: Thrift.Type.STRING, index: 3 },
    5: { alias: 'deviceIdentifier', type: Thrift.Type.STRING, index: 4 },
    6: { alias: 'deviceDescription', type: Thrift.Type.STRING, index: 5 },
    7: { alias: 'supportsTwoFactor', type: Thrift.Type.BOOL, index: 6 }
  }),
  result: Thrift.Struct.define('authenticateLongSessionResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: module.exports.AuthenticationResult },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

UserStore.completeTwoFactorAuthentication = Thrift.Method.define({
  alias: 'completeTwoFactorAuthentication',
  args: Thrift.Struct.define('completeTwoFactorAuthenticationArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'oneTimeCode', type: Thrift.Type.STRING, index: 1 },
    3: { alias: 'deviceIdentifier', type: Thrift.Type.STRING, index: 2 },
    4: { alias: 'deviceDescription', type: Thrift.Type.STRING, index: 3 }
  }),
  result: Thrift.Struct.define('completeTwoFactorAuthenticationResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: module.exports.AuthenticationResult },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

UserStore.revokeLongSession = Thrift.Method.define({
  alias: 'revokeLongSession',
  args: Thrift.Struct.define('revokeLongSessionArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 }
  }),
  result: Thrift.Struct.define('revokeLongSessionResult', {
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

UserStore.authenticateToBusiness = Thrift.Method.define({
  alias: 'authenticateToBusiness',
  args: Thrift.Struct.define('authenticateToBusinessArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 }
  }),
  result: Thrift.Struct.define('authenticateToBusinessResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: module.exports.AuthenticationResult },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

UserStore.getUser = Thrift.Method.define({
  alias: 'getUser',
  args: Thrift.Struct.define('getUserArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 }
  }),
  result: Thrift.Struct.define('getUserResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.User },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

UserStore.getPublicUserInfo = Thrift.Method.define({
  alias: 'getPublicUserInfo',
  args: Thrift.Struct.define('getPublicUserInfoArgs', {
    1: { alias: 'username', type: Thrift.Type.STRING, index: 0 }
  }),
  result: Thrift.Struct.define('getPublicUserInfoResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: module.exports.PublicUserInfo },
    1: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException }
  })
});

UserStore.getPremiumInfo = Thrift.Method.define({
  alias: 'getPremiumInfo',
  args: Thrift.Struct.define('getPremiumInfoArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 }
  }),
  result: Thrift.Struct.define('getPremiumInfoResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.PremiumInfo },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

UserStore.getUserUrls = Thrift.Method.define({
  alias: 'getUserUrls',
  args: Thrift.Struct.define('getUserUrlsArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 }
  }),
  result: Thrift.Struct.define('getUserUrlsResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: module.exports.UserUrls },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

UserStore.inviteToBusiness = Thrift.Method.define({
  alias: 'inviteToBusiness',
  args: Thrift.Struct.define('inviteToBusinessArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'emailAddress', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('inviteToBusinessResult', {
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

UserStore.removeFromBusiness = Thrift.Method.define({
  alias: 'removeFromBusiness',
  args: Thrift.Struct.define('removeFromBusinessArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'emailAddress', type: Thrift.Type.STRING, index: 1 }
  }),
  result: Thrift.Struct.define('removeFromBusinessResult', {
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

UserStore.updateBusinessUserIdentifier = Thrift.Method.define({
  alias: 'updateBusinessUserIdentifier',
  args: Thrift.Struct.define('updateBusinessUserIdentifierArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'oldEmailAddress', type: Thrift.Type.STRING, index: 1 },
    3: { alias: 'newEmailAddress', type: Thrift.Type.STRING, index: 2 }
  }),
  result: Thrift.Struct.define('updateBusinessUserIdentifierResult', {
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException },
    3: { alias: 'notFoundException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMNotFoundException }
  })
});

UserStore.listBusinessUsers = Thrift.Method.define({
  alias: 'listBusinessUsers',
  args: Thrift.Struct.define('listBusinessUsersArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 }
  }),
  result: Thrift.Struct.define('listBusinessUsersResult', {
    0: { alias: 'returnValue', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.UserProfile) },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

UserStore.listBusinessInvitations = Thrift.Method.define({
  alias: 'listBusinessInvitations',
  args: Thrift.Struct.define('listBusinessInvitationsArgs', {
    1: { alias: 'authenticationToken', type: Thrift.Type.STRING, index: 0 },
    2: { alias: 'includeRequestedInvitations', type: Thrift.Type.BOOL, index: 1 }
  }),
  result: Thrift.Struct.define('listBusinessInvitationsResult', {
    0: { alias: 'returnValue', type: Thrift.Type.LIST, def: Thrift.List.define(Thrift.Type.STRUCT, Types.BusinessInvitation) },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException },
    2: { alias: 'systemException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMSystemException }
  })
});

UserStore.getAccountLimits = Thrift.Method.define({
  alias: 'getAccountLimits',
  args: Thrift.Struct.define('getAccountLimitsArgs', {
    1: { alias: 'serviceLevel', type: Thrift.Type.I32, index: 0 }
  }),
  result: Thrift.Struct.define('getAccountLimitsResult', {
    0: { alias: 'returnValue', type: Thrift.Type.STRUCT, def: Types.AccountLimits },
    1: { alias: 'userException', type: Thrift.Type.EXCEPTION, def: Errors.EDAMUserException }
  })
});

// Define UserStore Client

function UserStoreClient(output) {
  this.output = output;
  this.seqid = 0;
}

UserStoreClient.prototype.checkVersion = function (clientName, edamVersionMajor, edamVersionMinor, callback) {
  var mdef = UserStore.checkVersion;
  var args = new mdef.args();
  args.clientName = clientName;
  args.edamVersionMajor = edamVersionMajor;
  args.edamVersionMinor = edamVersionMinor;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

UserStoreClient.prototype.getBootstrapInfo = function (locale, callback) {
  var mdef = UserStore.getBootstrapInfo;
  var args = new mdef.args();
  args.locale = locale;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

UserStoreClient.prototype.authenticateLongSession = function (username, password, consumerKey, consumerSecret, deviceIdentifier, deviceDescription, supportsTwoFactor, callback) {
  var mdef = UserStore.authenticateLongSession;
  var args = new mdef.args();
  args.username = username;
  args.password = password;
  args.consumerKey = consumerKey;
  args.consumerSecret = consumerSecret;
  args.deviceIdentifier = deviceIdentifier;
  args.deviceDescription = deviceDescription;
  args.supportsTwoFactor = supportsTwoFactor;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

UserStoreClient.prototype.completeTwoFactorAuthentication = function (authenticationToken, oneTimeCode, deviceIdentifier, deviceDescription, callback) {
  var mdef = UserStore.completeTwoFactorAuthentication;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.oneTimeCode = oneTimeCode;
  args.deviceIdentifier = deviceIdentifier;
  args.deviceDescription = deviceDescription;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

UserStoreClient.prototype.revokeLongSession = function (authenticationToken, callback) {
  var mdef = UserStore.revokeLongSession;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

UserStoreClient.prototype.authenticateToBusiness = function (authenticationToken, callback) {
  var mdef = UserStore.authenticateToBusiness;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

UserStoreClient.prototype.getUser = function (authenticationToken, callback) {
  var mdef = UserStore.getUser;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

UserStoreClient.prototype.getPublicUserInfo = function (username, callback) {
  var mdef = UserStore.getPublicUserInfo;
  var args = new mdef.args();
  args.username = username;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

UserStoreClient.prototype.getPremiumInfo = function (authenticationToken, callback) {
  var mdef = UserStore.getPremiumInfo;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

UserStoreClient.prototype.getUserUrls = function (authenticationToken, callback) {
  var mdef = UserStore.getUserUrls;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

UserStoreClient.prototype.inviteToBusiness = function (authenticationToken, emailAddress, callback) {
  var mdef = UserStore.inviteToBusiness;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.emailAddress = emailAddress;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

UserStoreClient.prototype.removeFromBusiness = function (authenticationToken, emailAddress, callback) {
  var mdef = UserStore.removeFromBusiness;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.emailAddress = emailAddress;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

UserStoreClient.prototype.updateBusinessUserIdentifier = function (authenticationToken, oldEmailAddress, newEmailAddress, callback) {
  var mdef = UserStore.updateBusinessUserIdentifier;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.oldEmailAddress = oldEmailAddress;
  args.newEmailAddress = newEmailAddress;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

UserStoreClient.prototype.listBusinessUsers = function (authenticationToken, callback) {
  var mdef = UserStore.listBusinessUsers;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

UserStoreClient.prototype.listBusinessInvitations = function (authenticationToken, includeRequestedInvitations, callback) {
  var mdef = UserStore.listBusinessInvitations;
  var args = new mdef.args();
  args.authenticationToken = authenticationToken;
  args.includeRequestedInvitations = includeRequestedInvitations;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

UserStoreClient.prototype.getAccountLimits = function (serviceLevel, callback) {
  var mdef = UserStore.getAccountLimits;
  var args = new mdef.args();
  args.serviceLevel = serviceLevel;
  mdef.sendRequest(this.output, this.seqid++, args, callback);
};

module.exports.UserStore.Client = UserStoreClient;

// Define UserStore Server

function UserStoreServer(service, stransport, Protocol) {
  var methodName;
  this.service = service;
  this.stransport = stransport;
  this.processor = new Thrift.Processor();
  for (methodName in UserStore) {
    if (service[methodName]) {
      this.processor.addMethod(UserStore[methodName], service[methodName].bind(service));
    }
  }
  this.stransport.process = function (input, output, noop) {
    var inprot = new Protocol(input);
    var outprot = new Protocol(output);
    this.processor.process(inprot, outprot, noop);
  }.bind(this);
}

UserStoreServer.prototype.start = function () {
  this.stransport.listen();
};
UserStoreServer.prototype.stop = function () {
  this.stransport.close();
};

module.exports.UserStore.Server = UserStoreServer;