
/*******************************************************
 * Copyright (C) 2018 XMind Ltd. - All Rights Reserved
 *******************************************************/

#include <nan.h>

NAN_METHOD(IapInit);

/*
 * Make the file activated, so that it can be handoff to iOS.
 * arguments:
 *   productID: String
 *   quantity: Integer
 *   callback
 *   productID String - The identifiers of the product to purchase. (The identifier of com.example.app.product1 is product1).
 *   quantity Integer (optional) - The number of items the user wants to purchase.
 *   callback Function (optional) - The callback called when the payment is added to the PaymentQueue.
 *     isProductValid Boolean - Determine if the product is valid and added to the payment queue.
 *
 * You should listen for the transactions-updated event as soon as possible and certainly before you call purchaseProduct.
 */
NAN_METHOD(IapPurchaseProduct);

/*
 * Retrieves the product descriptions.
 * arguments:
 *   productIDs String[] - The identifiers of the products to get.
 *   callback Function - The callback called with the products or an empty array if the products don't exist.
 *      products Product[] - Array of Product objects
 */
NAN_METHOD(IapGetProducts);

/*
 * Returns Boolean, whether a user can make a payment.
 */
NAN_METHOD(IapCanMakePayments);

/*
 * Returns String, the path to the receipt.
 */
NAN_METHOD(IapGetReceiptURL);

/*
 * Completes all pending transactions.
 */
NAN_METHOD(IapFinishAllTransactions);

/*
 * Completes the pending transactions corresponding to the date.
 * arguments:
 *   date String - The ISO formatted date of the transaction to finish.
 */
NAN_METHOD(IapFinishTransactionByDate);

NAN_METHOD(IapRestoreCompletedTransactions);
NAN_METHOD(IapRefreshReceipt);

