#ifndef	__CYBERARTICLE_PLUGIN_INTERFACE_H__
#define	__CYBERARTICLE_PLUGIN_INTERFACE_H__

#include "CyberArticleInterface.h"


#define CAPLUGIN_FLAG_TYPE_NODES_TOOL				0x00000001
#define CAPLUGIN_FLAG_TYPE_EDIT_TOOL				0x00000002
#define CAPLUGIN_FLAG_TYPE_NORMAL_TOOL				0x00000004
#define CAPLUGIN_FLAG_TYPE_IMPORT_TOOL				0x00000008
#define CAPLUGIN_FLAG_TYPE_EXPORT_TOOL				0x00000010
#define CAPLUGIN_FLAG_TYPE_EDIT_FORMAT_TOOL			0x00000020
#define CAPLUGIN_FLAG_TYPE_EDIT_INSERT_TOOL			0x00000040
#define CAPLUGIN_FLAG_TYPE_NEW_ARTICLE_TOOL			0x00000080
#define CAPLUGIN_FLAG_TYPE_EDIT_PROPERTIES_TOOL		0x00000100
#define CAPLUGIN_FLAG_TYPE_BOOK_TOOL				0x00000200
#define CAPLUGIN_FLAG_MENU_BEGIN_GROUP				0x00010000


#define CAPLUGIN_MIS_ENABLED        0x00000000L
#define CAPLUGIN_MIS_UNCHECKED      0x00000000L
#define CAPLUGIN_MIS_DISABLED       0x00000001L
#define CAPLUGIN_MIS_CHECKED		0x00000002L

// {74074DD7-051D-4941-88D1-3E29D793A642}
const GUID IID_ICAPlugin = 
{ 0x74074dd7, 0x51d, 0x4941, { 0x88, 0xd1, 0x3e, 0x29, 0xd7, 0x93, 0xa6, 0x42 } };

interface ICAPlugin: public IUnknown
{
	virtual HRESULT STDMETHODCALLTYPE Init(ICAApp* pApp) = 0;
	virtual HRESULT STDMETHODCALLTYPE Exit() = 0;
	virtual HRESULT STDMETHODCALLTYPE get_Flags(long* pnFlags) = 0;
	virtual HRESULT STDMETHODCALLTYPE put_Flags(long nFlags) = 0;
	virtual HRESULT STDMETHODCALLTYPE get_MenuItemText(BSTR* pbstrDescription) = 0;
	virtual HRESULT STDMETHODCALLTYPE get_MenuItemStatus(long* pnStatus) = 0;
	virtual HRESULT STDMETHODCALLTYPE get_MenuItemOrder(long* pnMenuItemOrder) = 0;
	virtual HRESULT STDMETHODCALLTYPE Execute() = 0;
};

// {434C6434-6BF4-4913-8D70-09E4E5F349E4}
const GUID IID_ICAEditPlugin = 
{ 0x434c6434, 0x6bf4, 0x4913, { 0x8d, 0x70, 0x9, 0xe4, 0xe5, 0xf3, 0x49, 0xe4} };

interface ICAEditPlugin: public IUnknown
{
	virtual HRESULT STDMETHODCALLTYPE put_WebBrowser(IWebBrowser2* pWebBrowser) = 0;
	virtual HRESULT STDMETHODCALLTYPE put_Book(ICABook* pBook) = 0;
	virtual HRESULT STDMETHODCALLTYPE put_Node(ICANode* pNode) = 0;
};

#endif	//__CYBERARTICLE_PLUGIN_INTERFACE_H__
