#ifndef	__CYBERARTICLE_INTERFACE_H__
#define	__CYBERARTICLE_INTERFACE_H__


interface ICAWindow;
interface ICANode;
interface ICANodeCollection;
interface ICABook;


// {9F72B81C-233C-4a65-956F-BF03ED79C96F}
const GUID IID_ICAApp = 
{ 0x9f72b81c, 0x233c, 0x4a65, { 0x95, 0x6f, 0xbf, 0x3, 0xed, 0x79, 0xc9, 0x6f } };

interface ICAApp : public IUnknown
{
	virtual HRESULT __stdcall get_Window(ICAWindow** ppWindow) = 0;
	virtual HRESULT __stdcall get_PasswordStorage(IUnknown** ppPasswordStorageUnk) = 0;
	virtual HRESULT __stdcall ViewHelp(BSTR bstrAppName) = 0;
};

// {FF8F3A9C-4628-4a2d-B5D6-B9C72377BAFB}
const GUID IID_ICAWindow = 
{ 0xff8f3a9c, 0x4628, 0x4a2d, { 0xb5, 0xd6, 0xb9, 0xc7, 0x23, 0x77, 0xba, 0xfb } };

interface ICAWindow : public IUnknown
{
	virtual HRESULT __stdcall get_HWND(HWND* pHwnd) = 0;
	virtual HRESULT __stdcall get_ImageList(HIMAGELIST* phImageList) = 0;
	virtual HRESULT __stdcall get_CurrentFolder(ICANode** ppNode) = 0;
	virtual HRESULT __stdcall get_SelectedNodesCount(long* pnCount) = 0;
	virtual HRESULT __stdcall get_SelectedNodes(ICANodeCollection** ppNodeCollection) = 0;
	virtual HRESULT __stdcall get_NodesCanSelect(ICANodeCollection** ppNodeCollection) = 0;
	virtual HRESULT __stdcall IsFoldersWindowFocused() = 0;
	virtual HRESULT __stdcall IsNodesWindowFocused() = 0;
	virtual HRESULT __stdcall NewArticle(ICANode* pParentNode, BSTR bstrTitle) = 0;
	virtual HRESULT __stdcall NewArticleUsingTemplate(ICANode* pParentNode, BSTR bstrTitle, BSTR bstrTemplateFileName) = 0;
	virtual HRESULT __stdcall EditArticle(ICANode* pArticle) = 0;
	virtual HRESULT __stdcall get_BookCount(long* pnCount) = 0;
	virtual HRESULT __stdcall get_Book(long nBookIndex, ICABook** ppBook) = 0;
	virtual HRESULT __stdcall AddBook(BSTR bstrBookGUID) = 0;
	virtual HRESULT __stdcall CloseBook(BSTR bstrBookGUID) = 0;
	virtual HRESULT __stdcall ViewArticle(BSTR bstrBookGUID, long nArticleNodeID) = 0;};

#endif	//__CYBERARTICLE_INTERFACE_H__

