#ifndef	__CYBERARTICLE_HTML_PLUGIN_INTERFACE_H__
#define	__CYBERARTICLE_HTML_PLUGIN_INTERFACE_H__

// {9F5EDF05-1E8E-4efd-B832-6B5F018A78CD}
const GUID IID_ICAHtmlPlugin = 
{ 0x9f5edf05, 0x1e8e, 0x4efd, { 0xb8, 0x32, 0x6b, 0x5f, 0x1, 0x8a, 0x78, 0xcd } };

interface ICAHtmlTool;
interface ICANode;

#define HPF_PROCESS_HTML_TOOL					0x00000001
#define HPF_CONFIG						0x00010000

interface ICAHtmlPlugin: public IUnknown
{
	virtual HRESULT STDMETHODCALLTYPE Init(ICAHtmlTool* pTool) = 0;
	virtual HRESULT STDMETHODCALLTYPE Exit() = 0;
	virtual HRESULT STDMETHODCALLTYPE get_PluginFlags(long* pnFlags) = 0;
	virtual HRESULT STDMETHODCALLTYPE put_HtmlFlags(long nFlags) = 0;
	virtual HRESULT STDMETHODCALLTYPE Config() = 0;
	virtual HRESULT STDMETHODCALLTYPE OnTag(BSTR bstrTag, BSTR* pbstrResult, VARIANT* pvAdditionalResourceURLs) = 0;
	virtual HRESULT STDMETHODCALLTYPE OnText(BSTR bstrText, BSTR* pbstrResult) = 0;
	virtual HRESULT STDMETHODCALLTYPE OnProgress(long nProgress) = 0;
	virtual HRESULT STDMETHODCALLTYPE OnBeforeProcessNode(ICANode* pNode) = 0;
	virtual HRESULT STDMETHODCALLTYPE OnAfterProcessNode() = 0;
	virtual HRESULT STDMETHODCALLTYPE OnBeforeProcessHtml(BSTR bstrURL, BSTR bstrHtml, BSTR* pbstrResult) = 0;
	virtual HRESULT STDMETHODCALLTYPE OnAfterProcessHtml(BSTR bstrHtml, BSTR* pbstrResult) = 0;
	virtual HRESULT STDMETHODCALLTYPE get_Order(long* pnOrder) = 0;
};


#endif	//__CYBERARTICLE_HTML_PLUGIN_INTERFACE_H__
