#ifndef	__CYBERARTICLE_HTML_PLUGIN_INTERFACE_H__
#define	__CYBERARTICLE_HTML_PLUGIN_INTERFACE_H__


#include <atlstr.h>
#include "WizHelper.h"

#define CYBERARTICLE_HTML_PLUGIN_REG_KEY_NAME		_T("Software\\Wizissoft\\CyberArticle\\Plugins\\Html")


inline BOOL CyberArticleRegisterHtmlPlugin(CLSID clsid, LPCTSTR lpszDescription, BOOL bInitEnabled = TRUE)
{
	CComBSTR bstrClsid(clsid);
	//
	CString strKey = CString(CYBERARTICLE_HTML_PLUGIN_REG_KEY_NAME _T("\\")) + CString(bstrClsid);
	//
	BOOL bCurUser = WizRegWriteString(HKEY_CURRENT_USER, strKey, _T(""), lpszDescription);
	BOOL bAllUser = WizRegWriteString(HKEY_LOCAL_MACHINE, strKey, _T(""), lpszDescription);
	//
	WizRegWriteBool(HKEY_CURRENT_USER, strKey, _T("InitEnabled"), bInitEnabled);
	//
	return bCurUser || bAllUser;
}

inline BOOL CyberArticleUnregisterHtmlPlugin(CLSID clsid)
{
	CComBSTR bstrClsid(clsid);
	//
	BOOL bCurUser = WizRegDeleteKey(HKEY_CURRENT_USER, CString(CYBERARTICLE_HTML_PLUGIN_REG_KEY_NAME _T("\\")) + CString(bstrClsid));
	BOOL bAllUser = WizRegDeleteKey(HKEY_LOCAL_MACHINE, CString(CYBERARTICLE_HTML_PLUGIN_REG_KEY_NAME _T("\\")) + CString(bstrClsid));
	return bCurUser || bAllUser;
}


#endif	//__CYBERARTICLE_HTML_PLUGIN_INTERFACE_H__
