#ifndef	__CYBERARTICLE_EXPORT_PLUGIN_HELPER_H__
#define	__CYBERARTICLE_EXPORT_PLUGIN_HELPER_H__

#include <atlstr.h>
#include "WizHelper.h"

#define CYBERARTICLE_EXPORT_PLUGIN_REG_KEY_NAME		_T("Software\\Wizissoft\\CyberArticle\\Plugins\\Export")


inline BOOL CyberArticleRegisterExportPlugin(CLSID clsid, LPCTSTR lpszDescription)
{
	CComBSTR bstrClsid(clsid);
	//
	BOOL bCurUser = WizRegWriteString(HKEY_CURRENT_USER, CString(CYBERARTICLE_EXPORT_PLUGIN_REG_KEY_NAME _T("\\")) + CString(bstrClsid), _T(""), lpszDescription);
	BOOL bAllUser = WizRegWriteString(HKEY_LOCAL_MACHINE, CString(CYBERARTICLE_EXPORT_PLUGIN_REG_KEY_NAME _T("\\")) + CString(bstrClsid), _T(""), lpszDescription);
	return bCurUser || bAllUser;
}

inline BOOL CyberArticleUnregisterExportPlugin(CLSID clsid)
{
	CComBSTR bstrClsid(clsid);
	//
	BOOL bCurUser = WizRegDeleteKey(HKEY_CURRENT_USER, CString(CYBERARTICLE_EXPORT_PLUGIN_REG_KEY_NAME _T("\\")) + CString(bstrClsid));
	BOOL bAllUser = WizRegDeleteKey(HKEY_LOCAL_MACHINE, CString(CYBERARTICLE_EXPORT_PLUGIN_REG_KEY_NAME _T("\\")) + CString(bstrClsid));
	return bCurUser || bAllUser;
}

#endif	//__CYBERARTICLE_EXPORT_PLUGIN_HELPER_H__
