-- *******************************************************
-- **            Mizus RaidTracker - Options            **
-- **              <http://cosmocanyon.de>              **
-- *******************************************************
--
-- This addon is written and copyrighted by:
--    * Mîzukichan @ EU-Antonidas (2010-2018)
--
--    This file is part of Mizus RaidTracker.
--
--    Mizus RaidTracker is free software: you can redistribute it and/or
--    modify it under the terms of the GNU General Public License as
--    published by the Free Software Foundation, either version 3 of the
--    License, or (at your option) any later version.
--
--    Mizus RaidTracker is distributed in the hope that it will be useful,
--    but WITHOUT ANY WARRANTY; without even the implied warranty of
--    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--    GNU General Public License for more details.
--
--    You should have received a copy of the GNU General Public License
--    along with Mizus RaidTracker.
--    If not, see <http://www.gnu.org/licenses/>.
-- Check for addon table
if (not ClassicRaidTracker) then ClassicRaidTracker = {} end
local mrt = ClassicRaidTracker

--------------
--  Locals  --
--------------
-- I change settings for LibDBIcon here, so I'll need access to it
local LDBIcon = LibStub("LibDBIcon-1.0")

-----------------------
--  Register panels  --
-----------------------
function MRT_Options_MainPanel_OnLoad(panel)
    panel.name = "Classic RaidTracker"
    panel.okay = function(self) MRT_Options_OnOkay(self) end
    panel.cancel = function(self) MRT_Options_OnCancel(self) end
    InterfaceOptions_AddCategory(panel)
end

function MRT_Options_TrackingPanel_OnLoad(panel)
    panel.name = MRT_L.Options["TP_Title"]
    panel.parent = "Classic RaidTracker"
    InterfaceOptions_AddCategory(panel)
end

function MRT_Options_ItemsTrackingPanel_OnLoad(panel)
    panel.name = MRT_L.Options["ITP_Title"]
    panel.parent = "Classic RaidTracker"
    InterfaceOptions_AddCategory(panel)
end

function MRT_Options_AttendancePanel_OnLoad(panel)
    panel.name = MRT_L.Options["AP_Title"]
    panel.parent = "Classic RaidTracker"
    InterfaceOptions_AddCategory(panel)
end

function MRT_Options_ExportPanel_OnLoad(panel)
    panel.name = MRT_L.Options["EP_Title"]
    panel.parent = "Classic RaidTracker"
    InterfaceOptions_AddCategory(panel)
end

--------------------------------------------------------
--  parse values and localization after ADDON_LOADED  --
--------------------------------------------------------
function MRT_Options_ParseValues()
    -- MainPanel
    MRT_Options_MainPanel_Title:SetText(MRT_ADDON_TITLE .. " " ..
                                            MRT_ADDON_VERSION)
    MRT_Options_MainPanel_Description:SetText(MRT_L.Options["MP_Description"])
    MRT_Options_MainPanel_Enabled_CB_Text:SetText(MRT_L.Options["MP_Enabled"])
    MRT_Options_MainPanel_Debug_CB_Text:SetText(MRT_L.Options["MP_Debug"])
    MRT_Options_MainPanel_SlashCmd_EB_Text:SetText(MRT_L.Options["MP_SlashCmd"])
    MRT_Options_MainPanel_MinimapIcon_CB_Text:SetText(
        MRT_L.Options["MP_MinimapIcon"])
    MRT_Options_MainPanel_Prunning_CB_Text:SetText(
        MRT_L.Options["MP_AutoPrunning"])
    MRT_Options_MainPanel_Reset_GUI_Button:SetText(
        MRT_L.Options["MP_ResetGuiPos"])
    -- TrackingPanel
    MRT_Options_TrackingPanel_Title:SetText(MRT_L.Options["TP_TitleText"])
    MRT_Options_TrackingPanel_Description:SetText("")
    MRT_Options_TrackingPanel_Log10MenRaids_CB_Text:SetText(
        MRT_L.Options["TP_Log10MenRaids"])
    MRT_Options_TrackingPanel_LogLFRRaids_CB_Text:SetText(
        MRT_L.Options["TP_LogLFRRaids"])
    MRT_Options_TrackingPanel_LogAVRaids_CB_Text:SetText(
        MRT_L.Options["TP_LogAVRaids"])
    MRT_Options_TrackingPanel_LogClassicRaids_CB_Text:SetText(
        MRT_L.Options["TP_LogClassicRaids"])
    MRT_Options_TrackingPanel_LogBCRaids_CB_Text:SetText(
        MRT_L.Options["TP_LogBCRaids"])
    MRT_Options_TrackingPanel_LogWotLKRaids_CB_Text:SetText(
        MRT_L.Options["TP_LogWotLKRaids"])
    MRT_Options_TrackingPanel_LogCataclysmRaids_CB_Text:SetText(
        MRT_L.Options["TP_LogCataclysmRaids"])
    MRT_Options_TrackingPanel_LogPandariaRaids_CB_Text:SetText(
        MRT_L.Options["TP_LogMoPRaids"])
    MRT_Options_TrackingPanel_LogWarlordsRaids_CB_Text:SetText(
        MRT_L.Options["TP_LogWarlordsRaids"])
    MRT_Options_TrackingPanel_LogLootModePersonal_CB_Text:SetText(
        MRT_L.Options["TP_LogLootModePersonal"])
    MRT_Options_TrackingPanel_CreateNewRaidOnNewZone_CB_Text:SetText(
        MRT_L.Options["TP_CreateNewRaidOnNewZone"])
    MRT_Options_TrackingPanel_UseServerTime_CB_Text:SetText(
        MRT_L.Options["TP_UseServerTime"])
    -- ItemsTrackingPanel
    MRT_Options_ItemsTrackingPanel_Title:SetText(MRT_L.Options["ITP_TitleText"])
    MRT_Options_ItemsTrackingPanel_MinItemQualityToLog_SliderText:SetText(
        MRT_L.Options["TP_MinItemQualityToLog_Desc"])
    MRT_Options_ItemsTrackingPanel_AskForDKPValue_CB_Text:SetText(
        MRT_L.Options["TP_AskForDKPValue"])
    MRT_Options_ItemsTrackingPanel_AskForDKPValuePersonal_CB_Text:SetText(
        MRT_L.Options["TP_AskForDKPValuePersonal"])
    MRT_Options_ItemsTrackingPanel_MinItemQualityToGetCost_SliderText:SetText(
        MRT_L.Options["TP_MinItemQualityToGetCost_Desc"])
    MRT_Options_ItemsTrackingPanel_OnlyTrackItemsAbove_Text:SetText(
        MRT_L.Options["TP_OnlyTrackItemsAbove"])
    MRT_Options_ItemsTrackingPanel_UseEPGPValues_CB_Text:SetText(
        MRT_L.Options["ITP_UseEPGP_GP_Values"])
    MRT_Options_ItemsTrackingPanel_ChooseAutoFocus_Title:SetText(
        MRT_L.Options["ITP_AutoFocus_Title"])
    MRT_Options_ItemsTrackingPanel_Create_ChooseAutoFocus_DropDownMenu()
    MRT_Options_ItemsTrackingPanel_IgnoreEnchantingMats_CB_Text:SetText(
        MRT_L.Options["ITP_IgnoreEnchantingMats"])
    MRT_Options_ItemsTrackingPanel_IgnoreGems_CB_Text:SetText(
        MRT_L.Options["ITP_IgnoreGems"])
    -- AttendancePanel
    MRT_Options_AttendancePanel_Title:SetText(MRT_L.Options["AP_TitleText"])
    MRT_Options_AttendancePanel_Description:SetText("")
    MRT_Options_AttendancePanel_GroupRestriction_Text:SetText(
        MRT_L.Options["AP_GroupRestriction"])
    MRT_Options_AttendancePanel_OfflinePlayers_Text:SetText(
        MRT_L.Options["AP_TrackOfflinePlayers"])
    MRT_Options_AttendancePanel_GA_CB_Text:SetText(
        MRT_L.Options["AP_GuildAttendance"])
    MRT_Options_AttendancePanel_GA_NoAuto_CB_Text:SetText(
        MRT_L.Options["AP_GuildAttendanceNoAuto"])
    MRT_Options_AttendancePanel_GA_UseTrigger_CB_Text:SetText(
        MRT_L.Options["AP_GuildAttendanceUseTrigger"])
    MRT_Options_AttendancePanel_GA_Trigger_EB_Text:SetText(
        MRT_L.Options["AP_GuildAttendanceTrigger"])
    MRT_Options_AttendancePanel_GADuration_SliderText:SetText(
        MRT_L.Options["AP_GuildAttendanceDuration"])
    MRT_Options_AttendancePanel_GA_UseCustomText_CB_Text:SetText(
        MRT_L.Options["AP_GuildAttendanceUseCustomText"])
    MRT_Options_AttendancePanel_GA_CustomText_EB_Title:SetText(
        MRT_L.Options["AP_GuildAttendanceCustomTextTitle"])
    -- ExportPanel
    MRT_Options_ExportPanel_Title:SetText(MRT_L.Options["EP_TitleText"])
    MRT_Options_ExportPanel_ChooseExport_Title:SetText(
        MRT_L.Options["EP_ChooseExport_Title"])
    MRT_Options_ExportPanel_Create_ChooseExport_DropDownMenu()
    MRT_Options_ExportPanel_EnglishExport_CB_Text:SetText(
        MRT_L.Options["EP_EnglishExport"])
    MRT_Options_ExportPanel_XMLExport_Title:SetText(
        MRT_L.Options["EP_AllXMLExportsTitle"])
    MRT_Options_ExportPanel_IgnorePerBossAttendance_CB_Text:SetText(
        MRT_L.Options["EP_CTRT_IgnorePerBossAttendance"])
    MRT_Options_ExportPanel_CTRTExport_Title:SetText(
        MRT_L.Options["EP_CTRTTitleText"])
    MRT_Options_ExportPanel_AddPoorItemToEachBoss_CB_Text:SetText(
        MRT_L.Options["EP_CTRT_AddPoorItem"])
    MRT_Options_ExportPanel_RLIPerBossAttendanceFix_CB_Text:SetText(
        MRT_L.Options["EP_CTRT_RLIAttendanceFix"])
    MRT_Options_ExportPanel_EQDKPExport_Title:SetText(
        MRT_L.Options["EP_EQDKPTitleText"])
    MRT_Options_ExportPanel_EQDKP_RLIPerBossAttendanceFix_CB_Text:SetText(
        MRT_L.Options["EP_CTRT_RLIAttendanceFix"])
    MRT_Options_ExportPanel_TextExport_Title:SetText(
        MRT_L.Options["EP_TextExportTitleText"])
    MRT_Options_ExportPanel_SetDateFormat_EB_Text:SetText(
        MRT_L.Options["EP_SetDateTimeFormat"])
    MRT_Options_ExportPanel_Currency_EB_Text:SetText(
        MRT_L.Options["EP_Currency"])
    -- restore saved options
    MRT_Options_RestoreValues()
end

--------------------------------------------------------------
--  Save changes - if required, change actual trackerstate  --
--------------------------------------------------------------
function MRT_Options_OnOkay(panel)
    MRT_Debug("InterfaceOptions - OkayButton pressed")
    -- MainPanel
    MRT_Options["General_MasterEnable"] =
        MRT_Options_MainPanel_Enabled_CB:GetChecked()
    MRT_Options["General_DebugEnabled"] =
        MRT_Options_MainPanel_Debug_CB:GetChecked()
    MRT_Options["General_SlashCmdHandler"] =
        MRT_Options_MainPanel_SlashCmd_EB:GetText()
    MRT_Options["General_ShowMinimapIcon"] =
        MRT_Options_MainPanel_MinimapIcon_CB:GetChecked()
    MRT_Options["General_PrunnRaidLog"] =
        MRT_Options_MainPanel_Prunning_CB:GetChecked()
    MRT_Options["General_PrunningTime"] =
        MRT_Options_MainPanel_Prunning_Slider:GetValue()
    -- update minimap icon
    if (MRT_Options["General_ShowMinimapIcon"]) then
        MRT_Options.MiniMap_SV.hide = false
        LDBIcon:Show("Classic RaidTracker")
    else
        MRT_Options.MiniMap_SV.hide = true
        LDBIcon:Hide("Classic RaidTracker")
    end
    -- TrackingPanel
    MRT_Options["Tracking_Log10MenRaids"] =
        MRT_Options_TrackingPanel_Log10MenRaids_CB:GetChecked()
    MRT_Options["Tracking_LogLFRRaids"] =
        MRT_Options_TrackingPanel_LogLFRRaids_CB:GetChecked()
    MRT_Options["Tracking_LogAVRaids"] =
        MRT_Options_TrackingPanel_LogAVRaids_CB:GetChecked()
    MRT_Options["Tracking_LogClassicRaids"] =
        MRT_Options_TrackingPanel_LogClassicRaids_CB:GetChecked()
    MRT_Options["Tracking_LogBCRaids"] =
        MRT_Options_TrackingPanel_LogBCRaids_CB:GetChecked()
    MRT_Options["Tracking_LogWotLKRaids"] =
        MRT_Options_TrackingPanel_LogWotLKRaids_CB:GetChecked()
    MRT_Options["Tracking_LogCataclysmRaids"] =
        MRT_Options_TrackingPanel_LogCataclysmRaids_CB:GetChecked()
    MRT_Options["Tracking_LogMoPRaids"] =
        MRT_Options_TrackingPanel_LogPandariaRaids_CB:GetChecked()
    MRT_Options["Tracking_LogWarlordsRaids"] =
        MRT_Options_TrackingPanel_LogWarlordsRaids_CB:GetChecked()
    MRT_Options["Tracking_LogLootModePersonal"] =
        MRT_Options_TrackingPanel_LogLootModePersonal_CB:GetChecked()
    MRT_Options["Tracking_CreateNewRaidOnNewZone"] =
        MRT_Options_TrackingPanel_CreateNewRaidOnNewZone_CB:GetChecked()
    MRT_Options["Tracking_UseServerTime"] =
        MRT_Options_TrackingPanel_UseServerTime_CB:GetChecked()
    -- ItemsTrackingPanel
    MRT_Options["Tracking_MinItemQualityToLog"] =
        MRT_Options_ItemsTrackingPanel_MinItemQualityToLog_Slider:GetValue()
    MRT_Options["Tracking_AskForDKPValue"] =
        MRT_Options_ItemsTrackingPanel_AskForDKPValue_CB:GetChecked()
    MRT_Options["Tracking_AskForDKPValuePersonal"] =
        MRT_Options_ItemsTrackingPanel_AskForDKPValuePersonal_CB:GetChecked()
    MRT_Options["Tracking_MinItemQualityToGetDKPValue"] =
        MRT_Options_ItemsTrackingPanel_MinItemQualityToGetCost_Slider:GetValue()
    MRT_Options["ItemTracking_UseEPGPValues"] =
        MRT_Options_ItemsTrackingPanel_UseEPGPValues_CB:GetChecked()
    MRT_Options["Tracking_AskCostAutoFocus"] =
        MRT_Lib_UIDropDownMenu_GetSelectedID(
            MRT_Options_ItemsTrackingPanel_ChooseAutoFocus_DropDownMenu)
    MRT_Options["ItemTracking_IgnoreEnchantingMats"] =
        MRT_Options_ItemsTrackingPanel_IgnoreEnchantingMats_CB:GetChecked()
    MRT_Options["ItemTracking_IgnoreGems"] =
        MRT_Options_ItemsTrackingPanel_IgnoreGems_CB:GetChecked()
    -- sanity check min item level
    local minILvl = tonumber(
                        MRT_Options_ItemsTrackingPanel_OnlyTrackItemsAbove_EB:GetText())
    if minILvl then
        MRT_Options["Tracking_OnlyTrackItemsAboveILvl"] = minILvl
    else
        MRT_Options_ItemsTrackingPanel_OnlyTrackItemsAbove_EB:SetText(
            MRT_Options["Tracking_OnlyTrackItemsAboveILvl"])
        MRT_Options_ItemsTrackingPanel_OnlyTrackItemsAbove_EB:SetCursorPosition(
            0)
    end
    -- AttendancePanel
    MRT_Options["Attendance_GroupRestriction"] =
        MRT_Options_AttendancePanel_GroupRestriction:GetChecked()
    MRT_Options["Attendance_TrackOffline"] =
        MRT_Options_AttendancePanel_OfflinePlayers:GetChecked()
    MRT_Options["Attendance_GuildAttendanceCheckEnabled"] =
        MRT_Options_AttendancePanel_GA_CB:GetChecked()
    MRT_Options["Attendance_GuildAttendanceCheckNoAuto"] =
        MRT_Options_AttendancePanel_GA_NoAuto_CB:GetChecked()
    MRT_Options["Attendance_GuildAttendanceCheckUseTrigger"] =
        MRT_Options_AttendancePanel_GA_UseTrigger_CB:GetChecked()
    MRT_Options["Attendance_GuildAttendanceCheckTrigger"] =
        MRT_Options_AttendancePanel_GA_Trigger_EB:GetText()
    MRT_Options["Attendance_GuildAttendanceCheckDuration"] =
        MRT_Options_AttendancePanel_GADuration_Slider:GetValue()
    MRT_Options["Attendance_GuildAttendanceUseCustomText"] =
        MRT_Options_AttendancePanel_GA_UseCustomText_CB:GetChecked()
    MRT_Options["Attendance_GuildAttendanceCustomText"] =
        MRT_Options_AttendancePanel_GA_CustomText_EB:GetText()
    -- ExportPanel
    MRT_Options["Export_ExportFormat"] =
        MRT_Lib_UIDropDownMenu_GetSelectedID(
            MRT_Options_ExportPanel_ChooseExport_DropDownMenu)
    MRT_Options["Export_ExportEnglish"] =
        MRT_Options_ExportPanel_EnglishExport_CB:GetChecked()
    MRT_Options["Export_CTRT_IgnorePerBossAttendance"] =
        MRT_Options_ExportPanel_IgnorePerBossAttendance_CB:GetChecked()
    MRT_Options["Export_CTRT_AddPoorItem"] =
        MRT_Options_ExportPanel_AddPoorItemToEachBoss_CB:GetChecked()
    MRT_Options["Export_CTRT_RLIPerBossAttendanceFix"] =
        MRT_Options_ExportPanel_RLIPerBossAttendanceFix_CB:GetChecked()
    MRT_Options["Export_EQDKP_RLIPerBossAttendanceFix"] =
        MRT_Options_ExportPanel_EQDKP_RLIPerBossAttendanceFix_CB:GetChecked()
    MRT_Options["Export_DateTimeFormat"] =
        MRT_Options_ExportPanel_SetDateFormat_EB:GetText()
    MRT_Options["Export_Currency"] =
        MRT_Options_ExportPanel_Currency_EB:GetText()
    -- Set slash command to new value
    SLASH_MIZUSRAIDTRACKER1 = "/" .. MRT_Options["General_SlashCmdHandler"]
    -- If MRT is enabled, check tracking status and adjust to new settings
    if (MRT_Options["General_MasterEnable"]) then
        MRT_CheckZoneAndSizeStatus()
    end
end

----------------------
--  Revert changes  --
----------------------
function MRT_Options_OnCancel(panel)
    MRT_Debug("InterfaceOptions - CancelButton pressed")
    MRT_Options_RestoreValues()
end

function MRT_Options_RestoreValues()
    -- MainPanel
    MRT_Options_MainPanel_Enabled_CB:SetChecked(
        MRT_Options["General_MasterEnable"])
    MRT_Options_MainPanel_Debug_CB:SetChecked(
        MRT_Options["General_DebugEnabled"])
    MRT_Options_MainPanel_SlashCmd_EB:SetText(
        MRT_Options["General_SlashCmdHandler"])
    MRT_Options_MainPanel_SlashCmd_EB:SetCursorPosition(0)
    MRT_Options_MainPanel_MinimapIcon_CB:SetChecked(
        MRT_Options["General_ShowMinimapIcon"])
    MRT_Options_MainPanel_Prunning_CB:SetChecked(
        MRT_Options["General_PrunnRaidLog"])
    MRT_Options_MainPanel_Prunning_Slider:SetValue(
        MRT_Options["General_PrunningTime"])
    MRT_Options_MainPanel_Prunning_SliderValue:SetText(
        tostring(MRT_Options["General_PrunningTime"]) .. " " ..
            MRT_L.Options["MP_Days"])
    -- TrackingPanel
    MRT_Options_TrackingPanel_Log10MenRaids_CB:SetChecked(
        MRT_Options["Tracking_Log10MenRaids"])
    MRT_Options_TrackingPanel_LogLFRRaids_CB:SetChecked(
        MRT_Options["Tracking_LogLFRRaids"])
    MRT_Options_TrackingPanel_LogAVRaids_CB:SetChecked(
        MRT_Options["Tracking_LogAVRaids"])
    MRT_Options_TrackingPanel_LogClassicRaids_CB:SetChecked(
        MRT_Options["Tracking_LogClassicRaids"])
    MRT_Options_TrackingPanel_LogBCRaids_CB:SetChecked(
        MRT_Options["Tracking_LogBCRaids"])
    MRT_Options_TrackingPanel_LogWotLKRaids_CB:SetChecked(
        MRT_Options["Tracking_LogWotLKRaids"])
    MRT_Options_TrackingPanel_LogCataclysmRaids_CB:SetChecked(
        MRT_Options["Tracking_LogCataclysmRaids"])
    MRT_Options_TrackingPanel_LogPandariaRaids_CB:SetChecked(
        MRT_Options["Tracking_LogMoPRaids"])
    MRT_Options_TrackingPanel_LogWarlordsRaids_CB:SetChecked(
        MRT_Options["Tracking_LogWarlordsRaids"])
    MRT_Options_TrackingPanel_LogLootModePersonal_CB:SetChecked(
        MRT_Options["Tracking_LogLootModePersonal"])
    MRT_Options_TrackingPanel_CreateNewRaidOnNewZone_CB:SetChecked(
        MRT_Options["Tracking_CreateNewRaidOnNewZone"])
    MRT_Options_TrackingPanel_UseServerTime_CB:SetChecked(
        MRT_Options["Tracking_UseServerTime"])
    -- ItemsTrackingPanel
    MRT_Options_ItemsTrackingPanel_MinItemQualityToLog_Slider:SetValue(
        MRT_Options["Tracking_MinItemQualityToLog"])
    MRT_Options_ItemsTrackingPanel_MinItemQualityToLog_SliderValue:SetText(
        "|c" .. MRT_ItemColors[MRT_Options["Tracking_MinItemQualityToLog"] + 1] ..
            MRT_ItemValues[MRT_Options["Tracking_MinItemQualityToLog"] + 1])
    MRT_Options_ItemsTrackingPanel_AskForDKPValue_CB:SetChecked(
        MRT_Options["Tracking_AskForDKPValue"])
    MRT_Options_ItemsTrackingPanel_AskForDKPValuePersonal_CB:SetChecked(
        MRT_Options["Tracking_AskForDKPValuePersonal"])
    MRT_Options_ItemsTrackingPanel_MinItemQualityToGetCost_Slider:SetValue(
        MRT_Options["Tracking_MinItemQualityToGetDKPValue"])
    MRT_Options_ItemsTrackingPanel_MinItemQualityToGetCost_SliderValue:SetText(
        "|c" ..
            MRT_ItemColors[MRT_Options["Tracking_MinItemQualityToGetDKPValue"] +
                1] ..
            MRT_ItemValues[MRT_Options["Tracking_MinItemQualityToGetDKPValue"] +
                1])
    MRT_Options_ItemsTrackingPanel_OnlyTrackItemsAbove_EB:SetText(
        MRT_Options["Tracking_OnlyTrackItemsAboveILvl"])
    MRT_Options_ItemsTrackingPanel_OnlyTrackItemsAbove_EB:SetCursorPosition(0)
    MRT_Options_ItemsTrackingPanel_UseEPGPValues_CB:SetChecked(
        MRT_Options["ItemTracking_UseEPGPValues"])
    MRT_Options_ItemsTrackingPanel_Create_ChooseAutoFocus_DropDownMenu()
    MRT_Options_ItemsTrackingPanel_IgnoreEnchantingMats_CB:SetChecked(
        MRT_Options["ItemTracking_IgnoreEnchantingMats"])
    MRT_Options_ItemsTrackingPanel_IgnoreGems_CB:SetChecked(
        MRT_Options["ItemTracking_IgnoreGems"])
    -- AttendancePanel
    MRT_Options_AttendancePanel_GroupRestriction:SetChecked(
        MRT_Options["Attendance_GroupRestriction"])
    MRT_Options_AttendancePanel_OfflinePlayers:SetChecked(
        MRT_Options["Attendance_TrackOffline"])
    MRT_Options_AttendancePanel_GA_CB:SetChecked(
        MRT_Options["Attendance_GuildAttendanceCheckEnabled"])
    MRT_Options_AttendancePanel_GA_NoAuto_CB:SetChecked(
        MRT_Options["Attendance_GuildAttendanceCheckNoAuto"])
    MRT_Options_AttendancePanel_GA_UseTrigger_CB:SetChecked(
        MRT_Options["Attendance_GuildAttendanceCheckUseTrigger"])
    MRT_Options_AttendancePanel_GA_Trigger_EB:SetText(
        MRT_Options["Attendance_GuildAttendanceCheckTrigger"])
    MRT_Options_AttendancePanel_GA_Trigger_EB:SetCursorPosition(0)
    MRT_Options_AttendancePanel_GADuration_Slider:SetValue(
        MRT_Options["Attendance_GuildAttendanceCheckDuration"])
    MRT_Options_AttendancePanel_GADuration_SliderValue:SetText(
        MRT_Options["Attendance_GuildAttendanceCheckDuration"] .. " " ..
            MRT_L.Options["AP_Minutes"])
    MRT_Options_AttendancePanel_GA_UseCustomText_CB:SetChecked(
        MRT_Options["Attendance_GuildAttendanceUseCustomText"])
    MRT_Options_AttendancePanel_GA_CustomText_EB:SetText(
        MRT_Options["Attendance_GuildAttendanceCustomText"])
    -- ExportPanel
    MRT_Options_ExportPanel_Create_ChooseExport_DropDownMenu()
    MRT_Options_ExportPanel_EnglishExport_CB:SetChecked(
        MRT_Options["Export_ExportEnglish"])
    MRT_Options_ExportPanel_IgnorePerBossAttendance_CB:SetChecked(
        MRT_Options["Export_CTRT_IgnorePerBossAttendance"])
    MRT_Options_ExportPanel_AddPoorItemToEachBoss_CB:SetChecked(
        MRT_Options["Export_CTRT_AddPoorItem"])
    MRT_Options_ExportPanel_RLIPerBossAttendanceFix_CB:SetChecked(
        MRT_Options["Export_CTRT_RLIPerBossAttendanceFix"])
    MRT_Options_ExportPanel_EQDKP_RLIPerBossAttendanceFix_CB:SetChecked(
        MRT_Options["Export_EQDKP_RLIPerBossAttendanceFix"])
    MRT_Options_ExportPanel_SetDateFormat_EB:SetText(
        MRT_Options["Export_DateTimeFormat"])
    MRT_Options_ExportPanel_SetDateFormat_EB:SetCursorPosition(0) -- Editboxes in OptionPanels needs its Position at 0 - nasty bug.
    MRT_Options_ExportPanel_Currency_EB:SetText(MRT_Options["Export_Currency"])
    MRT_Options_ExportPanel_Currency_EB:SetCursorPosition(0)
end

------------------------
--  Slider functions  --
------------------------
function MRT_Options_MP_Prunning_Slider(slider)
    local sliderValue = slider:GetValue()
    MRT_Options_MainPanel_Prunning_SliderValue:SetText(
        sliderValue .. " " .. MRT_L.Options["MP_Days"])
end

function MRT_Options_TP_MinItemQualityToLog_Slider(slider)
    local sliderValue = slider:GetValue()
    local sliderText = "|c" .. MRT_ItemColors[sliderValue + 1] ..
                           MRT_ItemValues[sliderValue + 1]
    MRT_Options_ItemsTrackingPanel_MinItemQualityToLog_SliderValue:SetText(
        sliderText)
end

function MRT_Options_TP_MinItemQualityToGetCost_Slider(slider)
    local sliderValue = slider:GetValue()
    local sliderText = "|c" .. MRT_ItemColors[sliderValue + 1] ..
                           MRT_ItemValues[sliderValue + 1]
    MRT_Options_ItemsTrackingPanel_MinItemQualityToGetCost_SliderValue:SetText(
        sliderText)
end

function MRT_Options_AP_GADuration_Slider()
    local sliderValue = MRT_Options_AttendancePanel_GADuration_Slider:GetValue()
    local sliderText = sliderValue .. " " .. MRT_L.Options["AP_Minutes"]
    MRT_Options_AttendancePanel_GADuration_SliderValue:SetText(sliderText)
end

----------------------
--  Button handler  --
----------------------
function MRT_Options_MainPanel_ResetGUIPos()
    MRT_GUIFrame:ClearAllPoints()
    MRT_GUIFrame:SetPoint("CENTER", UIParent, "CENTER")
end

------------------------
--  Create functions  --
------------------------
function MRT_Options_ItemsTrackingPanel_Create_ChooseAutoFocus_DropDownMenu()
    -- Create DropDownFrame
    if (not MRT_Options_ItemsTrackingPanel_ChooseAutoFocus_DropDownMenu) then
        CreateFrame("Frame",
                    "MRT_Options_ItemsTrackingPanel_ChooseAutoFocus_DropDownMenu",
                    MRT_Options_ItemsTrackingPanel,
                    "MRT_Lib_UIDropDownMenuTemplate")
    end
    -- Anchor DropDownFrame
    MRT_Options_ItemsTrackingPanel_ChooseAutoFocus_DropDownMenu:ClearAllPoints()
    MRT_Options_ItemsTrackingPanel_ChooseAutoFocus_DropDownMenu:SetPoint(
        "TOPLEFT", MRT_Options_ItemsTrackingPanel_ChooseAutoFocus_Title,
        "BOTTOMLEFT", -15, -5)
    MRT_Options_ItemsTrackingPanel_ChooseAutoFocus_DropDownMenu:Show()
    -- List of DropDownMenuItems
    local items = {
        MRT_L.Options["ITP_AutoFocus_Always"],
        MRT_L.Options["ITP_AutoFocus_NoCombat"],
        MRT_L.Options["ITP_AutoFocus_Never"]
    }
    -- Click handler function
    local function OnClick(self)
        MRT_Lib_UIDropDownMenu_SetSelectedID(
            MRT_Options_ItemsTrackingPanel_ChooseAutoFocus_DropDownMenu,
            self:GetID())
    end
    -- DropDownMenu initialize function
    local function initialize(self, level)
        local info = MRT_Lib_UIDropDownMenu_CreateInfo()
        for k, v in pairs(items) do
            info = MRT_Lib_UIDropDownMenu_CreateInfo()
            info.text = v
            info.value = v
            info.func = OnClick
            MRT_Lib_UIDropDownMenu_AddButton(info, level)
        end
    end
    -- Setup DropDownMenu
    MRT_Lib_UIDropDownMenu_Initialize(
        MRT_Options_ItemsTrackingPanel_ChooseAutoFocus_DropDownMenu, initialize)
    MRT_Lib_UIDropDownMenu_SetWidth(
        MRT_Options_ItemsTrackingPanel_ChooseAutoFocus_DropDownMenu, 200)
    MRT_Lib_UIDropDownMenu_SetButtonWidth(
        MRT_Options_ItemsTrackingPanel_ChooseAutoFocus_DropDownMenu, 224)
    MRT_Lib_UIDropDownMenu_SetSelectedID(
        MRT_Options_ItemsTrackingPanel_ChooseAutoFocus_DropDownMenu,
        MRT_Options["Tracking_AskCostAutoFocus"])
    MRT_Lib_UIDropDownMenu_JustifyText(
        MRT_Options_ItemsTrackingPanel_ChooseAutoFocus_DropDownMenu, "LEFT")
end

function MRT_Options_ExportPanel_Create_ChooseExport_DropDownMenu()
    -- Create DropDownFrame
    if (not MRT_Options_ExportPanel_ChooseExport_DropDownMenu) then
        CreateFrame("Frame",
                    "MRT_Options_ExportPanel_ChooseExport_DropDownMenu",
                    MRT_Options_ExportPanel, "MRT_Lib_UIDropDownMenuTemplate")
    end
    -- Anchor DropDownFrame
    MRT_Options_ExportPanel_ChooseExport_DropDownMenu:ClearAllPoints()
    MRT_Options_ExportPanel_ChooseExport_DropDownMenu:SetPoint("TOPLEFT",
                                                               MRT_Options_ExportPanel_ChooseExport_Title,
                                                               "BOTTOMLEFT",
                                                               -15, -5)
    MRT_Options_ExportPanel_ChooseExport_DropDownMenu:Show()
    -- List of DropDownMenuItems
    local items = {
        MRT_L.Options["EP_CTRT_compatible"], MRT_L.Options["EP_EQDKP_Plus_XML"],
        MRT_L.Options["EP_MLDKP_15"], MRT_L.Options["EP_DKPBoard"],
        MRT_L.Options["EP_Plain_Text"], MRT_L.Options["EP_BBCode"],
        MRT_L.Options["EP_BBCode_wowhead"], MRT_L.Options["EP_HTML"]
    }
    -- Click handler function
    local function OnClick(self)
        MRT_Lib_UIDropDownMenu_SetSelectedID(
            MRT_Options_ExportPanel_ChooseExport_DropDownMenu, self:GetID())
    end
    -- DropDownMenu initialize function
    local function initialize(self, level)
        local info = MRT_Lib_UIDropDownMenu_CreateInfo()
        for k, v in pairs(items) do
            info = MRT_Lib_UIDropDownMenu_CreateInfo()
            info.text = v
            info.value = v
            info.func = OnClick
            MRT_Lib_UIDropDownMenu_AddButton(info, level)
        end
    end
    -- Setup DropDownMenu
    MRT_Lib_UIDropDownMenu_Initialize(
        MRT_Options_ExportPanel_ChooseExport_DropDownMenu, initialize)
    MRT_Lib_UIDropDownMenu_SetWidth(
        MRT_Options_ExportPanel_ChooseExport_DropDownMenu, 250)
    MRT_Lib_UIDropDownMenu_SetButtonWidth(
        MRT_Options_ExportPanel_ChooseExport_DropDownMenu, 224)
    MRT_Lib_UIDropDownMenu_SetSelectedID(
        MRT_Options_ExportPanel_ChooseExport_DropDownMenu,
        MRT_Options["Export_ExportFormat"])
    MRT_Lib_UIDropDownMenu_JustifyText(
        MRT_Options_ExportPanel_ChooseExport_DropDownMenu, "LEFT")
end

-----------------------
--  ToolTip handler  --
-----------------------
function MRT_Options_SetTT(frame, zone)
    MRT_Options_TT:SetOwner(frame, "ANCHOR_BOTTOMRIGHT")
    MRT_Options_TT:SetText(MRT_L.Options["TT_" .. zone])
    MRT_Options_TT:Show()
end

function MRT_Options_HideTT()
    MRT_Options_TT:Hide()
    MRT_Options_TT:SetOwner(UIParent, "ANCHOR_NONE")
end
