/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.entity;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.ilexiconn.llibrary.LLibrary;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class EntityHelper {
    static int startEntityId = 0;
    private static Field classToIDMappingField;
    private static Field stringToIDMappingField;
    private static List<Class<? extends Entity>> removedEntities;

    public static boolean hasEntityBeenRemoved(Class<? extends Entity> entity) {
        return removedEntities.contains(entity);
    }

    public static void registerEntity(String entityName, Class<? extends Entity> entityClass) {
        int entityId = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID(entityClass, (String)entityName, (int)entityId);
        EntityRegistry.registerModEntity(entityClass, (String)entityName, (int)entityId, (Object)LLibrary.instance, (int)64, (int)1, (boolean)true);
    }

    public static void registerEntity(String entityName, Class<? extends Entity> entityClass, int primaryColor, int secondaryColor) {
        int entityId = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID(entityClass, (String)entityName, (int)entityId, (int)primaryColor, (int)secondaryColor);
        EntityRegistry.registerModEntity(entityClass, (String)entityName, (int)entityId, (Object)LLibrary.instance, (int)64, (int)1, (boolean)true);
    }

    public static void removeLivingEntity(Class<? extends EntityLiving> clazz) {
        EntityHelper.removeEntity(clazz);
        EntityHelper.removeEntityEgg(clazz);
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null) continue;
            EntityRegistry.removeSpawn(clazz, (EnumCreatureType)EnumCreatureType.ambient, (BiomeGenBase[])new BiomeGenBase[]{biome});
            EntityRegistry.removeSpawn(clazz, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])new BiomeGenBase[]{biome});
            EntityRegistry.removeSpawn(clazz, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{biome});
            EntityRegistry.removeSpawn(clazz, (EnumCreatureType)EnumCreatureType.waterCreature, (BiomeGenBase[])new BiomeGenBase[]{biome});
        }
    }

    public static void removeEntity(Class<? extends Entity> clazz) {
        removedEntities.add(clazz);
        EntityList.field_75623_d.remove(clazz);
        Object name = EntityList.field_75626_c.get(clazz);
        EntityList.field_75625_b.remove(name);
        EntityList.field_75626_c.remove(clazz);
        try {
            Map classToIDMapping = (Map)classToIDMappingField.get(null);
            Map stringToIDMapping = (Map)stringToIDMappingField.get(null);
            classToIDMapping.remove(clazz);
            stringToIDMapping.remove(name);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void removeEntityEgg(Class<? extends EntityLiving> clazz) {
        Integer toRemove = null;
        for (Object key : EntityList.field_75627_a.keySet()) {
            Integer intKey = (Integer)key;
            Class entityClass = EntityList.func_90035_a((int)intKey);
            if (!clazz.equals(entityClass)) continue;
            toRemove = intKey;
            break;
        }
        if (toRemove != null) {
            EntityList.field_75627_a.remove(toRemove);
        }
    }

    private static int getUniqueEntityId() {
        while (EntityList.func_75617_a((int)(++startEntityId)) != null) {
        }
        return startEntityId;
    }

    public static Entity getEntityFromClass(Class entityClass, World world) {
        Entity entity = null;
        try {
            entity = (Entity)entityClass.getConstructor(World.class).newInstance(world);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entity;
    }

    static {
        removedEntities = Lists.newArrayList();
        int i = 0;
        for (Field field : EntityList.class.getDeclaredFields()) {
            if (field.getType() != Map.class) continue;
            if (i == 3) {
                field.setAccessible(true);
                classToIDMappingField = field;
            } else if (i == 4) {
                field.setAccessible(true);
                stringToIDMappingField = field;
                break;
            }
            ++i;
        }
    }
}

