/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.screenshot;

import cpw.mods.fml.client.FMLClientHandler;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ScreenshotHelper
implements Runnable {
    private static IntBuffer pixelBuffer;
    private static int[] pixelValues;
    private int width;
    private int height;
    private String captureTime;
    private int[] pixels;
    private Framebuffer frameBuffer;

    public static void saveScreenshotAsync(int width, int height, int[] pixels, Framebuffer frameBuffer) {
        ScreenshotHelper saver = new ScreenshotHelper();
        saver.width = width;
        saver.height = height;
        saver.captureTime = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
        saver.pixels = pixels;
        saver.frameBuffer = frameBuffer;
        new Thread(saver).start();
    }

    public static void takeScreenshot() {
        Minecraft mc = Minecraft.func_71410_x();
        Framebuffer frameBuffer = mc.func_147110_a();
        int screenshotWidth = mc.field_71443_c;
        int screenshotHeight = mc.field_71440_d;
        if (OpenGlHelper.func_148822_b()) {
            screenshotWidth = frameBuffer.field_147622_a;
            screenshotHeight = frameBuffer.field_147620_b;
        }
        int targetCapacity = screenshotWidth * screenshotHeight;
        if (pixelBuffer == null || pixelBuffer.capacity() < targetCapacity) {
            pixelBuffer = BufferUtils.createIntBuffer((int)targetCapacity);
            pixelValues = new int[targetCapacity];
        }
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        pixelBuffer.clear();
        if (OpenGlHelper.func_148822_b()) {
            GL11.glBindTexture((int)3553, (int)frameBuffer.field_147617_g);
            GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)pixelBuffer);
        } else {
            GL11.glReadPixels((int)0, (int)0, (int)screenshotWidth, (int)screenshotHeight, (int)32993, (int)33639, (IntBuffer)pixelBuffer);
        }
        pixelBuffer.get(pixelValues);
        TextureUtil.func_147953_a((int[])pixelValues, (int)screenshotWidth, (int)screenshotHeight);
        int[] pixelCopy = new int[pixelValues.length];
        System.arraycopy(pixelValues, 0, pixelCopy, 0, pixelValues.length);
        ScreenshotHelper.saveScreenshotAsync(screenshotWidth, screenshotHeight, pixelCopy, frameBuffer);
    }

    @Override
    public void run() {
        BufferedImage image;
        if (OpenGlHelper.func_148822_b()) {
            int i;
            image = new BufferedImage(this.frameBuffer.field_147621_c, this.frameBuffer.field_147618_d, 1);
            int diff = i = this.frameBuffer.field_147620_b - this.frameBuffer.field_147618_d;
            while (i < this.frameBuffer.field_147620_b) {
                for (int j = 0; j < this.frameBuffer.field_147621_c; ++j) {
                    int pixel = this.pixels[i * this.frameBuffer.field_147622_a + j];
                    image.setRGB(j, i - diff, pixel);
                }
                ++i;
            }
        } else {
            image = new BufferedImage(this.width, this.height, 1);
            image.setRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
        }
        File ssDir = new File("screenshots");
        File ssFile = new File("screenshots", this.captureTime + ".png");
        int iterator = 0;
        while (ssFile.exists()) {
            ssFile = new File("screenshots", this.captureTime + "_" + ++iterator + ".png");
        }
        try {
            ssDir.mkdirs();
            ImageIO.write((RenderedImage)image, "png", ssFile);
            FMLClientHandler.instance().getClient().field_71439_g.func_146105_b(new ChatComponentText("Saved screenshot as ").func_150257_a(new ChatComponentText(ssFile.getName()).func_150255_a(new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, ssDir.getAbsolutePath())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"gui.llibrary.screenshot")))).func_150228_d(Boolean.valueOf(true)))));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

