/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.render;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ilexiconn.llibrary.client.render.IExtension;
import net.ilexiconn.llibrary.client.render.IModelExtension;
import net.ilexiconn.llibrary.client.render.item.Item3dRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderHelper {
    private static Map<Class<? extends ModelBase>, List<IExtension>> modelExtensions = Maps.newHashMap();
    private static ResourceLocation glintTexture = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    public static void registerModelExtension(IModelExtension modelExtension) {
        RenderHelper.registerModelExtension(ModelBiped.class, modelExtension);
    }

    private static void registerModelExtension(Class<? extends ModelBase> modelClazz, IExtension modelExtension) {
        ArrayList extensionsForModel = modelExtensions.get(modelClazz);
        if (extensionsForModel == null) {
            extensionsForModel = Lists.newArrayList();
        }
        extensionsForModel.add(modelExtension);
        modelExtensions.put(modelClazz, extensionsForModel);
    }

    public static List<IExtension> getModelExtensionsFor(Class<? extends ModelBase> clazz) {
        return modelExtensions.get(clazz);
    }

    public static void renderItemIn3d(ItemStack stack) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        if (textureManager == null) {
            return;
        }
        Item item = stack.func_77973_b();
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)32826);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.03125f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int passes = item.getRenderPasses(stack.func_77960_j());
        for (int pass = 0; pass < passes; ++pass) {
            if (stack.func_94608_d() == 0) {
                textureManager.func_110577_a(TextureMap.field_110575_b);
            } else {
                textureManager.func_110577_a(TextureMap.field_110576_c);
            }
            IIcon icon = item.getIcon(stack, pass);
            float minU = icon.func_94209_e();
            float maxU = icon.func_94212_f();
            float minV = icon.func_94206_g();
            float maxV = icon.func_94210_h();
            RenderHelper.setColorFromInt(item.func_82790_a(stack, pass));
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)maxU, (float)minV, (float)minU, (float)maxV, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)625.0f);
        }
        if (stack.hasEffect(0)) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            textureManager.func_110577_a(glintTexture);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)768, (int)1);
            float f7 = 0.76f;
            GL11.glColor4f((float)(0.5f * f7), (float)(0.25f * f7), (float)(0.8f * f7), (float)1.0f);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            float f8 = 0.125f;
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            float f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
            GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)625.0f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
            GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)625.0f);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public static void setColorFromInt(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
    }

    public static void registerItem3dRenderer(Item item, ModelBase model, ResourceLocation texture) {
        MinecraftForgeClient.registerItemRenderer((Item)item, (IItemRenderer)new Item3dRenderer(item, model, texture));
    }
}

