/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.model.tabula;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Map;
import net.ilexiconn.llibrary.client.model.entity.animation.IModelAnimator;
import net.ilexiconn.llibrary.client.model.modelbase.MowzieModelBase;
import net.ilexiconn.llibrary.client.model.modelbase.MowzieModelRenderer;
import net.ilexiconn.llibrary.client.model.tabula.Animation;
import net.ilexiconn.llibrary.client.model.tabula.AnimationComponent;
import net.ilexiconn.llibrary.client.model.tabula.CubeGroup;
import net.ilexiconn.llibrary.client.model.tabula.CubeInfo;
import net.ilexiconn.llibrary.common.json.container.JsonTabulaModel;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModelJson
extends MowzieModelBase {
    private JsonTabulaModel tabulaModel;
    private Map<MowzieModelRenderer, MowzieModelRenderer> childParentMap = Maps.newHashMap();
    private Map<String, MowzieModelRenderer> nameMap = Maps.newHashMap();
    private Map<String, MowzieModelRenderer> identifierMap = Maps.newHashMap();
    private IModelAnimator animator;
    private ArrayList<Animation> animations = Lists.newArrayList();
    private Animation playingAnimation;
    private int animationTimer;
    private int animationLength;

    public ModelJson(JsonTabulaModel model) {
        this.tabulaModel = model;
        this.field_78090_t = model.getTextureWidth();
        this.field_78089_u = model.getTextureHeight();
        this.animations = model.getAnimations();
        for (CubeInfo c : model.getCubes()) {
            this.cube(c, null);
        }
        for (CubeGroup g : model.getCubeGroups()) {
            this.cubeGroup(g);
        }
        this.setInitPose();
    }

    public ModelJson(JsonTabulaModel model, IModelAnimator animator) {
        this(model);
        this.animator = animator;
    }

    public void func_78088_a(Entity entity, float limbSwing, float limbSwingAmount, float rotation, float rotationYaw, float rotationPitch, float partialTicks) {
        this.func_78087_a(limbSwing, limbSwingAmount, rotation, rotationYaw, rotationPitch, partialTicks, entity);
        double[] scale = this.tabulaModel.getScale();
        GL11.glScaled((double)scale[0], (double)scale[1], (double)scale[2]);
        for (Map.Entry<MowzieModelRenderer, MowzieModelRenderer> cube : this.childParentMap.entrySet()) {
            if (cube.getValue() != null) continue;
            cube.getKey().func_78785_a(partialTicks);
        }
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float rotation, float rotationYaw, float rotationPitch, float partialTicks, Entity entity) {
        super.func_78087_a(limbSwing, limbSwingAmount, rotation, rotationYaw, rotationPitch, partialTicks, entity);
        if (!Minecraft.func_71410_x().func_147113_T()) {
            this.setToInitPose();
            if (this.playingAnimation != null) {
                this.updateAnimation(entity);
            }
            if (this.animator != null) {
                this.animator.setRotationAngles(this, limbSwing, limbSwingAmount, rotation, rotationYaw, rotationPitch, partialTicks, entity);
            }
        }
    }

    private void cubeGroup(CubeGroup group) {
        for (CubeInfo cube : group.cubes) {
            this.cube(cube, null);
        }
        for (CubeGroup c : group.cubeGroups) {
            this.cubeGroup(c);
        }
    }

    private void cube(CubeInfo cube, MowzieModelRenderer parent) {
        MowzieModelRenderer modelRenderer = this.createModelRenderer(cube);
        this.childParentMap.put(modelRenderer, parent);
        this.nameMap.put(cube.name, modelRenderer);
        this.identifierMap.put(cube.identifier, modelRenderer);
        if (parent != null) {
            parent.func_78792_a(modelRenderer);
        }
        for (CubeInfo c : cube.children) {
            this.cube(c, modelRenderer);
        }
    }

    public void startAnimation(int id) {
        if (this.playingAnimation == null) {
            this.playingAnimation = this.animations.get(id);
            this.animationLength = 0;
            for (Map.Entry<String, ArrayList<AnimationComponent>> entry : this.playingAnimation.sets.entrySet()) {
                for (AnimationComponent component : entry.getValue()) {
                    if (component.startKey + component.length <= this.animationLength) continue;
                    this.animationLength = component.startKey + component.length;
                }
            }
            this.animationTimer = 0;
        }
    }

    public void stopAnimation() {
        this.playingAnimation = null;
    }

    public void updateAnimation(Entity entity) {
        for (Map.Entry<String, ArrayList<AnimationComponent>> entry : this.playingAnimation.sets.entrySet()) {
            MowzieModelRenderer animating = this.identifierMap.get(entry.getKey());
            for (AnimationComponent component : entry.getValue()) {
                if (this.animationTimer <= component.startKey) continue;
                int componentTimer = this.animationTimer - component.startKey;
                if (componentTimer > component.length) {
                    componentTimer = component.length;
                }
                animating.field_78800_c = (float)((double)animating.field_78800_c + component.posChange[0] / (double)component.length * (double)componentTimer);
                animating.field_78797_d = (float)((double)animating.field_78797_d + component.posChange[1] / (double)component.length * (double)componentTimer);
                animating.field_78798_e = (float)((double)animating.field_78798_e + component.posChange[2] / (double)component.length * (double)componentTimer);
                animating.field_78795_f = (float)((double)animating.field_78795_f + Math.toRadians(component.rotChange[0] / (double)component.length * (double)componentTimer));
                animating.field_78796_g = (float)((double)animating.field_78796_g + Math.toRadians(component.rotChange[1] / (double)component.length * (double)componentTimer));
                animating.field_78808_h = (float)((double)animating.field_78808_h + Math.toRadians(component.rotChange[2] / (double)component.length * (double)componentTimer));
            }
        }
        this.animationTimer = entity.field_70173_aa % this.animationLength;
        if (this.animationTimer > this.animationLength) {
            if (this.playingAnimation.loops) {
                this.animationTimer = 0;
            } else {
                this.stopAnimation();
            }
        }
    }

    private MowzieModelRenderer createModelRenderer(CubeInfo cubeInfo) {
        MowzieModelRenderer cube = new MowzieModelRenderer(this, cubeInfo.txOffset[0], cubeInfo.txOffset[1]);
        cube.func_78793_a((float)cubeInfo.position[0], (float)cubeInfo.position[1], (float)cubeInfo.position[2]);
        cube.func_78790_a((float)cubeInfo.offset[0], (float)cubeInfo.offset[1], (float)cubeInfo.offset[2], cubeInfo.dimensions[0], cubeInfo.dimensions[1], cubeInfo.dimensions[2], 0.0f);
        cube.field_78795_f = (float)Math.toRadians((float)cubeInfo.rotation[0]);
        cube.field_78796_g = (float)Math.toRadians((float)cubeInfo.rotation[1]);
        cube.field_78808_h = (float)Math.toRadians((float)cubeInfo.rotation[2]);
        return cube;
    }

    public MowzieModelRenderer getCube(String name) {
        return this.nameMap.get(name);
    }

    public boolean isAnimationInProgress() {
        return this.playingAnimation != null;
    }
}

