/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import net.ilexiconn.llibrary.client.gui.GuiChangelog;
import net.ilexiconn.llibrary.client.gui.GuiSlotModUpdateContainerList;
import net.ilexiconn.llibrary.common.json.container.JsonModUpdate;
import net.ilexiconn.llibrary.common.update.ChangelogHandler;
import net.ilexiconn.llibrary.common.update.VersionHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiCheckForUpdates
extends GuiScreen {
    public List<JsonModUpdate> outdatedMods;
    private GuiSlotModUpdateContainerList modList;
    private int selectedIndex;
    private int listWidth;
    private int loadingTimer;
    private boolean failed = false;

    public void func_73866_w_() {
        this.field_146292_n.clear();
        if (this.loadingTimer >= 50) {
            this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 100, this.field_146295_m - 38, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
            for (JsonModUpdate mod : this.outdatedMods) {
                int i = 52;
                this.listWidth = Math.max(this.listWidth, this.getFontRenderer().func_78256_a(mod.name) + i);
                this.listWidth = Math.max(this.listWidth, this.getFontRenderer().func_78256_a(mod.modid) + i);
                this.listWidth = Math.max(this.listWidth, this.getFontRenderer().func_78256_a(mod.currentVersion) + i);
            }
            this.listWidth = Math.min(this.listWidth, 200);
            this.modList = new GuiSlotModUpdateContainerList(this, this.listWidth);
            this.modList.registerScrollButtons(this.field_146292_n, 7, 8);
            this.field_146292_n.add(new GuiButton(1, 20, this.field_146295_m - 38, this.listWidth, 20, I18n.func_135052_a((String)"gui.llibrary.updatecheck.update", (Object[])new Object[0])));
        } else {
            this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 100, this.field_146295_m - 38, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        }
        this.centerDoneButton();
    }

    public void centerDoneButton() {
        int j = 0;
        int k = 0;
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton button = (GuiButton)this.field_146292_n.get(i);
            int id = button.field_146127_k;
            if (id == 0) {
                k = button.field_146128_h;
                continue;
            }
            if (id != 1) continue;
            j = button.field_146128_h + button.field_146120_f;
        }
        if (j > k) {
            ((GuiButton)this.field_146292_n.get((int)0)).field_146128_h += j - k + 20;
        }
    }

    protected void func_146284_a(GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiMainMenu());
        } else if (id == 1 && this.selectedIndex < this.outdatedMods.size()) {
            Desktop desktop;
            JsonModUpdate mod = this.outdatedMods.get(this.selectedIndex);
            Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
            if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                try {
                    desktop.browse(new URI(mod.getUpdateUrl()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void func_73876_c() {
        ++this.loadingTimer;
        if (this.loadingTimer == 50) {
            try {
                this.outdatedMods = VersionHandler.searchForOutdatedModsInefficiently();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.outdatedMods = Lists.newArrayList();
                this.failed = true;
            }
            this.func_73866_w_();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        int i = this.field_146294_l / 2;
        int j = this.field_146295_m / 2;
        if (this.modList != null) {
            this.modList.drawScreen(mouseX, mouseY, partialTicks);
        }
        if (this.outdatedMods == null) {
            int k = this.loadingTimer % 50 / 12;
            String s = (k > 0 ? "." : "") + " " + (k > 1 ? "." : "") + " " + (k > 2 ? "." : "");
            this.drawScaledString(I18n.func_135052_a((String)"gui.llibrary.updatecheck.search", (Object[])new Object[0]) + " " + s, i, j - 20, 0xFFFFFF, 1.5f);
        } else if (this.outdatedMods.isEmpty()) {
            if (this.failed) {
                this.func_73732_a(this.field_146289_q, EnumChatFormatting.RED + I18n.func_135052_a((String)"gui.llibrary.updatecheck.fail", (Object[])new Object[0]), i, j - 30, 0xFFFFFF);
            } else {
                this.drawScaledString(I18n.func_135052_a((String)"gui.llibrary.updatecheck.no_updates.line1", (Object[])new Object[0]), i, j - 40, 0xFFFFFF, 1.5f);
                this.drawScaledString(I18n.func_135052_a((String)"gui.llibrary.updatecheck.no_updates.line2", (Object[])new Object[0]), i, j - 20, 0xFFFFFF, 1.0f);
            }
        } else if (this.selectedIndex < this.outdatedMods.size()) {
            JsonModUpdate mod = this.outdatedMods.get(this.selectedIndex);
            String[] changelog = null;
            try {
                changelog = ChangelogHandler.getChangelog(mod, mod.getNewestVersion());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int k = Math.max(this.modList.getLeft() + this.listWidth + 20 - this.field_146294_l / 2 + 201, 1);
            int l = this.modList.getTop() - this.field_146295_m / 2 + 110;
            GuiChangelog.drawChangelog(this, this.getFontRenderer(), changelog, k, l, mod.getNewestVersion(), mod);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void drawScaledString(String text, int x, int y, int color, float scale) {
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.func_73732_a(this.field_146289_q, text, (int)((float)x / scale), (int)((float)y / scale), color);
        GL11.glPopMatrix();
    }

    public void selectItemIndex(int var1) {
        this.selectedIndex = var1;
    }

    public boolean itemIndexSelected(int var1) {
        return this.selectedIndex == var1;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public Minecraft getMinecraftInstance() {
        return Minecraft.func_71410_x();
    }
}

