/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.tileentity;

import net.ilexiconn.jurassicraft.common.handler.JurassiCraftDNAHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileDNACombinator
extends TileEntity
implements ISidedInventory {
    private static final short combinationSpeed = 100;
    private ItemStack[] slots = new ItemStack[3];
    private short combinationTime = 0;

    public short getCombinationTime() {
        return this.combinationTime;
    }

    public void setCombinationTime(short time) {
        this.combinationTime = time;
    }

    public short getCombinationSpeed() {
        return 100;
    }

    public int getCombinationProgressScaled(int i) {
        return this.getCombinationTime() * i / this.getCombinationSpeed();
    }

    public boolean isCombining() {
        return this.getCombinationTime() > 0;
    }

    private boolean canCombine() {
        if (this.slots[0] == null || this.slots[1] == null) {
            return false;
        }
        if (this.slots[0].func_77973_b() != this.slots[1].func_77973_b()) {
            return false;
        }
        if (!this.slots[0].func_77942_o() || !this.slots[1].func_77942_o()) {
            return false;
        }
        if (!(this.slots[0].func_77978_p().func_74764_b("Quality") && this.slots[1].func_77978_p().func_74764_b("Quality") && this.slots[0].func_77978_p().func_74764_b("DNA") && this.slots[1].func_77978_p().func_74764_b("DNA"))) {
            return false;
        }
        if (this.slots[0].func_77978_p().func_74762_e("Quality") + this.slots[1].func_77978_p().func_74762_e("Quality") > 100) {
            return false;
        }
        return this.slots[2] == null || this.slots[0].func_77973_b() == this.slots[2].func_77973_b() && this.slots[0].func_77978_p().func_74762_e("Quality") + this.slots[1].func_77978_p().func_74762_e("Quality") == this.slots[2].func_77978_p().func_74762_e("Quality");
    }

    private void combineDNA() {
        ItemStack combinedDNA = new ItemStack(this.slots[0].func_77973_b());
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("Quality", this.slots[0].func_77978_p().func_74762_e("Quality") + this.slots[1].func_77978_p().func_74762_e("Quality"));
        compound.func_74778_a("DNA", JurassiCraftDNAHandler.mixTwoDNAs(this.slots[0].func_77978_p().func_74779_i("DNA"), this.slots[1].func_77978_p().func_74779_i("DNA")));
        combinedDNA.func_77982_d(compound);
        --this.slots[0].field_77994_a;
        if (this.slots[0].field_77994_a <= 0) {
            this.slots[0] = null;
        }
        --this.slots[1].field_77994_a;
        if (this.slots[1].field_77994_a <= 0) {
            this.slots[1] = null;
        }
        if (this.slots[2] != null) {
            ++this.slots[2].field_77994_a;
        } else {
            this.slots[2] = combinedDNA;
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.canCombine()) {
                this.combinationTime = (short)(this.combinationTime + 1);
                if (this.getCombinationTime() >= this.getCombinationSpeed()) {
                    this.setCombinationTime((short)0);
                    this.combineDNA();
                }
            } else {
                this.setCombinationTime((short)0);
            }
        }
    }

    public boolean hasItems() {
        return this.slots[0] != null || this.slots[1] != null || this.slots[2] != null;
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70298_a(int i, int stackSize) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= stackSize) {
                ItemStack splitedStack = this.slots[i];
                this.slots[i] = null;
                return splitedStack;
            }
            ItemStack splitedStack = this.slots[i].func_77979_a(stackSize);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return splitedStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "DNA Combiner";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return false;
    }

    public int[] func_94128_d(int i) {
        return new int[]{0};
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            byte k = compound.func_74771_c("Slot");
            if (k < 0 || k >= this.slots.length) continue;
            this.slots[k] = ItemStack.func_77949_a((NBTTagCompound)compound);
        }
        this.setCombinationTime(nbt.func_74765_d("CombinationTime"));
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("CombinationTime", this.getCombinationTime());
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }
}

