/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.tileentity.fence;

import java.util.HashMap;
import net.ilexiconn.jurassicraft.common.api.IFenceBase;
import net.ilexiconn.jurassicraft.common.api.IFenceGrid;
import net.ilexiconn.jurassicraft.common.api.IFencePole;
import net.ilexiconn.jurassicraft.common.block.fence.BlockSecurityFenceLowCorner;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemRedstone;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileSecurityFence
extends TileEntity
implements ISidedInventory {
    private ItemStack[] slots = new ItemStack[2];
    private byte[] fenceSecurityLevel = new byte[4];
    private byte fenceDirection = 0;
    private short fenceGridsStored = 0;
    private short fenceBasesStored = 0;
    private short fencePolesStored = 0;

    public int getFenceGridsStored() {
        return this.fenceGridsStored;
    }

    public void setFenceGridsStored(short fenceGrids) {
        this.fenceGridsStored = fenceGrids;
    }

    public int getFenceBasesStored() {
        return this.fenceBasesStored;
    }

    public void setFenceBasesStored(short fenceBases) {
        this.fenceBasesStored = fenceBases;
    }

    public int getFencePolesStored() {
        return this.fencePolesStored;
    }

    public void setFencePolesStored(short fencePoles) {
        this.fencePolesStored = fencePoles;
    }

    public byte getSecurityLevel(int direction) {
        return this.fenceSecurityLevel[direction];
    }

    public void setSecurityLevel(byte securityLV, int direction) {
        if (securityLV > -1 && securityLV < 4) {
            this.fenceSecurityLevel[direction] = securityLV;
        }
    }

    public byte getDirection() {
        return this.fenceDirection;
    }

    public void setDirection(byte dir) {
        this.fenceDirection = dir;
    }

    public boolean isFenceBuilt(int direction) {
        return this.fenceSecurityLevel[direction] > 0;
    }

    public byte getHeightPlanned(int level) {
        switch (level) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 5;
            }
        }
        return 0;
    }

    public boolean hasIronIngots() {
        return this.slots[0] != null && this.slots[0].func_77973_b().func_77658_a().equals("item.ingotIron");
    }

    public boolean hasRedstone() {
        return this.slots[1] != null && this.slots[1].func_77973_b() instanceof ItemRedstone;
    }

    public boolean hasFenceBases() {
        return this.fenceBasesStored > 0;
    }

    public boolean hasFenceGrids() {
        return this.fenceGridsStored > 0;
    }

    public boolean hasFencePoles() {
        return this.fencePolesStored > 0;
    }

    public boolean isSecurityLevelValid(int level) {
        return level > -1 && level < 4;
    }

    public boolean isFenceValid(int direction, int level) {
        if (level == 0) {
            return this.fenceSecurityLevel[direction] <= 0;
        }
        if (level == 1 || level == 2 || level == 3) {
            return this.fenceSecurityLevel[direction] > 0;
        }
        return false;
    }

    public boolean isDistanceValid(int distance) {
        return distance > 0 && distance < 12;
    }

    public boolean isHeightValid(int height) {
        return height > 0 && height < 7;
    }

    public int getRequiredFenceGrids(int securityLV, int direction) {
        return this.getHeightPlanned(securityLV) * (this.calculateDistanceToNextPole(direction) - 1);
    }

    public boolean hasEnoughFenceGrids(int securityLV, int direction) {
        TileSecurityFence nextFence;
        TileEntity tileEntity = null;
        switch (direction) {
            case 0: {
                tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + this.calculateDistanceToNextPole(direction));
                break;
            }
            case 1: {
                tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c - this.calculateDistanceToNextPole(direction), this.field_145848_d, this.field_145849_e);
                break;
            }
            case 2: {
                tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - this.calculateDistanceToNextPole(direction));
                break;
            }
            case 3: {
                tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + this.calculateDistanceToNextPole(direction), this.field_145848_d, this.field_145849_e);
            }
        }
        if (tileEntity instanceof TileSecurityFence && ((nextFence = (TileSecurityFence)tileEntity).hasFenceGrids() && nextFence.isSecurityLevelValid(securityLV) || this.hasFenceGrids() && this.isSecurityLevelValid(securityLV))) {
            return this.getFenceGridsStored() + nextFence.getFenceGridsStored() >= this.getRequiredFenceGrids(securityLV, direction);
        }
        return false;
    }

    public int getRequiredFenceBases(int direction) {
        return this.calculateDistanceToNextPole(direction) - 1;
    }

    public boolean hasEnoughFenceBases(int securityLV, int direction) {
        TileSecurityFence nextFence;
        TileEntity tileEntity = null;
        switch (direction) {
            case 0: {
                tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + this.calculateDistanceToNextPole(direction));
                break;
            }
            case 1: {
                tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c - this.calculateDistanceToNextPole(direction), this.field_145848_d, this.field_145849_e);
                break;
            }
            case 2: {
                tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - this.calculateDistanceToNextPole(direction));
                break;
            }
            case 3: {
                tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + this.calculateDistanceToNextPole(direction), this.field_145848_d, this.field_145849_e);
            }
        }
        if (tileEntity instanceof TileSecurityFence && ((nextFence = (TileSecurityFence)tileEntity).hasFenceBases() && nextFence.isSecurityLevelValid(securityLV) || this.hasFenceBases() && this.isSecurityLevelValid(securityLV))) {
            return this.getFenceBasesStored() + nextFence.getFenceBasesStored() >= this.getRequiredFenceBases(direction);
        }
        return false;
    }

    public int getRequiredFencePoles(int securityLV) {
        if (securityLV == 0 || securityLV == 2) {
            return 4;
        }
        return 2;
    }

    public boolean hasEnoughFencePoles(int securityLV) {
        TileSecurityFence nextFence;
        TileEntity tileEntity = null;
        switch (this.fenceDirection) {
            case 0: {
                tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + this.calculateDistanceToNextPole(this.fenceDirection));
                break;
            }
            case 1: {
                tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c - this.calculateDistanceToNextPole(this.fenceDirection), this.field_145848_d, this.field_145849_e);
                break;
            }
            case 2: {
                tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - this.calculateDistanceToNextPole(this.fenceDirection));
                break;
            }
            case 3: {
                tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + this.calculateDistanceToNextPole(this.fenceDirection), this.field_145848_d, this.field_145849_e);
            }
        }
        if (tileEntity instanceof TileSecurityFence && ((nextFence = (TileSecurityFence)tileEntity).hasFencePoles() && nextFence.isSecurityLevelValid(securityLV) || this.hasFencePoles() && this.isSecurityLevelValid(securityLV))) {
            return this.getFencePolesStored() + nextFence.getFencePolesStored() >= this.getRequiredFencePoles(securityLV);
        }
        return false;
    }

    private boolean hasSecurityFenceMainBlockAt(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) instanceof BlockSecurityFenceLowCorner;
    }

    public boolean canCraftBases(int number) {
        return number > 0 && this.slots[0] != null && this.slots[0].field_77994_a - 8 * number > -1 && this.getFenceBasesStored() + number <= 256;
    }

    public boolean canCraftGrids(int number) {
        return number > 0 && this.slots[0] != null && this.slots[1] != null && this.slots[0].field_77994_a - 1 * number > -1 && this.slots[1].field_77994_a - 3 * number > -1 && this.getFenceGridsStored() + number <= 256;
    }

    public boolean canCraftPoles(int number) {
        return number > 0 && this.slots[0] != null && this.slots[1] != null && this.slots[0].field_77994_a - 6 * number > -1 && this.slots[1].field_77994_a - 4 * number > -1 && this.getFencePolesStored() + number <= 256;
    }

    public void tryToIncreaseFenceBases(int number) {
        if (this.canCraftBases(number)) {
            this.setFenceBasesStored((short)(this.getFenceBasesStored() + number));
            this.slots[0].field_77994_a -= 8 * number;
            if (this.slots[0].field_77994_a < 1) {
                this.slots[0] = null;
            }
        }
    }

    public void tryToIncreaseFenceGrids(int number) {
        if (this.canCraftGrids(number)) {
            this.setFenceGridsStored((short)(this.getFenceGridsStored() + number));
            this.slots[0].field_77994_a -= 1 * number;
            if (this.slots[0].field_77994_a < 1) {
                this.slots[0] = null;
            }
            this.slots[1].field_77994_a -= 3 * number;
            if (this.slots[1].field_77994_a < 1) {
                this.slots[1] = null;
            }
        }
    }

    public void tryToIncreaseFencePoles(int number) {
        if (this.canCraftPoles(number)) {
            this.setFencePolesStored((short)(this.getFencePolesStored() + number));
            this.slots[0].field_77994_a -= 6 * number;
            if (this.slots[0].field_77994_a < 1) {
                this.slots[0] = null;
            }
            this.slots[1].field_77994_a -= 4 * number;
            if (this.slots[1].field_77994_a < 1) {
                this.slots[1] = null;
            }
        }
    }

    private boolean hasSecurityFencePoleAt(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) instanceof IFencePole;
    }

    private boolean hasSecurityFenceGridAt(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) instanceof IFenceGrid;
    }

    private boolean hasSecurityFenceBaseAt(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) instanceof IFenceBase;
    }

    public TileSecurityFence getNextFence(TileSecurityFence fence, int direction) {
        TileEntity tileEntity = null;
        switch (direction) {
            case 0: {
                for (int i = 1; i < 12; ++i) {
                    if (!fence.hasSecurityFenceMainBlockAt(fence.field_145850_b, fence.field_145851_c, fence.field_145848_d, fence.field_145849_e + i)) continue;
                    tileEntity = fence.field_145850_b.func_147438_o(fence.field_145851_c, fence.field_145848_d, fence.field_145849_e + i);
                }
                break;
            }
            case 1: {
                for (int i = 1; i < 12; ++i) {
                    if (!fence.hasSecurityFenceMainBlockAt(fence.field_145850_b, fence.field_145851_c - i, fence.field_145848_d, fence.field_145849_e)) continue;
                    tileEntity = fence.field_145850_b.func_147438_o(fence.field_145851_c - i, fence.field_145848_d, fence.field_145849_e);
                }
                break;
            }
            case 2: {
                for (int i = 1; i < 12; ++i) {
                    if (!fence.hasSecurityFenceMainBlockAt(fence.field_145850_b, fence.field_145851_c, fence.field_145848_d, fence.field_145849_e - i)) continue;
                    tileEntity = fence.field_145850_b.func_147438_o(fence.field_145851_c, fence.field_145848_d, fence.field_145849_e - i);
                }
                break;
            }
            case 3: {
                for (int i = 1; i < 12; ++i) {
                    if (!fence.hasSecurityFenceMainBlockAt(fence.field_145850_b, fence.field_145851_c + i, fence.field_145848_d, fence.field_145849_e)) continue;
                    tileEntity = fence.field_145850_b.func_147438_o(fence.field_145851_c + i, fence.field_145848_d, fence.field_145849_e);
                }
                break;
            }
        }
        if (tileEntity instanceof TileSecurityFence) {
            return (TileSecurityFence)tileEntity;
        }
        return null;
    }

    public TileSecurityFence getNextFence(TileSecurityFence fence, int direction, int distance) {
        TileEntity tileEntity = null;
        switch (direction) {
            case 0: {
                tileEntity = fence.field_145850_b.func_147438_o(fence.field_145851_c, fence.field_145848_d, fence.field_145849_e + distance);
                break;
            }
            case 1: {
                tileEntity = fence.field_145850_b.func_147438_o(fence.field_145851_c - distance, fence.field_145848_d, fence.field_145849_e);
                break;
            }
            case 2: {
                tileEntity = fence.field_145850_b.func_147438_o(fence.field_145851_c, fence.field_145848_d, fence.field_145849_e - distance);
                break;
            }
            case 3: {
                tileEntity = fence.field_145850_b.func_147438_o(fence.field_145851_c + distance, fence.field_145848_d, fence.field_145849_e);
            }
        }
        if (tileEntity instanceof TileSecurityFence) {
            return (TileSecurityFence)tileEntity;
        }
        return null;
    }

    public int calculateDistanceToNextPole(int direction) {
        switch (direction) {
            case 0: {
                for (int i = 1; i < 12; ++i) {
                    if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + i)) continue;
                    return i;
                }
                break;
            }
            case 1: {
                for (int i = 1; i < 12; ++i) {
                    if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c - i, this.field_145848_d, this.field_145849_e)) continue;
                    return i;
                }
                break;
            }
            case 2: {
                for (int i = 1; i < 12; ++i) {
                    if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - i)) continue;
                    return i;
                }
                break;
            }
            case 3: {
                for (int i = 1; i < 12; ++i) {
                    if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c + i, this.field_145848_d, this.field_145849_e)) continue;
                    return i;
                }
                break;
            }
        }
        return 0;
    }

    public int calculateHeighOfThePole() {
        int i = 0;
        while (this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + i + 1, this.field_145849_e)) {
            ++i;
        }
        return i;
    }

    public HashMap<Integer, int[]> getAllMainBlocks() {
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        int numberOfBlocks = 0;
        for (int i = -11; i < 12; ++i) {
            for (int k = -11; k < 12; ++k) {
                if (!this.hasSecurityFenceGridAt(this.field_145850_b, this.field_145851_c + i, this.field_145848_d, this.field_145849_e + k) && !this.hasSecurityFenceBaseAt(this.field_145850_b, this.field_145851_c + i, this.field_145848_d, this.field_145849_e + k) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c + i, this.field_145848_d, this.field_145849_e + k) && !this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c + i, this.field_145848_d, this.field_145849_e + k)) continue;
                map.put(numberOfBlocks, new int[]{i, k});
                ++numberOfBlocks;
            }
        }
        return map;
    }

    public int[] getBlocksToRepair(int security, int direction) {
        return this.getBlocksToRepair(security, direction, this.calculateDistanceToNextPole(direction));
    }

    public int[] getBlocksToRepair(int security, int direction, int distance) {
        int[] brokenBlocks;
        block32: {
            block31: {
                brokenBlocks = new int[3];
                int height = 0;
                switch (security) {
                    case 1: {
                        height = 2;
                        break;
                    }
                    case 2: {
                        height = 3;
                        break;
                    }
                    case 3: {
                        height = 5;
                    }
                }
                if (security <= 0 || security >= 4) break block31;
                switch (direction) {
                    case 0: {
                        int i;
                        for (i = 1; i < distance; ++i) {
                            if (this.hasSecurityFenceBaseAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + i)) continue;
                            brokenBlocks[0] = brokenBlocks[0] + 1;
                        }
                        for (i = 1; i < distance; ++i) {
                            for (int j = 1; j <= height; ++j) {
                                if (this.hasSecurityFenceGridAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e + i)) continue;
                                brokenBlocks[1] = brokenBlocks[1] + 1;
                            }
                        }
                        for (int j = 1; j <= height; ++j) {
                            if (!this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e)) {
                                brokenBlocks[2] = brokenBlocks[2] + 1;
                            }
                            if (this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e + distance)) continue;
                            brokenBlocks[2] = brokenBlocks[2] + 1;
                        }
                        break block32;
                    }
                    case 1: {
                        int i;
                        for (i = 1; i < distance; ++i) {
                            if (this.hasSecurityFenceBaseAt(this.field_145850_b, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)) continue;
                            brokenBlocks[0] = brokenBlocks[0] + 1;
                        }
                        for (i = 1; i < distance; ++i) {
                            for (int j = 1; j <= height; ++j) {
                                if (this.hasSecurityFenceGridAt(this.field_145850_b, this.field_145851_c - 1, this.field_145848_d + j, this.field_145849_e)) continue;
                                brokenBlocks[1] = brokenBlocks[1] + 1;
                            }
                        }
                        for (int j = 1; j <= height; ++j) {
                            if (!this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e)) {
                                brokenBlocks[2] = brokenBlocks[2] + 1;
                            }
                            if (this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c - distance, this.field_145848_d + j, this.field_145849_e)) continue;
                            brokenBlocks[2] = brokenBlocks[2] + 1;
                        }
                        break block32;
                    }
                    case 2: {
                        int i;
                        for (i = 1; i < distance; ++i) {
                            if (this.hasSecurityFenceBaseAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - i)) continue;
                            brokenBlocks[0] = brokenBlocks[0] + 1;
                        }
                        for (i = 1; i < distance; ++i) {
                            for (int j = 1; j <= height; ++j) {
                                if (this.hasSecurityFenceGridAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e - i)) continue;
                                brokenBlocks[1] = brokenBlocks[1] + 1;
                            }
                        }
                        for (int j = 1; j <= height; ++j) {
                            if (!this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e)) {
                                brokenBlocks[2] = brokenBlocks[2] + 1;
                            }
                            if (this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e - distance)) continue;
                            brokenBlocks[2] = brokenBlocks[2] + 1;
                        }
                        break block32;
                    }
                    case 3: {
                        int i;
                        for (i = 1; i < distance; ++i) {
                            if (this.hasSecurityFenceBaseAt(this.field_145850_b, this.field_145851_c + i, this.field_145848_d, this.field_145849_e)) continue;
                            brokenBlocks[0] = brokenBlocks[0] + 1;
                        }
                        for (i = 1; i < distance; ++i) {
                            for (int j = 1; j <= height; ++j) {
                                if (this.hasSecurityFenceGridAt(this.field_145850_b, this.field_145851_c + i, this.field_145848_d + j, this.field_145849_e)) continue;
                                brokenBlocks[1] = brokenBlocks[1] + 1;
                            }
                        }
                        for (int j = 1; j <= height; ++j) {
                            if (!this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e)) {
                                brokenBlocks[2] = brokenBlocks[2] + 1;
                            }
                            if (this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c + distance, this.field_145848_d + j, this.field_145849_e)) continue;
                            brokenBlocks[2] = brokenBlocks[2] + 1;
                        }
                        break;
                    }
                }
                break block32;
            }
            brokenBlocks = new int[]{0, 0, 0};
        }
        return brokenBlocks;
    }

    public boolean canRepair(int security, int direction) {
        int distance = this.calculateDistanceToNextPole(direction);
        int height = 0;
        switch (security) {
            case 1: {
                height = 2;
                break;
            }
            case 2: {
                height = 3;
                break;
            }
            case 3: {
                height = 5;
            }
        }
        if (security > 0 && security < 4) {
            switch (direction) {
                case 0: {
                    int i;
                    for (i = 1; i < distance; ++i) {
                        if (this.hasSecurityFenceBaseAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + i) || this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d, this.field_145849_e + i)) continue;
                        return false;
                    }
                    for (i = 1; i < distance; ++i) {
                        for (int j = 1; j <= height; ++j) {
                            if (this.hasSecurityFenceGridAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e + i) || this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + j, this.field_145849_e + i)) continue;
                            return false;
                        }
                    }
                    for (int j = 1; j <= height; ++j) {
                        if (!this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e) && !this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + j, this.field_145849_e)) {
                            return false;
                        }
                        if (this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e + distance) || this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + j, this.field_145849_e + distance)) continue;
                        return false;
                    }
                    break;
                }
                case 1: {
                    int i;
                    for (i = 1; i < distance; ++i) {
                        if (this.hasSecurityFenceBaseAt(this.field_145850_b, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) || this.field_145850_b.func_147437_c(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)) continue;
                        return false;
                    }
                    for (i = 1; i < distance; ++i) {
                        for (int j = 1; j <= height; ++j) {
                            if (this.hasSecurityFenceGridAt(this.field_145850_b, this.field_145851_c - 1, this.field_145848_d + j, this.field_145849_e) || this.field_145850_b.func_147437_c(this.field_145851_c - 1, this.field_145848_d + j, this.field_145849_e)) continue;
                            return false;
                        }
                    }
                    for (int j = 1; j <= height; ++j) {
                        if (!this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e) && !this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + j, this.field_145849_e)) {
                            return false;
                        }
                        if (this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c - distance, this.field_145848_d + j, this.field_145849_e) || this.field_145850_b.func_147437_c(this.field_145851_c - distance, this.field_145848_d + j, this.field_145849_e)) continue;
                        return false;
                    }
                    break;
                }
                case 2: {
                    int i;
                    for (i = 1; i < distance; ++i) {
                        if (this.hasSecurityFenceBaseAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - i) || this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d, this.field_145849_e - i)) continue;
                        return false;
                    }
                    for (i = 1; i < distance; ++i) {
                        for (int j = 1; j <= height; ++j) {
                            if (this.hasSecurityFenceGridAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e - i) || this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + j, this.field_145849_e - i)) continue;
                            return false;
                        }
                    }
                    for (int j = 1; j <= height; ++j) {
                        if (!this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e) && !this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + j, this.field_145849_e)) {
                            return false;
                        }
                        if (this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e - distance) || this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + j, this.field_145849_e - distance)) continue;
                        return false;
                    }
                    break;
                }
                case 3: {
                    int i;
                    for (i = 1; i < distance; ++i) {
                        if (this.hasSecurityFenceBaseAt(this.field_145850_b, this.field_145851_c + i, this.field_145848_d, this.field_145849_e) || this.field_145850_b.func_147437_c(this.field_145851_c + i, this.field_145848_d, this.field_145849_e)) continue;
                        return false;
                    }
                    for (i = 1; i < distance; ++i) {
                        for (int j = 1; j <= height; ++j) {
                            if (this.hasSecurityFenceGridAt(this.field_145850_b, this.field_145851_c + i, this.field_145848_d + j, this.field_145849_e) || this.field_145850_b.func_147437_c(this.field_145851_c + i, this.field_145848_d + j, this.field_145849_e)) continue;
                            return false;
                        }
                    }
                    for (int j = 1; j <= height; ++j) {
                        if (!this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e) && !this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + j, this.field_145849_e)) {
                            return false;
                        }
                        if (this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c + distance, this.field_145848_d + j, this.field_145849_e) || this.field_145850_b.func_147437_c(this.field_145851_c + distance, this.field_145848_d + j, this.field_145849_e)) continue;
                        return false;
                    }
                    break;
                }
            }
        }
        return true;
    }

    public boolean hasRequiredStructure(int securityLevel, int direction, int distance) {
        switch (direction) {
            case 0: {
                switch (securityLevel) {
                    case 0: {
                        int j;
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + distance)) {
                            return false;
                        }
                        for (j = 1; j <= 2; ++j) {
                            if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + j, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e)) {
                                return false;
                            }
                            if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + j, this.field_145849_e + distance) || this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e + distance)) continue;
                            return false;
                        }
                        for (j = 0; j <= 2; ++j) {
                            for (int k = 1; k < distance - 1; ++k) {
                                if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + j, this.field_145849_e + k)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                    case 1: {
                        int k;
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + distance)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + 3, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e + distance) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + 3, this.field_145849_e + distance)) {
                            return false;
                        }
                        for (k = 1; k < distance - 1; ++k) {
                            if (this.hasSecurityFenceBaseAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + k)) continue;
                            return false;
                        }
                        for (int j = 1; j <= 2; ++j) {
                            for (int k2 = 1; k2 < distance - 1; ++k2) {
                                if (this.hasSecurityFenceGridAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e + k2)) continue;
                                return false;
                            }
                        }
                        for (k = 1; k < distance - 1; ++k) {
                            if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e + k)) continue;
                            return false;
                        }
                        return true;
                    }
                    case 2: {
                        int k;
                        int j;
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + distance)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 4, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + 4, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 5, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + 5, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 4, this.field_145849_e + distance) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + 4, this.field_145849_e + distance)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 5, this.field_145849_e + distance) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + 5, this.field_145849_e + distance)) {
                            return false;
                        }
                        for (int k3 = 1; k3 < distance - 1; ++k3) {
                            if (this.hasSecurityFenceBaseAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + k3)) continue;
                            return false;
                        }
                        for (j = 1; j <= 3; ++j) {
                            for (k = 1; k < distance - 1; ++k) {
                                if (this.hasSecurityFenceGridAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e + k)) continue;
                                return false;
                            }
                        }
                        for (j = 4; j <= 5; ++j) {
                            for (k = 1; k < distance - 1; ++k) {
                                if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + j, this.field_145849_e + k)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                }
                return false;
            }
            case 1: {
                switch (securityLevel) {
                    case 0: {
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c - distance, this.field_145848_d, this.field_145849_e)) {
                            return false;
                        }
                        for (int j = 1; j <= 2; ++j) {
                            if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + j, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e)) {
                                return false;
                            }
                            if (this.field_145850_b.func_147437_c(this.field_145851_c - distance, this.field_145848_d + j, this.field_145849_e) || this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c - distance, this.field_145848_d + j, this.field_145849_e)) continue;
                            return false;
                        }
                        for (int i = 1; i < distance - 1; ++i) {
                            for (int j = 0; j <= 2; ++j) {
                                if (this.field_145850_b.func_147437_c(this.field_145851_c - i, this.field_145848_d + j, this.field_145849_e)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                    case 1: {
                        int i;
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c - distance, this.field_145848_d, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + 3, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c - distance, this.field_145848_d + 3, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c - distance, this.field_145848_d + 3, this.field_145849_e)) {
                            return false;
                        }
                        for (i = 1; i < distance - 1; ++i) {
                            if (this.hasSecurityFenceBaseAt(this.field_145850_b, this.field_145851_c - i, this.field_145848_d, this.field_145849_e)) continue;
                            return false;
                        }
                        for (i = 1; i < distance - 1; ++i) {
                            for (int j = 1; j <= 2; ++j) {
                                if (this.hasSecurityFenceGridAt(this.field_145850_b, this.field_145851_c - i, this.field_145848_d + j, this.field_145849_e)) continue;
                                return false;
                            }
                        }
                        for (i = 1; i < distance - 1; ++i) {
                            if (this.field_145850_b.func_147437_c(this.field_145851_c - i, this.field_145848_d + 3, this.field_145849_e)) continue;
                            return false;
                        }
                        return true;
                    }
                    case 2: {
                        int i;
                        int j;
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c - distance, this.field_145848_d, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 4, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + 4, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 5, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + 5, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c - distance, this.field_145848_d + 4, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c - distance, this.field_145848_d + 4, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c - distance, this.field_145848_d + 5, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c - distance, this.field_145848_d + 5, this.field_145849_e)) {
                            return false;
                        }
                        for (int i2 = 1; i2 < distance - 1; ++i2) {
                            if (this.hasSecurityFenceBaseAt(this.field_145850_b, this.field_145851_c - i2, this.field_145848_d, this.field_145849_e)) continue;
                            return false;
                        }
                        for (j = 1; j <= 3; ++j) {
                            for (i = 1; i < distance - 1; ++i) {
                                if (this.hasSecurityFenceGridAt(this.field_145850_b, this.field_145851_c - i, this.field_145848_d + j, this.field_145849_e)) continue;
                                return false;
                            }
                        }
                        for (j = 4; j <= 5; ++j) {
                            for (i = 1; i < distance - 1; ++i) {
                                if (this.field_145850_b.func_147437_c(this.field_145851_c - i, this.field_145848_d + j, this.field_145849_e)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                }
                return false;
            }
            case 2: {
                switch (securityLevel) {
                    case 0: {
                        int j;
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - distance)) {
                            return false;
                        }
                        for (j = 1; j <= 2; ++j) {
                            if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + j, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e)) {
                                return false;
                            }
                            if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + j, this.field_145849_e - distance) || this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e - distance)) continue;
                            return false;
                        }
                        for (j = 0; j <= 2; ++j) {
                            for (int k = 1; k < distance - 1; ++k) {
                                if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + j, this.field_145849_e - k)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                    case 1: {
                        int k;
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - distance)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + 3, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e - distance) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + 3, this.field_145849_e - distance)) {
                            return false;
                        }
                        for (k = 1; k < distance - 1; ++k) {
                            if (this.hasSecurityFenceBaseAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - k)) continue;
                            return false;
                        }
                        for (int j = 1; j <= 2; ++j) {
                            for (int k4 = 1; k4 < distance - 1; ++k4) {
                                if (this.hasSecurityFenceGridAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e - k4)) continue;
                                return false;
                            }
                        }
                        for (k = 1; k < distance - 1; ++k) {
                            if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e - k)) continue;
                            return false;
                        }
                        return true;
                    }
                    case 2: {
                        int k;
                        int j;
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - distance)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 4, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + 4, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 5, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + 5, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 4, this.field_145849_e - distance) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + 4, this.field_145849_e - distance)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 5, this.field_145849_e - distance) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + 5, this.field_145849_e - distance)) {
                            return false;
                        }
                        for (int k5 = 1; k5 < distance - 1; ++k5) {
                            if (this.hasSecurityFenceBaseAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - k5)) continue;
                            return false;
                        }
                        for (j = 1; j <= 3; ++j) {
                            for (k = 1; k < distance - 1; ++k) {
                                if (this.hasSecurityFenceGridAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e - k)) continue;
                                return false;
                            }
                        }
                        for (j = 4; j <= 5; ++j) {
                            for (k = 1; k < distance - 1; ++k) {
                                if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + j, this.field_145849_e - k)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                }
                return false;
            }
            case 3: {
                switch (securityLevel) {
                    case 0: {
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c + distance, this.field_145848_d, this.field_145849_e)) {
                            return false;
                        }
                        for (int j = 1; j <= 2; ++j) {
                            if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + j, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + j, this.field_145849_e)) {
                                return false;
                            }
                            if (this.field_145850_b.func_147437_c(this.field_145851_c + distance, this.field_145848_d + j, this.field_145849_e) || this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c + distance, this.field_145848_d + j, this.field_145849_e)) continue;
                            return false;
                        }
                        for (int i = 1; i < distance - 1; ++i) {
                            for (int j = 0; j <= 2; ++j) {
                                if (this.field_145850_b.func_147437_c(this.field_145851_c + i, this.field_145848_d + j, this.field_145849_e)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                    case 1: {
                        int i;
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c + distance, this.field_145848_d, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + 3, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c + distance, this.field_145848_d + 3, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c + distance, this.field_145848_d + 3, this.field_145849_e)) {
                            return false;
                        }
                        for (i = 1; i < distance - 1; ++i) {
                            if (this.hasSecurityFenceBaseAt(this.field_145850_b, this.field_145851_c + i, this.field_145848_d, this.field_145849_e)) continue;
                            return false;
                        }
                        for (i = 1; i < distance - 1; ++i) {
                            for (int j = 1; j <= 2; ++j) {
                                if (this.hasSecurityFenceGridAt(this.field_145850_b, this.field_145851_c + i, this.field_145848_d + j, this.field_145849_e)) continue;
                                return false;
                            }
                        }
                        for (i = 1; i < distance - 1; ++i) {
                            if (this.field_145850_b.func_147437_c(this.field_145851_c + i, this.field_145848_d + 3, this.field_145849_e)) continue;
                            return false;
                        }
                        return true;
                    }
                    case 2: {
                        int i;
                        int j;
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.hasSecurityFenceMainBlockAt(this.field_145850_b, this.field_145851_c + distance, this.field_145848_d, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 4, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + 4, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 5, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c, this.field_145848_d + 5, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c + distance, this.field_145848_d + 4, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c + distance, this.field_145848_d + 4, this.field_145849_e)) {
                            return false;
                        }
                        if (!this.field_145850_b.func_147437_c(this.field_145851_c + distance, this.field_145848_d + 5, this.field_145849_e) && !this.hasSecurityFencePoleAt(this.field_145850_b, this.field_145851_c + distance, this.field_145848_d + 5, this.field_145849_e)) {
                            return false;
                        }
                        for (int i3 = 1; i3 < distance - 1; ++i3) {
                            if (this.hasSecurityFenceBaseAt(this.field_145850_b, this.field_145851_c + i3, this.field_145848_d, this.field_145849_e)) continue;
                            return false;
                        }
                        for (j = 1; j <= 3; ++j) {
                            for (i = 1; i < distance - 1; ++i) {
                                if (this.hasSecurityFenceGridAt(this.field_145850_b, this.field_145851_c + i, this.field_145848_d + j, this.field_145849_e)) continue;
                                return false;
                            }
                        }
                        for (j = 4; j <= 5; ++j) {
                            for (i = 1; i < distance - 1; ++i) {
                                if (this.field_145850_b.func_147437_c(this.field_145851_c + i, this.field_145848_d + j, this.field_145849_e)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private void placeFenceBlocks(World world, int security, int direction, int distance, int height, int x, int y, int z) {
        Block fenceBase = Blocks.field_150350_a;
        Block fenceGrid = Blocks.field_150350_a;
        Block fencePole = Blocks.field_150350_a;
        int blockMetadata = 0;
        switch (direction) {
            case 0: {
                int j;
                blockMetadata = 3;
                for (j = 1; j < height + 1; ++j) {
                    world.func_72921_c(x, y + j, z, 4, 2);
                    world.func_147468_f(x, y + j, z);
                    world.func_147475_p(x, y + j, z);
                    world.func_147465_d(x, y + j, z, fencePole, blockMetadata, 2);
                    world.func_72921_c(x, y + j, z + distance, 4, 2);
                    world.func_147468_f(x, y + j, z + distance);
                    world.func_147475_p(x, y + j, z + distance);
                    world.func_147465_d(x, y + j, z + distance, fencePole, blockMetadata, 2);
                }
                for (int k = 1; k < distance; ++k) {
                    world.func_147468_f(x, y, z + k);
                    world.func_147475_p(x, y, z + k);
                    world.func_147465_d(x, y, z + k, fenceBase, blockMetadata, 2);
                }
                for (j = 1; j < height + 1; ++j) {
                    for (int k = 1; k < distance; ++k) {
                        world.func_147468_f(x, y + j, z + k);
                        world.func_147475_p(x, y + j, z + k);
                        world.func_147465_d(x, y + j, z + k, fenceGrid, blockMetadata, 2);
                    }
                }
                return;
            }
            case 1: {
                int j;
                blockMetadata = 0;
                for (j = 1; j < height + 1; ++j) {
                    world.func_72921_c(x, y + j, z, 4, 2);
                    world.func_147468_f(x, y + j, z);
                    world.func_147475_p(x, y + j, z);
                    world.func_147465_d(x, y + j, z, fencePole, blockMetadata, 2);
                    world.func_72921_c(x - distance, y + j, z, 4, 2);
                    world.func_147468_f(x - distance, y + j, z);
                    world.func_147475_p(x - distance, y + j, z);
                    world.func_147465_d(x - distance, y + j, z, fencePole, blockMetadata, 2);
                }
                for (int i = 1; i < distance; ++i) {
                    world.func_147468_f(x - i, y, z);
                    world.func_147475_p(x - i, y, z);
                    world.func_147465_d(x - i, y, z, fenceBase, blockMetadata, 2);
                }
                for (j = 1; j < height + 1; ++j) {
                    for (int i = 1; i < distance; ++i) {
                        world.func_147468_f(x - i, y + j, z);
                        world.func_147475_p(x - i, y + j, z);
                        world.func_147465_d(x - i, y + j, z, fenceGrid, blockMetadata, 2);
                    }
                }
                return;
            }
            case 2: {
                int j;
                blockMetadata = 1;
                for (j = 1; j < height + 1; ++j) {
                    world.func_72921_c(x, y + j, z, 4, 2);
                    world.func_147468_f(x, y + j, z);
                    world.func_147475_p(x, y + j, z);
                    world.func_147465_d(x, y + j, z, fencePole, blockMetadata, 2);
                    world.func_72921_c(x, y + j, z - distance, 4, 2);
                    world.func_147468_f(x, y + j, z - distance);
                    world.func_147475_p(x, y + j, z - distance);
                    world.func_147465_d(x, y + j, z - distance, fencePole, blockMetadata, 2);
                }
                for (int k = 1; k < distance; ++k) {
                    world.func_147468_f(x, y, z - k);
                    world.func_147475_p(x, y, z - k);
                    world.func_147465_d(x, y, z - k, fenceBase, blockMetadata, 2);
                }
                for (j = 1; j < height + 1; ++j) {
                    for (int k = 1; k < distance; ++k) {
                        world.func_147468_f(x, y + j, z - k);
                        world.func_147475_p(x, y + j, z - k);
                        world.func_147465_d(x, y + j, z - k, fenceGrid, blockMetadata, 2);
                    }
                }
                return;
            }
            case 3: {
                int j;
                blockMetadata = 2;
                for (j = 1; j < height + 1; ++j) {
                    world.func_72921_c(x, y + j, z, 4, 2);
                    world.func_147468_f(x, y + j, z);
                    world.func_147475_p(x, y + j, z);
                    world.func_147465_d(x, y + j, z, fencePole, blockMetadata, 2);
                    world.func_72921_c(x + distance, y + j, z, 4, 2);
                    world.func_147468_f(x + distance, y + j, z);
                    world.func_147475_p(x + distance, y + j, z);
                    world.func_147465_d(x + distance, y + j, z, fencePole, blockMetadata, 2);
                }
                for (int i = 1; i < distance; ++i) {
                    world.func_147468_f(x + i, y, z);
                    world.func_147475_p(x + i, y, z);
                    world.func_147465_d(x + i, y, z, fenceBase, blockMetadata, 2);
                }
                for (j = 1; j < height + 1; ++j) {
                    for (int i = 1; i < distance; ++i) {
                        world.func_147468_f(x + i, y + j, z);
                        world.func_147475_p(x + i, y + j, z);
                        world.func_147465_d(x + i, y + j, z, fenceGrid, blockMetadata, 2);
                    }
                }
                return;
            }
        }
    }

    private void setFenceUpgrade(TileSecurityFence nextFence, int security, int direction) {
        switch (direction) {
            case 0: {
                this.setSecurityLevel((byte)(security + 1), 0);
                nextFence.setSecurityLevel((byte)(security + 1), 2);
                break;
            }
            case 1: {
                this.setSecurityLevel((byte)(security + 1), 1);
                nextFence.setSecurityLevel((byte)(security + 1), 3);
                break;
            }
            case 2: {
                this.setSecurityLevel((byte)(security + 1), 2);
                nextFence.setSecurityLevel((byte)(security + 1), 0);
                break;
            }
            case 3: {
                this.setSecurityLevel((byte)(security + 1), 3);
                nextFence.setSecurityLevel((byte)(security + 1), 1);
            }
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        nextFence.field_145850_b.func_147471_g(nextFence.field_145851_c, nextFence.field_145848_d, nextFence.field_145849_e);
    }

    private void consumeMaterials(TileSecurityFence nextFence, int security, int direction) {
        int prevMaterial = this.getFenceBasesStored();
        int requiredMaterial = this.getRequiredFenceBases(direction);
        this.setFenceBasesStored((short)(this.getFenceBasesStored() - requiredMaterial));
        if (this.getFenceBasesStored() <= 0) {
            this.setFenceBasesStored((short)0);
            nextFence.setFenceBasesStored((short)(nextFence.getFenceBasesStored() - (requiredMaterial -= prevMaterial)));
        }
        prevMaterial = this.getFenceGridsStored();
        requiredMaterial = this.getRequiredFenceGrids(security, direction);
        this.setFenceGridsStored((short)(this.getFenceGridsStored() - requiredMaterial));
        if (this.getFenceGridsStored() <= 0) {
            this.setFenceGridsStored((short)0);
            nextFence.setFenceGridsStored((short)(nextFence.getFenceGridsStored() - (requiredMaterial -= prevMaterial)));
        }
        prevMaterial = this.getFencePolesStored();
        requiredMaterial = this.getRequiredFencePoles(security);
        this.setFencePolesStored((short)(this.getFencePolesStored() - requiredMaterial));
        if (this.getFencePolesStored() <= 0) {
            this.setFencePolesStored((short)0);
            nextFence.setFencePolesStored((short)(nextFence.getFencePolesStored() - (requiredMaterial -= prevMaterial)));
        }
    }

    private void consumeMaterials(int bases, int grids, int poles) {
        this.setFenceBasesStored((short)(this.getFenceBasesStored() - bases));
        if (this.getFenceBasesStored() < 0) {
            this.setFenceBasesStored((short)0);
        }
        this.setFenceGridsStored((short)(this.getFenceGridsStored() - grids));
        if (this.getFenceGridsStored() < 0) {
            this.setFenceGridsStored((short)0);
        }
        this.setFencePolesStored((short)(this.getFencePolesStored() - poles));
        if (this.getFencePolesStored() < 0) {
            this.setFencePolesStored((short)0);
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean canBuildFence(int securityLV, int direction, int length, int height) {
        return this.isSecurityLevelValid(securityLV) && this.isHeightValid(height) && this.isDistanceValid(length) && this.isFenceValid(direction, securityLV) && this.hasEnoughFenceBases(securityLV, direction) && this.hasEnoughFenceGrids(securityLV, direction) && this.hasEnoughFencePoles(securityLV) && this.hasRequiredStructure(securityLV, direction, length);
    }

    public void tryToBuildFence(int security, int direction, int distance, int height) {
        if (!this.field_145850_b.field_72995_K && this.canBuildFence(security, direction, distance, height)) {
            TileSecurityFence nextFence = this.getNextFence(this, direction, distance);
            this.consumeMaterials(nextFence, security, direction);
            this.setFenceUpgrade(nextFence, security, direction);
            this.placeFenceBlocks(this.field_145850_b, security, direction, distance, height, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void tryToFixFence(int security, int direction, int distance, int height, int bases, int grids, int poles) {
        if (!this.field_145850_b.field_72995_K) {
            this.placeFenceBlocks(this.field_145850_b, security, direction, distance, height, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.consumeMaterials(bases, grids, poles);
        }
    }

    public boolean hasItems() {
        return this.slots[0] != null || this.slots[1] != null;
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70298_a(int i, int amount) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= amount) {
                ItemStack splitedStack = this.slots[i];
                this.slots[i] = null;
                return splitedStack;
            }
            ItemStack splitedStack = this.slots[i].func_77979_a(amount);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return splitedStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Security Fence Base";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return false;
    }

    public int[] func_94128_d(int i) {
        return new int[]{0};
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(tagCompound);
            list.func_74742_a((NBTBase)tagCompound);
        }
        compound.func_74782_a("Items", (NBTBase)list);
        compound.func_74774_a("Direction", this.getDirection());
        compound.func_74774_a("SecurityLevelSouth", this.getSecurityLevel(0));
        compound.func_74774_a("SecurityLevelWest", this.getSecurityLevel(1));
        compound.func_74774_a("SecurityLevelNorth", this.getSecurityLevel(2));
        compound.func_74774_a("SecurityLevelEast", this.getSecurityLevel(3));
        compound.func_74777_a("GridsStored", (short)this.getFenceGridsStored());
        compound.func_74777_a("BasesStored", (short)this.getFenceBasesStored());
        compound.func_74777_a("PolesStored", (short)this.getFencePolesStored());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList list = compound.func_150295_c("Items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = list.func_150305_b(i);
            byte j = tagCompound.func_74771_c("Slot");
            if (j < 0 || j >= this.slots.length) continue;
            this.slots[j] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        this.setDirection(compound.func_74771_c("Direction"));
        this.setSecurityLevel(compound.func_74771_c("SecurityLevelSouth"), 0);
        this.setSecurityLevel(compound.func_74771_c("SecurityLevelWest"), 1);
        this.setSecurityLevel(compound.func_74771_c("SecurityLevelNorth"), 2);
        this.setSecurityLevel(compound.func_74771_c("SecurityLevelEast"), 3);
        this.setFenceGridsStored(compound.func_74765_d("GridsStored"));
        this.setFenceBasesStored(compound.func_74765_d("BasesStored"));
        this.setFencePolesStored(compound.func_74765_d("PolesStored"));
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.func_145839_a(compound);
    }
}

