/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity;

import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftRidable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class EntityJurassiCraftSwimming
extends EntityJurassiCraftRidable {
    protected float swimRadius = 4.0f;
    protected float swimRadiusHeight = 4.0f;
    protected boolean isAgressive = false;
    protected int attackInterval = 50;
    protected float attackSpeed = 1.2f;
    protected float swimSpeed = 0.5f;
    protected boolean jumpOnLand = true;
    private double swimTargetX;
    private double swimTargetY;
    private double swimTargetZ;
    private Entity targetEntity;
    private boolean isAttacking;

    public EntityJurassiCraftSwimming(World world) {
        super(world);
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70090_H() {
        return this.field_70170_p.func_72918_a(this.field_70121_D, Material.field_151586_h, (Entity)this);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70090_H()) {
            this.field_70181_x *= 0.1;
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70090_H()) {
            double dx = this.swimTargetX - this.field_70165_t;
            double dy = this.swimTargetY - this.field_70163_u;
            double dz = this.swimTargetZ - this.field_70161_v;
            double dist = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
            if (dist < 1.0 || dist > 1000.0) {
                this.swimTargetX = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.swimRadius);
                this.swimTargetY = this.field_70163_u + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.swimRadiusHeight);
                this.swimTargetZ = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.swimRadius);
                this.isAttacking = false;
            }
            if (this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.swimTargetX), MathHelper.func_76128_c((double)(this.swimTargetY + (double)this.field_70131_O)), MathHelper.func_76128_c((double)this.swimTargetZ)).func_149688_o() == Material.field_151586_h) {
                this.field_70159_w += dx / dist * 0.05 * (double)this.swimSpeed;
                this.field_70181_x += dy / dist * 0.1 * (double)this.swimSpeed;
                this.field_70179_y += dz / dist * 0.05 * (double)this.swimSpeed;
            } else {
                this.swimTargetX = this.field_70165_t;
                this.swimTargetY = this.field_70163_u + 0.1;
                this.swimTargetZ = this.field_70161_v;
            }
            if (this.isAttacking) {
                this.field_70159_w *= (double)this.attackSpeed;
                this.field_70181_x *= (double)this.attackSpeed;
                this.field_70179_y *= (double)this.attackSpeed;
            }
            if (this.isAgressive && this.field_70146_Z.nextInt(this.attackInterval) == 0) {
                this.targetEntity = this.findEntityToAttack();
                if (this.targetEntity != null && this.targetEntity.func_70090_H()) {
                    this.swimTargetX = this.targetEntity.field_70165_t;
                    this.swimTargetY = this.targetEntity.field_70163_u;
                    this.swimTargetZ = this.targetEntity.field_70161_v;
                    this.isAttacking = true;
                }
            }
            this.field_70761_aq += (-((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI - this.field_70761_aq) * 0.5f;
            this.field_70177_z = this.field_70761_aq;
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70125_A += ((float)Math.atan2(this.field_70181_x, f) * 180.0f / (float)Math.PI - this.field_70125_A) * 0.5f;
        } else if (this.jumpOnLand && this.field_70122_E && this.field_70146_Z.nextInt(30) == 0) {
            this.field_70181_x = 0.3f;
            this.field_70159_w = -0.2f + this.field_70146_Z.nextFloat() * 0.4f;
            this.field_70179_y = -0.2f + this.field_70146_Z.nextFloat() * 0.4f;
        }
    }

    protected Entity findEntityToAttack() {
        EntityPlayer player = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        return player != null && this.func_70685_l((Entity)player) ? player : null;
    }

    public void func_70108_f(Entity entity) {
        super.func_70108_f(entity);
        if (this.isAgressive && this.targetEntity == entity) {
            this.func_70652_k(entity);
        }
    }

    public boolean func_70652_k(Entity entity) {
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        return entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public void func_70030_z() {
        int air = this.func_70086_ai();
        super.func_70030_z();
        if (this.func_70089_S() && !this.func_70090_H()) {
            this.func_70050_g(--air);
            if (this.func_70086_ai() == -10) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.func_70050_g(300);
        }
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.field_70121_D);
    }
}

