/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.time;

import net.minecraft.world.World;

public class Time {
    public long ticks;
    public int seconds;
    public int minutes;
    public int hours;

    public static Time getTimeFromTicks(long ticks) {
        Time t = new Time();
        t.ticks = ticks;
        t.seconds = (int)t.ticks / 20;
        t.minutes = t.seconds / 60;
        t.hours = t.minutes / 60;
        t.minutes -= t.hours * 60;
        t.seconds -= t.seconds / 60 * 60;
        t.ticks -= t.ticks / 20L * 20L;
        return t;
    }

    public static int getWorldTimeInHours(World world) {
        long time = world.func_72820_D() % 24000L;
        int hours = (int)time / 1000 + 6 > 24 ? (int)time / 1000 + 6 - 24 : (int)time / 1000 + 6;
        return hours;
    }

    public static String toAmPm(int hours) {
        String am = hours + (hours == 12 ? " pm" : " am");
        String pm = hours - 12 + (hours - 12 == 12 ? " am" : " pm");
        return hours > 12 ? pm : am;
    }

    public String toString() {
        Object[] aobject = new Object[]{this.hours, this.minutes, this.seconds, this.ticks};
        return String.format("%sh %smin %ss %st", aobject);
    }

    public long totalTicks() {
        return this.ticks + (long)(this.seconds * 20) + (long)(this.minutes * 60 * 20) + (long)(this.hours * 60 * 60 * 20);
    }
}

