/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.command;

import com.google.common.collect.Lists;
import java.awt.Desktop;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.common.color.EnumChatColor;
import net.ilexiconn.llibrary.common.command.ChatHelper;
import net.ilexiconn.llibrary.common.command.ChatMessage;
import net.ilexiconn.llibrary.common.json.container.JsonModUpdate;
import net.ilexiconn.llibrary.common.update.ChangelogHandler;
import net.ilexiconn.llibrary.common.update.UpdateHelper;
import net.ilexiconn.llibrary.common.update.VersionHandler;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;

public class CommandLLibrary
extends CommandBase {
    public String func_71517_b() {
        return "llibrary";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/llibrary list OR /llibrary update <modid> OR /llibrary changelog <modid> <version>";
    }

    public int func_82362_a() {
        return 0;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        List<JsonModUpdate> outdatedMods = VersionHandler.getOutdatedMods();
        if (args.length >= 1) {
            if (args[0].equalsIgnoreCase("list")) {
                if (args.length > 1) {
                    throw new WrongUsageException("/llibrary list", new Object[0]);
                }
                ChatHelper.chatTo(sender, new ChatMessage("--- Showing a list of outdated mods ---", EnumChatColor.DARK_GREEN));
                for (JsonModUpdate mod : outdatedMods) {
                    ChatHelper.chatTo(sender, new ChatMessage("(" + mod.modid + ") ", EnumChatColor.BLUE), new ChatMessage(mod.name + " version " + mod.currentVersion + " - Latest version: " + mod.getNewestVersion(), EnumChatColor.WHITE));
                }
                ChatHelper.chatTo(sender, new ChatMessage("Use ", EnumChatColor.GREEN), new ChatMessage("/llibrary update <modid>", EnumChatColor.YELLOW), new ChatMessage(" to update the desired mod, ", EnumChatColor.GREEN), new ChatMessage("or", EnumChatColor.RED));
                ChatHelper.chatTo(sender, new ChatMessage("Use ", EnumChatColor.GREEN), new ChatMessage("/llibrary changelog <modid> <version>", EnumChatColor.YELLOW), new ChatMessage(" to see its version changelog.", EnumChatColor.GREEN));
                return;
            }
            if (args[0].equalsIgnoreCase("update")) {
                if (args.length != 2) {
                    throw new WrongUsageException("/llibrary update <modid>", new Object[0]);
                }
                for (JsonModUpdate mod : outdatedMods) {
                    Desktop desktop;
                    if (!args[1].equalsIgnoreCase(mod.modid) || (desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null) == null || !desktop.isSupported(Desktop.Action.BROWSE)) continue;
                    try {
                        desktop.browse(new URI(mod.getUpdateUrl()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return;
            }
            if (args[0].equalsIgnoreCase("changelog")) {
                if (args.length != 3) {
                    throw new WrongUsageException("/llibrary changelog <modid> <version>", new Object[0]);
                }
                for (int i = 0; i < UpdateHelper.modList.size(); ++i) {
                    JsonModUpdate mod = UpdateHelper.modList.get(i);
                    if (!args[1].equalsIgnoreCase(mod.modid)) continue;
                    boolean hasChangelogForVersion = false;
                    try {
                        hasChangelogForVersion = ChangelogHandler.hasModGotChangelogForVersion(mod, args[2]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (hasChangelogForVersion) {
                        LLibrary.proxy.openChangelogGui(mod, args[2]);
                        continue;
                    }
                    ChatHelper.chatTo(sender, new ChatMessage("There is no changelog for mod '" + mod.modid + "' version " + args[2] + "!", EnumChatColor.RED));
                }
                return;
            }
        }
        throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
    }

    public List func_71516_a(ICommandSender icommandsender, String[] astring) {
        if (astring.length == 1) {
            return CommandLLibrary.func_71530_a((String[])astring, (String[])new String[]{"list", "update", "changelog"});
        }
        if (astring[0].equalsIgnoreCase("update") && astring.length == 2) {
            return CommandLLibrary.func_71531_a((String[])astring, (Iterable)this.getAllModIDs(VersionHandler.getOutdatedMods()));
        }
        if (astring[0].equalsIgnoreCase("changelog") && astring.length == 2) {
            return CommandLLibrary.func_71531_a((String[])astring, (Iterable)this.getAllModIDs(UpdateHelper.modList));
        }
        if (astring[0].equalsIgnoreCase("changelog") && astring.length == 3) {
            return CommandLLibrary.func_71531_a((String[])astring, this.getAllModChangelogs(UpdateHelper.getModContainerById(astring[1])));
        }
        return null;
    }

    protected List getAllModIDs(List list) {
        ArrayList arraylist = Lists.newArrayList();
        for (Object aCollection : list) {
            JsonModUpdate mod = (JsonModUpdate)aCollection;
            arraylist.add(mod.modid);
        }
        return arraylist;
    }

    protected Collection<String> getAllModChangelogs(JsonModUpdate mod) {
        return mod.getVersions().keySet();
    }
}

