/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ilexiconn.llibrary.client.gui.GuiOverride;
import net.ilexiconn.llibrary.client.gui.GuiToast;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

@SideOnly(value=Side.CLIENT)
public class GuiHelper {
    private static Map<GuiOverride, Class<? extends GuiScreen>> overrideMap = Maps.newHashMap();
    private static List<GuiToast> toasts = Lists.newArrayList();

    public static void addOverride(Class<? extends GuiScreen> clazz, GuiOverride gui) {
        overrideMap.put(gui, clazz);
    }

    public static void createToast(int x, int y, String ... text) {
        int stringWidth = 0;
        for (String s : text) {
            stringWidth = Math.max(stringWidth, Minecraft.func_71410_x().field_71466_p.func_78256_a(s));
        }
        toasts.add(new GuiToast(x, y, stringWidth + 10, stringWidth * 3, text));
    }

    public static List<GuiToast> getToasts() {
        return toasts;
    }

    public static List<GuiOverride> getOverridesForGui(Class<? extends GuiScreen> clazz) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<GuiOverride, Class<? extends GuiScreen>> e : overrideMap.entrySet()) {
            if (e.getValue() != clazz) continue;
            list.add(e.getKey());
        }
        return list;
    }

    public static Map<GuiOverride, Class<? extends GuiScreen>> getOverrides() {
        return overrideMap;
    }
}

